<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\OpeningWordRequest;
use App\Models\OpeningWord;
use Illuminate\Http\Request;

class OpeningWordController extends AdminController
{
    public function __construct(OpeningWord $model)
    {
        parent::__construct();
        $this->model = $model;
        $this->image_width = 100;
        $this->image_height = 100;
        $this->image_ratio = '1/1';
        view()->share([

            'uploads_folder' => $this->uploads_folder,
            'image_width' => $this->image_width,
            'image_height' => $this->image_height,
            'image_ratio' => $this->image_ratio,

        ]);
    }

    public function index()
    {
        $id=1;
        $item = $this->model->find($id);
        return view($this->method_view, compact('item'));
    }
    public function store(OpeningWordRequest $request)
    {
        $image = $request['image'] ?? null;

        $data = $request->all();
        $img_name = $this->upload_crop_image(null, $request->image);
        if ($img_name) {
            $data['image'] = $img_name;
        }
        $data['created_by'] = auth()->user()->id;
        $this->model::create($data);
        session()->flash('success', $this->created_successfully);
        return redirect($this->index_route);
    }
    public function update(OpeningWordRequest $request, OpeningWord $opening_word)
    {
        $data = $request->all();

        $img_name = $this->upload_crop_image($opening_word);
        if ($img_name) {
            $data['image'] = $img_name;
        }
        $data['updated_by'] = 1;
        $update = $opening_word->update($data);
        session()->flash('success', $this->updated_successfully);
        return redirect($this->index_route);
    }
}
