<?php

namespace App\Http\Controllers\Admin;


use App\Http\Requests\SocialMediaRequest;
use App\Models\SocialMedia;

class SocialMediaController extends AdminController
{
    public function __construct(SocialMedia $model)
    {
        parent::__construct();
        $this->model = $model;
        $this->module_actions= ['edit','active'];

    }

    public function index()
    {
        $deleted_items = $this->model->onlyTrashed()
            ->with(['deletedBy' => function ($query) {
                $query->select('id', 'name');
            }])
            ->get();
        $all_items = $this->model->orderByRaw('-item_order DESC')
            ->with('createdBy')
            ->get();

        $items = request()->has('trashed') ? $deleted_items : $all_items;

        if (request()->ajax()) {
            return datatables()->of($items)
                ->addColumn('title_link', function ($data) {
                    return $data->title ? '<a href="' . route($this->module_name . '.show', $data->id) . '">' . $data->title . '</a>' : '';
                })
                ->addColumn('order_form', $this->components_view . '.order_form')
                ->addColumn('actions', function ($data) {
                    return view($this->components_view . '.actions', compact('data'))
                        ->with('module_actions', $this->module_actions);
                })
                ->rawColumns(['title_link','order_form', 'actions'])
                ->make(true);
        }
        return view($this->method_view, compact('items'))->with('deleted_items', $deleted_items);
    }

  

    public function update(SocialMediaRequest $request, SocialMedia $social_media)
    {
        $data = $request->all();

        $data['updated_by'] = 1;
        $update = $social_media->update($data);
        session()->flash('success', $this->updated_successfully);
        return redirect($this->index_route);
    }

}
