<?php

namespace App\Http\Controllers\Admin;


use App\Http\Requests\StaffRequest;
use App\Models\Staff;

class StaffController extends AdminController
{
    protected  $module_name;
    public function __construct(Staff $model)
    {
        parent::__construct();
        $this->model = $model;
        $this->image_width = 300;
        $this->image_height = 400;
        $this->image_ratio = '3/4';
        $this->module_name =  'staff';
        view()->share([

            'uploads_folder' => $this->uploads_folder,
            'image_width' => $this->image_width,
            'image_height' => $this->image_height,
            'image_ratio' => $this->image_ratio,
            'module_name' => $this->module_name,

        ]);
    }

    public function index()
    {
        $deleted_items = $this->model->onlyTrashed()
            ->with(['deletedBy' => function ($query) {
                $query->select('id', 'name');
            }])
            ->get();
        $all_items = $this->model->orderByRaw('-item_order DESC')
            ->with('createdBy')
            ->get();

        $items = request()->has('trashed') ? $deleted_items : $all_items;

        if (request()->ajax()) {
            return datatables()->of($items)
                ->editColumn('name', function ($data) {
                    return $data->name ? '<a href="' . route($this->module_name . '.show', $data->id) . '">' . $data->name . '</a>' : '';
                })
                ->editColumn('image', function ($data) {
                    return $data->image ? '<img src="' . $data->image_thumb_path . '" class="img-thumbnail" style="width: 50px">' : '<i class="fa fa-image no-img" >';
                })
                ->addColumn('actions', function ($data) {
                    return view($this->components_view . '.actions', compact('data'))
                        ->with('module_actions', $this->module_actions);
                })
                ->rawColumns(['name','image','actions'])
                ->make(true);
        }
        return view($this->method_view, compact('items'))->with('deleted_items', $deleted_items);
    }
    public function store(StaffRequest $request)
    {
        $image = $request['image'] ?? null;

        $data = $request->all();
        $img_name = $this->upload_crop_image(null, $request->image);
        if ($img_name) {
            $data['image'] = $img_name;
        }
        $data['created_by'] = auth()->user()->id;
        $this->model::create($data);
        session()->flash('success', $this->created_successfully);
        return redirect($this->index_route);
    }
    public function update(StaffRequest $request, Staff $staff)
    {
        $data = $request->all();

        $img_name = $this->upload_crop_image($staff);
        if ($img_name) {
            $data['image'] = $img_name;
        }
        $data['updated_by'] = 1;
        $update = $staff->update($data);
        session()->flash('success', $this->updated_successfully);
        return redirect($this->index_route);
    }
}
