<?php

namespace App\Http\Controllers\Admin;



use App\Models\Subscribe;

class SubscribeController extends AdminController
{
    public function __construct(Subscribe $model)
    {
        parent::__construct();
        $this->model = $model;
        $this->module_actions= ['delete'];

    }

    public function index()
    {
        $deleted_items = $this->model->onlyTrashed()
            ->with(['deletedBy' => function ($query) {
                $query->select('id', 'name');
            }])
            ->get();
        $all_items = $this->model->orderByRaw('-item_order DESC')
            ->with('createdBy')
            ->get();

        $items = request()->has('trashed') ? $deleted_items : $all_items;

        if (request()->ajax()) {
            return datatables()->of($items)


                ->addColumn('order_form', $this->components_view . '.order_form')

                ->addColumn('actions', function ($data) {
                    return view($this->components_view . '.actions', compact('data'))
                        ->with('module_actions', $this->module_actions);
                })
                ->rawColumns(['order_form', 'actions'])
                ->make(true);
        }
        return view($this->method_view, compact('items'))->with('deleted_items', $deleted_items);
    }


}
