<?php

namespace App\Http\Controllers\Admin;
use App\Http\Requests\VoteRequest;
use App\Models\Vote;

class VoteController extends AdminController
{
    public function __construct(Vote $model)
    {
        parent::__construct();
        $this->model = $model;
        view()->share([
        ]);
    }

    public function index()
    {
        $deleted_items = $this->model->onlyTrashed()
            ->with(['deletedBy' => function ($query) {
                $query->select('id', 'name');
            }])
            ->get();
        $all_items = $this->model->orderByRaw('-item_order DESC')
            ->with('createdBy')
            ->get();

        $items = request()->has('trashed') ? $deleted_items : $all_items;

        if (request()->ajax()) {
            return datatables()->of($items)
                ->editColumn('question', function ($data) {
                return $data->question ? '<a href="' . route($this->module_name . '.show', $data->id) . '">' . $data->question . '</a>' : '';
            })
                ->addColumn('actions', function ($data) {
                    return view($this->components_view . '.actions', compact('data'))
                        ->with('module_actions', $this->module_actions);
                })
                ->rawColumns(['question','actions'])
                ->make(true);
        }
        return view($this->method_view, compact('items'))->with('deleted_items', $deleted_items);
    }
    public function store(VoteRequest $request)
    {
        $data = $request->all();
        $data['created_by'] = auth()->user()->id;
        $this->model::create($data);
        session()->flash('success', $this->created_successfully);
        return redirect($this->index_route);
    }
    public function update(VoteRequest $request, Vote $vote)
    {
        $data = $request->all();
        $data['updated_by'] = 1;
        $update = $vote->update($data);
        session()->flash('success', $this->updated_successfully);
        return redirect($this->index_route);
    }
}
