<?php

namespace App\Http\Controllers\FrontEnd;

use App\Models\Contact;
use Illuminate\Http\Request;

class ContactController extends FrontEndController
{
    public function __construct(Contact $model)
    {
        parent::__construct($model);
    }


    public function index()
    {

        return view($this->method_view);

    }

    public function send(Request $request)
    {
        $contact = Contact::find(1);
        $to_email = $contact['email'];
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email',
            'subject' => 'required',
            'phone' => 'required',
            'message' => 'required',
            'captcha' => 'required|captcha',
        ]);

        $subject  = request('subject');
        $message  = request('message');
        $phone  = request('phone');
        $name  = request('name');
        $email  = request('email');


        $message_body = "<html><body><table border='0' dir='rtl' width='100%' cellpadding='5' cellspacing='0'><tr><td align='right'>
					<h2> اتصال عن طريق  الموقع  ".$_SERVER['HTTP_HOST']." - بتاريخ : ".date('d-m-Y')." </h2><br /><br /> 
					<h2>وفيما يلي تفاصيل الاتصال : <br /><br />
					الاسم : ".$name."<br />
					البريد الإلكتروني: ".$email."<br />
					 الهاتف: ".$phone."<br />
					الموضوع : ".$subject."<br /><br /><br /></h2>
					<h2>	الرسالة : </h2><h2>".$message."</h2>
					</td></tr></table></body></html>";

        //Set up the email headers
        $headers  = "From: $name <$email>\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=utf-8\r\n";
        //$headers   .= "Message-ID: <".time().rand(1,1000)."@".$_SERVER['SERVER_NAME'].">". "\r\n";
        $headers .= "Message-ID: <$to_email/>". "\r\n";


        if (@mail($to_email, $subject, $message_body, $headers)) {
            return response()->json(
                [
                    'status' => 'success',
                    'message' =>  $this->send_successfully,
                ]);
        } else {
            return response()->json(['status' => 'error', 'message' =>  $this->fail_send]);
        }


    }
}
