<?php

namespace App\Http\Controllers\FrontEnd;


use App\Models\Edition;
use App\Models\EditionCategory;

class EditionController extends FrontEndController
{
    public function __construct(Edition $model)
    {
        parent::__construct($model);
    }


    public function show($id)
    {

        $item = $this->model->findOrFail($id);
        return view($this->method_view, compact('item'));

    }

    public function view($id)
    {
        $edition_category = EditionCategory::Find($id);

        $all_editions= Edition::where('edition_category_id',$id)->orderBy('id','DESC')->paginate(9);
        //return $all_editions;
        return view('front_end.editions.view' , compact('edition_category','all_editions'));

    }

}
