<?php

namespace App\Http\Controllers\FrontEnd;

use App\Models\Member;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\Request;
use Illuminate\Support\Collection as BaseCollection;


class MemberController extends FrontEndController
{
    public function __construct(Member $model)
    {
        parent::__construct($model);
    }


    public function index()
    {

        return view('front_end.members.index');

    }

    public function show($id)
    {
        $item = $this->model->findOrFail($id);
        return view($this->method_view, compact('item'));

    }

    public function search(Request $request)
    {


        $members = Member::when($request->search, function ($q) use ($request) {

            return $q->whereTranslationlike('name', '%' . $request->search . '%');

        })->paginate(12);

        return view('front_end.members.index', compact('members'));

    }


    public function search_letter($letter)
    {

        $allname = Member::all();

        $collection_name = $allname->pluck('name')->toArray();

        foreach ($collection_name as $item) {

            $firstCharacter = substr($item, 0, 2);

            if ($firstCharacter == $letter) {

                $members[] = Member::whereTranslationlike('name', '%' . $item . '%')->orderByRaw('-item_order DESC')->get();
            }
        }

            return view('front_end.members.all_index', compact('members'));

    }

}
