<?php

namespace App\Http\Controllers\FrontEnd;

use App\Models\Subscribe;
use Illuminate\Http\Request;

class SubscribeController extends FrontEndController
{

    protected $send_successfully;

    public function __construct(Subscribe $model)
    {
        $this->send_successfully = trans('admin.created_successfully');

        parent::__construct($model);
    }

    public function subscribe(Request $request)
    {
        if ($request->ajax()) {
            $this->validate($request, [
                'email_1' => 'required|email',
            ]);


            $data['email'] = request('email_1');


            $save = Subscribe::create($data);


            if ($save) {
                return response()->json(
                    [
                        'status' => 'success',
                        'message' => $this->send_successfully,
                    ]);
            } else {
                return response()->json(['status' => 'error', 'message' => $this->fail_send]);
            }
        }

        return redirect()->back();

    }


}
