<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StaffRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [];
        foreach(config('translatable.locales') as $locale){
            if($locale=='ar'){
                $rules += [$locale.'.name' => 'required'];
            }else{
                $rules += [$locale.'.name' => 'nullable'];
            }
        }

        return $rules;
    }
}
