<?php

namespace App\Http\Requests;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class VoteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = isset($this->vote) ? $this->vote->id : null;
        $rules = [
        ];

        foreach(config('translatable.locales') as $locale){
            if($locale=='ar'){
                $rules += [$locale.'.question' => ['required',Rule::unique('vote_translations','question')->ignore($id,'vote_id')]];
            }else{
                $rules += [$locale.'.question' => 'nullable'];
            }
        }
        return $rules;
    }
    public function attributes()
    {
        return [
            'ar.question' => 'السؤال'
        ];
    }
}
