<?php

namespace App\Models;

use Astrotomic\Translatable\Translatable;

class Menu extends AppModel
{
    use Translatable;
    protected $fillable = ['name','image','created_by', 'updated_by', 'deleted_by'];
    public $translatedAttributes = ['title','description'];

    public function getImagePathAttribute()
    {
        return $this->image ? asset('uploads/'.$this->table.'/'.$this->image): null;
    }

    public function getImageThumbPathAttribute()
    {
        return $this->image ? asset('uploads/'.$this->table.'/thumbs/'.$this->image): null;
    }

}
