<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOpeningWordTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('opening_word_translations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('opening_word_id')->unsigned();
            $table->string('title')->nullable();
            $table->text('description')->nullable();
            $table->text('image_description')->nullable();
            $table->string('locale')->index();
            $table->unique(['opening_word_id','locale']);
            $table->foreign('opening_word_id')->references('id')->on('opening_words')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('opening_word_translations');
    }
}
