<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Bar;
class BarsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('bars')->truncate();
        DB::table('bar_translations')->truncate();

        $items = [
            [28, 'مرحبا بكم في الموقع الرسمي لاتحاد الكتاب العرب في دمشق', '', '', 'http://awu.sy/', 0],
            [62, 'يرجى من السادة أعضاء اتحاد الكتاب العرب إرسال السيرة الذاتية وصورة شخصية حديثة، وذلك لتجديد السيرة الذاتية على موقع الاتحاد  أو لإضافة سيرة جديدة. وذلك عبر البريد الألكتروني:  mawkif@tutanota.com\r\n                                        ', '', '', 'http://www.', 0]
        ];

        for($i=0 ; $i < count($items); $i++)

            Bar::create([
                'ar' => ['title' => $items[$i][1]],
                'en' => ['title' => null],
                'id' =>  $items[$i][0],
                'link' =>  $items[$i][4],
                'in_out' =>  $items[$i][5],
            ]);

        DB::statement('SET FOREIGN_KEY_CHECKS=0');
    }
}
