<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\BookCategory;
class BookCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('book_categories')->truncate();
        DB::table('book_category_translations')->truncate();

        $items = [
            ['روايات'],
            ['دراسات'],
            ['أدب الطفل'],
            ['الشعر'],
            ['القصة'],
            ['المسرح'],

        ];

        for($i=0 ; $i < count($items); $i++)
        BookCategory::create([
            'ar' => [ 'title' => $items[$i][0]],
            'en' => ['title' => null ],
        ]);

        DB::statement('SET FOREIGN_KEY_CHECKS=0');
    }
}
