<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\EditionCategory;
class EditionCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('edition_categories')->truncate();
        DB::table('edition_category_translations')->truncate();

        $items = [
            ['الأسبوع الأدبي'],
            ['الموقف الأدبي'],
            ['الفكر السياسي'],
            ['التراث العربي'],
            ['الآداب العالمية'],
            ['إصدارات خاصة'],
            ['شام الطفولة'],

        ];

        for($i=0 ; $i < count($items); $i++)
            EditionCategory::create([
                'ar' => [ 'title' => $items[$i][0]],
                'en' => ['title' => null ],
            ]);

        DB::statement('SET FOREIGN_KEY_CHECKS=0');
    }
}
