@extends('layouts.admin.app')

@section('content')
    <div class="alert alert-info">
        <div class="alert alert-info">
            <p>- {{trans('admin.img_allow_note.type',['[jpg, jpeg, png]'])}}</p>
            <p>- {{trans('admin.img_allow_note.ratio',['['.$image_ratio.']'])}}</p>
            <p>- {{trans('admin.img_allow_note.min_w',[$image_width])}}</p>
        </div>
    </div>
    <form class="form-horizontal form" role="form"
          action="{{isset($item) ? route($module_name.'.update' , $item->id) : route($module_name.'.store')}}"
          method="POST"
          enctype="multipart/form-data">
        @csrf
        @if (isset($item))
            @method("PUT")
        @endif


        <div class="tabbed-info">
            <ul class="nav nav-tabs" role="tablist">
                @foreach(config('translatable.locales') as $locale)
                    <li class="{{$locale=='ar' ? 'active':''}}"><a data-toggle="tab"
                                                                   href="#tab-{{$locale}}">@lang('admin.'.$locale)</a>
                    </li>
                @endforeach
            </ul>
            <div class="tab-content">
                @foreach(config('translatable.locales') as $locale)
                    <div id="tab-{{$locale}}" class="tab-pane {{$locale=='ar' ? 'active' : ''}}">
                        <div class="form-group">
                            <label for="{{$locale}}[name]"
                                   class="col-form-label col-lg-2 text-left">@lang('admin.name')
                                (@lang('admin.'.$locale)): <i class="text-danger">*</i></label>
                            <div class="col-lg-8">
                                <input type="text" name="{{$locale}}[name]" id="{{$locale}}[name]"
                                       class="form-control  rtl" placeholder=""
                                       value="{{isset($item) && $item->translate($locale)
                                        !=null? $item->translate($locale)->name : old($locale.'.name') }}">
                                @error($locale.'.name')
                                <p class="invalid-feedback text-danger text-right rtl" role="alert">
                                    {{ $message }}
                                </p>
                                @enderror

                            </div>
                        </div>
                        <div class="form-group">
                            <label for="{{$locale}}[description]"
                                   class="col-form-label col-lg-2 text-left">@lang('admin.description')
                                (@lang('admin.'.$locale)): <i class="text-danger">*</i></label>
                            <div class="col-lg-8">
                                <textarea type="text" name="{{$locale}}[description]" id="{{$locale}}[description]"
                                          @isset($item) rows="<?= strlen($item->description)/100+5 ?>" @endisset
                                          class="form-control {{$locale=='ar' ? 'textarea_rtl':'textarea_ltr'}}" >
                                        {{isset($item)&&$item->translate($locale)!=null?$item->translate($locale)->description:old($locale.'.description') }}

                                </textarea>
                                @error($locale.'.description')
                                <p class="invalid-feedback text-danger text-right rtl" role="alert">
                                    {{ $message }}
                                </p>
                                @enderror

                            </div>
                        </div>

                    </div>
                @endforeach
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-8 col-md-offset-2">
                <button type="submit" class="btn btn-sm btn-primary"><i
                            class="fa fa-save"></i> {{trans('admin.save')}}</button>
            </div>
        </div>


    </form>
@endsection

@push('js')


@endpush
