@extends('layouts.admin.app')

@section('widget-toolbar')
    @if($item->deleted_at==null)


        <a href="{{route($module_name.'.active',$item->id)}}"
           class="btn btn-xs btn-white btn-{{$item->status==1 ? 'primary': 'warning'}}" title=""
           data-rel="tooltip" data-placement="top"
           data-original-title="{{$item->status==1 ? trans('admin.inactive'): trans('admin.active')}}"
           data-loading-text="<i class='fa fa-spinner fa-spin '></i>"
           onclick="active(this,event);">
            <i class="ace-icon fa fa-{{$item->status==1 ? 'check': 'ban'}}"></i>
        </a>

        <a class="btn btn-white btn-info btn-xs" href="{{route($module_name.'.edit',$item->id)}}" data-rel="tooltip"
           data-placement="top" title="@lang('admin.edit')" data-original-title=" @lang('admin.edit')">
            <i class="ace-icon fa fa-pencil"></i>
        </a>


        <a class="btn btn-white btn-danger btn-xs" data-rel="tooltip" data-placement="top" title=""
           data-original-title=" حذف "
           onclick="event.preventDefault();deleteItem('{{route($module_name . '.destroy', [$item->id, 'soft_delete'])}}')">
            <i class="ace-icon fa fa-trash-o"></i>
        </a>


    @else
        <button class="btn btn-white btn-info btn-xs"
                data-rel="tooltip" data-placement="top"
                title="@lang('admin.restore')"
                data-original-title="@lang('admin.restore')"

                onclick="restoreItem('{{route($module_name.'.restore',[$item->id])}}')">
            <i class="fa fa-undo"></i>
        </button>

        </button>
    @endif

@endsection
@section('content')

    <div class="tabbed-info">
        <ul class="nav nav-tabs" role="tablist">
            @foreach(config('translatable.locales') as $locale)
                <li class="{{$locale=='ar' ? 'active':''}}"><a data-toggle="tab"
                                                               href="#tab-{{$locale}}">@lang('admin.'.$locale)</a>
                </li>
            @endforeach
        </ul>
        <div class="tab-content">
            @foreach(config('translatable.locales') as $locale)
                <div id="tab-{{$locale}}" class="tab-pane {{$locale=='ar' ? 'active' : ''}}  {{$locale=='ar' ? 'rtl' : 'ltr text-left'}}">
                    <div class="form-group">

                        <div class="col-lg-8">
                            {{$item->translate($locale)->title}}

                        </div>
                    </div>
                    <div class="form-group">

                        <div class="col-lg-8">
                            {{$item->translate($locale)->short_description}}

                        </div>
                    </div>
                    <div class="form-group">


                        <div class="col-lg-8">
                            {!! $item->translate($locale)->description !!}

                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>



    <div class="row">
        <div class="col-md-3">
            @if($item->image)
                <img src="{{$item->image_thumb_path}}" class="img-thumbnail"/>
            @else
                @lang('admin.no_image')
            @endif
        </div>
    </div>

@endsection

@push('js')

@endpush

