@extends('layouts.admin.app')

@section('content')

    <form class="form-horizontal form" role="form"
          action="{{isset($item) ? route($module_name.'.update' , $item->id) : route($module_name.'.store')}}"
          method="POST"
          enctype="multipart/form-data">
        @csrf
        @if (isset($item))
            @method("PUT")
        @endif

        <div class="form-group">
            <label for="nav_menu_id"
                   class="col-form-label col-lg-2 text-left">@lang('admin.nav_menu'):</label>
            <div class="col-lg-8">

                @if(isset($nav_menus))
                <select name="nav_menu_id" data-placeholder="@lang('admin.select')"
                        class="form-control chosen-select chosen-rtl" tabindex="2">
                    <option value=""></option>
                    @foreach($nav_menus as $menu)
                        <option value="{{$menu->id}}"
                                @if(isset($item))
                                @if($menu->id == $item->nav_menu_id)
                                selected
                                @endif
                                @endif
                        > {{$menu->name}} </option>
                    @endforeach
                </select>

                @error('nav_menu_id')
                <p class="invalid-feedback text-danger" role="alert">
                    {{ $message }}
                </p>
                @enderror
                @elseif(isset($nav_menu))
                    <select name="nav_menu_id" class="form-control">
                            <option value="{{$nav_menu->id}}"> {{$nav_menu->name}} </option>
                    </select>
                @endif
            </div>
        </div>

                        <div class="form-group">
                            <label for="name"
                                   class="col-form-label col-lg-2 text-left">@lang('admin.name'): <i class="text-danger">*</i></label>
                            <div class="col-lg-8">
                                <input type="text" name="name" id="name"
                                       class="form-control  rtl" placeholder=""
                                       value="{{isset($item) && $item !=null ? $item->name : old('name') }}">
                                @error('name')
                                <p class="invalid-feedback text-danger text-right rtl" role="alert">
                                    {{ $message }}
                                </p>
                                @enderror

                            </div>
                        </div>

        <div class="form-group">
            <div class="col-md-8 col-md-offset-2">
                <button type="submit" class="btn btn-sm btn-primary"><i
                        class="fa fa-save"></i> {{trans('admin.save')}}</button>
            </div>
        </div>


    </form>
@endsection

@push('js')


@endpush
