@extends('layouts.admin.app')
@section('widget-toolbar')
    <span>

    </span>
@endsection
@section('content')


    <form class="form-horizontal form" role="form"
          action="{{isset($item) ? route($module_name.'.update' , $item->id) : route($module_name.'.store')}}"
          method="POST"
          enctype="multipart/form-data">
        @csrf
        @if (isset($item))
            @method("PUT")
        @endif


                    <div class="form-group">
                            <label for="site_name"
                                   class="control-label col-lg-2 text-right">@lang('admin.site_name'): <i class="text-danger">*</i></label>
                            <div class="col-lg-8">
                                <input type="text" name="site_name" id="site_name"
                                       class="form-control rtl" placeholder=""
                                       value="{{isset($item) ? $item->site_name : old('site_name') }}">
                                @error('site_name')
                                <p class="invalid-feedback text-danger text-right rtl" role="alert">
                                    {{ $message }}
                                </p>
                                @enderror
                            </div>

                        </div>
                        <div class="form-group">
                            <label for="keywords"
                                   class="control-label col-lg-2 text-right">@lang('admin.keywords')
                                : </label>
                            <div class="col-lg-8">
                                            <textarea name="keywords" id="keywords" rows="5"
                                                      class="form-control rtl">{{isset($item) ? $item->keywords : old('keywords') }}</textarea>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="description"
                                   class="control-label col-lg-2 text-right">@lang('admin.description')
                                : </label>

                            <div class="col-lg-8">
                                            <textarea name="description" id="description"
                                                      rows="10"
                                                      class="form-control rtl">{{isset($item) ? $item->description : old('description') }}</textarea>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="form-group">
                                <label for="footer_desc"
                                       class="control-label col-lg-2 text-right">@lang('admin.footer_desc')
                                    : </label>

                                <div class="col-lg-8">
                                            <textarea name="footer_desc" id="footer_desc"
                                                      rows="10"
                                                      class="form-control rtl">{{isset($item) ? $item->footer_desc : old($locale.'.footer_desc') }}</textarea>
                                </div>
                            </div>
                        </div>






        <div class="form-group">
            <div class="col-md-8 col-md-offset-2">
                <button type="submit" class="btn btn-sm btn-primary"><i
                            class="fa fa-save"></i> {{trans('admin.save')}}</button>
            </div>
        </div>
    </form>


@endsection

@section('js')


@endsection
