@extends('layouts.admin.app')


@section('widget-actions')

@endsection
@section('content')

    @if ($items->count() > 0)
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead>
            <tr>
                <th width="50">#</th>
                <th>@lang('users.name')</th>
                <th>@lang('users.username')</th>
                <th>@lang('users.email')</th>
                <th width="150">@lang('admin.actions')</th>
            </tr>
            </thead>
            <tbody>
            @foreach($items as $index => $item)

                <tr>
                    <td>{{$index+1}}</td>
                    <td>{{$item->name}}</td>
                    <td>{{$item->username}}</td>
                    <td>{{$item->email}}</td>
                    <td>
                        {{view($components_view.'.actions')->with('data',$item)->with('module_actions', ['edit'])}}
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
        @else
        <div class="alert alert-info">@lang('admin.no_records')</div>
    @endif


@endsection

@push('js')

@endpush
