@extends('layouts.admin.app')

@section('widget-toolbar')
    <a  href="{{route($module_name.'.active',$item->id)}}"
        class="btn btn-xs btn-white btn-{{$item->status==1 ? 'primary': 'warning'}}" title=""
        data-rel="tooltip" data-placement="top"
        data-original-title="{{$item->status==1 ? trans('admin.inactive'): trans('admin.active')}}"
        data-loading-text="<i class='fa fa-spinner fa-spin '></i>"
        onclick="active(this,event);">
        <i class="ace-icon fa fa-{{$item->status==1 ? 'check': 'ban'}}"></i>
    </a>

    <a class="btn btn-white btn-info btn-xs" href="{{route($module_name.'.edit',$item->id)}}" data-rel="tooltip"
       data-placement="top" title="@lang('admin.edit')" data-original-title=" @lang('admin.edit')">
        <i class="ace-icon fa fa-pencil"></i>
    </a>

@endsection
@section('content')


    <div class="tabbed-info">
        <ul class="nav nav-tabs" role="tablist">
            @foreach(config('translatable.locales') as $locale)
                <li class="{{$locale=='ar' ? 'active':''}}"><a data-toggle="tab"
                                                               href="#tab-{{$locale}}">@lang('admin.'.$locale)</a>
                </li>
            @endforeach
        </ul>
        <div class="tab-content">
            @foreach(config('translatable.locales') as $locale)
                <div id="tab-{{$locale}}" class="tab-pane {{$locale=='ar' ? 'active' : ''}}  {{$locale=='ar' ? 'rtl' : 'ltr text-left'}}">
                    <div class="form-group">

                        <div class="col-lg-8">
                            {{$item->translate($locale)->question}}

                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

@endsection

@push('js')

@endpush

