@extends('layouts.frontend.app')

@push('css')
   {{-- <link rel="stylesheet" href="{{asset("frontend/assets/css/last-news.css")}}">--}}
@endpush

@section('content')
@include('layouts.frontend.includes.header-pages')

    {{-- start last news section --}}
    <div class="last-news text-center">
        <div class="container">
            <h2 class="news-heading"> @lang('frontend.administrative_bodies')</h2>
            <div class="row">
                @foreach($administrative_bodies as $bodies)
                    <div class="col-md-4 col-xs-12 col-sm-6 news-item">
                        <div class="news-img">
                            <img class="img-responsive" src="{{$bodies->image_path}}" alt="" >
                        </div>
                        <div class="caption">
                            <div class="caption-content">
                                <div class="news-head">
                                    <h3 class=" col-xs-text-center">{{$bodies->title}} </h3>
                                </div>

                                <div class="desc">
                                    <p class="news-desc">
                                        {!! $bodies->short_description !!}
                                    </p>
                                </div>
                            </div>

                            <a href="{{route('administrative_bodies.details',$bodies->id)}}"
                               class="news-details">
                                @lang('frontend.more')
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>

        </div>
    </div>
    {{--end last news section --}}
    {{-- start new edition section --}}
    @include('components.frontend.new_edition')

    {{--end new edition section --}}


    {{--start friend sites --}}
    @include('components.frontend.friendsite')
    {{--end friend sites--}}
@endsection
