@extends('layouts.frontend.app')

@push('css')
   {{-- <link rel="stylesheet" href="{{asset("frontend/assets/css/last-news.css")}}">--}}
@endpush

@section('content')

@include('layouts.frontend.includes.header-pages')

    {{-- start last news section --}}
    <div class="last-news text-center">
        <div class="container">
            <h2 class="news-heading"> @lang('frontend.book_activity')</h2>
            <div class="row">
                @foreach($book_activities as $activity)
                    <div class="col-md-4 col-xs-12 col-sm-6 news-item">
                        <div class="news-img">
                            <img class="img-responsive" src="{{$activity->image_path}}" alt="" >
                        </div>
                        <div class="caption">
                            <div class="caption-content">
                                <div class="news-head">
                                    <h3 class=" col-xs-text-center">{{$activity->title}} </h3>
                                </div>

                                <div class="desc">
                                    <p class="news-desc">
                                        {!! $activity->short_description !!}
                                    </p>
                                </div>
                            </div>

                            <a href="{{route('book_activities.details',$activity->id)}}"
                               class="news-details">
                                @lang('frontend.more')
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>

        </div>
    </div>
    {{--end last news section --}}
    {{-- start new edition section --}}
    @include('components.frontend.new_edition')

    {{--end new edition section --}}


    {{--start friend sites --}}
    @include('components.frontend.friendsite')
    {{--end friend sites--}}
@endsection
