@extends('layouts.frontend.app')
@push('css')
    <link rel="stylesheet" href="{{asset("frontend/assets/css/contacts.css")}}">
@endpush
@section('content')





@include('layouts.frontend.includes.header-pages')


    {{-- contact --}}

    <div class="contact-pages">
        <div class="container">
            <div class="row">
                <div class="col-md-8 col-sm-12 col-xs-12">
                    <div class="contact_form">
                        <div class="contact-form-title MB-50">
                            <h3>@lang('frontend.leave_a_message') </h3>
                        </div>
                        <div class="contact-form-inner">
                            <form action="{{route('send_email')}}" method="post" role="form" class="php-email-form ">
                                @csrf

                                <div class="contact_form-top">
                                    <div class="input-field">
                                        <input name="name" type="text" placeholder="@lang('frontend.name') : ">
                                        <span>*</span>
                                        <p id="msg_name" class="error_txt"></p>

                                    </div>
                                    <div class="input-field">
                                        <input name="subject" type="text" placeholder="@lang('frontend.subject') :">
                                        <p id="msg_subject" class="error_txt"></p>

                                    </div>
                                </div>
                                <div class="contact_form-middle">
                                    <div class="input-field">
                                        <input name="email" type="text" placeholder="@lang('frontend.email') :">
                                        <span>*</span>
                                        <p id="msg_email" class="error_txt"></p>

                                    </div>
                                    <div class="input-field">
                                        <input name="phone" type="text" placeholder="@lang('frontend.phone') :">
                                        <p id="msg_phone" class="error_txt"></p>

                                    </div>
                                </div>

                                <div class="contact-form-bottom">
                                    <textarea name="message" placeholder="@lang('frontend.message') :"></textarea>
                                    <p id="msg_message" class="error_txt"></p>

                                    <div class="form-submite">
                               <span>
                                    <input class="cap" type="text" id="captcha" name="captcha"
                                           autocomplete="off">
                               </span>

                                        @captcha
                                        <p class="note">@lang('frontend.change_captcha')</p>
                                        <p id="msg_captcha" class="error_txt"></p>
                                        <button type="button" class="btn btn-default"
                                                data-loading-text="<i class='fa fa-spinner fa-spin'></i> Processing"
                                                onclick="sendEmail(this,event)">@lang('frontend.send_message')</button>
                                    </div>
                                </div>


                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-md-4  col-sm-6  col-xs-12">
                    <div class="get-informed">
                        <div class="contact-form-title">
                            <h3>@lang('frontend.contact_with_us')</h3>
                        </div>
                        <div class="single-infromed-list">
                            <div class="single-infromed  fix">
                                <div class="inform-img">
                                    <img src="{{asset('frontend/assets/images/contact/contact1.png')}}" alt="">
                                </div>
                                <div class="inform-details">
                                    <div class="inform-title">
                                        <h2>@lang('frontend.address')</h2>

                                    </div>
                                    <div class="inform-info">
                                        <ul>
                                            <li><i class="zmdi zmdi-phone-in-talk"></i>@lang('frontend.location')
                                                : {{$contacts['title']}}</li>
                                            <li><i class="zmdi zmdi-email"></i>@lang('frontend.title')
                                                : {{$contacts['address']}}</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="single-infromed  fix">
                                <div class="inform-img">
                                    <img src="{{asset('frontend/assets/images/contact/contact-3.jpg')}}" alt="">

                                </div>
                                <div class="inform-details">
                                    <div class="inform-title">
                                        <h2>@lang('frontend.email') : </h2>

                                    </div>
                                    <div class="inform-info">
                                        <ul>
                                            <li><i class="zmdi zmdi-phone-in-talk"></i>@lang('frontend.email_1')
                                                : <a href="mailto:{{$contacts['email']}}">{{$contacts['email']}}</a></li>
                                            <li><i class="zmdi zmdi-email"></i>@lang('frontend.email_2')
                                                : <a href="mailto:{{$contacts['email_2']}}">{{$contacts['email_2']}}</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="single-infromed  fix">
                                <div class="inform-img">
                                    <img src="{{asset('frontend/assets/images/contact/contact2.png')}}" alt="">

                                </div>
                                <div class="inform-details">
                                    <div class="inform-title">
                                        <h2>@lang('frontend.phone')</h2>

                                    </div>
                                    <div class="inform-info">
                                        <ul>
                                            <li>@lang('frontend.phone')
                                                : <span class="phone">{{$contacts['phone']}}</span></li>
                                            <li>@lang('frontend.mobile')
                                                : <span class="phone">{{$contacts['mobile']}}</span></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- contact --}}

















    {{--start friend sites--}}
    @include('components.frontend.friendsite')
    {{--end friend sites--}}
@endsection
