@extends('layouts.frontend.app')
@push('css')
    <link rel="stylesheet" href="{{asset("frontend/assets/css/members.css")}}">
@endpush

@section('content')
@include('layouts.frontend.includes.header-pages')

    @include('components.frontend.Opening_speech')
    {{--start members section --}}
    <div class="members">
        <div class="container">
            <h2 class="members-heading text-center"> دليل الأعضاء </h2>
            <div class="members-search">

                <form action="{{route('search')}}" method="get">
                    <button type="submit" class="search_member"><i class="icofont-search"></i></button>

                    <input type="search" name="search"
                           id="search"
                           value="{{request()->search}}" required>

                </form>
            </div>
            <div class="alphabetical text-center">
                <?php $letters = ['أ', 'ب', 'ت', 'ث', 'ج', 'ح', 'خ', 'د', 'ذ', 'ر', 'ز', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ'
                    , 'ف', 'ق', 'ك', 'ل', 'م', 'ن', 'ه', 'و', 'ي'];
                ?>
                <span>
                    <i class="icofont-curved-right" style="font-size: 21px"></i>

                    @foreach($letters as $letter)
                        <a href="{{route('search.leeter',$letter)}}">{{$letter}}</a>
                        @if($letter != 'ي')
                            -
                        @endif
                    @endforeach
                    <i class="icofont-curved-left" style="font-size: 21px"></i>
                </span>
            </div>

            <div class="row">

                @foreach($members as $member_item)
                @foreach($member_item as $item)
                    <div class="col-md-4">
                        <div class="item item2">
                            <div class="media">
                                <div class="members-img pull-right">
                                    <img src="{{$item->image_thumb_path}}" class="img-responsive">
                                </div>
                                <div class="media-body members-body">
                                    <div class="members-name">
                                        <h4> {{$item->name}} </h4>
                                    </div>
                                    <p class="members-job"> {{$item->job}}  </p>
                                </div>
                            </div>
                            <hr class="member-separator">
                            <div class=" parg desc6">
                                <p> {!! nl2br($item->short_description) !!} </p>
                            </div>
                            <a href="{{route('members.details',$item->id)}}" class="members-details">
                                @lang('frontend.see_more')
                            </a>
                        </div>
                    </div>
                @endforeach
                @endforeach

            </div>
        </div>
    </div>
    {{--end members section--}}
    {{-- start new edition section --}}
    @include('components.frontend.new_edition')

    {{--end new edition section --}}
    {{--start friend sites --}}
    @include('components.frontend.friendsite')
    {{--end friend sites--}}
@endsection
