@extends('layouts.frontend.app')

@push('css')
    {{-- <link rel="stylesheet" href="{{asset("frontend/assets/css/last-news.css")}}">--}}
@endpush

@section('content')
@include('layouts.frontend.includes.header-pages')

    {{-- start last news section --}}
    <div class="last-news text-center">
        <div class="container">
            <h2 class="news-heading"> @lang('frontend.results')</h2>
            <div class="row">
                @foreach($results as $sub_result)
                    @foreach($sub_result as $result)
                        <div class="col-md-4 col-xs-12 col-sm-6 news-item">
                            <div class="news-img">
                                <img class="img-responsive" src="{{$result->image_path}}" alt="">
                            </div>
                            <div class="caption">
                                <div class="caption-content">
                                    <div class="news-head">
                                       <h3 class=" col-xs-text-center">{{$result->title ? $result->title : $result->name}}{{-- <a
                                                href="{{route('results.details',$result->id)}}">{{$result->title}} </a>--}}
                                        </h3>
                                    </div>

                                    <div class="desc">
                                        <p class="news-desc">
                                            {!! $result->short_description !!}
                                        </p>
                                    </div>
                                </div>

                                <a href="{{route($result->getModel()->getTable().'.details',$result->id)}}"
                                   class="news-details">
                                    @lang('frontend.more')
                                </a>
                            </div>
                        </div>
                        @if($loop->iteration%3==0)
            </div>
            <div class="row">
                @endif
                @endforeach
                @endforeach
            </div>

        </div>
    </div>
    {{--end last news section --}}

    {{-- start new edition section--}}
    @include('components.frontend.new_edition')
    {{--end new edition section--}}

    {{--start friend sites --}}
    @include('components.frontend.friendsite')
    {{--end friend sites--}}
@endsection
