<?php
Route::macro('newResource', function ($uri, $controller, $except = []) {
    Route::post("{$uri}/active/{id}", "{$controller}@active")->name("{$uri}.active");
    Route::post("{$uri}/is_new/{id}", "{$controller}@is_new")->name("{$uri}.is_new");
    Route::post("{$uri}/set_order/{id}", "{$controller}@set_order")->name("{$uri}.set_order");
    Route::delete("{$uri}/delete_image/{id}", "{$controller}@delete_image")->name("{$uri}.delete_image");
    Route::delete("{$uri}/restore/{id}", "{$controller}@restore")->name("{$uri}.restore");
    Route::delete("{$uri}/force_delete/{id}", "{$controller}@force_delete")->name("{$uri}.force_delete");
    Route::resource(
        $uri,
        $controller
    )->except($except);
});

Route::group(['middleware' => ['auth']], function () {

    Route::namespace('Admin')->prefix('cp')->group(function () {
        Route::get('/', 'HomeController@index')->name('home.index');
        Route::get('/', 'HomeController@index')->name('admin');


        Route::newResource('abouts', 'AboutController');
        Route::newResource('sliders', 'SliderController');
        Route::newResource('activities', 'ActivityController');
        Route::newResource('pension_founds', 'PensionFoundController');
        Route::newResource('circulars', 'CircularsController');
        Route::newResource('social_media','SocialMediaController');
        Route::newResource('contacts', 'ContactController');
        Route::newResource('settings', 'SettingController');
        Route::newResource('users', 'UserController');
        Route::newResource('nav_menu_items', 'NavMenuItemController');

        /*start control panel from  site original database*/
        Route::newResource('votes', 'VoteController');
        Route::newResource('bars', 'BarController');
        Route::newResource('categories', 'categoryController');
        Route::newResource('events', 'EventController');
        Route::newResource('last_meetings', 'LastMeetingController');
        Route::newResource('book_activities', 'BookActivityController');
        Route::newResource('founders', 'FounderController');
        Route::newResource('majors', 'MajorController');
        Route::newResource('deeds', 'DeedController');
        /*end control panel from  site original database*/

        /* start control panel for frontend new sections  */
        Route::newResource('nav_menus', 'NavMenuController');
        Route::newResource('menus', 'MenuController');
        Route::newResource('boxes', 'BoxController');
        Route::newResource('opening_words', 'OpeningWordController');
        Route::newResource('last_news', 'LastNewController');
        Route::newResource('staff', 'StaffController');
        Route::newResource('members', 'MemberController');
        Route::newResource('friend_sites', 'FriendSiteController');
        Route::newResource('union_specials', 'UnionSpecialController');
        Route::newResource('branches', 'BranchController');
        Route::newResource('branch_news', 'BranchNewController');
        Route::newResource('book_categories', 'BookCategoryController');
        Route::newResource('books', 'BookController');
        Route::newResource('edition_categories', 'EditionCategoryController');
        Route::newResource('editions', 'EditionController');
        Route::newResource('publishing_conditions', 'PublishingConditionController');
        Route::newResource('administrative_bodies', 'AdministrativeBodiesController');
        Route::newResource('subscribes', 'SubscribeController');

        /*end control panel for frontend new sections  */

    });
});
Route::namespace('Old')->prefix('cp')->group(function () {
    Route::get('/oldCategoryTitles', 'OldController@index');
    Route::get('/cat/{id}', 'OldController@cat');
    Route::get('/about', 'OldController@about');
    Route::get('/branches_news', 'OldController@branches_news');
    Route::get('/news', 'OldController@news');
    Route::get('/cat_15', 'OldController@cat_15'); // فروع الاتحاد
    Route::get('/cat_63', 'OldController@cat_63'); //شروط الانتساب الى اتحاد الكتاب العرب
    Route::get('/cat_92', 'OldController@cat_92');  // الهيئات الإدارية
    Route::get('/cat_97', 'OldController@cat_97');  // شروط النشر في الاتحاد
    Route::get('/cat_74', 'OldController@cat_74');  // الإصدارات الدورية
    Route::get('/cat_81', 'OldController@cat_81');  // الإصدارات الدورية

    Route::get('/oldCategoryDetails/{cat_id}', 'OldController@categoryDetails');


    Route::get('/oldBooks/{cat_id}', 'BookController@categoryBooks');
    Route::get('/publishing_cond/{cat_id}', 'PublishingConditionController@publishing_condition');

    Route::get('/oldEdition/{cat_id}', 'EditionController@edition_category');
    Route::get('/oldBranchNews/{cat_id}', 'BranchNewsController@branch_news');


});
