<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Auth::routes();


Route::group(['prefix' => LaravelLocalization::setLocale(), 'middleware' => ['localeSessionRedirect', 'localizationRedirect', 'localeViewPath']], function () {


    Route::namespace('FrontEnd')->group(function () {
        Route::get('/', 'HomeController@index')->name('home');


        /*start route for front end */
        Route::get('abouts', 'AboutController@index')->name('abouts');
        Route::get('abouts/{id}', 'AboutController@show')->name('abouts.details');

        Route::get('activities', 'ActivityController@index')->name('activities');
        Route::get('activities/{id}', 'ActivityController@show')->name('activities.details');


        Route::get('pension_founds', 'PensionFoundController@index')->name('pension_founds');
        Route::get('pension_founds/{id}', 'PensionFoundController@show')->name('pension_founds.details');


        Route::get('circulars', 'CircularsController@index')->name('circulars');
        Route::get('circulars/{id}', 'CircularsController@show')->name('circulars.details');

        Route::get('property_laws', 'PropertyLawController@index')->name('property_laws');
        Route::get('participate_conditions', 'ParticipateConditionController@index')->name('participate_conditions');

        Route::get('contacts', 'ContactController@index')->name('contacts');

        Route::get('last_news', 'LastNewsController@index')->name('last_news');
        Route::get('last_news/{id}', 'LastNewsController@show')->name('last_news.details');
        Route::get('branch_news', 'BranchNewsController@index')->name('branch_news');
        Route::get('branch_news/{id}', 'BranchNewsController@show')->name('branch_news.details');

        Route::get('members', 'MemberController@index')->name('members');
        Route::get('members/{id}', 'MemberController@show')->name('members.details');

        Route::get('books', 'BookController@index')->name('books');

        Route::get('publishing_conditions', 'PublishingConditionController@index')->name('publishing_conditions');
        Route::get('publishing_conditions/{id}', 'PublishingConditionController@show')->name('publishing_conditions.details');

        Route::get('edition/category', 'EditionCategoryController@index')->name('edition_category');
        Route::get('editions/view/{id}', 'EditionController@view')->name('editions.view');
        Route::get('editions', 'EditionController@index')->name('editions');
        Route::get('editions/{id}', 'EditionController@show')->name('editions.details');

        Route::get('administrative', 'AdministrativeBodiesController@index')->name('administrative_bodies');
        Route::get('administrative/{id}', 'AdministrativeBodiesController@show')->name('administrative_bodies.details');

        Route::get('last-meetings', 'LastMeetingController@index')->name('last_meetings');
        Route::get('last-meetings/{id}', 'LastMeetingController@show')->name('last_meetings.details');


        Route::get('activity', 'BookActivityController@index')->name('book_activities');
        Route::get('activity/{id}', 'BookActivityController@show')->name('book_activities.details');

        Route::get('events', 'EventController@index')->name('events');
        Route::get('events/{id}', 'EventController@show')->name('events.details');

        Route::get('founders', 'FounderController@index')->name('founders');
        Route::get('founders/{id}', 'FounderController@show')->name('founders.details');

        Route::get('majors', 'MajorController@index')->name('majors');
        Route::get('majors/{id}', 'MajorController@show')->name('majors.details');

        Route::get('deeds', 'DeedController@index')->name('deeds');
        Route::get('deeds/{id}', 'DeedController@show')->name('deeds.details');

        Route::get('branches', 'BrancheController@index')->name('branches');
        Route::get('branches/{id}', 'BrancheController@show')->name('branches.details');
        Route::get('book_categories', 'BookCategoryController@index')->name('book_categories');
        Route::get('books/view/{id}', 'BookController@view')->name('books.view');
        Route::get('books/{id}', 'EditionController@show')->name('books.details');
        Route::get('search', 'MemberController@search')->name('search');
        Route::get('search/{letter}', 'MemberController@search_letter')->name('search.leeter');
        Route::get('search-all', 'HomeController@search_all')->name('search_all');

        Route::post('send_email', 'ContactController@send')->name('send_email');
        Route::post('subscribe', 'SubscribeController@subscribe')->name('subscribe');


        /*end route for front end */


        /*start testing route*/
        Route::get('trains', 'TrainController@index')->name('trains');
        /*end testing route */

        // Route::get('hasan/{age?}', 'HasanController@test')->name('hs');
    });
});


