<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta charset="utf-8" />
    <title><?php echo e(trans('admin.admin_title')); ?> | <?php echo e($module_title); ?> </title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="description" content="" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />

    <link rel="stylesheet" href="<?php echo e(mix('css/admin.app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('admin/bootstrapValidator/bootstrapValidator.min.css')); ?>">
    <?php if(app()->getLocale()=='ar'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('admin/assets/css/ace-rtl.css')); ?>">
    <?php endif; ?>
<?php echo $__env->yieldContent('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/css/colorbox.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/my_css/style.css')); ?>">

    <!--[if lte IE 9]>
    <link rel="stylesheet" href="<?php echo e(asset('css/ace-part2.css')); ?>" class="ace-main-stylesheet" />
    <![endif]-->

    <!--[if lte IE 9]>
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/css/ace-ie.css')); ?>" />
    <![endif]-->

    <!-- inline styles related to this page -->

    <!-- ace settings handler -->
    <script src="<?php echo e(asset('admin/assets/js/ace-extra.js')); ?>"></script>

    <!-- HTML5shiv and Respond.js for IE8 to support HTML5 elements and media queries -->

    <!--[if lte IE 8]>
    <script src="<?php echo e(asset('admin/assets/js/html5shiv.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/js/respond.js')); ?>"></script>
    <![endif]-->
    <script>
        (function () {
            window.Laravel = {
                csrfToken: '<?php echo e(csrf_token()); ?>'
            };
        })();
        var app_locale = '<?php echo config('app.locale'); ?>';
        var table_settings = {};
        var asset = '<?php echo e(asset('/')); ?>';
        var method_name = '<?php echo e($method_name); ?>';
        <?php if($module_name !='home'): ?>
        var index_route = '<?php echo e(route($module_name.'.index')); ?>';
        <?php endif; ?>
        var module_name = '<?php echo e($module_name); ?>';
    </script>
</head>

<body class="no-skin <?php echo e(app()->getLocale()=='ar' ? 'rtl' : ''); ?>">
<!-- #section:basics/navbar.layout -->
<div id="app">
<?php echo $__env->make('layouts.admin.includes.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- /section:basics/navbar.layout -->
<div class="main-container" id="main-container">


    <!-- #section:basics/sidebar -->
    <?php echo $__env->make('layouts.admin.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- /section:basics/sidebar -->
    <div class="main-content">
        <div class="main-content-inner">
            <!-- #section:basics/content.breadcrumbs -->
            <div class="breadcrumbs" id="breadcrumbs">
                <ul class="breadcrumb">
                    <li>

                        <i class="ace-icon fa fa-home home-icon"></i>
                        <a href="<?php echo e(route('admin')); ?>"> <?php echo app('translator')->get('home.module_title'); ?></a>
                    </li>

                    <?php if($method_name=='index' || $method_name==null): ?>
                    <li class="active"><?php echo e($module_title); ?></li>
                    <?php else: ?>
                    <li ><a href="<?php echo e(route($module_name.'.index')); ?>"> <?php echo e($module_title); ?> </a></li>
                    <?php endif; ?>




                </ul><!-- /.breadcrumb -->

                <!-- #section:basics/content.searchbox -->
                
                <div class="nav-search">

                    <?php if(request()->has('trashed')): ?>
                        <a href="<?php echo e(route($module_name.'.index',$param?? '')); ?>"
                           class="btn btn-inverse btn-xs"><?php echo app('translator')->get('admin.back'); ?> <i
                                class="fa fa-arrow-left"></i> </a>
                    <?php endif; ?>
                    <?php if(!request()->has('trashed') && (isset($deleted_items) && $deleted_items->count()>0)): ?>
                        <a href="<?php echo e(route($module_name.'.index',['trashed',$param?? ''])); ?>"
                           class="btn btn-danger btn-xs"><i
                                class="fa fa-trash"></i> <?php echo app('translator')->get('admin.trashed'); ?></a>
                    <?php endif; ?>
                </div>
                <!-- /.nav-search -->

                <!-- /section:basics/content.searchbox -->
            </div>

            <!-- /section:basics/content.breadcrumbs -->
            <div class="page-content">
                <!-- #section:settings.box -->
                
                <!-- /.ace-settings-container -->

                <!-- /section:settings.box -->
                <div class="row">
                    <div class="col-xs-12">
                        <!-- PAGE CONTENT BEGINS -->
                        <div class="widget-box">
                            <div class="widget-header">
                                <h4 class="widget-title"><?php echo e($method_title ?? ''); ?></h4>


                                <div class="widget-toolbar">

                                        <?php if (! empty(trim($__env->yieldContent('widget-toolbar')))): ?>
                                            <?php echo $__env->yieldContent('widget-toolbar'); ?>
                                        <?php else: ?>
                                            <?php if($method_name=='index'): ?>
                                            <a href="<?php echo e(route($module_name.'.create')); ?>" class="btn btn-primary btn-xs"><i class="ace-icon fa fa-plus"></i><?php echo e(trans('admin.create')); ?></a>
                                            <?php endif; ?>
                                        <?php endif; ?>


                                </div>
                            </div>

                            <div class="widget-body">

                                <div class="widget-main">

                                    <?php if($message = \Session::get('success')): ?>
                                        <div class="alert alert-success">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php endif; ?>
                                        <?php if($message = \Session::get('error')): ?>
                                        <div class="alert alert-danger">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php endif; ?>
                                    <?php echo $__env->yieldContent('content'); ?>
                                </div>
                            </div>
                        </div>

                        <!-- PAGE CONTENT ENDS -->
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.page-content -->
        </div>
    </div><!-- /.main-content -->


    <a href="#" id="btn-scroll-up" class="btn-scroll-up btn btn-sm btn-inverse">
        <i class="ace-icon fa fa-angle-double-up icon-only bigger-110"></i>
    </a>
    <div class="modal fade draggable-modal" id="ajaxModal" tabindex="-1" role="basic" aria-hidden="true">
        <div class="modal-dialog">


            <div class="modal-content">
                <div class="modal-body ">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin bigger-250"></i>
                        <span>&nbsp;&nbsp;   </span>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div><!-- /.main-container -->
</div>

<!--[if IE]>
<script type="text/javascript">
    window.jQuery || document.write("<script src='<?php echo e(asset('admin/assets/js/jquery1x.js')); ?>'>"+"<"+"/script>");
</script>
<![endif]-->
<script type="text/javascript">
    if('ontouchstart' in document.documentElement) document.write("<script src='<?php echo e(asset('admin/assets/js/jquery.mobile.custom.js')); ?>'>"+"<"+"/script>");
</script>

<script src="<?php echo e(mix('js/admin.app.js')); ?>"></script>

<script src="<?php echo e(asset('admin/bootstrapValidator/bootstrapValidator.min.js')); ?>"></script>
<?php if(app()->getLocale()=='ar'): ?>
    <script src="<?php echo e(asset('admin/bootstrapValidator/ar_MA.js')); ?>"></script>
<?php endif; ?>
<script src="<?php echo e(asset('admin/assets/js/date-time/bootstrap-datepicker.js')); ?>"></script>
<script src="<?php echo e(asset('admin/assets/js/date-time/bootstrap-timepicker.js')); ?>"></script>
<script src="<?php echo e(asset('admin/assets/js/date-time/moment.js')); ?>"></script>
<script src="<?php echo e(asset('admin/assets/js/date-time/daterangepicker.js')); ?>"></script>
<script src="<?php echo e(asset('admin/assets/js/date-time/bootstrap-datetimepicker.js')); ?>"></script>
<script src="<?php echo e(asset('admin/assets/js/bootstrap-colorpicker.js')); ?>"></script>
<script src="<?php echo e(asset('admin/assets/js/jquery.bootstrap-duallistbox.js')); ?>"></script>
<script src="<?php echo e(asset('admin/assets/js/jquery.colorbox.js')); ?>"></script>
<script src="<?php echo e(asset('admin/assets/my_js/script.js')); ?>"></script>
<script type="text/javascript">
    jQuery(function($) {
        $('#colorpicker1').colorpicker();

        $("body").delegate(".date-picker", "focusin", function () {
            $(this).datepicker({
                autoclose: true,
                todayHighlight: true
            })
                //show datepicker when clicking on the icon
                .next().on(ace.click_event, function () {
                $(this).prev().focus();
            });
        });
    });

</script>


<script type="text/javascript">
    jQuery(function($) {
        var $overflow = '';
        var colorbox_params = {
            rel: 'colorbox',
            reposition:true,
            scalePhotos:true,
            scrolling:false,
            previous:'<i class="ace-icon fa fa-arrow-left"></i>',
            next:'<i class="ace-icon fa fa-arrow-right"></i>',
            close:'&times;',
            current:'{current} of {total}',
            maxWidth:'100%',
            maxHeight:'100%',
            onOpen:function(){
                $overflow = document.body.style.overflow;
                document.body.style.overflow = 'hidden';
            },
            onClosed:function(){
                document.body.style.overflow = $overflow;
            },
            onComplete:function(){
                $.colorbox.resize();
            }
        };

        $('.ace-thumbnails [data-rel="colorbox"]').colorbox(colorbox_params);
        $("#cboxLoadingGraphic").html("<i class='ace-icon fa fa-spinner orange fa-spin'></i>");//let's add a custom loading icon


        $(document).one('ajaxloadstart.page', function(e) {
            $('#colorbox, #cboxOverlay').remove();
        });
    })
</script>


<script src="<?php echo asset('admin/assets/plugins/tinymce/tinymce.min.js'); ?>"></script>
<script src="<?php echo asset('admin/assets/my_js/tinymce_settings.js'); ?>"></script>


<?php echo $__env->yieldPushContent('js'); ?>
</body>
</html>
<?php /**PATH E:\xampp\htdocs\SWT\SyrMon\2021\awu.sy\awu\resources\views/layouts/admin/app.blade.php ENDPATH**/ ?>