<?php
    $status_class = $data->status == 1 ? 'btn-success' : 'btn-warning';
    $status_icon = $data->status == 1 ? 'check' : 'ban';
    $status_title = $data->status == 1 ? trans('admin.inactive') : trans('admin.active');

    $new_class = $data->new == 1 ? 'btn-success' : 'btn-warning';

    $new_title = $data->new == 1 ? trans('admin.not_new') : trans('admin.new');
?>
<div class="btn-group">
    <?php if($data->deleted_at==null): ?>
        <?php if(in_array('is_new',$module_actions)): ?>
            <a href="<?php echo e(route($module_name . '.is_new', $data->id)); ?>"
               class="btn btn-xs <?php echo e($new_class); ?>"
               data-container="body" data-rel="tooltip" data-placement="top"
               data-loading-text="<i class='fa fa-spinner fa-spin'></i>"
               data-original-title="<?php echo e($new_title); ?>"
               title="<?php echo e($new_title); ?>"
               onclick="active(this,event);">
                <i class="fa fa-star "></i>
            </a>
        <?php endif; ?>
            <?php if(in_array('active',$module_actions)): ?>
                <a href="<?php echo e(route($module_name . '.active', $data->id)); ?>"
                   class="btn btn-xs <?php echo e($status_class); ?>"
                   data-container="body" data-rel="tooltip" data-placement="top"
                   data-loading-text="<i class='fa fa-spinner fa-spin'></i>"
                   data-original-title="<?php echo e($status_title); ?>"
                   title="<?php echo e($status_title); ?>"
                   onclick="active(this,event);">
                    <i class="fa fa-<?php echo e($status_icon); ?> "></i>
                </a>
            <?php endif; ?>
        <?php if(in_array('edit',$module_actions)): ?>
            <a href="<?php echo e(route($module_name.'.edit',$data->id)); ?>"
               <?php if(isset($actions_modal) && in_array('edit',$actions_modal)): ?>
               data-toggle="modal" data-target="#ajaxModal"
               <?php endif; ?>
               class="btn btn-xs btn-info"
               data-container="body" data-rel="tooltip"
               data-placement="top" data-original-title="<?php echo e(trans('admin.edit')); ?>">
                <i class="fa fa-edit"></i>
            </a>
        <?php endif; ?>
        <?php if(in_array('delete',$module_actions)): ?>
            <a href="javascript:;" class="btn btn-xs btn-danger"
               data-container="body" data-rel="tooltip" data-placement="top"
               data-original-title="<?php echo app('translator')->get('admin.delete'); ?>"
               onclick="deleteItem('<?php echo e(route($module_name . '.destroy', [$data->id, 'soft_delete'])); ?>')">
                <i class="fa fa-trash"></i>
            </a>
        <?php endif; ?>
    <?php else: ?>
        <?php if(in_array('delete',$module_actions)): ?>
            <button class="btn btn-xs btn-info"
                    data-container="body" data-rel="tooltip" data-placement="top"
                    title="<?php echo app('translator')->get('admin.restore'); ?>"
                    data-original-title="<?php echo app('translator')->get('admin.restore'); ?>"

                    onclick="restoreItem('<?php echo e(route($module_name.'.restore',[$data->id])); ?>')">
                <i class="fa fa-undo"></i>
            </button>
        <?php endif; ?>
        <?php if(in_array('delete',$module_actions)): ?>
            <button class="btn btn-danger btn-xs"
                    data-container="body" data-rel="tooltip" data-placement="top"
                    title="<?php echo app('translator')->get('admin.force_delete'); ?>"
                    data-original-title="<?php echo app('translator')->get('admin.force_delete'); ?>"

                    onclick="deleteItem('<?php echo e(route($module_name.'.destroy',$data->id)); ?>')">
                <i class="fa fa-trash"></i>
            </button>
        <?php endif; ?>
    <?php endif; ?>
</div>
<?php /**PATH /home/awu/new.awu.sy/resources/views/components/admin/actions.blade.php ENDPATH**/ ?>