<?php
include('inc/header.php');
include("inc/resize_image.php");
$allow_img_w = 360;
$allow_ratio = 1/1;
$allow_ratio_text = '1/1';
$allow_img_h = $allow_img_w * (1/$allow_ratio);
$page_name_text = 'المنتجات';
$table_name = 'products';
$no_img     = '1_1.jpg';
?>
<script src="../plugins/cropimage/js/my_crop.js"></script>

<!-- Content Header (Page header) -->
<section class="content-header">
    <ol class="breadcrumb">
        <li><a href="index.php"><i class="fa fa-dashboard"></i> لوحة التحكم</a></li>
        <li class="active"><a href="<?php echo $table_name;?>.php"> <?php echo $page_name_text;?></a></li>
    </ol>
</section>

<section class="content">
    <div class="box box-primary">

<?php

$action = !isset($_GET['action']) ? "view" :$_GET['action'];
if ($action=="view"){
	if(isset($_GET['cat_id']) && is_numeric($_GET['cat_id']) && $_GET['cat_id'] !=0 && !empty($_GET['cat_id'])){
	$catid = intval($_GET['cat_id']);
	$AllItems = getSpecialItems($table_name," WHERE cat_id=$catid");
	$cat = getItemById('categories',$catid);
	$cat_name =' في  التصنيف  '.$cat['title'];
	$add_link = '&cat_id='.$catid;
    }else{
    	$AllItems = getAllItems('products');
    	$cat_name = '';
    	$add_link = '';
    }
?>
<div class="box-header">
    <h3 class="box-title"> المنتجات <?php echo $cat_name?></h3>
    <div class="box-tools pull-left">
    <a href="products.php?action=add<?php echo $add_link?>" class="btn btn-primary"><i class="fa fa-plus"></i> إضافة منتج</a>
    </div>
</div>
<?php

if(sizeof($AllItems) > 0){
?>

<div class="box-body">
<table class="table table-bordered table-striped datatables">
    <thead>
    <tr>
        <th width="8%" align="center">#</th>
        <th width="10%" align="center">الصورة </th>
        <th width="32%" align="center">الاسم </th>
        <th width="15%" align="center">التصنيف </th>
        <th width="15%" align="center">تاريخ الاضافة / التعديل</th>
        <th width="20%" align="center">الاجراء</th>
    </tr>
    </thead>
    <tbody>
<?php
for($i=0;$i<sizeof($AllItems);$i++){
$id          = $AllItems[$i]['id'];
$title       = $AllItems[$i]['title'];
$image       = $AllItems[$i]['image'];
$state       = $AllItems[$i]['state'];
$home        = $AllItems[$i]['home'];
$cat_id      = $AllItems[$i]['cat_id'];

$add_date    = $AllItems[$i]['add_date'];
$last_update = $AllItems[$i]['last_update'];

$cat    = getItemById('categories',$cat_id);
?>
    <tr >
        <td align="center"><?php echo $i+1?></td>
        <td align="center">
        <?php
        if(!empty($image) && file_exists('../uploads/products/thumb/'.$image)){
        ?>
        <img src="../uploads/products/thumb/<?php echo $image?>" class="img-responsive" width="85" />
        <?php
        }else{
        ?>
        <img class="img-responsive pull-lang-reverse" src="../assets/images/<?php echo $no_img?>" width="85" />
        <?php
        }
        ?>
        </td>
        <td align="center">
        <a href="products.php?action=details&id=<?php echo $id?>"><?php echo $title?></a>

        </td>
        <td align="center">
             <?php echo $cat['title'] ?>

        </td>
        <td align="center">
        <?php
        if($last_update==0){
            echo $add_date;
        }else{
            echo $last_update;
        }

        ?>
        </td>
        <?php

        ?>

        <td align="center">

        <?php
        if($state==1){
            echo' <a href="products.php?action=show&id='.$id.'&state=0" class="btn btn-success" data-toggle="tooltip" title="حجب" ><i class="fa fa-check-circle"></i></a> ';
        }else{
            echo' <a href="products.php?action=show&id='.$id.'&state=1" class="btn btn-danger" data-toggle="tooltip" title=" تفعيل" ><i class="fa  fa-ban"></i></a> ';
        }

        if($home==1){
            echo' <a href="products.php?action=home&id='.$id.'&home=0" class="btn btn-success" data-toggle="tooltip" title="إلغاء العرض في الرئيسية" ><i class="fa fa-home"></i></a> ';
        }else{
            echo' <a href="products.php?action=home&id='.$id.'&home=1" class="btn btn-danger" data-toggle="tooltip" title=" عرض في الرئيسية" ><i class="fa  fa-home"></i></a> ';
        }
        ?>
        <a class="btn btn-default" href="products.php?action=edit&id=<?php echo $id?>"  data-toggle="tooltip" title="" data-original-title="تعديل">
        <i class="fa fa-edit text-blue"></i></a>
        <a class="btn btn-default confirm" href="products.php?action=del&id=<?php echo $id?>"  data-toggle="tooltip" title="" data-original-title="حذف">
        <i class="fa fa-trash-o text-red"></i></a></td>
    </tr>
<?php
}
?>
</tbody>
</table>

<?php
}else{
	echo '<div class="callout callout-warning"><h4>السجل فارغ !  </h4></div>';
}
?>
</div>
<?php



}elseif($action=="add"){
?>
<div class="box-header">
    <h3 class="box-title"> إضافة منتج </h3>
</div>
<div class="box-body">
<div class="callout callout-info">
 <h4>ملاحظة </h4>
<p> - الصورة يجب أن تكون بلاحقة JPG,PNG,GIf  </p>
<p> -  نسبة العرض إلى الارتفاع <?php echo $allow_ratio_text;?> والحد الأصغري  (<?php echo $allow_img_h.'*'.$allow_img_w;?> ) </p>
</div>
<div class="tabbed-info page-row">
    <ul class="nav nav-tabs" style="margin-bottom:15px;">
      <li class="active">
      <a href="#tab-1" data-toggle="tab"> عربي <i class="fa"></i></a>
      </li>
      <li class="">
      <a href="#tab-2" data-toggle="tab"> انكليزي  <i class="fa"></i></a>
      </li>
    </ul>
 <form  enctype="multipart/form-data" class="form-horizontal" role="form" action="?action=insert" method="post"  id="upload_form">
        <input type="hidden" id="x1" name="x1" />
        <input type="hidden" id="y1" name="y1" />
        <input type="hidden" id="x2" name="x2" />
        <input type="hidden" id="y2" name="y2" />
        <input type="hidden" id="filesize" name="filesize" />
        <input type="hidden" id="filetype" name="filetype" />
        <input type="hidden" id="filedim" name="filedim" />
        <input type="hidden" id="h" name="h"/>
        <input type="hidden" id="w" name="w"/>
<div class="tab-content">
    <div class="tab-pane active" id="tab-1">
        <div class="form-group">
            <label for="title" class="col-sm-2 control-label">اسم المنتج  : <em class="text-red">*</em></label>
            <div class="col-sm-6">
              <input type="text" name="title" class="form-control text-right" id="title" placeholder="">
            </div>
        </div>
        <div class="form-group">

            <?php
			if(isset($_GET['cat_id']) &&
				!empty($_GET['cat_id']) &&
				$_GET['cat_id']!=0 &&
				is_numeric($_GET['cat_id'])
				&& checkItem('id','categories',$_GET['cat_id'])){
				$cat_id    = intval($_GET['cat_id']);
				$cat       = getItemById('categories',$cat_id);
				echo '<label for="cat_brand" class="col-sm-2 control-label">تم اختيار قسم:  </label>
                      <div class="col-sm-6"><h4 class="text-success">'.$cat['title'].'</h4>';
				echo '<input type="hidden" name="cat" value="'.$cat_id.'" ></div>';
			}else{
				$cat = getAllItems('categories');
				if(sizeof($cat) > 0){
				?>
                <label for="cat_brand" class="col-sm-2 control-label">القسم  : <em class="text-red">*</em></label>
                <div class="col-sm-6" id="cat">
					<select name="cat" class="form-control chzn-cat" id="cat_brand">
						<option value="">اختر القسم</option>
						<?php
						for($ci=0;$ci<sizeof($cat);$ci++){
                            $cat_id      = $cat[$ci]['id'];
                            $cat_title   = $cat[$ci]['title'];
                            echo '<option value="'.$cat_id.'">'.$cat_title.'</option>';
                            }
						?>
					</select>
                </div>
				<?php
				}else{
				?>
				<a href="categories.php?action=add" class="btn btn-primary "><i class="fa fa-plus"></i> إضافة قسم </a>
				<?php
				}
			}
			?>
        </div>
        <div class="form-group">
            <label for="content" class="col-sm-2 control-label">وصف تفصيلي  : </label>
            <div class="col-sm-6">
                <textarea name="content" rows="10" class="form-control textarea" dir="rtl"></textarea>
            </div>
        </div>


    </div>
    <div class="tab-pane" id="tab-2">
      <div class="form-group">
        <label for="title_en" class="col-sm-2 control-label">اسم المنتج : </label>
        <div class="col-sm-6">
          <input type="text" name="title_en" class="form-control ltr">
        </div>
      </div>
      <div class="form-group">
        <label for="content_en" class="col-sm-2 control-label">وصف تفصيلي : </label>
        <div class="col-sm-6">
          <textarea name="content_en" rows="10" class="form-control ltr textarea_en"></textarea>
        </div>
      </div>
    </div>
   </div>
      <div class="form-group">
            <label for="image_file" class="col-sm-2 control-label">الصورة   : </label>
            <div class="col-sm-6">
            <input type="file" name="image_file" id="image_file" onchange="initGrop(<?php echo ($allow_img_w).','.($allow_img_h) ;?>);"/>
            <p class=" text-red" id="error"></p>
            </div>
        </div>
        <fieldset id="image_div" style="display:none">
        <div class="form-group">
            <label for="image_file" class="col-sm-2 control-label">    </label>
            <div class="col-sm-10" id="interface">
                 <img id="preview"  />
            </div>
        </div>
       </fieldset>
        <div class="form-group">
         <label for="image_file" class="col-sm-2 control-label"></label>
          <div class="col-sm-6">
          <img id="preview"  />
         </div>
        </div>

<div class="form-group">
    <div class="col-sm-6 col-sm-offset-2">
     	<button type="submit" name="Add" class="btn btn-primary"><i class="fa fa-save"></i> حفظ </button>
    </div>
</div>
 </form>
</div>
<script type="text/javascript">
$(document).ready(function() {
  $('#upload_form').bootstrapValidator({
	fields: {
		title : {
			validators: {
				notEmpty: {
					message: ''
					}
				}
			},
        cat : {
			validators: {
				notEmpty: {
					message: ''
					}
				}
			},
			image_file: {
				validators: {
					file: {
						extension: 'PNG,JPG,JPEG,gif',
						type: 'image/jpeg,image/png,image/gif',
						message: 'نوع الصورة غير مسموح , يسمح فقط بالأنواع [PNG,JPG,JPEG,GIF]'
					}
				}
			}
		}
  });
});
</script>
</div>
<?php
}elseif($action=="insert"){
?>
<div class="box-header">
    <h3 class="box-title"> إضافة منتج </h3>
</div>
<div class="box-body">
<?php
if (isset($_POST['Add'])){
	$title         = $_POST['title'];
    $content       = $_POST['content'];
	$title_en      = $_POST['title_en'];
	$content_en    = $_POST['content_en'];
	$cat_id        = $_POST['cat'];
	$image_file    = $_FILES['image_file']['name'];
    $image_temp    = $_FILES['image_file']['tmp_name'];
if($title =='' || $cat_id ==''){
	echo '<br><div class="alert alert-danger alert-dismissable"><i class="fa fa-ban"></i><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>جميع الحقول التي بجانبها علامة (*) مطلوبة   </div><a href="" class="btn btn-primary" onclick="window.history.go(-1); return false;">عودة للخلف</a>';
	}else{
     	$INSERT = $con->prepare("INSERT INTO products (title,content,title_en,content_en,image,cat_id,add_date,state) VALUES (:title,:content,:title_en,:content_en,:image,:cat_id,now(),:state)");
		$INSERT->execute(array(
			':title'=>$title,
			':content'=>$content,
			':title_en'=>$title_en,
			':content_en'=>$content_en,
			':image'=>'',
		    ':cat_id'=>$cat_id,
			':state'=>1
		));

		$count = $INSERT->rowCount();
		if($count > 0){
			$id = $con->lastInsertId();
		if(!empty($image_file)){
				$img_name = $table_name.'_'.$id;
				$ext = @strtolower(end(explode('.',$image_file)));
				$image_name  = $table_name."_".$id.".".$ext;
				$target_path = "../uploads/".$table_name."/".$image_name;
				$small_path  = "../uploads/".$table_name."/thumb/".$image_name;

				if(move_uploaded_file($image_temp,$target_path)){
					$iWidth =$_POST['w'];
					$iHeight=$_POST['h'];
					$jpeg_quality = 90;
					$aSize = getimagesize($target_path);
					switch($aSize[2]) {
						case IMAGETYPE_JPEG:
								$sExt = '.jpg';
								$vImg = @imagecreatefromjpeg($target_path);
								break;
						case IMAGETYPE_PNG:
								$sExt = '.png';
								$vImg = @imagecreatefrompng($target_path);
								break;
						case IMAGETYPE_GIF:
                                $sExt = '.gif';
                                $vImg = @imagecreatefromgif($target_path);
                                break;
						default:
								return;
					}
					if($iHeight < $allow_img_h){
						$vDstImg = imagecreatetruecolor($allow_img_w,$allow_img_h);
						$whiteBackground = imagecolorallocate($vDstImg, 255, 255, 255);
						imagefill($vDstImg,0,0,$whiteBackground);
					}else{
						$vDstImg = @imagecreatetruecolor($iWidth,$iHeight);
					}

					imagecopyresampled($vDstImg,$vImg,0,0,(int)$_POST['x1'],(int)$_POST['y1'],$iWidth,$iHeight,(int)$_POST['w'],(int)$_POST['h']);
					if(imagejpeg($vDstImg,$small_path,$jpeg_quality)){
						list($width,$height) = getimagesize($target_path);
						if($height > $allow_img_h)
						{
							list($width1,$height1)=calculate_width_height($width,$height,$width,$allow_img_h);
							resize($small_path,$small_path,$width1,$height1);
						}
				    }
					$UPDATE   =  $con->prepare("UPDATE $table_name SET image=? WHERE id=?");
					$UPDATE->execute(array($image_name,$id));

				}
			}
			echo'<div class="alert alert-success alert-dismissable"><i class="fa fa-check"></i><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button> تمت الإضافة بنجاح.</div>';
			echo '<META HTTP-EQUIV="Refresh" CONTENT="1;URL=products.php" >';
		}

	}
}
?>
</div>
<?php
}elseif($action=="edit"){
    $id = isset($_GET['id']) && is_numeric($_GET['id']) ? intval($_GET['id']):0;
	$Item = getItemById('products',$id);
	if(count($Item) > 0){
	$title         = stripslashes($Item['title']);
    $content       = stripslashes($Item['content']);
	$title_en      = stripslashes($Item['title_en']);
	$content_en    = stripslashes($Item['content_en']);
	$get_cat_id        = $Item['cat_id'];
	$image         = $Item['image'];
?>
<div class="box-header">
    <h3 class="box-title"> تعديل المنتج: <?=$title?> </h3>

</div>
<div class="box-body">
<div class="callout callout-info">
 <h4>ملاحظة </h4>
<p> - الصورة يجب أن تكون بلاحقة JPG,PNG,GIf  </p>
<p> -  نسبة العرض إلى الارتفاع <?php echo $allow_ratio_text;?> والحد الأصغري  (<?php echo $allow_img_h.'*'.$allow_img_w;?> ) </p>
</div>

<div class="tabbed-info page-row">
    <ul class="nav nav-tabs" style="margin-bottom:15px;">
      <li class="active">
      <a href="#tab-1" data-toggle="tab"> عربي <i class="fa"></i></a>
      </li>
      <li class="">
      <a href="#tab-2" data-toggle="tab"> انكليزي  <i class="fa"></i></a>
      </li>
    </ul>
 <form  enctype="multipart/form-data" class="form-horizontal" role="form" action="?action=update" method="post"  id="upload_form">
 <input type="hidden" name="id" value="<?=$id?>" />
        <input type="hidden" id="x1" name="x1" />
        <input type="hidden" id="y1" name="y1" />
        <input type="hidden" id="x2" name="x2" />
        <input type="hidden" id="y2" name="y2" />
        <input type="hidden" id="filesize" name="filesize" />
        <input type="hidden" id="filetype" name="filetype" />
        <input type="hidden" id="filedim" name="filedim" />
        <input type="hidden" id="h" name="h"/>
        <input type="hidden" id="w" name="w"/>
<div class="tab-content">
    <div class="tab-pane active" id="tab-1">
        <div class="form-group">
            <label for="title" class="col-sm-2 control-label">اسم المنتج  : <em class="text-red">*</em></label>
            <div class="col-sm-6">
              <input type="text" name="title" class="form-control text-right" id="title" value="<?=$title?>">
            </div>
        </div>
        <div class="form-group">
            <label for="cat" class="col-sm-2 control-label">القسم  : <em class="text-red">*</em></label>
            <div class="col-sm-6" id="cat">

            <?php
			$cat = getAllItems('categories');
				if(sizeof($cat) > 0){
			?>
				<select name="cat" class="form-control chzn-cat" id="cat_brand">
						<option value="">اختر القسم</option>
						<?php
						for($ci=0;$ci<sizeof($cat);$ci++){
                            $cat_id      = $cat[$ci]['id'];
                            $cat_title   = $cat[$ci]['title'];

							?>
                            <option value="<?=$cat_id?>" <?= $cat_id ==$get_cat_id ? 'selected': ''?>><?=$cat_title?></option>
                            <?php
							}
						?>
					</select>
            <?php
			}else{
			?>
            <a href="categories.php?action=add" class="btn btn-primary "><i class="fa fa-plus"></i> إضافة قسم </a>
            <?php
			}
			?>
            </div>
        </div>
        <div class="form-group">
            <label for="content" class="col-sm-2 control-label">وصف تفصيلي  : </label>
            <div class="col-sm-6">
                <textarea name="content" rows="10" class="form-control textarea" dir="rtl"><?=$content?></textarea>
            </div>
        </div>


    </div>
    <div class="tab-pane" id="tab-2">
      <div class="form-group">
        <label for="title_en" class="col-sm-2 control-label">اسم المنتج : </label>
        <div class="col-sm-6">
          <input type="text" name="title_en" class="form-control ltr" value="<?=$title_en?>">
        </div>
      </div>
      <div class="form-group">
        <label for="content_en" class="col-sm-2 control-label">وصف تفصيلي : </label>
        <div class="col-sm-6">
          <textarea name="content_en" rows="10" class="form-control ltr textarea_en"><?=$content_en?></textarea>
        </div>
      </div>
    </div>
   </div>
      <div class="form-group">
            <label for="image_file" class="col-sm-2 control-label">الصورة   : </label>
            <div class="col-sm-6">
            <input type="file" name="image_file" id="image_file" onchange="initGrop(<?php echo ($allow_img_w).','.($allow_img_h) ;?>);"/>
            <div class="text-red" id="error"></div>
            </div>
        </div>
		<fieldset id="image_div">
        <div class="form-group">
            <label for="image_file" class="col-sm-2 control-label">    </label>
            <div class="col-sm-10">
            	<?php
				if(!empty($image) && file_exists('../uploads/'.$table_name.'/'.$image)&& file_exists('../uploads/'.$table_name.'/thumb/'.$image)){
					$img_path='../uploads/'.$table_name.'/thumb/'.$image;
				?>
            	<div class="col-sm-10" id="interface">
                <a href="?action=delimg&id=<?php echo $id;?>" class="btn btn-danger confirm btn-sm delimg" data-toggle="tooltip"  data-original-title="حذف">
                <i class="fa fa-trash-o"></i> حذف الصورة </a>
                <img id="preview"  src="<?php echo $img_path;?>"/>
                </div>
                <?php
				}else{
				 ?>
                 <div class="col-sm-10" id="interface"><img id="preview"  /></div>
                <?php
				}
				?>
            </div>
        </div>
        </fieldset>
<div class="form-group">
    <div class="col-sm-6 col-sm-offset-2">
     	<button type="submit" name="Edit" class="btn btn-primary"><i class="fa fa-save"></i> حفظ </button>
    </div>
</div>
 </form>
</div>

<script type="text/javascript">
$(document).ready(function() {

  $('#upload_form').bootstrapValidator({
	fields: {
		title : {
			validators: {
				notEmpty: {
					message: ''
					}
				}
			},
			cat : {
			validators: {
				notEmpty: {
					message: ''
					}
				}
			},
			image_file: {
				validators: {
					file: {
						extension: 'PNG,JPG,JPEG,gif',
						type: 'image/jpeg,image/png,image/gif',
						message: 'نوع الصورة غير مسموح , يسمح فقط بالأنواع [PNG,JPG,JPEG,GIF]'
					}
				}
			}
		}
  });

});

</script>
</div>
<?php
	}
}elseif ($action=="update"){
?>
<div class="box-header">
    <h3 class="box-title"> تعديل منتج </h3>

</div>
<div class="box-body">
<?php
if (isset($_POST['Edit'])){
	$id = isset($_POST['id']) && is_numeric($_POST['id']) ? intval($_POST['id']):0;
	$title         = $_POST['title'];
    $content       = $_POST['content'];
	$title_en      = $_POST['title_en'];
	$content_en    = $_POST['content_en'];
    $cat_id     = $_POST['cat'];
	$image_file    = $_FILES['image_file']['name'];
    $image_temp    = $_FILES['image_file']['tmp_name'];
if($title =='' || $cat_id ==''){
	echo '<br><div class="alert alert-danger alert-dismissable"><i class="fa fa-ban"></i><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>جميع الحقول التي بجانبها علامة (*) مطلوبة   </div><a href="" class="btn btn-primary" onclick="window.history.go(-1); return false;">عودة للخلف</a>';
}else{
     	$UPDATE = $con->prepare("UPDATE products SET title=:title, content=:content, title_en=:title_en, content_en=:content_en, cat_id=:cat_id, last_update=now() WHERE id=:id");
		$UPDATE->execute(array(
			':title'=>$title,
			':content'=>$content,
			':title_en'=>$title_en,
			':content_en'=>$content_en,
			':cat_id'=>$cat_id,
		    ':id'=>$id
		));

		if(!empty($image_file)){
		    $img_name = $table_name.'_'.$id;
		    $ext = @strtolower(end(explode('.',$image_file)));
		    $image_name  = $table_name."_".$id.".".$ext;
		    $target_path = "../uploads/".$table_name.'/'.$image_name;
		    $small_path  = "../uploads/".$table_name."/thumb/".$image_name;

		    if(move_uploaded_file($image_temp,$target_path)){
		        $iWidth =$_POST['w'];
		        $iHeight=$_POST['h'];
		        $jpeg_quality = 90;
		        $aSize = getimagesize($target_path);
		        switch($aSize[2]) {
		            case IMAGETYPE_JPEG:
		                $sExt = '.jpg';
		                $vImg = @imagecreatefromjpeg($target_path);
		                break;
		            case IMAGETYPE_PNG:
		                $sExt = '.png';
		                $vImg = @imagecreatefrompng($target_path);
		                break;
		            case IMAGETYPE_GIF:
		                $sExt = '.gif';
		                $vImg = @imagecreatefromgif($target_path);
		                break;
		            default:
		                return;
		        }
		        if($iHeight < $allow_img_h){
		            $vDstImg = imagecreatetruecolor($allow_img_w,$allow_img_h);
		            $whiteBackground = imagecolorallocate($vDstImg, 255, 255, 255);
		            imagefill($vDstImg,0,0,$whiteBackground);
		        }else{
		            $vDstImg = @imagecreatetruecolor($iWidth,$iHeight);
		        }

		        imagecopyresampled($vDstImg,$vImg,0,0,(int)$_POST['x1'],(int)$_POST['y1'],$iWidth,$iHeight,(int)$_POST['w'],(int)$_POST['h']);
		        if(imagejpeg($vDstImg,$target_path,$jpeg_quality)){
		            list($width,$height) = getimagesize($target_path);
		                list($width1,$height1)=calculate_width_height($width,$height,$width,$allow_img_h);
		                resize($target_path,$small_path,$width1,$height1);
		        }
		        $UPDATE_IMG   =  $con->prepare("UPDATE $table_name SET image=? WHERE id=?");
		        $UPDATE_IMG->execute(array($image_name,$id));
		    }
		}
			echo'<div class="alert alert-success alert-dismissable"><i class="fa fa-check"></i><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button> تم التعديل بنجاح.</div>';
			echo '<META HTTP-EQUIV="Refresh" CONTENT="1;URL=products.php" >';

	}
}
?>
</div>

<?php
}elseif ($action=="details"){
	$id = isset($_GET['id']) && is_numeric($_GET['id']) ? intval($_GET['id']):0;
	$Item = getItemById('products',$id);
	if(count($Item) > 0){
		$title         = stripslashes($Item['title']);
        $content       = stripslashes($Item['content']);
    	$title_en      = stripslashes($Item['title_en']);
    	$content_en    = stripslashes($Item['content_en']);
    	$cat_id        = $Item['cat_id'];
		$image         = $Item['image'];

	
?>

	<div class="box-header">
		<h3 class="box-title"><?php echo $title?></h3>
		<div class="box-tools pull-left">
		<a href="products.php?action=edit&id=<?php echo $id?>" class="btn btn-default" data-toggle="tooltip" title="تعديل"><i class="fa fa-edit text-blue"></i></a>
		<a href="products.php?action=del&id=<?php echo $id?>" class="btn btn-default confirm" data-toggle="tooltip" title="حذف"><i class="fa fa-trash-o text-red"></i></a>
		</div>
	</div>
	<div class="box-body">
		<div class="tabbed-info page-row">
			<ul class="nav nav-tabs" style="margin-bottom:15px;">
			  <li class="active">
			  <a href="#tab-1" data-toggle="tab"> عربي <i class="fa"></i></a>
			  </li>
			  <li class="">
			  <a href="#tab-2" data-toggle="tab"> انكليزي  <i class="fa"></i></a>
			  </li>
			</ul>
			<div class="tab-content">
				<div class="tab-pane active" id="tab-1">
					<div class="row">
						<div class="col-md-3">
							<img src="../uploads/products/thumb/<?php echo $image ?>" class="img-responsive">
						</div>
						<div class="col-md-9">
							<?php echo stripslashes($content) ?>
						</div>
					</div>

				</div>
				<div class="tab-pane lang-en" id="tab-2">
					<div class="row">

						<div class="col-md-9">
							<?php echo $content_en ?>
						</div>
						<div class="col-md-3">
							<img src="../uploads/products/thumb/<?php echo $image ?>" class="img-responsive">
						</div>
					</div>

				</div>

			</div>
		</div>

	</div>
<?php
	}
?>
<?php

}elseif($action=="show"){
	$id    = isset($_GET['id']) && is_numeric($_GET['id']) ? intval($_GET['id']):0;
	$state = isset($_GET['state']) && is_numeric($_GET['state']) ? intval($_GET['state']):0;

	$UPDATE = $con->prepare("UPDATE products SET state=:sstate WHERE id=:sid");
	$UPDATE->execute(array(':sstate'=>$state,':sid'=>$id));
	header('Location: products.php');
	exit();

}elseif($action=="home"){
	$id    = isset($_GET['id']) && is_numeric($_GET['id']) ? intval($_GET['id']):0;
	$home = isset($_GET['home']) && is_numeric($_GET['home']) ? intval($_GET['home']):0;

	$UPDATE = $con->prepare("UPDATE products SET home=:home WHERE id=:sid");
	$UPDATE->execute(array(':home'=>$home,':sid'=>$id));
	header('Location: products.php');
	exit();

}elseif($action=="del"){
	$id = isset($_GET['id']) && is_numeric($_GET['id']) ? intval($_GET['id']):0;
	$Item = getItemById('products',$id);
	if(count($Item) > 0){
		$imagename = $Item['image'];
		$normal_path ='../uploads/products/normal/'.$imagename;
		$img_path='../uploads/products/'.$imagename;
		$thumb_path='../uploads/products/thumb/'.$imagename;
		$DELETE = $con->prepare("DELETE FROM products WHERE id=:sid");
		$DELETE->bindParam(":sid",$id);
		$DELETE->execute();
		if(!empty($imagename)){
		    if(file_exists($img_path)){
			     @unlink($img_path);
		    }
		    if(file_exists($thumb_path)){
		       @unlink($thumb_path);
		    }
			if(file_exists($normal_path)){
			     @unlink($normal_path);
		    }
		}
		header('Location: products.php');
		exit();
	}
}elseif($action=="delimg"){
	$id = isset($_GET['id']) && is_numeric($_GET['id']) ? intval($_GET['id']):0;
	$Item = getItemById($table_name,$id);
	if(count($Item) > 0){
		$imagename = $Item['image'];
		$normal_path = '../uploads/'.$table_name.'/normal/'.$imagename;
		$img_path    = '../uploads/'.$table_name.'/'.$imagename;
		$thumb_path  = '../uploads/'.$table_name.'/thumb/'.$imagename;
		$UPDATE = $con->prepare("UPDATE $table_name SET image='' WHERE id=:sid");
		$UPDATE->bindParam(":sid",$id);
		$UPDATE->execute();
		if(!empty($imagename) && file_exists($img_path)){
			@unlink($img_path);
			@unlink($thumb_path);
			@unlink($normal_path);
		}
		header('Location: '.$table_name.'.php?action=edit&id='.$id);
		exit();
	}
}else{
	echo '<div class="alert alert-warning">الصفحة غير موجودة</div>';
}

?>

    </div>
</section>
<?php
include('inc/footer.php');
?>
