<?php
session_start();

// make a string with all the characters that we 
// want to use as the verification code
$alphanum  = "ABCDEFGHIJKLMNPQRSTUVWXYZ123456789";

// generate the verication code 
$rand = substr(str_shuffle($alphanum), 0, 5);

// choose one of four background images
$bgNum = rand(1, 6);

// create an image object using the chosen background
$image = imagecreatefromjpeg("./bg/background$bgNum.jpg");
$imgHeight = 20;
$imgWidth =100;
$colorGrey=imagecolorallocate($image, 100, 100, 100);
imageline($image, 0, 0, 0, $imgHeight, $colorGrey);
imageline($image, 0, 0, $imgWidth, 0, $colorGrey);
imageline($image, $imgWidth-1, 0, $imgWidth-1, $imgHeight-1, $colorGrey);
imageline($image, 0, $imgHeight-1, $imgWidth-1, $imgHeight-1, $colorGrey);


$textColor = imagecolorallocate ($image, rand(0,100), rand(50,100), rand(100,150)); 

$img_text = $rand;

for ($i = 0; $i <= 5; $i++) {
   $sp_text.= $img_text[$i]." ";
}


// write the code on the background image
imagestring ($image, 20, 9, 3,  $sp_text, $textColor); 
	

// create the hash for the verification code
// and put it in the session
$_SESSION['image_random_value'] = md5($rand);
	
// send several headers to make sure the image is not cached	
// taken directly from the PHP Manual
	
// Date in the past 
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); 

// always modified 
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); 

// HTTP/1.1 
header("Cache-Control: no-store, no-cache, must-revalidate"); 
header("Cache-Control: post-check=0, pre-check=0", false); 

// HTTP/1.0 
header("Pragma: no-cache"); 	

imageantialias($image, true);
// send the content type header so the image is displayed properly
header('Content-type: image/jpeg');

// send the image to the browser
imagejpeg($image);

// destroy the image to free up the memory
imagedestroy($image);
?>
