<?php

/**
 * Users billing accounts and site payment options administration (users accounts, groups periods, payment systems, site currency management).
 *
 * @package Newsletter
 * */
include "include/config.php";
include "include/common_functions.php";
include "include/functions_auth.php";
include "common.php";
include "include/config.inc.php";

login_cheeck($auth);
$mode = IsFileAllowed($auth["id"], GetRightModulePath(__FILE__));
$this_page = "billing";
$file_name = $config["server"] . "/billing.php";
$smarty->assign("file_name", $file_name);

@$sel = $_GET["sel"] ? $_GET["sel"] : $_POST["sel"];
if ($mode == 1) {
	switch ($sel) {
		case "groups": GroupListBilling();
			break;
		case "add_payment": AddTypePayment();
			break;
		case "delete_payment": DeleteTypePayment();
			break;
		case "activate": ActiveTypePayment();
			break;
		case "settings": SettingsBilling();
			break;
		case "saveset": SaveSettingsBilling();
			break;
		case "remove_currency": RemoveCurrency();
			break;
		case "add_currency": AddCurrency();
			break;
		case "save_changes": SaveChanges();
			break;
		case "change_status": ChangeStatus();
			break;
		case "manual_payment_details": PaymentDetails();
			break;
		default: ListBilling();
	}
}

////////////// list function /////////////////////////////////////////////////////////////
function ListBilling($err = "") {
	global $smarty, $dbconn, $config, $lang, $file_name;

	AdminMainMenu("pays");
	ArrAddSlashes($_REQUEST);

	$search = isset($_REQUEST["search"]) ? $_REQUEST["search"] : "";
	$type = isset($_REQUEST["type"]) ? intval($_REQUEST["type"]) : 1;
	$letter = (!isset($_REQUEST["letter"]) || strval($_REQUEST["letter"]) == "*") ? "*" : intval($_REQUEST["letter"]);

	switch ($type) {
		case 1 : $type_str = "fname";
			break;
		case 2 : $type_str = "sname";
			break;
		case 3 : $type_str = "email";
			break;
	}
	$search_str = "";
	$filter_str = "?";

	if ($search) {
		$filter_str .= "search={$search}&type={$type}&";
		$search_str .= " AND u.{$type_str} LIKE '{$search}%'";
	}
	///////// letter
	if (strval($letter) != "*") {
		$filter_str .= "letter={$letter}&";
		$search_str .= " AND lower(substring(u.email,1,1)) ='" . strtolower(chr($letter)) . "'";
	}

	///// settings
	$strSQL = "SELECT COUNT(DISTINCT b.id) FROM " . BILLING_REQUESTS_TABLE . " b LEFT JOIN " . USERS_TABLE . " u ON u.id=b.id_user WHERE u.id NOT IN (1,2) {$search_str}";
	$rs = $dbconn->Execute($strSQL);
	$amount = $rs->fields[0];

	$strSQL = "	SELECT DISTINCT b.id, b.id_user, b.count_curr, b.currency, DATE_FORMAT(b.date_send, '{$config["date_format"]} %H:%i:%s') as date_send_show, b.status, b.paysystem, b.user_info,u.fname, u.sname, u.email
					FROM " . BILLING_REQUESTS_TABLE . " b
					LEFT JOIN " . USERS_TABLE . " u ON u.id=b.id_user
					WHERE u.id NOT IN (1,2) {$search_str} ORDER BY u.fname";

	$rs = $dbconn->Execute($strSQL);
	$i = 0;
	while (!$rs->EOF) {
		$row = $rs->GetRowAssoc(false);
		$pays[$i]["id"] = $row["id"];
		$pays[$i]["id_user"] = $row["id_user"];
		$pays[$i]["amount"] = $row["count_curr"];
		$pays[$i]["currency"] = $row["currency"];
		$pays[$i]["date_send_show"] = $row["date_send_show"];
		$pays[$i]["status"] = $row["status"];
		$pays[$i]["paysystem"] = $row["paysystem"];
		$pays[$i]["user_name"] = $row["fname"] . " " . $row["sname"];
		$pays[$i]["user_email"] = $row["email"];
		$pays[$i]["product"] = $lang["pays"]["product"];

		$rs->MoveNext();
		$i++;
	}
	if (count($pays))
		ArrStripSlashes($pays);

	/// letter link
	$param_letter = $file_name . "?letter=";
	$used_search_form = ($search_str) ? true : false;
	$letter_links = LettersLink($param_letter, $letter, $used_search_form);
	$smarty->assign("letter_links", $letter_links);

	$form["err"] = $err;

	get_smarty_array_list("billing_page", $config["billing_page"]);
	$smarty->assign("search", $search);
	$smarty->assign("type", $type);
	$smarty->assign("pays", $pays);
	$smarty->assign("amount", $amount);
	$smarty->assign("letter", $letter);
	$smarty->assign("form", $form);
	$smarty->display($config["admin_nl_gentemplates"] . "/admin_billing_table.tpl");
	exit;
}

function GroupListBilling($err = "") {
	global $smarty, $dbconn, $config, $lang, $file_name;

	AdminMainMenu("pays");

	if ($err) {
		$form["err"] = $err;
	}

	///// settings
	$settings_manager = new SettingsManager();
	$form["currency"] = $settings_manager->GetSiteSettings("site_unit_costunit");

	///// groups
	$strSQL = "SELECT id, name FROM " . GROUPS_TABLE . "  WHERE type='f' ORDER BY name";
	$rs = $dbconn->Execute($strSQL);
	$i = 0;
	while (!$rs->EOF) {
		$groups[$i]["id"] = $rs->fields[0];
		$groups[$i]["name"] = $rs->fields[1];
		$rs->MoveNext();
		$i++;
	}
	$smarty->assign("groups", $groups);

	$strSQL = "SELECT a.*, b.name as group_name FROM " . GROUP_PERIOD_TABLE . " a LEFT JOIN " . GROUPS_TABLE . " AS b ON b.id=a.id_group WHERE b.type <> 't' ORDER BY a.date";
	$rs = $dbconn->Execute($strSQL);
	$i = 0;
	while (!$rs->EOF) {
		$row = $rs->GetRowAssoc(false);
		$data[$i]["id"] = $row["id"];
		$data[$i]["id_group"] = $row["id_group"];
		$data[$i]["type"] = $row["type"];
		$data[$i]["date"] = $row["date"];
		if ($data[$i]["type"] == "3") {
			$tmp_amount = explode("|", $row["amount"]);
			$tmp_period = explode("|", $row["period"]);
			$data[$i]["period"] = $tmp_amount[0] . " " . $lang["pays"]["periods"][$tmp_period[0]] . ", ";
			$data[$i]["period"] .= $tmp_amount[1] . " " . $lang["pays"]["periods"][$tmp_period[1]];
		} else {
			$data[$i]["period"] = $row["amount"] . " " . $lang["pays"]["periods"][$row["period"]];
		}
		$data[$i]["cost"] = $row["cost"] . " " . $form["currency"];
		$data[$i]["status"] = $row["status"];
		$data[$i]["status_str"] = $lang["pays"]["act_status_{$row["status"]}"];
		$data[$i]["group_name"] = $row["group_name"];
		$data[$i]["del_link"] = $file_name . "?sel=delete_payment&id={$data[$i]["id"]}";
		$data[$i]["act_link"] = $file_name . "?sel=activate&id={$data[$i]["id"]}";
		$rs->MoveNext();
		$i++;
	}
	$smarty->assign("data", $data);
	$smarty->assign("payment_link", $config["server"] . "/payment.php");
	$smarty->assign("err", $lang["err"]);
	$smarty->assign("form", $form);
	$smarty->assign("button", $lang["button"]);

	$smarty->display($config["admin_nl_gentemplates"] . "/admin_billing_group_cost_table.tpl");
	exit;
}

function AddTypePayment() {
	global $dbconn;

	ArrAddSlashes($_POST);
	$error = "";
	$group = intval($_POST["group"]);
	if ($_POST["type"] == 1) {
		$amount = intval($_POST["period_time"]);
		$period = $_POST["period"];
	} elseif ($_POST["type"] == 2) {
		$amount = intval($_POST["period_email"]);
		$period = "emails";
	} else {
		$amount = intval($_POST["period_time"]) . "|" . intval($_POST["period_email"]);
		$period = $_POST["period"] . "|" . "emails";
	}
	$cost = intval($_POST["cost"]);

	$strSQL = "INSERT INTO " . GROUP_PERIOD_TABLE . " (id_group,type,date,amount,period,cost,status) VALUES ({$group},{$_POST["type"]},NOW(),'{$amount}','{$period}', '{$cost}', '1')";
	$dbconn->Execute($strSQL);
	$id_group = $dbconn->Insert_ID();
	$strSQL = "INSERT INTO " . BILLING_PERIODS_CCBILL_TABLE . " (id_group_period, ccbill_sub_id) VALUES ({$id_group}, '0000000000')";
	$dbconn->Execute($strSQL);

	GroupListBilling($error);
	exit;
}

function DeleteTypePayment() {
	global $dbconn;

	$id = intval($_GET["id"]);
	$strSQL = "DELETE FROM " . GROUP_PERIOD_TABLE . " WHERE id={$id}";
	$dbconn->Execute($strSQL);
	GroupListBilling();
	exit;
}

function ActiveTypePayment() {
	global $dbconn;

	$id = intval($_GET["id"]);
	$strSQL = "UPDATE " . GROUP_PERIOD_TABLE . " SET status=IF (status='1','0','1') WHERE id={$id}";
	$dbconn->Execute($strSQL);
}

function SettingsBilling($err = "") {
	global $smarty, $dbconn, $config, $lang;

	@$settype = $_GET["settype"] ? $_GET["settype"] : $_POST["settype"];
	if (!$settype)
		$settype = "general";
	AdminMainMenu("pays");
	$form = array();
	if ($err) {
		$form["err"] = $err;
	}

	$rs = $dbconn->Execute("SELECT template_name, name FROM " . BILLING_PAYSYSTEMS_TABLE);
	$i = 0;
	while (!$rs->EOF) {
		$paysystems[$i]["value"] = $rs->fields[0];
		$paysystems[$i]["name"] = $lang["pays"]["option_" . $rs->fields[0]];
		$paysystems[$i]["name_orig"] = $rs->fields[1];
		$i++;
		$rs->MoveNext();
	}
	$smarty->assign("paysystems", $paysystems);

	if ($settype == "general") {
		/// currency
		$settings_manager = new SettingsManager();
		$data['site_unit_costunit'] = $settings_manager->GetSiteSettings("site_unit_costunit");

		$rs = $dbconn->Execute("SELECT abbr, id, name, symbol FROM " . UNITS_TABLE . " ");
		$i = 0;
		while (!$rs->EOF) {
			$currency[$i]["num"] = $i;
			$currency[$i]["abbr"] = $rs->fields[0];
			$currency[$i]["id"] = $rs->fields[1];
			$currency[$i]["name"] = $rs->fields[2];
			$currency[$i]["symbol"] = htmlentities($rs->fields[3]);
			$currency[$i]["symbol_view"] = $rs->fields[3];
			$rs->MoveNext();
			$i++;
		}
		$smarty->assign("count", $i);
		$smarty->assign("currency", $currency);
		$smarty->assign("data", $data);
	} else {
		include_once "include/systems/functions/" . $settype . ".php";
		$settings_manager = new SettingsManager();
		if ($settype == 'avangate') {
			///// settings
			$currency = $settings_manager->GetSiteSettings("site_unit_costunit");
			///// groups
			$strSQL = "SELECT id, name FROM " . GROUPS_TABLE . "  WHERE type='f' ORDER BY name";
			$rs = $dbconn->Execute($strSQL);
			$i = 0;
			while (!$rs->EOF) {
				$groups[$i]["id"] = $rs->fields[0];
				$groups[$i]["name"] = $rs->fields[1];
				$rs->MoveNext();
				$i++;
			}
			$smarty->assign("groups", $groups);

			$strSQL = "SELECT a.*, b.name as group_name FROM " . GROUP_PERIOD_TABLE . " a LEFT JOIN " . GROUPS_TABLE . " AS b ON b.id=a.id_group WHERE b.type <> 't' ORDER BY a.date";
			$rs = $dbconn->Execute($strSQL);
			$i = 0;
			while (!$rs->EOF) {
				$row = $rs->GetRowAssoc(false);
				$data_packets[$i]["id"] = $row["id"];
				$data_packets[$i]["id_group"] = $row["id_group"];
				$data_packets[$i]["type"] = $row["type"];
				$data_packets[$i]["date"] = $row["date"];
				if ($data_packets[$i]["type"] == "3") {
					$tmp_amount = explode("|", $row["amount"]);
					$tmp_period = explode("|", $row["period"]);
					$data_packets[$i]["period"] = $tmp_amount[0] . " " . $lang["pays"]["periods"][$tmp_period[0]] . ", ";
					$data_packets[$i]["period"] .= $tmp_amount[1] . " " . $lang["pays"]["periods"][$tmp_period[1]];
				} else {
					$data_packets[$i]["period"] = $row["amount"] . " " . $lang["pays"]["periods"][$row["period"]];
				}
				$data_packets[$i]["cost"] = $row["cost"] . " " . $form["currency"];
				$data_packets[$i]["status"] = $row["status"];
				$data_packets[$i]["status_str"] = $lang["pays"]["act_status_{$row["status"]}"];
				$data_packets[$i]["group_name"] = $row["group_name"];
				$rs->MoveNext();
				$i++;
			}
			$smarty->assign("data_packets", $data_packets);
			$smarty->assign("currency", $currency);
			$smarty->assign("avangate", TRUE);
		}
		if ($settype == 'manual') {
			$active_lang = $settings_manager->GetActiveLanguages();
			$current_lang_id = (isset($_REQUEST["language_id"]) && !empty($_REQUEST["language_id"])) ? intval($_REQUEST["language_id"]) : $config["default_lang"];
			$smarty->assign("current_lang_id", $current_lang_id);
			$smarty->assign("active_lang", $active_lang);
			$data = getBillingData($settype, $lang, $current_lang_id);
		} else {
			$data = getBillingData($settype, $lang);
		}
		$smarty->assign("data", $data);
	}

	$smarty->assign("settype", $settype);
	$smarty->assign("form", $form);
	$smarty->assign("button", $lang["button"]);
	$smarty->display($config["admin_nl_gentemplates"] . "/admin_billing_settings_table.tpl");
	exit;
}

function SaveSettingsBilling() {
	global $smarty, $dbconn, $config, $lang, $file_name;

	$settype = $_POST["settype"];

	if ($settype == "general") {
		$site_unit_costunit = strval($_POST["currency"]);

		if (!strlen($site_unit_costunit)) {
			$err = $lang["err"]["invalid_feilds"];
			$err .= "<br>" . $lang["pays"]["currency"];
			SettingsBilling($err);
			return;
		}

		$strSQL = "UPDATE " . SETTINGS_TABLE . " SET value='{$site_unit_costunit}' WHERE name='site_unit_costunit'";
		$dbconn->Execute($strSQL);
	} else {
		include_once "include/systems/functions/" . $settype . ".php";
		ArrAddSlashes($_POST);
		$err = setBillingData($settype, $_POST, $lang);
		if ($settype == "manual") {
			$data = getBillingData($settype, $lang, intval($_POST["lang_id"]));
		} else {
			$data = getBillingData($settype, $lang);
		}
		if ($err) {
			SettingsBilling($err);
			return;
		}
	}
	if ($settype == "manual") {
		header("Location: {$file_name}?sel=settings&settype={$settype}&err=success_save&language_id=" . intval($_POST["lang_id"]));
	} else {
		header("Location: {$file_name}?sel=settings&settype={$settype}&err=success_save");
	}
}

function AddCurrency() {
	global $smarty, $dbconn, $lang;
	ArrAddSlashes($_REQUEST);

	$strSQL = "SELECT COUNT(id) FROM " . UNITS_TABLE . " WHERE abbr='{$_REQUEST["currency_abbr"]}'";
	$rs = $dbconn->Execute($strSQL);
	$count = $rs->fields[0];
	if ($_REQUEST["currency_name"] != '' && $_REQUEST["currency_abbr"] != '' && $_REQUEST["currency_symbol"] != '' && $count == 0) {
		$strSQL = "INSERT INTO " . UNITS_TABLE . " (abbr, name, fractional_unit, symbol) VALUES ('{$_REQUEST["currency_abbr"]}','{$_REQUEST["currency_name"]}', 0 ,'{$_REQUEST["currency_symbol"]}')";
		$rs = $dbconn->Execute($strSQL);
		$smarty->assign("error", $lang["common"]["success_save"]);
	} else {
		if ($count == 0) {
			$smarty->assign("error", $lang["errors"]["empty_fields"]);
		} else {
			$smarty->assign("error", $lang["errors"]["currensy_is_present"]);
		}
	}
	SettingsBilling();
	return;
}

function RemoveCurrency() {
	global $smarty, $dbconn, $lang;

	$id = intval($_REQUEST["id"]);
	$strSQL = "SELECT COUNT(id) FROM " . UNITS_TABLE;
	$rs = $dbconn->Execute($strSQL);
	$count = $rs->fields[0];
	$strSQL = "SELECT abbr FROM " . UNITS_TABLE . " WHERE id={$id}";
	$rs = $dbconn->Execute($strSQL);
	$abbr = $rs->fields[0];
	$strSQL = "SELECT value FROM " . SETTINGS_TABLE . " WHERE name='site_unit_costunit'";
	$rs = $dbconn->Execute($strSQL);
	$current_abbr = $rs->fields[0];
	if ($count <> 1) {
		$strSQL = "DELETE FROM " . UNITS_TABLE . " WHERE id={$id}";
		$rs = $dbconn->Execute($strSQL);
		$smarty->assign("error", $lang["common"]["success_save"]);
	} else {
		$smarty->assign("error", $lang["err"]["currency_not_deleted"]);
	}

	if ($current_abbr == $abbr) {
		$strSQL = "SELECT abbr FROM " . UNITS_TABLE . " LIMIT 0,1";
		$rs = $dbconn->Execute($strSQL);
		$first_abbr = $rs->fields[0];
		$strSQL = "UPDATE " . SETTINGS_TABLE . " SET VALUE='{$first_abbr}' WHERE name='site_unit_costunit'";
		$rs = $dbconn->Execute($strSQL);
	}

	SettingsBilling();
	return;
}

function SaveChanges() {
	global $smarty, $dbconn, $config, $lang;

	ArrAddSlashes($_REQUEST);

	$count = intval($_REQUEST["count"]);
	$strSQL = "SELECT value FROM " . SETTINGS_TABLE . " WHERE name='site_unit_costunit'";
	$rs = $dbconn->Execute($strSQL);
	$current_abbr = $rs->fields[0];
	$strSQL = "SELECT id FROM " . UNITS_TABLE . " WHERE abbr='{$current_abbr}'";
	$rs = $dbconn->Execute($strSQL);
	$current_id = $rs->fields[0];

	for ($i = 0; $i < $count; $i++) {
		$strSQL = "UPDATE " . UNITS_TABLE . " SET abbr='{$_REQUEST["abbr_m"][$i]}', name='{$_REQUEST["name_m"][$i]}', symbol='{$_REQUEST["symbol_m"][$i]}' WHERE id={$_REQUEST["id_m"][$i]}";
		$dbconn->Execute($strSQL);
		if ($id_m[$i] == $current_id) {
			$strSQL = "UPDATE " . SETTINGS_TABLE . " SET value='{$_REQUEST["abbr_m"][$i]}' WHERE name='site_unit_costunit'";
			$dbconn->Execute($strSQL);
		}
	}
	header("Location: {$file_name}?sel=settings&err=success_save");
	exit();
}

function ChangeStatus() {
	global $dbconn, $config_admin;

	ArrAddSlashes($_GET);

	$id = intval($_GET["id"]);
	$status = ($_GET["status"] == "approve") ? "approve" : "decline";
	$strSQL = "SELECT id_product,id_user,id_group FROM " . BILLING_REQUESTS_TABLE . " WHERE id={$id}";
	$rs = $dbconn->Execute($strSQL);
	$id_product = $rs->fields[0];
	$id_user = $rs->fields[1];

	$to_email = GetUserEmail($id_user);

	if ($rs->RowCount() > 0) {
		$strSQL = "UPDATE " . BILLING_REQUESTS_TABLE . " SET status='{$status}' WHERE id={$id}";
		$dbconn->Execute($strSQL);

		if ($status == "approve") {
			$strSQL = "SELECT id_group, cost, period, amount FROM " . GROUP_PERIOD_TABLE . " WHERE id={$id_product}";
			$rs = $dbconn->Execute($strSQL);
			$period = $rs->fields[2];
			$amount = $rs->fields[3];
			$id_group = $rs->fields[0];

			if (in_array($period, array('day', 'week', 'month', 'year'))) {
				$period_day = $amount * $config_admin["pay_period"][$period];
				if (!$id_group)
					return "";

				$strSQL = "DELETE FROM " . USER_GROUP_TABLE . " WHERE id_user ={$id_user}";
				$dbconn->Execute($strSQL);
				$strSQL = "INSERT INTO  " . USER_GROUP_TABLE . "  (id_user, id_group) VALUES ({$id_user}, {$id_group})";
				$dbconn->Execute($strSQL);

				$strSQL = "SELECT id, date_begin, date_end FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$id_user}";
				$rs = $dbconn->Execute($strSQL);
				if ($rs->fields[0] > 0) {
					$strSQL = "UPDATE " . BILLING_USER_PERIOD_TABLE . " SET date_end=date_end + INTERVAL " . $period_day . " DAY WHERE id='" . $rs->fields[0] . "'";
				} else {
					$strSQL = "INSERT INTO " . BILLING_USER_PERIOD_TABLE . " (id_group_period, date_begin, date_end, id_user)
                            VALUES ({$id_product}, NOW(), NOW()+INTERVAL " . $period_day . " DAY, {$id_user})";
				}
				$dbconn->Execute($strSQL);
			} elseif ($period == "emails") {
				$strSQL = "SELECT id, email FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$id_user}";
				$rs = $dbconn->Execute($strSQL);
				if ($rs->fields[0] > 0) {
					$period = intval($rs->fields[1]) + intval($amount);
				} else {
					$period = $amount;
				}
				if (!$id_group)
					return "";

				$strSQL = "DELETE FROM " . USER_GROUP_TABLE . " WHERE id_user = {$id_user}";
				$dbconn->Execute($strSQL);
				$strSQL = "INSERT INTO " . USER_GROUP_TABLE . " (id_user, id_group) VALUES ({$id_user}, {$id_group})";
				$dbconn->Execute($strSQL);
				$strSQL = "DELETE FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$id_user}";
				$dbconn->Execute($strSQL);
				$strSQL = "INSERT INTO " . BILLING_USER_PERIOD_TABLE . " (id_group_period, id_user, email) VALUES ({$id_product}, {$id_user}, {$period})";
				$dbconn->Execute($strSQL);
			}elseif (strpos($period, "|emails")) {
				$period_arr = explode("|", $period);
				$amount_arr = explode("|", $amount);
				$time_add = $amount_arr[0] * $config_admin["pay_period"][$period_arr[0]];
				$email_add = $amount_arr[1];

				if (!$id_group)
					return "";

				$strSQL = "DELETE FROM " . USER_GROUP_TABLE . " WHERE id_user={$id_user}";
				$dbconn->Execute($strSQL);
				$strSQL = "INSERT INTO " . USER_GROUP_TABLE . "  (id_user, id_group) VALUES ({$id_user}, {$id_group})";
				$dbconn->Execute($strSQL);

				$strSQL = "SELECT id, date_begin, date_end, email FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$id_user}";
				$rs = $dbconn->Execute($strSQL);
				if ($rs->fields[0] > 0) {
					$strSQL = "UPDATE " . BILLING_USER_PERIOD_TABLE . " SET date_end=date_end + INTERVAL " . $time_add . " DAY, email=email+" . $email_add . "
                      WHERE id='" . $rs->fields[0] . "'";
				} else {
					$strSQL = "INSERT INTO " . BILLING_USER_PERIOD_TABLE . " (id_group_period, date_begin, date_end, id_user, email)
                            VALUES ({$id_product}, NOW(), NOW()+INTERVAL " . $time_add . " DAY, {$id_user}, '" . $email_add . "')";
				}
				$dbconn->Execute($strSQL);
			}
			$strSQL = "UPDATE " . USERS_TABLE . " SET status= '1' WHERE id={$id_user}";
			$dbconn->Execute($strSQL);

			if (GetAlertStatus("mail_approvepayment_by_user")) {
				// Alert polzovatelu ob apruve
				$data_ = array();
				$data_["site_name"] = $config["server"];
				$data_["name"] = GetUserName($id_user);
				SendAlert("mail_approvepayment_by_user", $data_, $to_email, GetUserName(1), $id_user);
			}
		} elseif ($status == "decline") {
			if (GetAlertStatus("mail_declinepayment_by_user")) {
				// Alert polzovatelu ob apruve
				$data_ = array();
				$data_["site_name"] = $config["server"];
				$data_["name"] = GetUserName($id_user);
				SendAlert("mail_declinepayment_by_user", $data_, $to_email, GetUserName(1), $id_user);
			}
		}
	}
	echo $status;
	exit;
}

function PaymentDetails($err = "") {
	global $smarty, $dbconn, $config;
	AdminMainMenu("pays");

	$id = intval($_REQUEST["id"]);
	$strSQL = "	SELECT DISTINCT b.id, b.id_user, b.count_curr, b.currency, DATE_FORMAT(b.date_send, '{$config["date_format"]} %H:%i:%s') as date_send_show, b.status, b.paysystem, b.user_info,u.fname, u.sname, u.email
					FROM " . BILLING_REQUESTS_TABLE . " b
					LEFT JOIN " . USERS_TABLE . " u ON u.id=b.id_user
					WHERE b.id={$id}";
	$rs = $dbconn->Execute($strSQL);
	$row = $rs->GetRowAssoc(false);
	$smarty->assign("details", $row);
	$smarty->display($config["admin_nl_gentemplates"] . "/admin_billing_details.tpl");
	exit;
}

?>