<?php

include "./include/config.php";
include "./include/common_functions.php";
include "include/functions_auth.php";
include "./common.php";
include "./include/config.inc.php";

$strSQL = " SELECT id, name, type FROM " . GROUPS_TABLE . " WHERE id NOT IN (1,2) ORDER BY name";

$rs = $dbconn->Execute($strSQL);
$i = 0;

$group_arr = array();
$modules_arr = array();
$functions_arr = array();
$functions_checked = array();
$checkboxes = array();

$amount = $rs->RowCount();

if ($amount > 0) {
	while (!$rs->EOF) {
		$group_arr[$rs->fields[0]]["id"] = $rs->fields[0];
		$group_arr[$rs->fields[0]]["type"] = $rs->fields[2];
		$group_arr[$rs->fields[0]]["name"] = strval($rs->fields[1]);
		$checkboxes[$rs->fields[0]] = $rs->fields[0];
		$rs->MoveNext();
	}
	ArrStripSlashes($group_arr);
	get_smarty_array_list("group_page", $config["group_page"]);
	$smarty->assign("amount", $amount);
} else {
	$smarty->assign("empty_row", "1");
	$smarty->assign("amount", 0);
}

$smarty->assign("column_width", 100 / ($amount + 1));

foreach ($group_arr as $group_id => $group) {
	$id = $group['id'];
	$group_arr[$id]['modules'] = array();
	$group_arr[$id]['functions'] = array();
	if ($id) {
		// Modules
		$rs = $dbconn->Execute("SELECT gm.id_module, m.name FROM " . GROUP_MODULE_TABLE . " as gm LEFT JOIN " . MODULES_TABLE . " as m ON m.id=gm.id_module WHERE gm.id_group={$id}");
		while (!$rs->EOF) {
			$module_id = $rs->fields[0];
			$modules_arr[$module_id] = $rs->fields[1];
			$group_arr[$id]['modules'][$module_id] = $rs->fields[1];
			$checkboxes[$id] = isset($checkboxes[$id]) ? $checkboxes[$id] + 1 : 1;
			// Functions
			$functions_arr[$module_id] = !isset($functions_arr[$module_id]) ? array() : $functions_arr[$module_id];
			$strSQL = "SELECT DISTINCT f.id, f.name FROM " . GROUP_FUNCTION_TABLE . " as gf LEFT JOIN " . FUNCTIONS_TABLE . " as f ON f.id=gf.id_function WHERE gf.id_group={$id} AND f.id_module={$module_id} ORDER BY f.id";
			$func_rs = $dbconn->Execute($strSQL);
			while (!$func_rs->EOF) {
				$func_id = $func_rs->fields[0];
				$func_name = $func_rs->fields[1];
				$group_arr[$id]['functions'][$module_id][$func_id] = $func_name;
				$functions_arr[$module_id][$func_id] = $func_name;
				$functions_checked[$func_id] = isset($functions_checked[$func_id]) ? $functions_checked[$func_id] + 1 : 1;
				$checkboxes[$id] = isset($checkboxes[$id]) ? $checkboxes[$id] + 1 : 1;
				$func_rs->MoveNext();
			}
			$rs->MoveNext();
		}
	}
}

$module_functions_show = array();
foreach ($group_arr as $group_id => $group) {
	foreach ($group_arr[$group_id]['functions'] as $module_id => $functions)
		if (count($functions) != count($functions_arr[$module_id]) && count($functions) != 0)
			$module_functions_show[$module_id] = $module_id;
}

ksort($modules_arr);
asort($checkboxes);

$new_group_arr = array();
foreach ($checkboxes as $checkbox_id => $checkbox_value)
	$new_group_arr[$checkbox_id] = $group_arr[$checkbox_id];
$group_arr = $new_group_arr;

$smarty->assign("group_arr", $group_arr);
$smarty->assign("modules_arr", $modules_arr);
$smarty->assign("functions_arr", $functions_arr);
$smarty->assign("functions_checked", $functions_checked);
$smarty->assign("module_functions_show", $module_functions_show);
$smarty->display($config["admin_nl_gentemplates"] . "/new_compare.tpl");
exit;
