<?php
include "./include/config.php";
include "./include/common_functions.php";
include "./include/functions_auth.php";
include "./common.php";
include "./include/config.inc.php";
include "./include/newsletters_function.php";
include_once "./include/class.form.php";
include "./include/class.email_validator.php";
include "./include/forms_function.php";
include_once "./include/class.settings_manager.php";

ArrAddSlashes($_POST);

$post_data = array();
$post_data["form_id"] = intval($_GET["id"]);

$post_data["name"] = $_POST["name"] ? strip_tags($_POST["name"]) : "";
$post_data["surname"] = $_POST["surname"] ? strip_tags($_POST["surname"]) : "";
$post_data["email"] = $_POST["email"] ? strip_tags($_POST["email"]) : "";
$post_data["moderator_id"] = $_POST["mid"] ? intval($_POST["mid"]) : 1;

$res = $dbconn->Execute("SELECT * FROM ".FORM_TABLE." WHERE id='{$post_data["form_id"]}'");
$form_data = $res->GetRowAssoc(false);
ArrStripSlashes($form_data);
$post_data["moderator_id"] = isset($form_data['id_user']) ? $form_data['id_user'] : $post_data["moderator_id"];

$settings = GetUserSettings(array('from_name','from_email'),$post_data["moderator_id"]);

if($_GET["sel"]){
	$sel = $_GET["sel"];
	$is_link = 1;
}else{
	$sel = $form_data["type"];
	$is_link = 0;
}
$sel = $_GET["sel"] ? $_GET["sel"] : $form_data["type"];
switch($sel){
	case "sub": Subscribe(); break;
	case "unsub": UnSubscribe($is_link); break;
	default: Subscribe();
}

function Subscribe(){
	global $config, $smarty, $dbconn, $lang, $post_data, $form_data, $settings;
	MainMenu("forms");

	//Get all fields data from _POST
	$errors = array();
	$form_class=new Form($dbconn, $config);
	$attrs=array();
	$data=$_POST;
	foreach ($data as $key=>$value){
		$arr=array();
		if (preg_match('/^attr_(\d*)/', $key, $arr)==0) continue;
		$id_attr=$arr[1];
		$sec_attrs[$id_attr]=$form_class->getSectionAttribute($id_attr);
		unset($data[$key]);
		if (is_array($value) && $sec_attrs[$id_attr]['control_type']=='select'){
			$temp=array();
			foreach ($value as $i=>$v) {
				$temp[$v]=$v;
			}
			$data[$id_attr]=$temp;
		}
		else $data[$id_attr]=$value;
		$attrs[$id_attr]=$value;
	}

	//Checkbox control, if attribute not exist in _POST data, but exist in Form attributes it sets to 0
	$form_fields=$form_class->getFormAttributes($post_data["form_id"]);
	foreach ($form_fields as $form_field){
		if ($form_field['control_type']=='checkbox'){
			//check if this field presence in filled attributes
			$keys=array_keys($attrs);
			if (!in_array($form_field['id'], $keys)) $attrs[$form_field['id']]=0;
			$sec_attrs[$form_field['id']]=$form_class->getSectionAttribute($form_field['id']);
		}
	}
    
	//Get attibutes patterns
	$regs=$form_class->getRegExps();
	foreach ($sec_attrs as $index=>$field){
		if (isset($field['setup']['reg_exp'])) {
			$id_reg=$sec_attrs[$index]['setup']['reg_exp'];
			$sec_attrs[$index]['setup']['reg_exp']=$regs[$id_reg]['reg_exp'];
		}
	}

	//Check user data
	$err='';
	$valid=true;
	foreach ($attrs as $id_attr=>$value){
		if ($sec_attrs[$id_attr]['mandatory']=='Y'){
			if ($value=='' || !isset($value)){
				$valid=false;
				$err .= "<br>".$sec_attrs[$id_attr]['field_name'];
			}
		}
		if (isset($sec_attrs[$id_attr]['setup']['reg_exp'])){
			$pattern=$sec_attrs[$id_attr]['setup']['reg_exp'];
			if (preg_match($pattern, $value)==0){
				$valid=false;
				$err .= "<br>".$sec_attrs[$id_attr]['field_name'];
			}
		}
	}

	//If isset form field with list then add their values into the POST data
	if (isset($attrs[FIELD_MAILLIST])) {
		unset($_POST['SelectLists']);
		$_POST['SelectLists'] = array();
		if(is_array($attrs[FIELD_MAILLIST])){
			foreach ($attrs[FIELD_MAILLIST] as $id_list){
				$_POST['SelectLists'][$id_list]='YES';
			}
		}else{
			$_POST['SelectLists'][$attrs[FIELD_MAILLIST]]='YES';
		}

	}

	if ($post_data["name"]=="") {
		$errors[1] = $lang["err"]["specify_firstname"];
	}
	if ($post_data["surname"]=="") {
		$errors[2] = $lang["err"]["specify_secondname"];
	}
	$email_validator = New EmailValidator($post_data["email"]);
	if ($email_validator->returnValidatedEmailStatus()!=2) {
		$errors[4] = $lang["err"]["invalid_email"];
	} else {
		$strSQL = "SELECT id FROM ".SEND_USERS_TABLE." WHERE email1='{$post_data["email"]}' AND id_user={$post_data["moderator_id"]}";
		$rs = $dbconn->Execute($strSQL);
		$arr_list = array();
		$action_user = "insert";
		if ($rs->RowCount()) {
			//$errors[4] = "Email already exist";
			foreach ($_POST["SelectLists"] as $key => $value) {
				$strSQL = "SELECT * FROM ".CLIENTS_LISTS_TABLE." WHERE client_id={$rs->fields[0]} AND list_id='{$key}' AND id_user={$post_data["moderator_id"]}";
				$rs = $dbconn->Execute($strSQL);
				if ($rs->RowCount()) {
					unset($_POST["SelectLists"][$key]);
					$errors[7] = $lang["err"]["exists_email"];
				}
			}
			$action_user = "update";
		}else{
			$action_user = "insert";
		}
	}
	if ($form_data["captcha"] == 1 && $_SESSION['captcha_keystring'] != $_POST["captcha"]) {
		$errors[5] = $lang["err"]["invalid_kcaptcha"];
	}

	if (!$valid) $errors[6]=$err;

	if (count($errors)!=0) {
		$smarty->assign("name", $post_data["name"]);
		$smarty->assign("surname", $post_data["surname"]);
		$smarty->assign("company", $company);
		$smarty->assign("email", $post_data["email"]);

		$smarty->assign("errors", $errors);
		$smarty->assign("form_data", $form_data);

		$lists = array();
		$strSQL = "SELECT list_id FROM ".FORMS_LISTS_TABLE." WHERE form_id={$post_data["form_id"]}";
		$rs = $dbconn->Execute($strSQL);
		while (!$rs->EOF) {
			$lists[] = $rs->fields[0];
			$rs->MoveNext();
		}
		$smarty->assign("lists", $lists);

		$strSQL = "SELECT * FROM ".FORM_TABLE." WHERE id={$post_data["form_id"]}";
		$res=$dbconn->Execute($strSQL);
		$row = $res->GetRowAssoc(false);

		//Get all form attibutes
		$fields=$form_class->getFormAttributes($_GET['id']);
		$regs=$form_class->getRegExps();

		foreach ($fields as $index=>$field){
			if (isset($field['setup']['reg_exp'])) {
				$id_reg=$fields[$index]['setup']['reg_exp'];
				$fields[$index]['setup']['reg_exp']=$regs[$id_reg]['reg_exp'];
			}
		}
		$smarty->assign('fields', $fields);
		$smarty->assign('regs', $regs);

		$smarty->assign('user_data', $attrs);
		$smarty->assign("moderator_id", $post_data["moderator_id"]);
		$smarty->display($config["admin_nl_gentemplates"]."/forms_subscribe.tpl");
		exit;
	}
	
    if (isset($_REQUEST["id"]) && $_REQUEST["id"] != 0) {
        $thank_data = getFormContent((int) $_REQUEST["id"]);
        $id = intval($_REQUEST["id"]);
        $thank_data["id"] = $id;
        $smarty->assign("data", $data);
    }
	
	$to = GetUserSettings(array('from_email'),$post_data["moderator_id"]);
	
	if (isset($thank_data['thankyou']) && $thank_data['thankyou']) {
		require_once "./include/swift/Swift.php";
		require_once "./include/swift/Swift/Connection/Multi.php";
		$settings = GetUserSettings(array('from_name', 'from_email', 'type_dispatch'), $id_user);
		switch ($settings["type_dispatch"]) {
			case "smtp":
				require_once "swift/Swift/Connection/SMTP.php";
				$smtp_info = GetSmtpInfo($id_user);
				$connections = array();

				foreach ($smtp_info as $key => $value) {
					switch ($value["use_encrypt"]) {
						case "no":
							$enctype = SWIFT_SMTP_ENC_OFF;
							break;
						case "tls":
							$enctype = SWIFT_SMTP_ENC_TLS;
							break;
						case "ssl":
							$enctype = SWIFT_SMTP_ENC_SSL;
							break;
					}
					$conn = new Swift_Connection_SMTP($value["host"], $value["port"], $enctype);

					if ($value["use_auth"]) {
						if ($value["use_popb4smtp"]) {
							require_once "swift/Swift/Authenticator/@PopB4Smtp.php";
							$conn->attachAuthenticator(new Swift_Authenticator_PopB4Smtp(str_replace("smtp.", "pop.", strtolower($value["host"]))));
						}
						$conn->setUsername($value["login"]);
						$conn->setpassword($value["password"]);
					}
					$connections[] = $conn;
				}
				$swift = new Swift(new Swift_Connection_Multi($connections));

				break;
			case "mail":
				require_once "swift/Swift/Connection/NativeMail.php";
				$swift = new Swift(new Swift_Connection_NativeMail());
				break;
			case "sendmail":
				require_once "swift/Swift/Connection/Sendmail.php";
				$swift = new Swift(new Swift_Connection_Sendmail());
				break;
			default:
				require_once "swift/Swift/Connection/NativeMail.php";
				$swift = new Swift(new Swift_Connection_NativeMail());
		}
		$message = new Swift_Message('123');
		$message->setSubject($thank_data["thankyou_subject"]);
        $message->attach(new Swift_Message_Part($thank_data["thankyou_email"]));
		
		$message->setCharset("utf-8");
		$message->setFrom(new Swift_Address($settings["from_email"], $settings["from_name"]));

		if (!$swift->send($message, new Swift_Address($post_data["email"]), $settings["from_email"])) {
			//error
			$error = 1;
		} else {
			$error = 0;
		}

	}
	
	if($action_user == "insert"){
		$new_pass = substr(md5(time()),0,6);
		$strSQL = "INSERT INTO ".SEND_USERS_TABLE." (date,email1,firstname,secondname,company,password,id_user)
							VALUES (NOW(),'{$post_data["email"]}','{$post_data["name"]}','{$post_data["surname"]}','{$company}','".md5($new_pass)."',{$post_data["moderator_id"]})";
		$rs = $dbconn->Execute($strSQL);
		$uid = $dbconn->Insert_ID();
		$form_class->saveUserAttributes($uid, $attrs);

		$list_arr = array();
		foreach ($_POST["SelectLists"] as $key => $value){
			$list_arr[]=$key;
		}
		CheckResponse($uid,$list_arr,$post_data["email"],GetSubscriberName($uid),$post_data["moderator_id"]);

		if(GetAlertStatus("mail_subcription_by_subscriber")){
			$message = "{$lang["common"]["firstname"]}: {$post_data["name"]}\n{$lang["common"]["secondname"]}: {$post_data["surname"]}\n{$lang["common"]["email"]}: {$post_data["email"]}\n";
			$message .= GetUserAttr($form_class,$uid);
			// Alert podpischiku o podpiske
			$data_ = array();
			$data_["name"] = GetSubscriberName($uid);
			$data_["list_name"] = GetListName(array_flip($_POST["SelectLists"]));
			$data_["subscriber_info"] = $message;
			$data_["account_link"] = $config["server"]."/subcribers_account.php";
			$data_["login_info"] = "{$lang["common"]["login"]}: {$post_data["email"]}\n{$lang["common"]["pwd"]}: {$new_pass}";
			$status = SendAlert("mail_subcription_by_subscriber",$data_,$post_data["email"],$post_data["name"]." ".$post_data["surname"],$post_data["moderator_id"]);
		}

		if(GetAlertStatus("mail_newsubscriber_by_am")){
			$message = "{$lang["common"]["firstname"]}: {$post_data["name"]}\n{$lang["common"]["secondname"]}: {$post_data["surname"]}\n{$lang["common"]["email"]}: {$post_data["email"]}\n";
			$message .= GetUserAttr($form_class,$uid);
			// Alert moderu o podpiske
			$data_ = array();
			$data_["name"] = GetUserName($post_data["moderator_id"]);
			$data_["list_name"] = GetListName(array_flip($_POST["SelectLists"]));
			$data_["subscriber_info"] = $message;
			SendAlert("mail_newsubscriber_by_am",$data_,$to["from_email"],GetUserName($post_data["moderator_id"]),$post_data["moderator_id"]);
		}

	}elseif($action_user == "update"){
		$rs = $dbconn->Execute("SELECT id FROM ".SEND_USERS_TABLE." WHERE email1='{$post_data["email"]}' AND id_user={$post_data["moderator_id"]}");
		$uid = $rs->fields[0];
		$form_class->saveUserAttributes($uid, $attrs);
	}
	
	$status_subscribe = SUBSCRIBE;
	$data_ = array();
	$list_id = array_flip($_POST["SelectLists"]);

	if($form_data["confirmation"] == "1"){ // if confirmable
		$status_subscribe  = UNCONF_SUB;
		foreach ($_POST["SelectLists"] as $key => $value){
			$strSQL = "SELECT * FROM ".CLIENTS_LISTS_TABLE." WHERE client_id='{$uid}' AND list_id='{$key}' AND id_user={$post_data["moderator_id"]}";
			$rs = $dbconn->Execute($strSQL);
			if (!$rs->RowCount()) {
				$strSQL = "INSERT INTO ".CLIENTS_LISTS_TABLE." (client_id,list_id,status_subscribe,date_status,id_user) VALUES ({$uid},{$key}, {$status_subscribe},NOW(), {$post_data["moderator_id"]})";
				$dbconn->Execute($strSQL);
			}
		}
		//Confirm message
		$data_["subject"] = $form_data["confirmation_subject"];
		$data_["content"] = ParseConfirmation($uid, $form_data["confirmation_email"], $list_id,$post_data["moderator_id"]);
		SendAlert("",$data_,$post_data["email"],"",$post_data["moderator_id"]);
		if ($form_data["confirmation_url"]!="" && $form_data["confirmation_url"]!=="http://") {
			echo "<script>location.href='{$form_data["confirmation_url"]}';</script>";
			exit;
		}else{
			die($form_data["confirmation_text"]);
		}
	}

	foreach ($_POST["SelectLists"] as $key => $value){
		$strSQL = "SELECT * FROM ".CLIENTS_LISTS_TABLE." WHERE client_id='{$uid}' AND list_id='{$key}' AND id_user={$post_data["moderator_id"]}";
		$rs = $dbconn->Execute($strSQL);
		if (!$rs->RowCount()) {
			$strSQL = "INSERT INTO ".CLIENTS_LISTS_TABLE." (client_id,list_id,status_subscribe,date_status,id_user) VALUES ({$uid},{$key}, {$status_subscribe},NOW(), {$post_data["moderator_id"]})";
			$dbconn->Execute($strSQL);
		}
		$strSQL = "SELECT * FROM ".LISTS_TABLE." WHERE id={$key}";
		$rs = $dbconn->Execute($strSQL);
		$row_list = $rs->GetRowAssoc(false);
		if ($row_list["release_sub_id"] > 0){
			$data_["id_newsletter"] = $row_list["release_unsub_id"];
			SendAlert("forward",$data_,$post_data["email"],"",$post_data["moderator_id"]);
		}
	}

	if ($form_data["thankyou"] == "1") {
		$data_["subject"] = $form_data["thankyou_subject"];
		$data_["content"] = $form_data["thankyou_email"];
		SendAlert("",$data_,$post_data["email"],"",$post_data["moderator_id"]);
	}
	if($form_data["thankyou_url"]!="" && $form_data["thankyou_url"]!=="http://"){
		echo "<script>location.href='{$form_data["thankyou_url"]}';</script>";
		exit;
	}else{
		die($form_data["thankyou_text"]);
	}
	$smarty->display($config["admin_nl_gentemplates"]."/subscription.tpl");
}

function UnSubscribe($is_link){
	global $config, $smarty, $dbconn, $lang, $post_data, $form_data, $settings;
        
	MainMenu("forms");
	ArrAddSlashes($_REQUEST);
	$data=array();
	if($is_link){
		$data["moderator_id"] = intval($_REQUEST["mid"]);
		$data["md5_email"] = $_REQUEST["c"];
		$data["list_id"][] = intval($_REQUEST["l"]);
		$data["newsletter_id"] = intval($_REQUEST["cr"]);
	}else{
		$data["moderator_id"] = $post_data["moderator_id"];
		$data["md5_email"] = md5($post_data["email"]);
		$data["list_id"] = $_POST['SelectLists'];
		$data["newsletter_id"] = 0;
	}
        
	$strSQL = "SELECT id,email1 FROM ".SEND_USERS_TABLE." WHERE md5(email1)='{$data["md5_email"]}' AND id_user={$data["moderator_id"]}";
	$rs = $dbconn->Execute($strSQL);
	if (!$rs->RowCount()) {
    	die ($lang["err"]["unknown_email"]);
	}
	$data["subscriber_id"] = $rs->fields[0];
	$data["email"] = $rs->fields[1];


	//If isset form field with list then add their values into the POST data
	if(isset($_POST["attr_".FIELD_MAILLIST])){
		unset($data["list_id"]);
		$data["list_id"] = array();
		foreach ($_POST["attr_".FIELD_MAILLIST] as $id_list){
			$data["list_id"][]=$id_list;
		}
	}
        
	$data_ =array();
	if($form_data["confirmation"] == "1"){
		$strSQL = "UPDATE ".CLIENTS_LISTS_TABLE." SET status_subscribe=".UNCONF_UNSUB.", date_status=NOW() WHERE client_id={$data["subscriber_id"]} AND id_user={$data["moderator_id"]}";
		$dbconn->Execute($strSQL);

		// Notifai
		$data_["subject"] = $form_data["confirmation_subject"];
		$data_["content"] = ParseConfirmation($data["subscriber_id"], $form_data["confirmation_email"], $data["list_id"],$data["moderator_id"]);
		SendAlert("",$data_,$data["email"],"",$data["moderator_id"]);

		if($form_data["confirmation_url"]!="" && $form_data["confirmation_url"]!=="http://"){
			echo "<script>location.href='{$form_data["confirmation_url"]}';</script>";
			exit;
		}else{
			die($form_data["confirmation_text"]);
		}
	}else{
		$lists=array();
		foreach ($data["list_id"] as $key => $value){
			$strSQL = "SELECT id FROM ".CLICK_COUNTER_TABLE." WHERE client_id={$data["subscriber_id"]} AND list_id={$value} AND url='uns' AND DATE_FORMAT(time,'%d.%m.%Y') != DATE_FORMAT(NOW(),'%d.%m.%Y')";
			$rs = $dbconn->Execute($strSQL);
			if (!$rs || !$rs->RowCount()) {
				$strSQL = "INSERT INTO ".CLICK_COUNTER_TABLE." (release_id,client_id,list_id,url,time,link_type,id_user) VALUES ({$data["newsletter_id"]},{$data["subscriber_id"]},{$value},'uns',NOW(),'unsubscribe',{$data["moderator_id"]})";
				$rs = $dbconn->Execute($strSQL);
			}
			$rs = $dbconn->Execute("SELECT * FROM ".LISTS_TABLE." WHERE id={$value}");
            if ($rs) {
                $row_list = $rs->GetRowAssoc(false);
            }
			$lists[]=$row_list["name"];
			if($row_list["release_unsub_id"] > 0){
				$data_["id_newsletter"] = $row_list["release_unsub_id"];
				SendAlert("forward",$data_,$data["email"],"",$data["moderator_id"]);
			}
			ActionAfterUnSubscribe($data["subscriber_id"],$value,$data["moderator_id"]);
		}
	}
        
        //print_r($data); exit;
	$to = GetUserSettings(array('from_email'),1);
	if(GetAlertStatus("mail_unsubcription_by_subscriber")){
		// Alert podpischiku ob otpiske
		$data_ = array();
		$data_["name"] = GetSubscriberName($data["subscriber_id"]);
		SendAlert("mail_unsubcription_by_subscriber",$data_,$data["email"],GetSubscriberName($data["subscriber_id"]),$post_data["moderator_id"]);
	}

	if(GetAlertStatus("mail_unsub_subscriber_by_am")){
		// Alert moderu ob otpiske podpischika
		$data_ = array();
		$data_["name"] = GetUserName($post_data["moderator_id"]);
		$data_["list_name"] = GetListName($data["list_id"]);
		$data_["subscriber_info"] = "{$lang["common"]["name"]}: ".GetSubscriberName($data["subscriber_id"]);
		SendAlert("mail_unsub_subscriber_by_am",$data_,$to["from_email"],GetUserName(1),$post_data["moderator_id"]);
	}

	if ($form_data["thankyou"] == "1"){
		// Notifai
		$data_["subject"] = $form_data["thankyou_subject"];
		$data_["content"] = $form_data["thankyou_email"];
		SendAlert("",$data_,$data["email"],"",$data["moderator_id"]);
	}

	if ($form_data["thankyou_url"]!="" && $form_data["thankyou_url"]!=="http://") {
		echo "<script>location.href='".$form_data["thankyou_url"]."';</script>";
		exit;
	} elseif($form_data["thankyou_text"]!="") {
		die($form_data["thankyou_text"]);
	}
	$smarty->assign("lists",implode(", ",$lists));
	$smarty->display($config["admin_nl_gentemplates"]."/unsubscription.tpl");
}

function ParseConfirmation($uid, $text, $listid, $moderator_id) {
	global $dbconn,$config,$post_data;

	$rs = $dbconn->Execute("SELECT email1 FROM ".SEND_USERS_TABLE." WHERE id={$uid}");
	$row = $rs->GetRowAssoc(false);
	$list="&list_id[]=";
	$list.=implode("&list_id[]=",$listid);

	$text1 = preg_replace("/\%CONFIRMLINK\%/i",$config["server"]."/confirm.php?mid={$moderator_id}&e=".md5($row["email1"])."{$list}"."&form_id={$post_data["form_id"]}", $text);
	if(strlen($text)==strlen($text1)) $text1.="\n".$config["server"]."/confirm.php?mid={$moderator_id}&e=".md5($row["email1"])."{$list}"."&form_id={$post_data["form_id"]}";
	return $text1;
}

?>