<?php

include "../include/config.php";
include "../include/common_functions.php";
include "../include/functions_auth.php";
include "../common.php";
include "../include/config.inc.php";
include "../include/forms_function.php";

login_cheeck($auth);
$mode = IsFileAllowed($auth["id"], GetRightModulePath(__FILE__));
$this_page = "forms";

if ($mode == 1) {
    @$sel = $_POST["sel"] ? $_POST["sel"] : $_GET["sel"];
    switch ($sel) {
        case "edit": if (IsFunctionAllowed($auth["id"], 24)) {
                EditForms();
            } else {
                ListForms();
            } break;
        case "save": SaveForms();
            break;
        case "delete": if (IsFunctionAllowed($auth["id"], 25)) {
                DeleteForms();
            } else {
                ListForms();
            } break;
        case "view": ViewForms();
            break;
        case "code": GetCodeForms();
            break;
        default: ListForms();
    }
}

function ListForms() {
    global $lang, $config, $smarty, $dbconn, $auth;
    AdminMainMenu("forms");

    $settings = GetUserSettings(array('is_tips'));

    if (IsFunctionAllowed($auth["id"], 24)) {
        $smarty->assign("create_form", 1);
    }
    if (IsFunctionAllowed($auth["id"], 25)) {
        $smarty->assign("delete_form", 1);
    }

    $res = $dbconn->Execute("SELECT COUNT(id) FROM " . FORM_TABLE . " WHERE id_user={$auth["id"]}");
    $amount = $res->fields[0];

    $data = array();
    $c = 0;
    $strSQL = "SELECT id, name, type, date FROM " . FORM_TABLE . " WHERE id_user={$auth["id"]} ORDER BY name";
    $res = $dbconn->Execute($strSQL);
    while (!$res->EOF) {
        $data[$c]['id'] = $res->fields[0];
        $data[$c]['name'] = $res->fields[1];
        $data[$c]['type'] = ($res->fields[2] == "sub") ? "Subscription" : "Unsubscription";
        $data[$c]['type_code'] = $res->fields[2];
        $data[$c]['date'] = $res->fields[3];
        $c++;
        $res->MoveNext();
    }
    ArrStripSlashes($data);

    get_smarty_array_list("form_page", $config["form_page"]);
    $smarty->assign("amount", $amount);
    $smarty->assign("data", $data);
    $smarty->assign("is_tips", $settings['is_tips']);
    $smarty->display($config["admin_nl_gentemplates"] . "/forms.tpl");
    exit;
}

function EditForms($err="") {
    global $lang, $config, $smarty, $dbconn, $auth;
    AdminMainMenu("forms");
    $file_name = (isset($_SERVER["PHP_SELF"])) ? AfterLastSlash($_SERVER["PHP_SELF"]) : "index.php";

    $settings = GetUserSettings(array('is_tips'));

    $form["action"] = $file_name;

    if (isset($_REQUEST["id"]) && $_REQUEST["id"] != 0) {
        $data = getFormContent((int) $_REQUEST["id"]);
        $id = intval($_REQUEST["id"]);
        $data["id"] = $id;
        $smarty->assign("data", $data);
    } else {
        $data["RequireConfirm"] = 0;
        $data["SendThankyou"] = 0;
        $data["ConfirmURL"] = "http&#58;//";
        $data["ThanksURL"] = "http&#58;//";
        $data["FormType"] = "sub";
        $data["ConfirmSubject"] = 'Subscription confirmation';
        $data["ConfirmEmail"] = 'Hello, Please click on the link below to confirm your subscription: %CONFIRMLINK%';
        $data["ConfirmPage"] = 'Subscription Confirmation. \n\n Please check your email to confirm your subscription...';
        $data["ThanksSubject"] = "Thank you for subscription.";
        $data["ThanksEmail"] = "Hello, Your subscription is now completed.";
        $data["ThanksPage"] = 'Subscription Confirmed. \n\n You have been successfully added to our mailing list.';
        $smarty->assign("data", $data);
        $id = 0;
    }

    if ($err != "") {
        $err["captcha"] = ($err["captcha"] == "on") ? 1 : 0;
        $smarty->assign("error", 1);
        $smarty->assign("data", $err);
    }
    $smarty->assign("form", $form);
    $smarty->assign("list_form", getListsF($id, 0));
    $smarty->assign("script", "location");
    $smarty->assign("is_tips", $settings['is_tips']);
    $smarty->display($config["admin_nl_gentemplates"] . "/forms_create.tpl");
}

function SaveForms() {
    global $lang, $config, $smarty, $dbconn, $auth;
    AdminMainMenu("forms");

    if (trim($_POST["FormName"]) == "" || count($_POST["Lists"]) == 0) {
        EditForms("Error");
        exit;
    }

    $_POST["captcha"] = (isset($_POST["captcha"]) && ($_POST["captcha"] == "on")) ? 1 : 0;
    @$id = $_POST["id"] ? $_POST["id"] : $_GET["id"];
    if ($id == 0 || $id == "0") {
        $ConfirmPage = isset($_POST["ConfirmPage"]) ? str_prepare($_POST["ConfirmPage"]) : "";
        $ConfirmURL = isset($_POST["ConfirmURL"]) ? str_prepare(strip_tags($_POST["ConfirmURL"])) : "";
        $ConfirmEmail = isset($_POST["ConfirmEmail"]) ? str_prepare($_POST["ConfirmEmail"]) : "";
        $ThanksEmail = isset($_POST["ThanksEmail"]) ? str_prepare($_POST["ThanksEmail"]) : "";
        $ThanksSubject = isset($_POST["ThanksSubject"]) ? str_prepare($_POST["ThanksSubject"]) : "";
        $ConfirmSubject = isset($_POST["ConfirmSubject"]) ? str_prepare($_POST["ConfirmSubject"]) : "";
        $FormName = isset($_POST["FormName"]) ? str_prepare($_POST["FormName"]) : "";
        $FormType = isset($_POST["FormType"]) ? str_prepare($_POST["FormType"]) : "";
        $RequireConfirm = isset($_POST["RequireConfirm"]) ? str_prepare($_POST["RequireConfirm"]) : "";
        $SendThankyou = isset($_POST["SendThankyou"]) ? str_prepare($_POST["SendThankyou"]) : "";
        $ThanksPage = isset($_POST["ThanksPage"]) ? str_prepare($_POST["ThanksPage"]) : "";
        $ThanksURL = isset($_POST["ThanksURL"]) ? str_prepare(strip_tags($_POST["ThanksURL"])) : "";

        $dbconn->Execute("INSERT INTO " . FORM_TABLE . "
					(name,type,	confirmation,thankyou,confirmation_text,thankyou_text,confirmation_url,	thankyou_url,
					confirmation_email,	thankyou_email,	date,thankyou_subject,confirmation_subject,captcha,id_user)
					VALUES('{$FormName}','{$FormType}',
		 					'{$RequireConfirm}','{$SendThankyou}',
		 					'{$ConfirmPage}','{$ThanksPage}',
		 					'{$ConfirmURL}','{$ThanksURL}',
		 					'{$ConfirmEmail}','{$ThanksEmail}',
							NOW(),'{$ThanksSubject}',
		 					'{$ConfirmSubject}','" . $_POST["captcha"] . "'," . $auth["id"] . ")");
        $fid = $dbconn->_insertid();

        foreach ($_POST["Lists"] as $list) {
            $res = $dbconn->Execute("INSERT INTO " . FORMS_LISTS_TABLE . " (form_id,list_id) VALUES ({$fid},{$list})");
        }
    } else {
        $id = intval($_POST["id"]);
        $dbconn->Execute("UPDATE " . FORM_TABLE . " SET
					name = '" . str_prepare($_POST["FormName"]) . "',
					type = '" . str_prepare($_POST["FormType"]) . "',
					confirmation = '" . str_prepare($_POST["RequireConfirm"]) . "',
					thankyou = '" . str_prepare($_POST["SendThankyou"]) . "',
					confirmation_text = '" . str_prepare($_POST["ConfirmPage"]) . "',
					thankyou_text = '" . str_prepare($_POST["ThanksPage"]) . "',
					confirmation_url = '" . str_prepare($_POST["ConfirmURL"]) . "',
					thankyou_url = '" . str_prepare($_POST["ThanksURL"]) . "',
					confirmation_email = '" . str_prepare(strip_tags($_POST["ConfirmEmail"])) . "',
					thankyou_email = '" . str_prepare(strip_tags($_POST["ThanksEmail"])) . "',
					thankyou_subject = '" . str_prepare($_POST["ThanksSubject"]) . "',
					confirmation_subject = '" . str_prepare($_POST["ConfirmSubject"]) . "',
					captcha = '{$_POST["captcha"]}'
				WHERE id={$id}");

        $dbconn->Execute("DELETE FROM " . FORMS_LISTS_TABLE . " WHERE form_id={$id}");
        foreach ($_POST["Lists"] as $list) {
            $list = intval($list);
            $dbconn->Execute("INSERT INTO " . FORMS_LISTS_TABLE . " (form_id,list_id) VALUES ({$id},{$list})");
        }
    }
    //ListForms();
    header("Location: {$config["server"]}/forms/index.php");
    exit;
}

function DeleteForms() {
    if (isset($_POST["del"])) {
        foreach ($_POST["del"] as $val) {
            delForm(intval($val));
        }
    } elseif (isset($_GET['did']) && !empty($_GET['did'])) {
        delForm(intval($_GET['did']));
    }
    ListForms();
    exit;
}

function ViewForms() {
    global $dbconn, $auth;
    AdminMainMenu("forms");
    $id = intval($_GET["id"]);
    $res = $dbconn->Execute("SELECT * FROM " . FORM_TABLE . " WHERE id={$id} AND id_user={$auth["id"]}");
    $row = $res->GetRowAssoc(false);
    print ($row["type"] == "sub") ? generateForm($row) : generateUnsubscribeForm($row);
    exit;
}

function GetCodeForms() {
    global $lang, $config, $config_index, $smarty, $dbconn, $auth;
    AdminMainMenu("forms");

    $id = intval($_GET["id"]);
    $res = $dbconn->Execute("SELECT * FROM " . FORM_TABLE . " WHERE id={$id} AND id_user={$auth["id"]}");
    $row = $res->GetRowAssoc(false);

    $form_html = ($row["type"] == "sub") ? generateForm($row) : generateUnsubscribeForm($row);

    $smarty->assign("code", htmlspecialchars($form_html));
    $smarty->assign("jquery", 1);
    $smarty->display($config["admin_nl_gentemplates"] . "/forms_code.tpl");
    exit;
}

?>