<?php

include "include/config.php";
include "include/common_functions.php";
include "include/functions_auth.php";
include "common.php";
include "include/config.inc.php";

login_cheeck($auth);
$mode = IsFileAllowed($auth["id"], GetRightModulePath(__FILE__));

$file_name = $config["server"] . "/groups.php";
$smarty->assign("file_name", $file_name);
$this_page = "groups";
if ($mode == 1) {
    @$sel = $_POST["sel"] ? $_POST["sel"] : $_GET["sel"];
    switch ($sel) {
        case "add": AddGroup();
            break;
        case "edit": EditForm("edit");
            break;
        case "change": ChangeGroup();
            break;
        case "del": DelGroup($_POST["id"] ? $_POST["id"] : $_GET["id"]);
            ListGroup();
            break;
        case "delete": DelUsers();
            break;
        case "perm": PermForm();
            break;
        case "permchange": PermChange();
            break;
        case "user": UserForm();
            break;
        case "adduser": AddUser();
            break;
        case "saveuser": SaveUser();
            break;
        case "change_status": UpdateStatus();
            break;
        case "create_footer": CreateFooter();
            break;
        case "save_footer": SaveFooter();
            break;
        default: ListGroup();
    }
}

function ListGroup($err = "") {
    global $smarty, $dbconn, $config, $lang, $file_name;

    AdminMainMenu("admins");

    $strSQL = "SELECT COUNT(id) FROM " . GROUPS_TABLE . " WHERE id NOT IN (1,2)";
    $rs = $dbconn->Execute($strSQL);
    $amount = $rs->fields[0];

    $strSQL = " SELECT id, name, type FROM " . GROUPS_TABLE . " WHERE id NOT IN (1,2) ORDER BY name";
    $rs = $dbconn->Execute($strSQL);
    $i = 0;
    if ($rs->RowCount() > 0) {
        while (!$rs->EOF) {
            $group_arr[$i]["id"] = $rs->fields[0];
            $group_arr[$i]["type"] = $rs->fields[2];
            $group_arr[$i]["name"] = strval($rs->fields[1]);
            $group_arr[$i]["type_name"] = $lang["groups"]["types"][strval($rs->fields[2])];
            $group_arr[$i]["editlink"] = $file_name . "?sel=add&id=" . $rs->fields[0];
            $group_arr[$i]["userlink"] = $file_name . "?sel=user&id_group=" . $rs->fields[0];
            $group_arr[$i]["permlink"] = $file_name . "?sel=perm&id=" . $rs->fields[0];
            $group_arr[$i]["dellink"] = $file_name . "?sel=del&id=" . $rs->fields[0];
            $group_arr[$i]["create_footer"] = $file_name . "?sel=create_footer&id=" . $rs->fields[0];
            $rs->MoveNext();
            $i++;
        }
        ArrStripSlashes($group_arr);
        get_smarty_array_list("group_page", $config["group_page"]);
        $smarty->assign("group_arr", $group_arr);
        $smarty->assign("amount", $amount);
    } else {
        $smarty->assign("empty_row", "1");
    }
    $form["err"] = $err;
    $smarty->assign("form", $form);

    $smarty->assign("add_link", $file_name . "?sel=add");
    $smarty->display($config["admin_nl_gentemplates"] . "/admin_groups.tpl");
    exit;
}

function CreateFooter($error = 0) {
    global $smarty, $dbconn, $config, $lang, $auth;

    AdminMainMenu("admins");

    $id_group = $_GET["id"] ? intval($_GET["id"]) : $error;
    $data = array();

    $strSQL = "SELECT html_footer,text_footer,id_group FROM " . GROUPS_FOOTER_TABLE . " WHERE id_group={$id_group} AND id_user={$auth["id"]}";
    $res = $dbconn->Execute($strSQL);
    $data["html_footer"] = $res->fields[0];
    $data["text_footer"] = $res->fields[1];
    $data["id_group"] = $id_group;

    if ($error) {
        $smarty->assign("error", $lang["err"]["its_ok"]);
    }

    $smarty->assign("data", $data);
    $smarty->display($config["admin_nl_gentemplates"] . "/admin_groups_footer.tpl");
}

function SaveFooter() {
    global $smarty, $dbconn, $config, $lang, $auth;
    $_POST["html_footer"] = strip_tags($_POST["html_footer"]);
    ArrAddSlashes($_POST);
    $id_group = intval($_POST["id_group"]);

    $strSQL = "SELECT id_group FROM " . GROUPS_FOOTER_TABLE . " WHERE id_group={$id_group} AND id_user={$auth["id"]}";
    $res = $dbconn->Execute($strSQL);

    if ($res->RowCount() > 0) {
        $strSQL = "UPDATE " . GROUPS_FOOTER_TABLE . " SET html_footer='{$_POST["html_footer"]}',text_footer='{$_POST["text_footer"]}' WHERE id_group={$id_group} AND id_user={$auth["id"]}";
    } else {
        $strSQL = "INSERT INTO " . GROUPS_FOOTER_TABLE . " (id_group,html_footer,text_footer,id_user) VALUES({$id_group},'{$_POST["html_footer"]}','{$_POST["text_footer"]}',{$auth["id"]})";
    }
    $res = $dbconn->Execute($strSQL);
    CreateFooter($id_group);
    exit;
}

function AddUser($errors = array(), $data = "") {
    global $smarty, $dbconn, $config, $lang, $auth;

    AdminMainMenu("registration");
    $smarty->assign("viewjs", 1);
    if (isset($_GET["id"]) && intval($_GET["id"]) > 0) {
        $strSQL = "SELECT * FROM " . USERS_TABLE . " WHERE id=" . intval($_GET["id"]);
        $rs = $dbconn->Execute($strSQL);
        $row = $rs->GetRowAssoc(false);
        $data["id_user"] = $row["id"];
        $data["fname"] = $row["fname"];
        $data["sname"] = $row["sname"];
        $data["phone"] = $row["phone"];
        $data["wsite"] = $row["website"];
        $data["email"] = $row["email"];
        $data["login"] = $row["login"];

        $strSQL = "SELECT a.id_group, b.type FROM " . USER_GROUP_TABLE . " a LEFT JOIN " . GROUPS_TABLE . " b ON b.id=a.id_group WHERE a.id_user={$data["id_user"]}";
        $rs = $dbconn->Execute($strSQL);
        $row = $rs->GetRowAssoc(false);
        $data["group"] = $row["id_group"];
        $data["type"] = $row["type"];

        if ($data["type"] == 'd') {
            $data['group'] = $data['group'] . "_0";
        }
        $smarty->assign("viewjs", 0);
    }

    //$strSQL = "SELECT b.period,a.id_group_period FROM ".BILLING_USER_PERIOD_TABLE." a LEFT JOIN ".GROUP_PERIOD_TABLE." b ON  b.id=a.id_group_period WHERE a.id_user=".intval($_GET["id"]);
    $strSQL = "SELECT b.period,a.id_group_period FROM " . BILLING_USER_PERIOD_TABLE . " a LEFT JOIN " . GROUP_PERIOD_TABLE . " b ON  b.id=a.id_group_period WHERE a.id_user=" . intval($_GET["id"]);
    $rs = $dbconn->Execute($strSQL);
    $data["id_group_period"] = $rs->fields[1];
    if ($rs->fields[0] == "emails") {
        $where = " AND b.period = 'emails'";
    } elseif (in_array($rs->fields[0], array('day', 'week', 'month', 'year'))) {
        $where = " AND b.period IN ('day','week','month','year')";
    } elseif (!isset($rs->fields[0]) || empty($rs->fields[0])) {
        $where = "";
    }
    $strSQL = "SELECT b.id, b.period, b.amount, a.name, a.id as id_group, b.type FROM " . GROUPS_TABLE . " a, " . GROUP_PERIOD_TABLE . " b WHERE b.id_group=a.id AND b.status='1' {$where} ORDER BY a.id";
    $rs_p = $dbconn->Execute($strSQL);
    $j = 0;
    while (!$rs_p->EOF) {
        $row_p = $rs_p->GetRowAssoc(false);
        $groups[$j]["id"] = $row_p["id"];
        $groups[$j]["id_group"] = $row_p["id_group"];
        $groups[$j]["sel"] = ($row_p["id"] == $data["id_group_period"]) ? "1" : "";
        $groups[$j]["amount"] = $row_p["amount"];
        $groups[$j]["type"] = $row_p["type"];
        if ($groups[$j]["type"] == "3") {
            $tmp_amount = explode("|", $row_p["amount"]);
            $tmp_period = explode("|", $row_p["period"]);
            $groups[$j]["period"] = $tmp_amount[0] . " " . $lang["pays"]["periods"][$tmp_period[0]] . ", ";
            $groups[$j]["period"] .= $tmp_amount[1] . " " . $lang["pays"]["periods"][$tmp_period[1]];
        } else {
            $groups[$j]["period"] = $row_p["amount"] . " " . $lang["pays"]["periods"][$row_p["period"]];
        }
        //$groups[$j]["period"] = $lang["pays"]["periods"][$row_p["period"]];
        $groups[$j]["name"] = $row_p["name"];
        $rs_p->MoveNext();
        $j++;
    }

    $strSQL = "SELECT a.name, a.id as id_group FROM " . GROUPS_TABLE . " a WHERE a.type='d' LIMIT 1";
    $rs_p = $dbconn->Execute($strSQL);
    $row_p = $rs_p->GetRowAssoc(false);

    $groups[$j]["id"] = 0;
    $groups[$j]["id_group"] = $row_p["id_group"];

    $groups[$j]["sel"] = ($data["group"] == $groups[$j]["id_group"] . "_0") ? "1" : "";

    $groups[$j]["name"] = $row_p["name"];

    $smarty->assign("groups", $groups);


    if (count($errors) > 0) {
        $smarty->assign("errors", $errors);
        $smarty->assign("err", implode("<br>", $errors));
    }
    $smarty->assign("data", $data);

    $smarty->display($config["admin_nl_gentemplates"] . "/admin_user_add.tpl");
    exit;
}

function DelUsers() {
    if (isset($_POST["del"])) {
        foreach ($_POST["del"] as $val) {
            DelUser($val);
        }
    } elseif (isset($_GET['del']) && !empty($_GET['del'])) {
        DelUser($_GET['del']);
    }

    UserForm();
    exit;
}

function DelUser($id) {
    global $dbconn;

    if (!$id)
        return;
    $id = intval($id);
    $strSQL = "DELETE FROM " . USERS_TABLE . " WHERE id={$id} AND root_user='0' AND guest_user='0'";
    $dbconn->Execute($strSQL);
    $strSQL = "DELETE FROM " . USER_GROUP_TABLE . " WHERE id_user={$id}";
    $dbconn->Execute($strSQL);

    $strSQL = "DELETE FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$id}";
    $dbconn->Execute($strSQL);
    $strSQL = "DELETE FROM " . USER_SETTINGS_TABLE . " WHERE id_user={$id};";
    $dbconn->Execute($strSQL);
    return;
}

function SaveUser() {
    global $smarty, $dbconn, $config, $config_admin, $lang, $auth, $file_name;

    AdminMainMenu("registration");
    $errors = array();
    ArrAddSlashes($_POST);

    $id_user = (isset($_POST["id_user"])) ? intval($_POST["id_user"]) : 0;
    $arr = explode("_", $_POST["group"]);
    $group = intval($arr[0]);
    $id_period = intval($arr[1]);
    $fname = (isset($_POST["fname"])) ? strip_tags($_POST["fname"]) : "";
    $sname = (isset($_POST["sname"])) ? strip_tags($_POST["sname"]) : "";
    $phone = (isset($_POST["phone"])) ? strip_tags($_POST["phone"]) : "";
    $wsite = (isset($_POST["wsite"])) ? strip_tags($_POST["wsite"]) : "";
    $email = (isset($_POST["email"])) ? strip_tags($_POST["email"]) : "";
    $login = (isset($_POST["login"])) ? strip_tags($_POST["login"]) : "";
    $password = (isset($_POST["password"])) ? strip_tags($_POST["password"]) : "";
    $repassword = (isset($_POST["repassword"])) ? strip_tags($_POST["repassword"]) : "";


    if (empty($fname)) {
        $errors["fname"] = $lang["err"]["specify_firstname"];
    }
    if (empty($sname)) {
        $errors["sname"] = $lang["err"]["specify_secondname"];
    }
    if (empty($email)) {
        $errors["email"] = $lang["err"]["specify_email"];
    }
    if (!preg_match('/^\s*\w+([\.\w\-]+)*\w@\w+([\.\w\-]+)*\w\.\w{2,}\s*$/', $email)) {
        $errors["email"] = $lang["err"]["invalid_email"];
    }
    if (!$id_user) {
        if (empty($login)) {
            $errors["login"] = $lang["err"]["specify_login"];
        }
        if (empty($password)) {
            $errors["password"] = $lang["err"]["specify_password"];
        }
        if (empty($repassword)) {
            $errors["repassword"] = $lang["err"]["specify_repassword"];
        }
        if ($password != $repassword) {
            $errors["pass_repass"] = $lang["err"]["specify_repassword"];
        }

        $rs = $dbconn->Execute("SELECT id FROM " . USERS_TABLE . " WHERE login='{$login}'");
        if ($rs->RowCount()) {
            $errors["login_exist"] = $lang["err"]["login_exist"];
        }
        $smarty->assign("viewjs", 0);
    }
    if (count($errors) > 0) {
        AddUser($errors, $_POST);
        exit;
    }
    if (!$id_user) {

        $strSQL = "INSERT INTO " . USERS_TABLE . " (fname, sname, status, login, password, phone, email, website, date_registration)
					VALUES ('{$fname}','{$sname}','1', '{$login}', '" . md5($password) . "','{$phone}','{$email}','{$wsite}', NOW())";
        $rs = $dbconn->Execute($strSQL);
        $id_user = $dbconn->Insert_ID();
        CopyTemplateToNewUser($id_user);
        $admin_data = GetUserSettings(array('birthday_id'), 1);

        $strSQL = "SELECT * FROM " . SECTION_ATTRS_TABLE . " WHERE id={$admin_data["birthday_id"]}";
        $rs = $dbconn->Execute($strSQL);
        $row = $rs->GetRowAssoc(false);
        $strSQL = "INSERT INTO " . SECTION_ATTRS_TABLE . " (name,id_section,mandatory,control_type,control_setup,is_const,id_user)
					VALUES ('{$row["name"]}',{$row["id_section"]},'{$row["mandatory"]}','{$row["control_type"]}','{$row["control_setup"]}','{$row["is_const"]}',{$id_user})";
        $dbconn->Execute($strSQL);
        $birthday_id = $dbconn->Insert_ID();

        $strSQL = "	INSERT INTO " . USER_SETTINGS_TABLE . " (value, name, id_user) VALUES
						('{$fname} {$sname}','from_name',{$id_user}),('0','timeout',{$id_user}),
						('0','smtp_quota',{$id_user}),('0','send_period',{$id_user}),
						('{$email}','from_email',{$id_user}),('1','is_tips',{$id_user}),
						('0','auto_delete',{$id_user}),('smtp','type_dispatch',{$id_user}),
						('1','action_with_subscr',{$id_user}),('0','change_link',{$id_user}),
						('0','bounce',{$id_user}),('test@test.com','test_email',{$id_user}),('birthday_id','{$birthday_id}',{$id_user})";
        $dbconn->Execute($strSQL);
        $dbconn->Execute("INSERT into " . USER_GROUP_TABLE . "  (id_user, id_group) values ({$id_user}, {$group})");

        if ($_POST["alert_send"] == "1") {
            if (GetAlertStatus("mail_newuser_by_user")) {
                // Alert polzovatelu o registracii
                $data_ = array();
                $data_["site_name"] = $config["server"];
                $data_["name"] = GetUserName($id_user);
                $data_["login_info"] = "{$lang["common"]["login"]}: {$login}\n{$lang["common"]["pwd"]}: {$password}";
                $data_["link"] = $config["server"];
                SendAlert("mail_newuser_by_user", $data_, $email, $fname . " " . $sname, 1);
            }
        }
    } else {
        $strINS = "";
        if ($password != "" && $repassword != "" && $password == $repassword) {
            $strINS = "password = '" . md5($password) . "',";
        }
        $strSQL = "UPDATE " . USERS_TABLE . " SET fname='{$fname}', sname='{$sname}', " . $strINS . "
						phone='{$phone}', email='{$email}',website='{$wsite}'
					WHERE id=" . $id_user;
        $rs = $dbconn->Execute($strSQL);
        $dbconn->Execute("UPDATE " . USER_GROUP_TABLE . " SET id_group={$group} WHERE id_user={$id_user}");
    }

    if ($id_period != 0) {
        ////Period
        $strSQL = "SELECT id_group, cost, period, amount,type FROM " . GROUP_PERIOD_TABLE . " WHERE id={$id_period}";
        $rs = $dbconn->Execute($strSQL);
        $row = $rs->GetRowAssoc(false);
        $period = $row["period"];
        $period_type = $row["type"];

        $strSQL = "SELECT id_group_period FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$id_user}";
        $rs = $dbconn->Execute($strSQL);
        if (!($rs->fields[0] && $rs->fields[0] == $id_period)) {

            $strSQL = "DELETE FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$id_user}";
            $dbconn->Execute($strSQL);
            if ($period_type == 1) {
                $data["id_group"] = $row["id_group"];
                $data["period"] = $row["amount"] * $config_admin["pay_period"][$row["period"]];
                if (!$data["id_group"]) {
                    return "";
                }

                $strSQL = "INSERT INTO " . BILLING_USER_PERIOD_TABLE . " (id_group_period, date_begin, date_end, id_user)
                              VALUES ({$id_period}, NOW(), NOW()+INTERVAL " . $data["period"] . " DAY, {$id_user})";
                $dbconn->Execute($strSQL);
            } elseif ($period_type == 2) {
                $rs = $dbconn->Execute("SELECT id, email FROM " . BILLING_USER_PERIOD_TABLE . " where id_user={$id_user}");
                if ($rs->fields[0] > 0) {
                    $data["period"] = intval($rs->fields[1]) + intval($row["amount"]);
                } else {
                    $data["period"] = $row["amount"];
                }
                $data["id_group"] = $row["id_group"];
                if (!$data["id_group"]) {
                    return "";
                }
                $dbconn->Execute("INSERT into " . BILLING_USER_PERIOD_TABLE . " (id_group_period, id_user, email) values ({$id_period}, {$id_user}, {$data["period"]} ) ");
            } elseif ($period_type == 3) {
                $rs = $dbconn->Execute("SELECT id, date_begin, date_end, email FROM " . BILLING_USER_PERIOD_TABLE . " where id_user={$id_user}");
                $tmp = explode("|", $period);
                $time_period = $tmp[0];
                $email_period = $tmp[1];
                $tmp1 = explode("|", $row["amount"]);
                $time_amount = $tmp1[0];
                $email_amount = $tmp1[1];
                $data["period"] = $time_amount * $config_admin["pay_period"][$time_period];

                $strSQL = "INSERT INTO " . BILLING_USER_PERIOD_TABLE . " (id_group_period, date_begin, date_end, id_user, email)
              VALUES ({$id_period}, NOW(), NOW()+INTERVAL " . $data["period"] . " DAY, {$id_user}, '" . $email_amount . "')";

                $dbconn->Execute($strSQL);
            }
        }
    }
    //UserForm();
    echo "<script>location.href='{$file_name}?sel=user';</script>";
    exit;
}

function AddGroup($error = "") {
    global $smarty, $dbconn, $config, $lang;

    AdminMainMenu("admins");
    $id = isset($_REQUEST["id"]) ? intval($_REQUEST["id"]) : 0;

    $group = array();
    if ($id) {
        $strSQL = "SELECT id, name, type, trial_value, trial_period FROM " . GROUPS_TABLE . " WHERE id={$id}";
        $rs = $dbconn->Execute($strSQL);
        $group["id"] = $rs->fields[0];
        $group["name"] = FormFilter($rs->fields[1]);
        $group["group_type"] = $rs->fields[2];
        $group["trial_value"] = $rs->fields[3];
        $group["trial_period"] = $rs->fields[4];

        //if ($group["group_type"] == 'f') {
        $strSQL = "SELECT amount, period FROM " . GROUP_PERIOD_TABLE . " WHERE id_group='" . $id . "' LIMIT 1";
        $rs = $dbconn->Execute($strSQL);

        $group["period_value"] = explode('|', $rs->fields[0]);
        $group["period_type"] = explode('|', $rs->fields[1]);
        if (count($group["period_value"]) == 2 && count($group["period_type"]) == 2) {
            if ($group["group_type"] == 'd')
                $smarty->assign("free_email", $group["period_value"][1]);
            $smarty->assign("free_period_time", $group["period_value"][0]);
            $smarty->assign("free_period", $group["period_type"][0]);
        }
        //}
    }

    if ($error) {
        ArrStripSlashes($_POST);
        $group = $_POST;
        $smarty->assign("error", $error);
    }

    $settings_manager = new SettingsManager();
    $smarty->assign("currency", $settings_manager->GetSiteSettings("site_unit_costunit"));
    $smarty->assign("group", $group);

    if (isset($_GET['action'])) {
        if (isset($_GET["packet_id"])) {
            $pid = floor($_GET["packet_id"]);
            switch ($_GET['action']) {
                case 'delete_payment':
                    $strSQL = "DELETE FROM " . GROUP_PERIOD_TABLE . "  WHERE id='{$pid}'";
                    $dbconn->Execute($strSQL);
                    break;
            }
        }
        $smarty->assign("show_packets", true);
    }
    $file_name = $config["server"] . "/groups.php";
///// groups
    $strSQL = "SELECT id, name FROM " . GROUPS_TABLE . "  WHERE type='f' ORDER BY name";
    $rs = $dbconn->Execute($strSQL);
    $i = 0;
    while (!$rs->EOF) {
        $groups[$i]["id"] = $rs->fields[0];
        $groups[$i]["name"] = $rs->fields[1];
        $rs->MoveNext();
        $i++;
    }
    $smarty->assign("groups", $groups);

    $strSQL = "SELECT a.*, b.name as group_name FROM " . GROUP_PERIOD_TABLE . " a LEFT JOIN " . GROUPS_TABLE . " AS b ON b.id=a.id_group WHERE b.type <> 't' AND b.id = {$id} ORDER BY a.date";
    $rs = $dbconn->Execute($strSQL);
    $i = 0;
    while (!$rs->EOF) {
        $row = $rs->GetRowAssoc(false);
        $data[$i]["id"] = $row["id"];
        $data[$i]["id_group"] = $row["id_group"];
        $data[$i]["type"] = $row["type"];
        $data[$i]["date"] = $row["date"];
        if ($data[$i]["type"] == "3") {
            $tmp_amount = explode("|", $row["amount"]);
            $tmp_period = explode("|", $row["period"]);
            $data[$i]["period"] = $tmp_amount[0] . " " . $lang["pays"]["periods"][$tmp_period[0]] . ", ";
            $data[$i]["period"] .= $tmp_amount[1] . " " . $lang["pays"]["periods"][$tmp_period[1]];
        } else {
            $data[$i]["period"] = $row["amount"] . " " . $lang["pays"]["periods"][$row["period"]];
        }
        $data[$i]["cost"] = $row["cost"] . " " . $form["currency"];
        $data[$i]["status"] = $row["status"];
        $data[$i]["status_str"] = $lang["pays"]["act_status_{$row["status"]}"];
        $data[$i]["group_name"] = $row["group_name"];
        $data[$i]["del_link"] = $file_name . "?sel=add&id={$id}&action=delete_payment&packet_id={$data[$i]["id"]}";
        $data[$i]["act_link"] = $file_name . "?sel=add&id={$id}&action=activate&packet_id={$data[$i]["id"]}";
        $rs->MoveNext();
        $i++;
    }
    $smarty->assign("data", $data);
    $smarty->assign("payment_link", $config["server"] . "/payment.php");
    $smarty->assign("err", $lang["err"]);
    $smarty->assign("form", $form);
    $smarty->assign("button", $lang["button"]);

    $smarty->display($config["admin_nl_gentemplates"] . "/admin_groups_form.tpl");
    exit;
}

function ChangeGroup() {
    global $smarty, $dbconn, $config, $lang, $file_name;

    $packages = array();
    if (isset($_POST['serrialize']) && $_POST['serrialize']) {
        $strings = explode('&', $_POST['serrialize']);
        $period = array();
        $period_time = array();
        $period_email = array();
        $type = array();
        $cost = array();
        $trial_value = array();
        $trial_period = array();
        foreach ($strings as $string) {
            $sub_strings = explode('=', $string);
            $id = $sub_strings[0];
            $value = $sub_strings[1];
            $id = (string) preg_replace('/[^a-z_]/', '', $id);
            switch ($id) {
                case 'period_period':
                    $period[] = $value;
                    break;
                case 'period_time':
                    $period_time[] = $value;
                    break;
                case 'period_email':
                    $period_email[] = $value;
                    break;
                case 'type':
                    $type[] = $value;
                    break;
                case 'cost':
                    $cost[] = $value;
                    break;
                case 'trial_value':
                    $trial_value[] = $value;
                    break;
                case 'trial_period':
                    $trial_period[] = $value;
                    break;
            }
        }
        if (count($type) > 0) {
            foreach ($type as $id => $value) {
                $packages[$id] = array(
                    'period' => $period[$id],
                    'type' => $type[$id],
                    'period_time' => $period_time[$id],
                    'period_email' => $period_email[$id],
                    'trial_value' => $trial_value[$id],
                    'trial_period' => $trial_period[$id],
                    'cost' => $cost[$id],
                );
            }
        }
    }

    $id = isset($_REQUEST["id"]) ? intval($_REQUEST["id"]) : 0;
    $group_name = isset($_REQUEST["name"]) ? mysql_real_escape_string(FormFilter($_REQUEST["name"])) : null;
    $group_type = isset($_REQUEST["group_type"]) && in_array($_REQUEST["group_type"], array('d', 'f')) ? $_REQUEST["group_type"] : 'f';

    $trial_value = intval($_REQUEST["period_value"]);
    $trial_period = $_REQUEST["period_type"];

    if (!$group_name) {
        AddGroup($lang["err"]["form_errors"]);
        return;
    }

    if (($group_type == 'd') && CheckGroupTypeAlreadyExists($group_type, $id) == true) {
        AddGroup($lang["err"]["group_type_exists_" . $group_type]);
        return;
    }
    if ($id) {
        $strSQL = "UPDATE " . GROUPS_TABLE . " SET name='{$group_name}', type='" . $group_type . "', trial_value='" . $trial_value . "', trial_period='" . $trial_period . "' WHERE id={$id}";
        $dbconn->Execute($strSQL);
    } else {
        $strSQL = "INSERT INTO " . GROUPS_TABLE . " (name, type, trial_value, trial_period) VALUES('{$group_name}', '" . $group_type . "', '" . $trial_value . "', '" . $trial_period . "' )";
        $dbconn->Execute($strSQL);
        $id = $dbconn->Insert_ID();
    }
    if ($group_type == 'd') {
        $amount = intval($_POST["free_period_time"]) . '|' . intval($_POST["free_email"]);
        $period = $_POST["free_period"] . '|emails';
        $strSQL = "DELETE FROM " . GROUP_PERIOD_TABLE . " WHERE id_group={$id}";
        $dbconn->Execute($strSQL);
        $strSQL = "INSERT INTO " . GROUP_PERIOD_TABLE . " (id_group,type,date,amount,period,cost,status) VALUES ({$id},2,NOW(),'{$amount}','{$period}', '0', '1')";
        $dbconn->Execute($strSQL);
    } else {
        if (count($packages) > 0) {
            foreach ($packages as $value) {
                $group = $id;
                if ($value["period"]) {
                    if ($value["type"] == 1) {
                        $amount = intval($value["period_time"]);
                        $period = $value["period"];
                    } elseif ($value["type"] == 2) {
                        $amount = intval($value["period_email"]);
                        $period = "emails";
                    } else {
                        $amount = intval($value["period_time"]) . "|" . intval($value["period_email"]);
                        $period = $value["period"] . "|" . "emails";
                    }
                    $cost = intval($value["cost"]);
                    if (!$cost) {
                        $error = "error";
                    } else {
                        $strSQL = "INSERT INTO " . GROUP_PERIOD_TABLE . " (id_group,type,date,amount,period,cost,status) VALUES ({$group},{$value["type"]},NOW(),'{$amount}','{$period}', '{$cost}', '1')";
                        $dbconn->Execute($strSQL);
                        $id_group = $dbconn->Insert_ID();
                        $strSQL = "INSERT INTO " . BILLING_PERIODS_CCBILL_TABLE . " (id_group_period, ccbill_sub_id) VALUES ({$id_group}, '0000000000')";
                        $dbconn->Execute($strSQL);
                    }
                }
            }
        }
    }
    if (isset($_REQUEST['action'])) {
        echo "<script>location.href='{$file_name}?sel=add&id={$group}&action=add_packet';</script>";
        exit;
    }
    header("Location: {$file_name}");
    exit;
}

function CheckGroupTypeAlreadyExists($type, $id) {
    global $dbconn;

    $add_str = ($id > 0) ? " AND id <> '" . $id . "'" : "";
    $strSQL = "SELECT COUNT(*) FROM " . GROUPS_TABLE . " WHERE type='" . $type . "'" . $add_str;

    $rs = $dbconn->Execute($strSQL);
    if ($rs->fields[0] > 0) {
        return true;
    } else {
        return false;
    }
}

function PermForm($err = "") {
    global $smarty, $dbconn, $config, $config_admin, $page, $letter, $lang, $e, $file_name;

    AdminMainMenu("admins");
    $id = intval($_GET["id"]);

    $sess_perm = array();
    $sess_function = array();

    if (isset($_SESSION["perm"])) {
        $sess_perm = $_SESSION["perm"];
    } else {
        if ($id) {
            $rs = $dbconn->Execute("SELECT id_module FROM " . GROUP_MODULE_TABLE . " WHERE id_group={$id}");
            $i = 0;
            while (!$rs->EOF) {
                $sess_perm[$i] = $rs->fields[0];
                $rs->MoveNext();
                $i++;
            }
        }
    }


    if ($id) {
        $strSQL = " SELECT DISTINCT id_function FROM " . GROUP_FUNCTION_TABLE . " WHERE id_group={$id} GROUP BY id";
        $rs = $dbconn->Execute($strSQL);
        $i = 0;
        while (!$rs->EOF) {
            $sess_function[$i] = $rs->fields[0];
            $rs->MoveNext();
            $i++;
        }
    }


    if ($id > 0) {
        $strSQL = "SELECT name FROM " . GROUPS_TABLE . " WHERE id={$id}";
        $rs = $dbconn->Execute($strSQL);
        $data["groupname"] = $rs->fields[0];
    } else {
        $data["groupname"] = $lang["groups"]["default_group"];
    }

    $strSQL = "SELECT id, name FROM " . MODULES_TABLE . " WHERE id NOT IN (9) ORDER BY id";
    $rs = $dbconn->Execute($strSQL);
    $i = 0;
    while (!$rs->EOF) {
        $perm[$i]["id"] = $rs->fields[0];
        /////// Functions modules
        $strSQL = "SELECT id, name FROM " . FUNCTIONS_TABLE . " WHERE id_module={$perm[$i]["id"]} ORDER BY id";
        $func = $dbconn->Execute($strSQL);
        $j = 0;
        while (!$func->EOF) {
            if ($rs->fields[0] != 9) {
                $perm[$i]["functions"][$j]["id"] = $func->fields[0];
                $perm[$i]["functions"][$j]["name"] = $lang["functions"][$func->fields[1]]["name"];
                $perm[$i]["functions"][$j]["comment"] = $lang["functions"][$func->fields[1]]["comment"];
                if (in_array($perm[$i]["functions"][$j]["id"], $sess_function))
                    $perm[$i]["functions"][$j]["checked"] = "1";
                else
                    $perm[$i]["functions"][$j]["checked"] = "0";
                $j++;
            }
            $func->MoveNext();
        }
        /////////////////////////
        $perm[$i]["name"] = $lang["modules"][$rs->fields[1]]["name"];
        $perm[$i]["comment"] = $lang["modules"][$rs->fields[1]]["comment"];
        if (in_array($perm[$i]["id"], $sess_perm))
            $perm[$i]["checked"] = "1";
        else
            $perm[$i]["checked"] = "0";
        $rs->MoveNext();
        $i++;
    }

    $strSQL = "SELECT DISTINCT p.id, p.permission_name, gp.permission_count
				FROM " . PERMISSIONS_TABLE . " p
				LEFT JOIN " . GROUPS_PERMISSIONS_TABLE . " gp ON (gp.id_permission=p.id AND gp.id_group={$id})
				WHERE 1
				ORDER BY p.id";
    $rs = $dbconn->Execute($strSQL);
    $i = 0;
    while (!$rs->EOF) {
        $permisions[$i]['id'] = $rs->fields[0];
        $permisions[$i]['name'] = $lang["permission"][$rs->fields[1]]["name"];
        $permisions[$i]['count'] = $rs->fields[2] ? $rs->fields[2] : "";
        $rs->MoveNext();
        $i++;
    }
    $form["action"] = $file_name;
    $form["err"] = $err;

    $smarty->assign("lang_perm", $lang["modules"]);
    $smarty->assign("lang_func", $lang["functions"]);
    $smarty->assign("data", $data);
    $smarty->assign("jquery", 1);
    $smarty->assign("perm", $perm);
    $smarty->assign("id_group", $id);
    $smarty->assign("permisions", $permisions);
    $smarty->assign("form", $form);
    $smarty->assign("button", $lang["button"]);

    $smarty->display($config["admin_nl_gentemplates"] . "/admin_groups_perm_form.tpl");
    exit;
}

function PermChange() {
    global $dbconn;
    ArrAddSlashes($_POST);

    $id_group = intval($_POST["id_group"]);

    $function = array();
    foreach ($_POST["perm"] as $key => $value) {
        $function[$value] = $_POST["function" . $value];
    }
    if (isset($_POST["perm"])) {
        $strSQL = "DELETE FROM " . GROUP_MODULE_TABLE . " WHERE id_group={$id_group}";
        $dbconn->Execute($strSQL);
        foreach ($_POST["perm"] as $key => $value) {
            if ($value != 0) {
                $strSQL = "INSERT INTO " . GROUP_MODULE_TABLE . " (id_group, id_module) VALUES ({$id_group}, {$value})";
                $dbconn->Execute($strSQL);
            }
        }
    }
    if (isset($function)) {
        $strSQL = "DELETE FROM " . GROUP_FUNCTION_TABLE . " WHERE id_group={$id_group}";
        $dbconn->Execute($strSQL);
        foreach ($function as $key => $value) {
            foreach ($value as $key1 => $value1) {
                if ($value1 != 0) {
                    $strSQL = "INSERT INTO " . GROUP_FUNCTION_TABLE . " (id_group, id_function) VALUES ({$id_group}, {$value1})";
                    $dbconn->Execute($strSQL);
                }
            }
        }
    }

    $strSQL = "DELETE FROM " . GROUPS_PERMISSIONS_TABLE . " WHERE id_group={$id_group}";
    $dbconn->Execute($strSQL);
    foreach ($_POST["perm_count"] as $key => $val) {
        if ($val != 1 || $val != "") {
            $strSQL = "INSERT INTO " . GROUPS_PERMISSIONS_TABLE . " (id_group,id_permission,permission_count) VALUES ({$id_group}," . intval($key) . "," . intval($val) . ")";
            $dbconn->Execute($strSQL);
        }
    }
    echo "<script>window.close();window.opener.focus();</script>";
    exit;
}

function DelGroup($id) {
    global $smarty, $dbconn, $config, $config_admin, $lang;

    $id = intval($id);
    if (!$id) {
        ListGroup();
        return;
    }

    unset($_SESSION['perm']);
    unset($_SESSION['function']);

    $strSQL = "DELETE FROM " . GROUPS_TABLE . " WHERE id={$id}";
    $dbconn->Execute($strSQL);

    $strSQL = "DELETE FROM " . GROUP_MODULE_TABLE . " WHERE id_group={$id}";
    $dbconn->Execute($strSQL);

    $strSQL = "DELETE FROM " . GROUP_PERIOD_TABLE . " WHERE id_group={$id}";
    $dbconn->Execute($strSQL);

    $rs = $dbconn->Execute("SELECT id FROM " . GROUPS_TABLE . " WHERE type='g'");
    $default_group = $rs->fields[0];

    $rs = $dbconn->Execute("SELECT id FROM " . USER_GROUP_TABLE . " WHERE id_group={$id}");
    while (!$rs->EOF) {
        $dbconn->Execute("UPDATE " . USERS_TABLE . " SET status='0' WHERE id={$rs->fields[0]}");
        $dbconn->Execute("UPDATE " . USER_GROUP_TABLE . " SET id_group={$default_group} WHERE id={$rs->fields[0]}");
        $rs->MoveNext();
    }
    return;
}

function UserForm($err = "") {
    global $smarty, $dbconn, $config, $config_admin, $lang, $file_name;

    AdminMainMenu("admin_user");
    @$group = intval($_REQUEST["id_group"]);

    ///////// groups form
    $strSQL = "SELECT DISTINCT a.id, a.name, COUNT(b.id) AS count
					FROM " . GROUPS_TABLE . " a
					LEFT JOIN " . USER_GROUP_TABLE . " b ON b.id_group = a.id
					WHERE a.type='d' || a.type='f'
					GROUP BY a.id ORDER BY a.name";
    $rs = $dbconn->Execute($strSQL);

    $groups = array();
    $i = 0;
    while (!$rs->EOF) {
        $groups[$i]["id"] = $rs->fields[0];
        $groups[$i]["name"] = stripslashes($rs->fields[1]);
        $groups[$i]["count"] = $rs->fields[2];
        $i++;
        $rs->MoveNext();
    }
    $smarty->assign("groups", $groups);

    if ($group) {
        $where_str = "WHERE a.id>0 AND (SELECT id_group FROM " . USER_GROUP_TABLE . " WHERE id_user=a.id)={$group} AND a.id NOT IN (1,2)";
    } else {
        $where_str = "WHERE a.id NOT IN (1,2)";
    }

    $strSQL = "SELECT COUNT(a.id) FROM " . USERS_TABLE . " a {$where_str}";
    $rs = $dbconn->Execute($strSQL);
    $amount = $rs->fields[0];

    ///////// query
    $strSQL = "SELECT a.id, CONCAT(a.fname,' ', a.sname) as name, a.status, a.login, DATE_FORMAT(a.date_registration, '{$config["date_format"]}') AS date_registration, a.login_count, a.root_user, a.guest_user FROM " . USERS_TABLE . " a {$where_str}";
    $rs = $dbconn->Execute($strSQL);
    $i = 0;
    while (!$rs->EOF) {
        $row = $rs->GetRowAssoc(false);
        $data[$i]["id"] = $row["id"];
        $data[$i]["name"] = $row["name"];
        $data[$i]["nick"] = $row["login"];
        $data[$i]["status"] = $row["status"];
        $data[$i]["date_rigistration"] = $row["date_registration"];
        $data[$i]["login_count"] = $row["login_count"];
        $data[$i]["edit_link"] = $file_name . "?sel=adduser&id=" . $data[$i]["id"];
        $rs->MoveNext();
        $i++;
    }
    ArrStripSlashes($data);

    $form["err"] = $err;

    get_smarty_array_list("users_page", $config["group_page"]);
    $smarty->assign("id_group", $group);
    $smarty->assign("amount", $amount);
    $smarty->assign("add_link", $file_name . "?sel=adduser");
    $smarty->assign("data", $data);

    $smarty->display($config["admin_nl_gentemplates"] . "/admin_user_table.tpl");
    exit;
}

function UpdateStatus() {
    global $lang, $config, $dbconn, $auth;

    if ($config["phpversion"] == 4 && strpos($sel, "ajax") !== false) {
        include "./include/class.json.php";
        $json = new Services_JSON();
    }
    $status = "d";
    $data = array();

    if ($_GET["par"] == "cros") {
        $status = 1;
        $data["class"] = "global";
    } else {
        $status = 0;
        $data["class"] = "";
    }
    $id = intval($_GET["id"]);
    $data["id"] = $id;
    $strSQL = "UPDATE " . USERS_TABLE . " SET status='{$status}' WHERE id={$id} and root_user='0' and guest_user='0'";
    $dbconn->Execute($strSQL);
    //header("Content-type:  charset=utf-8");
    if ($config["phpversion"] == 4) {
        echo $json->encode($data);
    } else {
        echo json_encode($data);
    }
    exit;
}

