<?php

class EmailValidator {

	var $emailAddress = '';
	var $emailDomain = '';
	var $senderEmail = '';
	var $connectAddress = '';
	var $hostname = '';

	var $_validateMX = true;
	var $_validateAddress = false;

	function EmailValidator($_email) {
		$this->emailAddress = $_email;
		return;
	}

	function _rfc822_compactible_regexp($_email) {
		$qtext = '[^\\x0d\\x22\\x5c\\x80-\\xff]';
		$dtext = '[^\\x0d\\x5b-\\x5d\\x80-\\xff]';
		$atom = '[^\\x00-\\x20\\x22\\x28\\x29\\x2c\\x2e\\x3a-\\x3c'.
        '\\x3e\\x40\\x5b-\\x5d\\x7f-\\xff]+';
        $quoted_pair = '\\x5c[\\x00-\\x7f]';
        $domain_literal = "\\x5b($dtext|$quoted_pair)*\\x5d";
        $quoted_string = "\\x22($qtext|$quoted_pair)*\\x22";
        $domain_ref = $atom;
        $sub_domain = "($domain_ref|$domain_literal)";
        $word = "($atom|$quoted_string)";
        $domain = "$sub_domain(\\x2e$sub_domain)*";
        $local_part = "$word(\\x2e$word)*";
        $addr_spec = "$local_part\\x40$domain";
        return preg_match("!^$addr_spec$!", $_email) ? 1 : 0;
	}

	function _rfc2822_compactible_regexp($_email) {
		$regexp = "/^(.* )?[<\[]?((?:(?:(?:[a-zA-Z0-9][\.\-\+_]?)*)[a-zA-Z0-9])+)\@(((?:(?:(?:[a-zA-Z0-9][\.\-_]?){0,62})[a-zA-Z0-9])+)\.([a-zA-Z0-9]{2,6}))[>\]]?$/";
		if (preg_match($regexp, $_email, $_matches)) {
			$this->emailAddress = $_matches[2] . '@' . $_matches[3];
			$this->emailDomain = $_matches[3];
			return true;
		} else {
			return false;
		}
	}

	function _validateRegexp() {
		$fchk = explode('@', $this->emailAddress);
		if (!isset($fchk[1])) {
			return false;
		}
		$this->emailDomain = $fchk[1];
		if (preg_match('/^[0-9]{1,3}[\.]{1,1}[0-9]{1,3}[\.]{1,1}[0-9]{1,3}[\.]{1,1}[0-9]{1,3}$/', $fchk[1])) {
			$regexIP = '(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])';
			if (preg_match("/^$regexIP\\.$regexIP\\.$regexIP\\.$regexIP$/", $fchk[1])) {
				return true;
			}
		} else {
			if ($this->_rfc822_compactible_regexp($this->emailAddress)) {
				return true;
			}
			if ($this->_rfc2822_compactible_regexp($this->emailAddress)) {
				return true;
			}
		}
		return false;
	}

	function _validateMxDns() {
		if (getmxrr($this->emailDomain, $mxHost, $weights)) {
			$this->connectAddress = $mxHost[0];
			return true;
		} else {
			$host = $this->emailDomain;
			if (checkdnsrr($host, 'MX')) { // or 'ANY'
				$this->connectAddress = $this->emailDomain;
				return true;
			}
		}
		return false;
	}

	// return level of email check
	function returnValidatedEmailStatus() {
		$level = -1;
		if ($this->_validateRegexp()) {
			$level = 1;
			if ($this->_validateMX == true) {
				if ($this->_validateMxDns()) {
					$level = 2;
				}
			}
		}
		return $level;
	}
}

// support windows platforms
if (!function_exists ('getmxrr') ) {
	function getmxrr($hostname, $mxhosts, $mxweight) {
		if (!is_array ($mxhosts) ) {
			$mxhosts = array ();
		}
		if (!empty ($hostname) ) {
			$output = "";
			@exec ("nslookup.exe -type=MX " . escapeshellarg($hostname), $output);
			$imx=-1;

			foreach ($output as $line) {
				$parts = "";
				if (preg_match ("/^$hostname\tMX preference = ([0-9]+), mail exchanger = (.*)$/", $line, $parts) ) {
					$imx++;
					$mxweight[$imx] = $parts[1];
					$mxhosts[$imx] = $parts[2];
				}
			}
			return ($imx!=-1);
		}
		return false;
	}
}

if (!function_exists('checkdnsrr')) {
	function checkdnsrr($hostName, $recType = 'MX')	{
		if(!empty($hostName)) {
			exec("nslookup.exe -type=$recType " . escapeshellarg($hostName), $result);
			// check each line to find the one that starts with the host
			// name. If it exists then the function succeeded.
			foreach ($result as $line) {
				if(eregi("^$hostName",$line)) {
					return true;
				}
			}
		}
		return false;
	}
}

?>