<?php

include_once "class.settings_manager.php";

function AdminMainMenu($header) {
    global $smarty, $lang, $auth, $dbconn, $config;
    RefreshAccount();

    $str_sql = "SELECT value, name FROM " . USER_SETTINGS_TABLE . " WHERE id_user={$auth["id"]} AND name IN ('type_dispatch', 'is_tips')";
    $rs = $dbconn->Execute($str_sql);
    while (!$rs->EOF) {
        $row = $rs->GetRowAssoc(false);
        $settings[$row["name"]] = $row["value"];
        $rs->MoveNext();
    }
    $config["type_dispatch"] = $settings["type_dispatch"] ? $settings["type_dispatch"] : "smtp";
    $_SESSION["is_tips"] = $settings["is_tips"] ? $settings["is_tips"] : "1";
    $config["this"] = $_SERVER["PHP_SELF"];
    GenerateMenu();

    $langs = getActiveLangs();
    $smarty->assign("langs_link", $langs);
    $smarty->assign('header', $lang[$header]);
    //foreach ($lang["button"] as $val) $val = "  ".$val."  ";
    $smarty->assign('button', $lang["button"]);
    $smarty->assign('help', $lang["admin_help"]);
    $smarty->assign('err', $lang["err"]);
    $smarty->assign('common', $lang["common"]);
    return $lang[$header];
}

function MainMenu($header) {
    global $smarty, $lang, $auth, $dbconn, $config;

    $langs = getActiveLangs();
    $smarty->assign("langs_link", $langs);
    $smarty->assign('header', $lang[$header]);
    $smarty->assign('button', $lang["button"]);
    $smarty->assign('help', $lang["admin_help"]);
    $smarty->assign('err', $lang["err"]);
    $smarty->assign('common', $lang["common"]);
    return $lang[$header];
}

function getActiveLangs() {
    global $dbconn;

    $rs = $dbconn->Execute("SELECT id, name, code FROM " . LANGUAGE_TABLE . " WHERE visible='1'");
    $i = 0;
    $count = $rs->RowCount();
    while (!$rs->EOF) {
        $lang_link[$i]["code"] = $rs->fields[2];
        $lang_link[$i]["name"] = ucfirst($rs->fields[1]);
        $lang_link[$i]["count"] = $count;
        $query = $_SERVER["QUERY_STRING"];

        if ($query) {
            $query_arr = array();
            $new_query_arr = array();
            $query_arr = explode("&", $query);
            foreach ($query_arr as $k => $v) {
                $s = explode("=", $v);
                if (trim($s[0] != "language_code"))
                    array_push($new_query_arr, $v);
            }
            $query = implode("&", $new_query_arr);
        }
        if (strlen($query) > 0)
            $query .= "&";
        $lang_link[$i]["link"] = "?" . $query . "language_code=" . $rs->fields[0];
        $rs->MoveNext();
        $i++;
    }
    return $lang_link;
}

function AfterLastSlash($str) {
    $arr = explode("/", $str);
    return $arr[count($arr) - 1];
}

function CheckInstallFolder($smarty) {
    global $config;

    $dh = opendir($config["site_path"]);
    while (($entry = readdir($dh)) !== false) {
        if (is_dir($config["site_path"] . "/" . $entry) && (strstr($entry, "install") || strstr($entry, "instal") || strstr($entry, "inst") || strstr($entry, "distrib"))) {
            $smarty->assign("folder", $entry);
            $smarty->assign("str", "install, instal, inst, distrib");
            $smarty->display($config["admin_nl_gentemplates"] . "/install_folder_error.tpl");
            exit;
        }
    }
    closedir($dh);
    return;
}

function get_smarty_array_list($control, $arr) {
    global $smarty;

    $smarty->assign(array(
        $control . "_values" => array_keys($arr),
        $control . "_output" => $arr
    ));
}

function create_navigation($jobs_total, $user_page, $params, $script_name, $p, $who = "user_page") {
    global $dbconn, $config;

    $per_page = $config[$who][$user_page];
    $pages_total = ceil($jobs_total / $per_page);
    $page_start = ($p < 9) ? 1 : $p - 4;
    $page_stop = ($pages_total > $page_start + 9) ? $page_start + 9 : $pages_total;

    $job_start = ($jobs_total == 0) ? 0 : $p * $per_page + 1;
    $job_stop = ($p + 1) * $per_page;
    if ($job_stop > $jobs_total) {
        $job_stop = $jobs_total;
    }

    $nav_arr = array();
    if ($p > 0) {
        $nav_arr[] = "<a href=\"$script_name?p=0$params\">&lt;&lt;</a>";
        $nav_arr[] = "<a href=\"$script_name?p=" . ($p - 1) . "&$params\">&lt;</a>";
    }

    if ($pages_total > 1) {
        for ($i = $page_start; $i <= $page_stop; $i++) {
            if ($i == ($p + 1)) {
                $nav_arr[] = "<b>[$i]</b>";
            } else {
                $nav_arr[] = "<a href=\"$script_name?p=" . ($i - 1) . "$params\">$i</a>";
            }
        }
    }

    if ($p < $pages_total - 1) {
        $nav_arr[] = "<a href=\"$script_name?p=" . ($p + 1) . "$params\">&gt;</a>";
        $nav_arr[] = "<a href=\"$script_name?p=" . ($pages_total - 1) . "$params\">&gt;&gt;</a>";
    }

    $navigation = join("&nbsp;|&nbsp;", $nav_arr);

    return $navigation;
}

function file_size($file) {
    $kb = 1024;         // Kilobyte
    $mb = 1024 * $kb;   // Megabyte
    $gb = 1024 * $mb;   // Gigabyte
    $tb = 1024 * $gb;   // Terabyte

    if (file_exists($file)) {
        $size = filesize($file);

        if ($size < $kb) {
            return $size . " B";
        } else if ($size < $mb) {
            return round($size / $kb, 2) . " KB";
        } else if ($size < $gb) {
            return round($size / $mb, 2) . " MB";
        } else if ($size < $tb) {
            return round($size / $gb, 2) . " GB";
        } else {
            return round($size / $tb, 2) . " TB";
        }
    } else {
        return "0 B";
    }
}

function delete_dir($file) {
    chmod($file, 0777);
    if (is_dir($file)) {
        $handle = opendir($file);
        while ($filename = readdir($handle)) {
            if ($filename != "." && $filename != "..")
                delete_dir($file . "/" . $filename);
        }
        closedir($handle);
        rmdir($file);
    }
    else
        unlink($file);
}

function str_prepare($s) {
    return addslashes(trim($s));
}

function SendAlert($alert_name, $data, $to_email, $to_name = "", $id_user = 1, $admin_id = 1) {
    global $config, $dbconn, $auth;
    include_once "newsletters_function.php";

    if (!$id_user) {
        $id_user = $auth["id"];
    }
    if (!$auth["lang"]) {
        $auth["lang"] = 1;
    }
    $settings_manager = new SettingsManager();
    $lang_file = $settings_manager->LangFileById($auth["lang"]);

    if (isset($_SESSION)) {
        unset($_SESSION['newsletter_data']);
        unset($_SESSION['send_settings']);
        unset($_SESSION['smtp_data']);
    }

    //Send
    require_once "swift/Swift.php";
    require_once "swift/Swift/Connection/Multi.php";
    $settings = GetUserSettings(array('from_name', 'from_email'), $id_user);

    $admin_settings = GetUserSettings(array('type_dispatch'), $admin_id);
    
    switch ($admin_settings["type_dispatch"]) {
        case "smtp":
            require_once "swift/Swift/Connection/SMTP.php";
            $smtp_info = GetSmtpInfo($admin_id);
            $connections = array();

            foreach ($smtp_info as $key => $value) {
                switch ($value["use_encrypt"]) {
                    case "no":
                        $enctype = SWIFT_SMTP_ENC_OFF;
                        break;
                    case "tls":
                        $enctype = SWIFT_SMTP_ENC_TLS;
                        break;
                    case "ssl":
                        $enctype = SWIFT_SMTP_ENC_SSL;
                        break;
                }

                $conn = new Swift_Connection_SMTP($value["host"], $value["port"], $enctype);

                if ($value["use_auth"]) {
                    if ($value["use_popb4smtp"]) {
                        require_once "swift/Swift/Authenticator/@PopB4Smtp.php";
                        $conn->attachAuthenticator(new Swift_Authenticator_PopB4Smtp(str_replace("smtp.", "pop.", strtolower($value["host"]))));
                    }
                    $conn->setUsername($value["login"]);
                    $conn->setpassword($value["password"]);
                }
                $connections[] = $conn;
            }
            $swift = new Swift(new Swift_Connection_Multi($connections));

            break;
        case "mail":
            require_once "swift/Swift/Connection/NativeMail.php";
            $swift = new Swift(new Swift_Connection_NativeMail());
            break;
        case "sendmail":
            require_once "swift/Swift/Connection/Sendmail.php";
            $swift = new Swift(new Swift_Connection_Sendmail());
            break;
        default:
            require_once "swift/Swift/Connection/NativeMail.php";
            $swift = new Swift(new Swift_Connection_NativeMail());
    }

    $message = new Swift_Message('123');
    $param = array('company_name','from_name','from_email');
    $settings = GetUserSettings($param, 1);
    $data['company_name'] = isset($settings['company_name']) ? $settings['company_name'] : 'PG Newsletter';
    $data['year'] = date('Y');
    
    if ($alert_name != "" && $alert_name != "forward") {
        // Sending alert
        //Lang load
        $mail_content = array();
        include_once $config["path_lang"] . "mail/" . basename($lang_file, ".lang") . "/{$alert_name}.lang";
        GetMailContentReplace($mail_content, $data);
        $message->setSubject($mail_content["subject"]);
        $message->attach(new Swift_Message_Part($mail_content["content"]));
    } elseif ($alert_name != "forward") {
        // Sending mail(confirmation and ....)
        $mail_content = array();
        $mail_content["subject"] = $data["subject"];
        $mail_content["content"] = $data["content"];
        $message->setSubject($mail_content["subject"]);
        $message->attach(new Swift_Message_Part($mail_content["content"]));
    } else {
        $mail_content = array();
        // Sending newsletter
        $strSQL = "INSERT INTO " . SEND_NEWSLETTERS_TABLE . " (id_newsletter, id_user, date_send,count_all,count_sent, status) VALUES({$data["id_newsletter"]}, {$id_user}, NOW(),1,1,2)";
        $dbconn->Execute($strSQL);
        $id_newsletter = $dbconn->Insert_ID();

        $newsletter_data = GetNewsletterInfo($id_newsletter, $message, $id_user, 0);

        $search = array("%BASIC:EMAIL%", "%BASIC:FIRSTNAME%", "%BASIC:SECONDNAME%", "%BASIC:UNSUBLINK%", "%BASIC:TELLFREND%", "%BASIC:WEBVERSION%");
        $replace = array("", "", "", "", "", "");
        $newsletter_data["body_text"] = str_replace($search, $replace, $newsletter_data["body_text"]);
        $newsletter_data["body"] = str_replace($search, $replace, $newsletter_data["body"]);

        $mail_content["subject"] = $newsletter_data["subject"];

        if ($data["subject"] && $data["subject"] != "")
            $mail_content["subject"] = $data["subject"];

        $message->setSubject($mail_content["subject"]);
        if ($newsletter_data["format"] == "htmltext") {
            $message->attach(new Swift_Message_Part($newsletter_data["body_text"]));
            $message->attach(new Swift_Message_Part($newsletter_data["body"], "text/html"));
        } elseif ($newsletter_data["format"] == "html") {
            $message->attach(new Swift_Message_Part($newsletter_data["body"], "text/html"));
        } elseif ($newsletter_data["format"] == "text") {
            $message->attach(new Swift_Message_Part($newsletter_data["body_text"]));
        }

        $strSQL = "DELETE FROM " . SEND_NEWSLETTERS_TABLE . " WHERE id={$id_newsletter}";
        $dbconn->Execute($strSQL);
    }
    
    $message->setCharset("utf-8");
    $message->setFrom(new Swift_Address($settings["from_email"], $settings["from_name"]));

    $error = $swift->send($message, new Swift_Address($to_email, $to_name), $settings["from_email"]);

    if (!$error) {
        //error
        $error = 1;
    } else {
        $error = 0;
    }

    $swift->disconnect();
    return $error;
}

function CheckResponse($id_subscriber, $list, $to_email, $to_name = "", $id_user = 1) {
    global $config, $dbconn, $auth;

    $strSQL = "SELECT a.id,al.id_list FROM " . AUTORESPONDER_TABLE . " a
					INNER JOIN " . AUTORESPONDER_LIST_TABLE . " al ON al.id_list IN (" . implode(",", $list) . ") AND al.id_autoresponder = a.id
					WHERE a.status=1 AND a.period='0' AND a.id_user={$id_user}";
    $rs = $dbconn->Execute($strSQL);
    while (!$rs->EOF) {
        $id = intval($rs->fields[0]);
        $data = array();
        $data["id_list"] = intval($rs->fields[1]);
        $data["id_subscriber"] = $id_subscriber;
        SendResponse($data, $id, $to_email, $to_name = "", $id_user);
        $rs->MoveNext();
    }
}

function SendResponse($data, $id, $to_email, $to_name = "", $id_user = 1) {
    global $config, $dbconn, $auth;
    include_once "newsletters_function.php";
    //Send
    require_once "swift/Swift.php";
    require_once "swift/Swift/Connection/Multi.php";
    $settings = GetUserSettings(array('from_name', 'from_email', 'type_dispatch'), $id_user);
    switch ($settings["type_dispatch"]) {
        case "smtp":
            require_once "swift/Swift/Connection/SMTP.php";
            $smtp_info = GetSmtpInfo($id_user);
            $connections = array();

            foreach ($smtp_info as $key => $value) {
                switch ($value["use_encrypt"]) {
                    case "no":
                        $enctype = SWIFT_SMTP_ENC_OFF;
                        break;
                    case "tls":
                        $enctype = SWIFT_SMTP_ENC_TLS;
                        break;
                    case "ssl":
                        $enctype = SWIFT_SMTP_ENC_SSL;
                        break;
                }
                $conn = new Swift_Connection_SMTP($value["host"], $value["port"], $enctype);

                if ($value["use_auth"]) {
                    if ($value["use_popb4smtp"]) {
                        require_once "swift/Swift/Authenticator/@PopB4Smtp.php";
                        $conn->attachAuthenticator(new Swift_Authenticator_PopB4Smtp(str_replace("smtp.", "pop.", strtolower($value["host"]))));
                    }
                    $conn->setUsername($value["login"]);
                    $conn->setpassword($value["password"]);
                }
                $connections[] = $conn;
            }
            $swift = new Swift(new Swift_Connection_Multi($connections));

            break;
        case "mail":
            require_once "swift/Swift/Connection/NativeMail.php";
            $swift = new Swift(new Swift_Connection_NativeMail());
            break;
        case "sendmail":
            require_once "swift/Swift/Connection/Sendmail.php";
            $swift = new Swift(new Swift_Connection_Sendmail());
            break;
        default:
            require_once "swift/Swift/Connection/NativeMail.php";
            $swift = new Swift(new Swift_Connection_NativeMail());
    }
    $message = new Swift_Message('123');

    $strSQL = "SELECT id FROM " . SEND_NEWSLETTERS_TABLE . " WHERE id_newsletter={$id} AND id_user={$id_user} AND is_responder=1";
    $rs = $dbconn->Execute($strSQL);
    if (!$rs || !$rs->fields[0]) {
        $strSQL = "INSERT INTO " . SEND_NEWSLETTERS_TABLE . " (id_newsletter, id_user, date_send, status,is_responder) VALUES({$id}, {$id_user}, NOW(),1,1)";
        $dbconn->Execute($strSQL);
        $id_newsletter = $dbconn->Insert_ID();
        $data["id_newsletter"] = $id_newsletter;
    } else {
        $id_newsletter = $rs->fields[0];
        $data["id_newsletter"] = $id_newsletter;
    }

    $newsletter_data = GetNewsletterInfo($id_newsletter, $message, $id_user, 0, 1);

    AddSubscriberAndPerson($data, $id_newsletter, $swift, $id_user, $newsletter_data);
    ChangeLink($newsletter_data["body"], $data, $id_user = 1, $newsletter_data["id"]);

    $message->setSubject($newsletter_data["subject"]);
    if ($newsletter_data["format"] == "htmltext") {
        $message->attach(new Swift_Message_Part($newsletter_data["body_text"]));
        $message->attach(new Swift_Message_Part($newsletter_data["body"], "text/html"));
    } elseif ($newsletter_data["format"] == "html") {
        $message->attach(new Swift_Message_Part($newsletter_data["body"], "text/html"));
    } elseif ($newsletter_data["format"] == "text") {
        $message->attach(new Swift_Message_Part($newsletter_data["body_text"]));
    }

    $message->setCharset("utf-8");
    $message->setFrom(new Swift_Address($settings["from_email"], $settings["from_name"]));

    if (!$swift->send($message, new Swift_Address($to_email, $to_name), $settings["from_email"])) {
        //error
        $data["error"] = 1;
    } else {
        $data["error"] = 0;
    }
    SetStatisticsResponder($data, $id_user);
    $swift->disconnect();
    //$total_send = MakeQueue($id_newsletter, $_POST, $list, 0);
}

function GetMailContentReplace($mail_content, $data) {
    foreach ($mail_content as $k => $value) {
        foreach ($data as $key => $val) {
            $mail_content[$k] = stripslashes($mail_content[$k]);
            $mail_content[$k] = str_replace("&#039;", "'", $mail_content[$k]);
            $mail_content[$k] = str_replace("[{$key}]", $val, $mail_content[$k]);
        }
    }
    return $mail_content;
}

function GetUserName($id = 1) {
    global $dbconn;

    $strSQL = "SELECT CONCAT(fname,' ',sname) FROM " . USERS_TABLE . " WHERE id={$id}";
    $rs = $dbconn->Execute($strSQL);
    return $rs->fields[0];
}

function GetUserEmail($id = 1) {
    global $dbconn;

    $strSQL = "SELECT email FROM " . USERS_TABLE . " WHERE id={$id}";
    $rs = $dbconn->Execute($strSQL);
    return $rs->fields[0];
}

function GetSubscriberName($id = 1) {
    global $dbconn;

    $strSQL = "SELECT CONCAT(firstname,' ',secondname) FROM " . SEND_USERS_TABLE . " WHERE id={$id}";
    $rs = $dbconn->Execute($strSQL);
    return stripslashes($rs->fields[0]);
}

function GetSubscriberEmail($id = 1) {
    global $dbconn;

    $strSQL = "SELECT email1 FROM " . SEND_USERS_TABLE . " WHERE id={$id}";
    $rs = $dbconn->Execute($strSQL);
    return stripslashes($rs->fields[0]);
}

function GetServiceName($id = 1) {
    global $dbconn, $lang;

    $strSQL = "SELECT type,amount,period FROM " . GROUP_PERIOD_TABLE . " WHERE id={$id}";
    $rs = $dbconn->Execute($strSQL);
    $row = $rs->GetRowAssoc(false);
    if ($row["type"] == "3") {
        $tmp_amount = explode("|", $row["amount"]);
        $tmp_period = explode("|", $row["period"]);
        $product_name = $tmp_amount[0] . " " . $lang["pays"]["periods"][$tmp_period[0]] . ", ";
        $product_name .= $tmp_amount[1] . " " . $lang["pays"]["periods"][$tmp_period[1]];
    } else {
        $product_name = $row["amount"] . " " . $lang["pays"]["periods"][$row["period"]];
    }

    return $product_name;
}

function GetListName($id_list) {
    global $dbconn;

    $strSQL = "SELECT name FROM " . LISTS_TABLE . " WHERE id IN (" . implode(",", $id_list) . ")";
    $rs = $dbconn->Execute($strSQL);
    $list = array();
    if ($rs) {
        while (!$rs->EOF) {
            $list[] = $rs->fields[0];
            $rs->MoveNext();
        }
    }
    return implode(", ", $list);
}

function GetNewsletterName($id, $is_response = 0) {
    global $dbconn;

    if (!$is_response) {
        $strSQL = "SELECT subject FROM " . CRELEASES_TABLE . " WHERE id={$id}";
    } else {
        $strSQL = "SELECT subject FROM " . AUTORESPONDER_TABLE . " WHERE id={$id}";
    }
    $rs = $dbconn->Execute($strSQL);
    return $rs->fields[0];
}

function GetUserAttr($form_class, $uid) {
    global $lang;
    $user_attrs = array();
    $count = 0;
    $attrs = $form_class->getAllAttributes($count);
    $str = "";
    foreach ($attrs as $index => $attr) {
        $temp = $form_class->getUserAttribute(intval($uid), $attr['id'], true);

        if ($temp === false)
            continue;
        if ($attr["control_type"] == 'checkbox') {
            $value = ($temp == "1") ? $lang["common"]["yes"] : $lang["common"]["no"];
        } else {
            $value = $temp;
        }
        if (isset($value) && $value != "")
            $str .= "{$attr["field_name"]}: {$value}\n";
    }

    return $str;
}

function encode($String, $Password) {
    $Salt = 'BGuxLWQtKweKEMV4';
    $StrLen = strlen($String);
    $Seq = $Password;
    $Gamma = '';
    while (strlen($Gamma) < $StrLen) {
        $Seq = pack("H*", sha1($Gamma . $Seq . $Salt));
        $Gamma.=substr($Seq, 0, 8);
    }

    return $String ^ $Gamma;
}

function TrialP() {
    global $dbconn;

    if (DEMO_MODE) {
        $ssap = md5("keW*3!V7#6NFu@3wC");

        $settings_manager = new SettingsManager();
        $trial_p = intval(encode(stripslashes($settings_manager->GetSiteSettings("trial_period")), $ssap));

        if ($trial_p > 0) {
            //Send
            $data = array();
            $data["trial_period"] = addslashes(encode(strval($trial_p - 1), $ssap));
            $settings_manager->SaveSiteSettings($data);
        } else {
            $data["error"] = 1;
            $data["email"] = "Trial period is end.";

            //header("Content-type: charset=utf-8");
            if ($config["phpversion"] == 4) {
                include_once "class.json.php";
                $json = new Services_JSON();
                echo $json->encode($data);
            } else {
                echo json_encode($data);
            }
            exit;
        }
    }
}

function GetAlertStatus($alert_name) {
    global $dbconn;

    $strSQL = "SELECT IF (unsubscribe_possible,1,0) FROM " . SYSTEM_LETTERS_TABLE . " WHERE name='{$alert_name}'";
    $rs = $dbconn->Execute($strSQL);
    return intval($rs->fields[0]);
}

function GetUserSettings($set_arr = "", $id = 0) {
    global $dbconn, $smarty, $lang, $config, $auth;
    $settings = array();
    // array
    if ($id == 0)
        $id = $auth["id"];
    if ($set_arr != "" && is_array($set_arr) && count($set_arr) > 0) {
        foreach ($set_arr as $key => $set_name) {
            $set_arr[$key] = "'" . $set_name . "'";
        }
        $sett_string = implode(", ", $set_arr);
        $str_sql = "SELECT value, name FROM " . USER_SETTINGS_TABLE . " WHERE id_user={$id} AND name IN ({$sett_string})";
        $rs = $dbconn->Execute($str_sql);
        while (!$rs->EOF) {
            $row = $rs->GetRowAssoc(false);
            $settings[$row["name"]] = $row["value"];
            $rs->MoveNext();
        }
    } elseif (strlen($set_arr) > 0) {
        $str_sql = "SELECT value, name FROM " . USER_SETTINGS_TABLE . " WHERE id_user={$id} AND name = '" . strval($set_arr) . "'";
        $rs = $dbconn->Execute($str_sql);
        $row = $rs->GetRowAssoc(false);
        $settings = $row["value"];
    } elseif (strval($set_arr) == "") {
        $str_sql = "SELECT value, name FROM " . USER_SETTINGS_TABLE . " id_user={$id} ORDER BY id";
        $rs = $dbconn->Execute($str_sql);
        while (!$rs->EOF) {
            $row = $rs->GetRowAssoc(false);
            $settings[$row["name"]] = $row["value"];
            $rs->MoveNext();
        }
    }
    return $settings;
}

////////////////// Permission function ////////////////////////
function GetAllPermissionsUser($id_user) {
    global $dbconn;
    $perm = array();
    $strSQL = "SELECT c.name FROM " . USER_GROUP_TABLE . " b
					LEFT JOIN " . GROUP_MODULE_TABLE . " a ON b.id_group=a.id_group
					LEFT JOIN " . MODULES_TABLE . " c ON c.id=a.id_module
					WHERE b.id_user={$id_user}";
    $rs = $dbconn->Execute($strSQL);
    while (!$rs->EOF) {
        array_push($perm, $rs->fields[0]);
        $rs->MoveNext();
    }

    $strSQL = "SELECT c.name FROM " . USER_GROUP_TABLE . " b, " . GROUP_FUNCTION_TABLE . " a
					LEFT JOIN " . FUNCTIONS_TABLE . " c ON c.id=a.id_function
					WHERE b.id_user={$id_user} AND b.id_group=a.id_group";
    $rs = $dbconn->Execute($strSQL);
    while (!$rs->EOF) {
        array_push($perm, $rs->fields[0]);
        $rs->MoveNext();
    }
    return $perm;
}

function GetPermissionsUser($id_user) {
    global $dbconn;
    $strSQL = "SELECT DISTINCT a.id_module FROM " . GROUP_MODULE_TABLE . " a, " . USER_GROUP_TABLE . " b
					WHERE b.id_user={$id_user} AND b.id_group=a.id_group ";
    $rs = $dbconn->Execute($strSQL);
    $i = 0;
    while (!$rs->EOF) {
        $module["id"][$i] = $rs->fields[0];
        $rs->MoveNext();
        $i++;
    }
    return $module;
}

function IsFileAllowed($id_user, $file) {
    global $dbconn, $config, $smarty;

    $smarty->assign("is_admin", ($id_user == 1) ? 1 : 0);
    $mod_arr = array();
    $mod_arr = GetPermissionsUser($id_user);

    $strSQL = "SELECT id_module FROM " . MODULE_FILE_TABLE . " WHERE file='{$file}' ";
    $rs = $dbconn->Execute($strSQL);
    $id_module = $rs->fields[0];

    if (is_array($mod_arr["id"]) && in_array($id_module, $mod_arr["id"])) {
        return "1";    ////// full mode
    } else {
        header("location: " . $config["server"] . "/index.php?err=1");
        exit;
    }
}

function GetPermFuncUser($id_user) {
    global $dbconn;
    $strSQL = "SELECT distinct a.id_function FROM " . GROUP_FUNCTION_TABLE . " a, " . USER_GROUP_TABLE . " b
					WHERE b.id_user={$id_user} AND b.id_group=a.id_group ";
    $rs = $dbconn->Execute($strSQL);
    $i = 0;
    while (!$rs->EOF) {
        $function["id"][$i] = $rs->fields[0];
        $rs->MoveNext();
        $i++;
    }
    return $function;
}

function GetValuePermUser($id_user, $id_permition) {
    global $dbconn;
    $strSQL = "SELECT DISTINCT a.permission_count, a.id_permission FROM " . GROUPS_PERMISSIONS_TABLE . " a, " . USER_GROUP_TABLE . " b
					WHERE b.id_user={$id_user} AND b.id_group=a.id_group AND id_permission={$id_permition}";
    $rs = $dbconn->Execute($strSQL);
    $row = $rs->GetRowAssoc(false);
    /* $perm["id"] = $row["id_permission"]; */
    /* $perm["value"] = $row["permission_count"]; */
    return $row["permission_count"];
}

function IsFunctionAllowed($id_user, $id_function) {
    global $dbconn, $config;

    $mod_arr = array();
    $mod_arr = GetPermFuncUser($id_user);

    if (is_array($mod_arr["id"]) && in_array($id_function, $mod_arr["id"])) {
        return 1;    ////// full mode
    } else {
        return 0;
    }
}

function GetRightModulePath($file) {
    global $config;
    $file_name = substr($file, strlen($config["site_path"]));
    $file_name = str_replace("\\", "/", $file_name);
    if (substr($file_name, 0, 1) != "/")
        $file_name = "/" . $file_name;
    return $file_name;
}

function PermissionError($err = "") {
    global $dbconn, $smarty, $config, $lang, $file_name;

    $file_name = "index.php";
    MainMenu("index");

    sess_delete(session_id());
    $cookie = $_COOKIE;
    if (isset($cookie["login"])) {
        $data["login"] = $cookie["login"];
        $data["pass"] = $cookie["pass"];
    }
    $file_name = "index.php";

    if ($err) {
        $form["err"] = $err;
        $data["login"] = $_POST["login"];
    }

    $form["action"] = $file_name;
    if (isset($data)) {
        $smarty->assign("data", $data);
    }

    $strSQL = " SELECT id, name, type FROM " . GROUPS_TABLE . " WHERE id NOT IN (1,2) ORDER BY name";
    $rs = $dbconn->Execute($strSQL);
    $i = 0;
    $amount = $rs->RowCount();
    if ($amount > 0) {
        while (!$rs->EOF) {
            $group_arr[$i]["id"] = $rs->fields[0];
            $group_arr[$i]["type"] = $rs->fields[2];
            $group_arr[$i]["name"] = strval($rs->fields[1]);
            $group_arr[$i]["type_name"] = $lang["groups"]["types"][strval($rs->fields[2])];
            $group_arr[$i]["editlink"] = $file_name . "?sel=add&id=" . $rs->fields[0];
            $group_arr[$i]["userlink"] = $file_name . "?sel=user&id_group=" . $rs->fields[0];
            $group_arr[$i]["permlink"] = $file_name . "?sel=perm&id=" . $rs->fields[0];
            $group_arr[$i]["dellink"] = $file_name . "?sel=del&id=" . $rs->fields[0];
            $group_arr[$i]["create_footer"] = $file_name . "?sel=create_footer&id=" . $rs->fields[0];
            $rs->MoveNext();
            $i++;
        }
        ArrStripSlashes($group_arr);
        get_smarty_array_list("group_page", $config["group_page"]);
        $smarty->assign("amount", $amount);
    } else {
        $smarty->assign("empty_row", "1");
    }

    $smarty->assign("group_arr", $group_arr);

    $smarty->assign("form", $form);
    $smarty->assign("page_type", "login");
    $smarty->assign("button", $lang["button"]);
    $smarty->assign("jquery", 1);
    $langs = getActiveLangs();
    $smarty->display($config["admin_nl_gentemplates"] . "/login_registration_form.tpl");
    exit;
}

function FormFilter($str) {
    return strip_tags(trim(strval($str)));
}

function SubscriberInfo($id) {
    global $dbconn;

    $strSQL = "SELECT id,firstname,secondname,email1 FROM " . SEND_USERS_TABLE . " WHERE id=" . $id;
    $rs = $dbconn->Execute($strSQL);
    $row = $rs->GetRowAssoc(false);
    $user_attrs["id"] = $row["id"];
    $user_attrs["firstname"] = $row["firstname"];
    $user_attrs["secondname"] = $row["secondname"];
    $user_attrs["email"] = $row["email1"];

    return $user_attrs;
}

function RefreshAccount() {
    global $dbconn, $config, $smarty, $auth, $lang;

    $settings_manager = new SettingsManager();
    $settings = $settings_manager->GetSiteSettings(array('site_unit_costunit'));
    $id_user = $auth["id"];
    $type = $auth["type"];
    $strSQL = "SELECT email FROM " . USERS_TABLE . " WHERE id={$id_user}";
    $rs = $dbconn->Execute($strSQL);
    $to_email = $rs->fields[0];
    
    if (!$auth["root"] && !$auth["guest"]) {
        /* if($type==0){
          $dbconn->Execute("UPDATE ".USERS_TABLE." SET login_count=login_count+1 WHERE id={$id_user}");
          }else{ */
        $strSQL = "SELECT a.email, b.period, b.type FROM " . BILLING_USER_PERIOD_TABLE . " a, " . GROUP_PERIOD_TABLE . " b WHERE a.id_user={$id_user} AND a.id_group_period=b.id";
        $rs = $dbconn->Execute($strSQL);
        $row = $rs->GetRowAssoc(false);
        
        $email = floor($row["email"]);
        $period = $row["period"];
        $period_type = $row["type"];
        $strSQL = "SELECT a.type, a.id, a.name FROM " . USER_GROUP_TABLE . " b, " . GROUPS_TABLE . " a WHERE b.id_user={$id_user} AND b.id_group=a.id GROUP BY a.id";
        $rs = $dbconn->Execute($strSQL);

        $group_type = $rs->fields[0];
        $group_id = $rs->fields[1];
        $group_name = $rs->fields[2];
        
        $smarty->assign("account_group_text", $group_name ? sprintf($lang['setup']['account_group_text'], $group_name) : '');
        $smarty->assign("account_letters_text", $email > 0 ? sprintf($lang['setup']['account_letters_text'], $email) : '');
        
        if ($period_type) {
            if ($period_type == 1) {
                $strSQL = "SELECT DATEDIFF(a.date_end, NOW()) AS now_res, b.cost FROM " . BILLING_USER_PERIOD_TABLE . "  AS a LEFT JOIN " . GROUP_PERIOD_TABLE . " AS b ON b.id = a.id_group_period  WHERE a.id_user={$id_user}";
                $rs = $dbconn->Execute($strSQL);
                $row = $rs->GetRowAssoc(false);
                $now_rest = $row["now_res"];
                $cost = $row["cost"];
                $smarty->assign("account_days_text", sprintf($lang['setup']['account_days_text'], $now_rest > 0 ? $now_rest : 0));
                if ($now_rest <= 0) {
                    if ($group_type != "g") { //// delete user from group and add to 'g' groups
                        $d_arr = array();
                        $rs = $dbconn->Execute("SELECT id FROM " . GROUPS_TABLE . " WHERE type='g' ");
                        while (!$rs->EOF) {
                            array_push($d_arr, " ( '" . $id_user . "', '" . $rs->fields[0] . "')");  //// add in 'g' groups
                            $rs->MoveNext();
                        }
                        $insert_str = implode(", ", $d_arr);
                        if (strlen($insert_str) > 0) {
                            $dbconn->Execute("DELETE FROM " . USER_GROUP_TABLE . " WHERE id_user={$id_user}");
                            $dbconn->Execute("DELETE FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$id_user}");
                            $rs = $dbconn->Execute("INSERT INTO  " . USER_GROUP_TABLE . " (id_user, id_group) VALUES {$insert_str}");
                        }
                    }
                    $new_account = 0;
                } elseif ($now_rest <= 1) {
                    if ($_REQUEST['authorized']) {
                        if (GetAlertStatus("mail_membership_end_by_am")) {
                            // Alert moderu o membership ends
                            $data_ = array();
                            $data_["name"] = GetUserName($id_user);
                            $data_["link"] = $config["server"] . "/index.php";
                            SendAlert("mail_membership_end_by_am", $data_, $to_email, $data_["name"], 1);
                        }
                    }
                }
            } elseif ($period_type == 2) {
                $strSQL = "SELECT DATEDIFF(a.date_end, NOW()) AS now_res, b.cost FROM " . BILLING_USER_PERIOD_TABLE . "  AS a LEFT JOIN " . GROUP_PERIOD_TABLE . " AS b ON b.id = a.id_group_period  WHERE a.id_user={$id_user}";
                $rs = $dbconn->Execute($strSQL);
                $row = $rs->GetRowAssoc(false);
                $now_rest = $row["now_res"];
                $cost = $row["cost"];
                //$smarty->assign("account_days_text", sprintf($lang['setup']['account_days_text'], $now_rest > 0 ? $now_rest : 0));
                if ($email <= 0) {
                    if ($group_type != "g") { //// delete user from group and add to 'g' groups
                        $d_arr = array();
                        $rs = $dbconn->Execute("SELECT id FROM " . GROUPS_TABLE . " WHERE type='g' ");
                        while (!$rs->EOF) {
                            array_push($d_arr, " ( '" . $id_user . "', '" . $rs->fields[0] . "')");  //// add in 'g' groups
                            $rs->MoveNext();
                        }
                        $insert_str = implode(", ", $d_arr);

                        if (strlen($insert_str) > 0) {
                            $dbconn->Execute("DELETE FROM " . USER_GROUP_TABLE . " WHERE id_user={$id_user}");
                            $rs = $dbconn->Execute("INSERT INTO  " . USER_GROUP_TABLE . " (id_user, id_group) VALUES {$insert_str}");
                        }
                    }
                    //$smarty->assign("notice_end_period", 1);
                    $new_account = 0;
                    //$dbconn->Execute("delete from ".BILLING_USER_PERIOD_TABLE." where id_user='".$id_user."'");
                    //echo "<script>location.href=\"{$config["server"]}/index.php\"</script>";exit;
                } elseif ($email <= 50) {
                    if (GetAlertStatus("mail_membership_end_by_am")) {
                        // Alert moderu o membership ends
                        $data_ = array();
                        $data_["name"] = GetUserName($id_user);
                        $data_["link"] = $config["server"] . "/index.php";
                        SendAlert("mail_membership_end_by_am", $data_, $to_email, $data_["name"], 1);
                    }
                    //$smarty->assign("notice_end_period", 1);
                }
            } elseif ($period_type == 3) {
                $strSQL = "SELECT DATEDIFF(date_end, NOW()) AS now_res, email FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$id_user}";
                $rs = $dbconn->Execute($strSQL);
                $row = $rs->GetRowAssoc(false);
                $now_rest = $row["now_res"];
                $email = $row["email"];
                $smarty->assign("account_days_text", sprintf($lang['setup']['account_days_text'], $now_rest > 0 ? $now_rest : 0));
                if ($now_rest <= 0 || $email <= 0) {
                    if ($group_type != "g") { //// delete user from group and add to 'g' groups
                        $d_arr = array();
                        $rs = $dbconn->Execute("SELECT id FROM " . GROUPS_TABLE . " WHERE type='g' ");
                        while (!$rs->EOF) {
                            array_push($d_arr, " ( '" . $id_user . "', '" . $rs->fields[0] . "')");  //// add in 'g' groups
                            $rs->MoveNext();
                        }
                        $insert_str = implode(", ", $d_arr);

                        if (strlen($insert_str) > 0) {
                            $dbconn->Execute("DELETE FROM " . USER_GROUP_TABLE . " WHERE id_user={$id_user}");
                            $rs = $dbconn->Execute("INSERT INTO  " . USER_GROUP_TABLE . " (id_user, id_group) VALUES {$insert_str}");
                        }
                    }
                    //$smarty->assign("notice_end_period", 1);
                    $new_account = 0;
                } elseif ($now_rest <= 3 || $email <= 50) {
                    if (GetAlertStatus("mail_membership_end_by_am")) {
                        // Alert moderu o membership ends
                        $data_ = array();
                        $data_["name"] = GetUserName($id_user);
                        $data_["link"] = $config["server"] . "/index.php";
                        SendAlert("mail_membership_end_by_am", $data_, $to_email, $data_["name"], 1);
                    }
                    //$smarty->assign("notice_end_period", 1);
                }
            }
        } else {
            $strSQL = "SELECT DATEDIFF(a.date_end, NOW()) AS now_res, b.cost FROM " . BILLING_USER_PERIOD_TABLE . "  AS a LEFT JOIN " . GROUP_PERIOD_TABLE . " AS b ON b.id = a.id_group_period  WHERE a.id_user={$id_user}";
            $rs = $dbconn->Execute($strSQL);
            $row = $rs->GetRowAssoc(false);
            if ($rs->RowCount() > 0) {
                $now_rest = $row["now_res"];
                $cost = $row["cost"];
                if ($now_rest <= 0) {
                    UserToFreeGroup($id_user);
                    //$smarty->assign("notice_free_period", 1);
                } else {
                    $smarty->assign("account_days_text", sprintf($lang['setup']['account_days_text'], $now_rest > 0 ? $now_rest : 0));
                    //$smarty->assign("notice_trial_period", $now_rest);
                }
            } else {
                UserToFreeGroup($id_user);
                //$smarty->assign("notice_free_period", 1);
            }
        }

        /*

          if ($rs->RowCount() > 0) {
          $email = intval($row["email"]);
          $period = $row["period"];
          $period_type = $row["type"];
          $strSQL = "SELECT a.type, a.id, a.name FROM " . USER_GROUP_TABLE . " b, " . GROUPS_TABLE . " a WHERE b.id_user={$id_user} AND b.id_group=a.id GROUP BY a.id";
          $rs = $dbconn->Execute($strSQL);

          $group_type = $rs->fields[0];
          $group_id = $rs->fields[1];
          $group_name = $rs->fields[2];
          echo $group_name; exit;
          $smarty->assign("account_group_text", $group_name ? sprintf($lang['setup']['account_group_text'], $group_name) : '');

          if ($period_type == 1) {
          $strSQL = "SELECT DATEDIFF(a.date_end, NOW()) AS now_res, b.cost FROM " . BILLING_USER_PERIOD_TABLE . "  AS a LEFT JOIN " . GROUP_PERIOD_TABLE . " AS b ON b.id = a.id_group_period  WHERE a.id_user={$id_user}";
          $rs = $dbconn->Execute($strSQL);
          $row = $rs->GetRowAssoc(false);
          $now_rest = $row["now_res"];
          $cost = $row["cost"];
          if ($now_rest <= 0) {
          if ($group_type != "g") { //// delete user from group and add to 'g' groups
          $d_arr = array();
          $rs = $dbconn->Execute("SELECT id FROM " . GROUPS_TABLE . " WHERE type='g' ");
          while (!$rs->EOF) {
          array_push($d_arr, " ( '" . $id_user . "', '" . $rs->fields[0] . "')");  //// add in 'g' groups
          $rs->MoveNext();
          }
          $insert_str = implode(", ", $d_arr);

          if (strlen($insert_str) > 0) {
          $dbconn->Execute("DELETE FROM " . USER_GROUP_TABLE . " WHERE id_user={$id_user}");
          $dbconn->Execute("DELETE FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$id_user}");
          $rs = $dbconn->Execute("INSERT INTO  " . USER_GROUP_TABLE . " (id_user, id_group) VALUES {$insert_str}");
          }
          }
          $smarty->assign("notice_end_period", 1);
          $new_account = 0;
          } elseif ($now_rest <= 1) {
          if ($_REQUEST['authorized']) {
          if (GetAlertStatus("mail_membership_end_by_am")) {
          // Alert moderu o membership ends
          $data_ = array();
          $data_["name"] = GetUserName($id_user);
          $data_["link"] = $config["server"] . "/index.php";
          SendAlert("mail_membership_end_by_am", $data_, $to_email, $data_["name"], 1);
          }
          }
          $smarty->assign("notice_end_period", 0);
          }
          } elseif ($period_type == 2) {
          if ($email <= 0) {
          if ($group_type != "g") { //// delete user from group and add to 'g' groups
          $d_arr = array();
          $rs = $dbconn->Execute("SELECT id FROM " . GROUPS_TABLE . " WHERE type='g' ");
          while (!$rs->EOF) {
          array_push($d_arr, " ( '" . $id_user . "', '" . $rs->fields[0] . "')");  //// add in 'g' groups
          $rs->MoveNext();
          }
          $insert_str = implode(", ", $d_arr);

          if (strlen($insert_str) > 0) {
          $dbconn->Execute("DELETE FROM " . USER_GROUP_TABLE . " WHERE id_user={$id_user}");
          $rs = $dbconn->Execute("INSERT INTO  " . USER_GROUP_TABLE . " (id_user, id_group) VALUES {$insert_str}");
          }
          }
          $smarty->assign("notice_end_period", 1);
          $new_account = 0;
          //$dbconn->Execute("delete from ".BILLING_USER_PERIOD_TABLE." where id_user='".$id_user."'");
          //echo "<script>location.href=\"{$config["server"]}/index.php\"</script>";exit;
          } elseif ($email <= 50) {
          if (GetAlertStatus("mail_membership_end_by_am")) {
          // Alert moderu o membership ends
          $data_ = array();
          $data_["name"] = GetUserName($id_user);
          $data_["link"] = $config["server"] . "/index.php";
          SendAlert("mail_membership_end_by_am", $data_, $to_email, $data_["name"], 1);
          }
          $smarty->assign("notice_end_period", 1);
          }
          } elseif ($period_type == 3) {
          $strSQL = "SELECT DATEDIFF(date_end, NOW()) AS now_res, email FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$id_user}";
          $rs = $dbconn->Execute($strSQL);
          $row = $rs->GetRowAssoc(false);
          $now_rest = $row["now_res"];
          $email = $row["email"];
          if ($now_rest <= 0 || $email <= 0) {
          if ($group_type != "g") { //// delete user from group and add to 'g' groups
          $d_arr = array();
          $rs = $dbconn->Execute("SELECT id FROM " . GROUPS_TABLE . " WHERE type='g' ");
          while (!$rs->EOF) {
          array_push($d_arr, " ( '" . $id_user . "', '" . $rs->fields[0] . "')");  //// add in 'g' groups
          $rs->MoveNext();
          }
          $insert_str = implode(", ", $d_arr);

          if (strlen($insert_str) > 0) {
          $dbconn->Execute("DELETE FROM " . USER_GROUP_TABLE . " WHERE id_user={$id_user}");
          $rs = $dbconn->Execute("INSERT INTO  " . USER_GROUP_TABLE . " (id_user, id_group) VALUES {$insert_str}");
          }
          }
          $smarty->assign("notice_end_period", 1);
          $new_account = 0;
          } elseif ($now_rest <= 3 || $email <= 50) {
          if (GetAlertStatus("mail_membership_end_by_am")) {
          // Alert moderu o membership ends
          $data_ = array();
          $data_["name"] = GetUserName($id_user);
          $data_["link"] = $config["server"] . "/index.php";
          SendAlert("mail_membership_end_by_am", $data_, $to_email, $data_["name"], 1);
          }
          $smarty->assign("notice_end_period", 1);
          }
          }
          } else {
          $strSQL = "SELECT DATEDIFF(a.date_end, NOW()) AS now_res, b.cost FROM " . BILLING_USER_PERIOD_TABLE . "  AS a LEFT JOIN " . GROUP_PERIOD_TABLE . " AS b ON b.id = a.id_group_period  WHERE a.id_user={$id_user}";
          $rs = $dbconn->Execute($strSQL);
          $row = $rs->GetRowAssoc(false);
          if ($rs->RowCount() > 0) {
          $now_rest = $row["now_res"];
          $cost = $row["cost"];
          if ($now_rest <= 0) {
          UserToFreeGroup($id_user);
          $smarty->assign("notice_free_period", 1);
          } else {
          $smarty->assign("notice_trial_period", $now_rest);
          }
          } else {
          UserToFreeGroup($id_user);
          $smarty->assign("notice_free_period", 1);
          }
          }
         */
    }
    return;
}

//Delete or Change status user after unsubscribe
function ActionAfterUnSubscribe($id_user, $id_list, $moderator_id = 0) {
    global $dbconn, $auth;
    
    if ($moderator_id == 0)
        $moderator_id = $auth["id"];
    $action_with_subscr = GetUserSettings("action_with_subscr", $moderator_id);
    
    switch ($action_with_subscr) {
        case "1":
            // Delete
            $rs = $dbconn->Execute("SELECT list_id FROM " . CLIENTS_LISTS_TABLE . " WHERE client_id={$id_user} AND id_user={$moderator_id}");
            if ($rs->RowCount() == 1) {
                $rs1 = $dbconn->Execute("DELETE FROM " . SEND_USERS_TABLE . " WHERE id={$id_user} AND id_user={$moderator_id}");
            }
            $dbconn->Execute("DELETE FROM " . CLIENTS_LISTS_TABLE . " WHERE list_id={$id_list} AND client_id={$id_user} AND id_user={$moderator_id}");
            $dbconn->Execute("DELETE FROM " . CLICK_COUNTER_TABLE . " WHERE client_id={$id_user} AND id_user={$moderator_id}");
            $dbconn->Execute("DELETE FROM " . SENT_USERS_TABLE . " WHERE id_subscriber={$id_user}");
            $dbconn->Execute("DELETE FROM " . USER_ATTR_TABLE . " WHERE id_user={$id_user}");
            break;
        case "2":
            // Change status
            $dbconn->Execute("UPDATE " . CLIENTS_LISTS_TABLE . " SET status_subscribe=" . UNSUBSCRIBE . " WHERE client_id={$id_user} AND list_id={$id_list} AND id_user={$moderator_id}");
            break;
    }
    return $user_attrs;
}

function CheckUpload($file, $type, $pach_to) {
    global $config;

    $ex_arr = explode(".", $file["name"]);
    $extension = strtolower($ex_arr[count($ex_arr) - 1]);
    if (is_uploaded_file($file["tmp_name"])) {
        if (in_array($extension, $config["extension_enabled"][$type])) {
            if (!move_uploaded_file($file["tmp_name"], $pach_to . $file["name"]))
                return false;
            chmod($pach_to . $file["name"], 0777);
            if (file_exists($file["tmp_name"]))
                unlink($file["tmp_name"]);
            return 1;
        }
    }
    if (file_exists($file["tmp_name"]))
        unlink($file["tmp_name"]);
    return 0;
}

function ArrAddSlashes($data_arr) {
    if (is_array($data_arr)) {
        foreach ($data_arr as $k => $v) {
            if (is_array($v)) {
                ArrAddSlashes($v);
            } else {
                $data_arr[$k] = addslashes(trim($v));
            }
        }
    } else {
        $data_arr = addslashes(trim($data_arr));
    }
}

function StripJS($str) {
    $str = preg_replace("/<script(.*?)\>(.*?)\<\/script\>/is", "", $str);
    return $str;
}

function BadWordsCheck($text) {
    global $lang, $config;

    $file_path = $config["site_path"] . "/include/bad_words.txt";
    $bad_words = array();
    $search_words = array();
    $bad_words = explode(",", file_get_contents($file_path));
    $text = strtolower($text);

    foreach ($bad_words as $val) {
        $r = trim($val);
        if (preg_match("/\b{$r}\b/i", $text) && $r != "") {
            array_push($search_words, $val);
        }
    }
    if (count($search_words) > 0) {
        return implode(", ", $search_words);
    }
    return 0;
}

function list_files($dir = '') {
    if (empty($dir) || !is_dir($dir))
        return false;

    $file_list = array();

    if (!$handle = @opendir($dir))
        return false;

    while (($file = readdir($handle)) !== false) {
        if ($file == '.' || $file == '..')
            continue;
        if (is_file($dir . '/' . $file))
            $file_list[] = $file;
    }
    closedir($handle);
    return $file_list;
}

function LettersLink($url_param, $active_leter, $used_search_form) {
    $leter_str = "";
    for ($i = 65; $i <= 90; $i++) {
        if ($i == $active_leter) {
            $leter_str .= "&nbsp;<font class='page_link_active'>" . chr($i) . "</font>";
        } else {
            $leter_str .= "&nbsp;<a class='page_link' href='{$url_param}{$i}'>" . chr($i) . "</a>";
        }
    }
    if ($active_leter == "*" && !$used_search_form) {
        $leter_str .= "&nbsp;&nbsp;&nbsp; &nbsp;<font class='page_link_active'>" . chr(65) . "-" . chr(90) . "</font>&nbsp;";
    } else {
        $leter_str .= "&nbsp;&nbsp;&nbsp; &nbsp;<a class='page_link' href='" . $url_param . "*'>" . chr(65) . "-" . chr(90) . "</a>&nbsp;";
    }
    return $leter_str;
}

function CheckReferer() {
    global $config;
    if (!in_array($_SESSION["to_redirect"], array($config["site_root"] . "/index.php", $config["site_root"] . "/menu.php", "", $config["site_root"] . "/ajax_get_data.php", $config["site_root"] . "/error.php"))) {
        header("Location: {$_SESSION["to_redirect"]}");
        exit;
    }
}

function AdminXMLMenu($root) {
    global $config, $lang, $auth, $arr_enabled, $arr_disabled;

    $arr_enabled = GetAllPermissionsUser($auth["id"]);
    $arr_disabled = array('groups', 'billing', 'server_errors_settings', 'logo_settings', 'languages_settings', 'manage_smtp_server', 'alerts_users', 'spam_words');
    
    $menu = array();
    
    foreach ($root->children as $cnt => $node) {
        switch ($node->tag) {
            case "section":
                $menu[$node->attrs["name"]] = array();
                $menu[$node->attrs["name"]]["name"] = $node->attrs["name"];
                if ($node->childrenCount > 0) {
                    $menu[$node->attrs["name"]]["child"] = array();
                    $menu[$node->attrs["name"]]["child"] = AdminXMLMenu($node);
                }
                break;
            case "item":
                if (in_array($node->attrs["name"], $arr_enabled) || ($auth["id"] == "1" && $node->attrs["name"] != "profile")) {
                    $menu[$node->attrs["name"]] = array();
                    $menu[$node->attrs["name"]]["name"] = $lang["admin_menu"][$node->attrs["name"]];
                    if ($node->attrs["href"] != "")
                        $menu[$node->attrs["name"]]["link"] = $config["server"] . $node->attrs["href"];
                    if ($node->attrs["img"] != "")
                        $menu[$node->attrs["name"]]["icon"] = $config["server"] . "/templates" . $node->attrs["img"];
                    if ($node->childrenCount > 0) {
                        $menu[$node->attrs["name"]]["child"] = array();
                        $menu[$node->attrs["name"]]["child"] = AdminXMLMenu($node);
                    }
                }
                if ($node->attrs["name"] == "profile" && $auth["id"] != 1) {
                    $menu[$node->attrs["name"]] = array();
                    $menu[$node->attrs["name"]]["name"] = $lang["admin_menu"][$node->attrs["name"]];
                    if ($node->attrs["href"] != "")
                        $menu[$node->attrs["name"]]["link"] = $config["server"] . $node->attrs["href"];
                    if ($node->attrs["img"] != "")
                        $menu[$node->attrs["name"]]["icon"] = $config["server"] . "/templates" . $node->attrs["img"];
                    if ($node->childrenCount > 0) {
                        $menu[$node->attrs["name"]]["child"] = array();
                        $menu[$node->attrs["name"]]["child"] = AdminXMLMenu($node);
                    }
                }
                break;
            case "subitem":
                if ((in_array($node->attrs["name"], $arr_enabled) && !in_array($node->attrs["name"], $arr_disabled)) || $auth["id"] == "1") {
                    $menu[$node->attrs["name"]] = array();
                    $menu[$node->attrs["name"]]["name"] = $lang["admin_menu"][$node->attrs["name"]];
                    if ($node->attrs["href"] != "")
                        $menu[$node->attrs["name"]]["link"] = $config["server"] . $node->attrs["href"];
                    if ($node->attrs["img"] != "")
                        $menu[$node->attrs["name"]]["icon"] = $config["server"] . "/templates" . $node->attrs["img"];
                    if ($node->childrenCount > 0) {
                        $menu[$node->attrs["name"]]["child"] = array();
                        $menu[$node->attrs["name"]]["child"] = AdminXMLMenu($node);
                    }
                }
                break;
        }
    }
    return $menu;
}

function GenerateMenu() {
    global $config, $smarty, $this_page, $auth;

    include_once "xmlparser.php";

    $xml_parser = new SimpleXmlParser($config["site_path"] . "/include/menu.xml");
    $xml_root = $xml_parser->getRoot();
    $menu_arr = array();
    $menu_arr = AdminXMLMenu($xml_root);

    unset($xml_parser, $xml_root);
    // general menu
    $general_menu = "<ul class=\"page_menu\">";
    foreach ($menu_arr["general_menu"]["child"] as $key => $val) {
        $class = ($this_page == $key) ? "2" : "";
        $general_menu .= "<li><a href=\"#\"><div class=\"menu-l{$class}\">&nbsp;</div><div class=\"menu-c{$class}\"><span>&nbsp;&nbsp;{$val["name"]}&nbsp;&nbsp;&nbsp;</span></div><div class=\"menu-r{$class}\">&nbsp;</div></a>";
        if ($val["child"])
            $general_menu .= "<ul>";
        foreach ($val["child"] as $key1 => $val1) {
            $general_menu .= "<li><a href=\"{$val1["link"]}\"><img src=\"{$val1["icon"]}\" alt=\"\" border=0 hspace=3 />{$val1["name"]}</a></li>";
        }
        if ($val["child"])
            $general_menu .= "</ul>";
        $general_menu .= "</li>";
    }
    $general_menu .= "</ul>";
    $smarty->assign("general_menu", $general_menu);
    
    // top menu
    $top_menu = "";
    foreach ($menu_arr["top_menu"]["child"] as $key => $val) {
        $top_menu .= "<li><span class=\"head_menu\">{$val["name"]}<img src=\"{$config["server"]}{$config["theme_path"]}{$config["default_image"]}/arrow.gif\" width=\"18\" height=\"15\" align=\"top\" class=\"arrow\" /></span>\n";
        if ($val["child"])
            $top_menu .= "<div class=\"sub_menu\">\n";
        foreach ($val["child"] as $key1 => $val1) {
            $top_menu .= "<a href=\"{$val1["link"]}\"><img src=\"{$val1["icon"]}\" alt=\"\" border=0 hspace=3 />{$val1["name"]}</a>\n";
        }
        if ($val["child"])
            $top_menu .= "</div>\n";
        $top_menu .= "</li>\n";
    }
    $smarty->assign("top_menu", $top_menu);
}

function GetDateFormat() {
    return GetUserSettings(array('date_format', 'time_format'), 1);
}

function FixEncoding($x) {
    if (mb_detect_encoding($x) == 'UTF-8') {
        return $x;
    } else {
        return utf8_encode($x);
    }
}

function GetTriggerByIdNewsletter($id, $id_user, $where = "link") {
    global $dbconn;

    $id = intval($id);
    $id_user = intval($id_user);
    $triggers = array();
    $strSQL = "SELECT * FROM " . TRIGGERS_TABLE . " WHERE id_user={$id_user} AND id_newsletter=(SELECT id_newsletter FROM " . SEND_NEWSLETTERS_TABLE . " WHERE id={$id} AND id_user={$id_user})";
    $res = $dbconn->Execute($strSQL);
    $i = 0;
    $j = 0;
    while (!$res->EOF) {
        $row = $res->GetRowAssoc(false);
        if ($row["condition_use"] == "link") {
            $triggers["link"][$i]["id_newsletter"] = $row["id_newsletter"];
            $triggers["link"][$i]["link"] = $row["link"];
            $action = unserialize($row["action"]);
            if ($action["action_send"] == "send")
                $triggers["link"][$i]["action"]["send"] = $row["id_send_newsletter"];
            if ($action["action_add"] == "add")
                $triggers["link"][$i]["action"]["add"] = explode("|", $row["id_list"]);
            if ($action["action_remove"] == "remove")
                $triggers["link"][$i]["action"]["remove"] = "remove";
            $i++;
        }
        if ($row["condition_use"] == "view") {
            $triggers["view"][$j]["id_newsletter"] = $row["id_newsletter"];
            $action = unserialize($row["action"]);
            if ($action["action_send"] == "send")
                $triggers["view"][$j]["action"]["send"] = $row["id_send_newsletter"];
            if ($action["action_add"] == "add")
                $triggers["view"][$j]["action"]["add"] = explode("|", $row["id_list"]);
            if ($action["action_remove"] == "remove")
                $triggers["view"][$j]["action"]["remove"] = "remove";
            $j++;
        }
        $res->MoveNext();
    }
    if ($where == "link") {
        return $triggers["link"];
    } else {
        return $triggers["view"];
    }
}

function SubscribeUserToList($id_subscriber, $lists, $id_moder) {
    global $dbconn;

    $id_subscriber = intval($id_subscriber);
    $id_moder = intval($id_moder);
    foreach ($lists as $key => $value) {
        $id_list = intval($value);
        $strSQL = "SELECT * FROM " . CLIENTS_LISTS_TABLE . " WHERE client_id='{$id_subscriber}' AND list_id='{$id_list}' AND id_user={$id_moder}";
        $rs = $dbconn->Execute($strSQL);
        if (!$rs->RowCount()) {
            $strSQL = "INSERT INTO " . CLIENTS_LISTS_TABLE . " (client_id,list_id,status_subscribe,date_status,id_user) VALUES ({$id_subscriber},{$id_list}, '1',NOW(), {$id_moder})";
            $dbconn->Execute($strSQL);
        }
    }
}

function CopyTemplateToNewUser($id_user) {
    global $dbconn, $config;
    $strSQL = "SELECT name,body,body_text,format FROM " . TEMPLATES_TABLE . " WHERE type='d' AND id_user=1";
    $res = $dbconn->Execute($strSQL);
    while (!$res->EOF) {
        $strSQL = "INSERT INTO " . TEMPLATES_TABLE . " (name,body,body_text,date,format,id_user)
					VALUES ('{$res->fields[0]}','{$res->fields[1]}','{$res->fields[2]}',NOW(),'{$res->fields[3]}',{$id_user})";
        $dbconn->Execute($strSQL);
        $res->MoveNext();
    }
}

function getDomainFromEmail($email) {
    $email_temp = explode('@', $email);
    return isset($email_temp[1]) ? $email_temp[1] : '';
}

function UserToFreeGroup($user_id) {
    global $dbconn;
    $strSQL = "SELECT a.id FROM " . GROUPS_TABLE . " a WHERE a.type = 'd' ";
    $rs = $dbconn->Execute($strSQL);
    $group_id = $rs->fields[0];
    $dbconn->Execute("DELETE FROM " . USER_GROUP_TABLE . " WHERE id_user={$user_id}");
    $dbconn->Execute("DELETE FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$user_id}");
    $rs = $dbconn->Execute("INSERT INTO  " . USER_GROUP_TABLE . " (id_user, id_group) VALUES ({$user_id}, {$group_id})");
}