<?php

/**
* paypal payment system functions
*
* @package Newsletter
* @subpackage Payment systems files
**/

//redirect on this place after user click button "Pay". use in payment.php
function MakePayment($billing_system, $amount, $currency, $id_trunzaction, $product_name) {
	global $dbconn, $config;
		$rs_sys = $dbconn->Execute("SELECT seller_id, recurring FROM ".BILLING_SYS_.$billing_system);
		$payGear = new Payment_Engine(PAYMENT_ENGINE_SEND, false, false);
		$PaySystem = $payGear->factory($billing_system);
		if (intval($rs_sys->fields[1]) ) {
			$strSQL = "select b.id, b.amount, b.period from ".BILLING_REQUESTS_TABLE." a, ".GROUP_PERIOD_TABLE." b where a.id='".$id_trunzaction."' and a.id_product=b.id";
			$rs = $dbconn->Execute($strSQL);
			if ($rs->fields[0]) {
				$period = $rs->fields[1];
				switch ($rs->fields[2]) {
					case 'day': $period_type = 'D'; break;
					case 'week': $period_type = 'W'; break;
					case 'month': $period_type = 'M'; break;
					case 'year': $period_type = 'Y'; break;
					case 'emails': $period_type = 'E'; break;
					default: $period_type = 'M';
				}
			} else {
				$period = '1';
				$period_type = 'M';
			}

			$pay_data = array(
				'seller_id'     => $rs_sys->fields[0],
				'amount_recurring'      => $amount,
				'order_id'		=> $id_trunzaction,
//				'test_mode'		=> "0",
				'return_method' => "2",
				'return_url'    => $config["server"]."/index.php",
				'cancel_return' => $config["server"]."/index.php",
				'type'          => "_xclick-subscriptions",
				'product_name'  => $product_name,
				'currency'      => $currency,
				'period_recurring'      => $period,
				'period_type_recurring'      => $period_type,
				'use_recurring'      => "1",
				'use_note'      => "1"
			);
		} else {
			$pay_data = array(
				'seller_id'     => $rs_sys->fields[0],
				'amount'        => $amount,
				'order_id'		=> $id_trunzaction,
				'test_mode'		=> "0",
				'return_method' => "2",
				'return_url'    => $config["server"]."/include/payment_request.php?sel=paypal",
				'notify_url'    => $config["server"]."/include/payment_request.php?sel=paypal",
				'cancel_return' => $config["server"]."/include/payment_request.php?sel=paypal",
				'type'          => "_xclick",
				'product_name'  => $product_name,
				'currency'      => $currency
			);
		}
		$PaySystem->setFrom($pay_data);
		$PaySystem->doPayment();
}

//get paysystem request values. use in include/payment_request.php
function RequestPayment($billing_system, $__REQUEST) {
	$payGear = new Payment_Engine(PAYMENT_ENGINE_RECEIVE, false, false);
	$PaySystem = $payGear->factory($billing_system);
	$pay_data = array(
		'count'		=> $__REQUEST[$PaySystem->_arrayField['amount_response']],
		'currency'	=> $__REQUEST[$PaySystem->_arrayField['currency_response']],
		'date'		=> date("Y-m-d H:i:s", strtotime($__REQUEST[$PaySystem->_arrayField['payment_date']]) ),
		'status'	=> ($PaySystem->checkPayment())?1:0,
		'id_req'	=> $__REQUEST[$PaySystem->_arrayField['order_id']],
		'quantity'	=> $__REQUEST[$PaySystem->_arrayField['quantity']]
	);
	return $pay_data;
}

//get paysystem settings. use in admin/admin_payment.php
function getBillingData($billing_system) {
	global $dbconn, $smarty, $lang;
		$rs = $dbconn->Execute("Select p.used, bs.seller_id, bs.recurring from ".BILLING_PAYSYSTEMS_TABLE." p, ".BILLING_SYS_.$billing_system." bs where p.template_name='".$billing_system."'");
		$data["use"] = $rs->fields[0];
		$data["value"] = $rs->fields[1];
		$data["recurring"] = intval($rs->fields[2]);
		$smarty->assign("header", $lang["pays"]);
		$smarty->assign("data", $data);
		$data["table_options"] = $smarty->fetch(SYSTEMS_DIR."templates/".$billing_system.".tpl");
		return $data;
}

//set(change) paysystem settings. use in admin/admin_payment.php
function setBillingData($billing_system, $__POST) {
	global $dbconn, $lang;
		$value = strval($__POST["value"]);
		$recurring = intval($__POST["recurring"]);
		$use = intval($__POST["use"]);
		$err = 0;
		if(!$value){
			$err = $lang["err"]["invalid_feilds"];
			$err .= "<br>".$lang["pays"]["paypal_seller_id"];
		} else {
			$strSQL = "Update ".BILLING_SYS_.$billing_system." set seller_id='".$value."', recurring='".$recurring."'";
			$dbconn->Execute($strSQL);
		}
			$strSQL = "Update ".BILLING_PAYSYSTEMS_TABLE." set used='".$use."' where template_name='".$billing_system."'";
			$dbconn->Execute($strSQL);
		return $err;
}

?>