<?php

include "./include/config.php";
include "./include/common_functions.php";
include "./include/functions_auth.php";
include "./common.php";
include "./include/config.inc.php";

foreach ($_POST as $id => $value) {
    $_POST[$id] = htmlspecialchars(strip_tags($value));
}

@$sel = $_GET["sel"] ? $_GET["sel"] : $_POST["sel"];
$sel = strip_tags($sel);

switch ($sel) {
    case "save": Save();
        break;
    case "group_periods": GroupPeriods();
        break;
    default: View();
}

function View() {
    global $dbconn, $smarty, $config;

    $smarty->assign("compare_link", $config["server"] . "/compare.php");

    MainMenu("registration");

    $strSQL = " SELECT id, name, type FROM " . GROUPS_TABLE . " WHERE id NOT IN (1,2) ORDER BY name";
    $rs = $dbconn->Execute($strSQL);
    $i = 0;
    if ($rs->RowCount() > 0) {
        while (!$rs->EOF) {
            $group_arr[$i]["id"] = $rs->fields[0];
            $group_arr[$i]["type"] = $rs->fields[2];
            $group_arr[$i]["name"] = strval($rs->fields[1]);
            $group_arr[$i]["type_name"] = $lang["groups"]["types"][strval($rs->fields[2])];
            $group_arr[$i]["editlink"] = $file_name . "?sel=add&id=" . $rs->fields[0];
            $group_arr[$i]["userlink"] = $file_name . "?sel=user&id_group=" . $rs->fields[0];
            $group_arr[$i]["permlink"] = $file_name . "?sel=perm&id=" . $rs->fields[0];
            $group_arr[$i]["dellink"] = $file_name . "?sel=del&id=" . $rs->fields[0];
            $group_arr[$i]["create_footer"] = $file_name . "?sel=create_footer&id=" . $rs->fields[0];
            $rs->MoveNext();
            $i++;
        }
        ArrStripSlashes($group_arr);
        get_smarty_array_list("group_page", $config["group_page"]);
        $smarty->assign("amount", $amount);
    } else {
        $smarty->assign("empty_row", "1");
    }

    $smarty->assign("group_arr", $group_arr);

    $smarty->assign('gid', isset($_GET["gid"]) ? intval(strip_tags($_GET["gid"])) : '');
    $smarty->assign('period_id', intval(strip_tags($_GET["period_id"])));
    $smarty->display($config["admin_nl_gentemplates"] . "/registration_user.tpl");
    exit;
}

function Save() {
    global $smarty, $dbconn, $config, $lang, $config_admin;

    MainMenu("registration");
    $errors = array();
    ArrAddSlashes($_POST);

    $fname = (isset($_POST["fname"])) ? strip_tags($_POST["fname"]) : "";
    $sname = (isset($_POST["sname"])) ? strip_tags($_POST["sname"]) : "";
    $phone = (isset($_POST["phone"])) ? strip_tags($_POST["phone"]) : "";
    $wsite = (isset($_POST["wsite"])) ? strip_tags($_POST["wsite"]) : "";
    $email = (isset($_POST["email"])) ? strip_tags($_POST["email"]) : "";
    $login = (isset($_POST["login"])) ? strip_tags($_POST["login"]) : "";
    $password = (isset($_POST["password"])) ? strip_tags($_POST["password"]) : "";
    $repassword = (isset($_POST["repassword"])) ? strip_tags($_POST["repassword"]) : "";
    $captcha = (isset($_POST["captcha"])) ? strip_tags($_POST["captcha"]) : "";
    $group_id = (isset($_POST["group_id"])) ? strip_tags($_POST["group_id"]) : "";
    $period_id = (isset($_POST["pay_id"])) ? strip_tags($_POST["pay_id"]) : "";

    if (empty($fname)) {
        $errors["fname"] = $lang["err"]["specify_firstname"];
    }
    if (empty($sname)) {
        $errors["sname"] = $lang["err"]["specify_secondname"];
    }
    if (empty($email)) {
        $errors["email"] = $lang["err"]["specify_email"];
    }
    if (!preg_match('/^\s*\w+([\.\w\-]+)*\w@\w+([\.\w\-]+)*\w\.\w{2,}\s*$/', $email)) {
        $errors["email"] = $lang["err"]["invalid_email"];
    }
    if (empty($login)) {
        $errors["login"] = $lang["err"]["specify_login"];
    }
    if (empty($password)) {
        $errors["password"] = $lang["err"]["specify_password"];
    }
    if (empty($repassword)) {
        $errors["repassword"] = $lang["err"]["specify_repassword"];
    }
    if ($password != $repassword) {
        $errors["pass_repass"] = $lang["err"]["invalid_kcaptcha"];
    }
    if (empty($captcha)) {
        $errors["captcha"] = $lang["err"]["specify_secur_code"];
    }
    //if (!$_SESSION['captcha_keystring'])
    //    echo "fuck";

    if (!$_SESSION['captcha_keystring'] || $_SESSION['captcha_keystring'] != $captcha) {
        $errors["captcha"] = $lang["err"]["invalid_kcaptcha"];
    }
    unset($_SESSION['captcha_keystring']);

    $rs = $dbconn->Execute("SELECT id FROM " . USERS_TABLE . " WHERE login='{$login}'");
    if ($rs->RowCount()) {
        $errors["login_exist"] = $lang["err"]["login_exist"];
    }

    $strSQL = " SELECT id, name, type, trial_value, trial_period FROM " . GROUPS_TABLE . " WHERE id NOT IN (1,2) ORDER BY name";
    $rs = $dbconn->Execute($strSQL);
    if ($rs->RowCount() > 0) {
        while (!$rs->EOF) {
            $group_arr[$rs->fields[0]]["id"] = $rs->fields[0];
            $group_arr[$rs->fields[0]]["type"] = $rs->fields[2];
            $group_arr[$rs->fields[0]]["name"] = strval($rs->fields[1]);
            $group_arr[$rs->fields[0]]["type_name"] = $lang["groups"]["types"][strval($rs->fields[2])];
            $group_arr[$rs->fields[0]]["editlink"] = $file_name . "?sel=add&id=" . $rs->fields[0];
            $group_arr[$rs->fields[0]]["userlink"] = $file_name . "?sel=user&id_group=" . $rs->fields[0];
            $group_arr[$rs->fields[0]]["permlink"] = $file_name . "?sel=perm&id=" . $rs->fields[0];
            $group_arr[$rs->fields[0]]["dellink"] = $file_name . "?sel=del&id=" . $rs->fields[0];
            $group_arr[$rs->fields[0]]["create_footer"] = $file_name . "?sel=create_footer&id=" . $rs->fields[0];
            $group_arr[$rs->fields[0]]["trial_value"] = $rs->fields[3];
            $group_arr[$rs->fields[0]]["trial_period"] = $rs->fields[4];
            $rs->MoveNext();
        }
        ArrStripSlashes($group_arr);
        get_smarty_array_list("group_page", $config["group_page"]);
        $smarty->assign("amount", $amount);
    } else {
        $smarty->assign("empty_row", "1");
    }
    //print_r($group_arr); exit;
    $smarty->assign("group_arr", $group_arr);
//print_r($errors); exit;
    if (count($errors) > 0) {
        $smarty->assign("errors", $errors);
        $smarty->assign("group_id", $group_id);
        $smarty->assign("period_id", strip_tags($_POST["period_id"]));
        $smarty->assign("err", implode("<br>", $errors));
        $smarty->assign("data", $_POST);
        $smarty->display($config["admin_nl_gentemplates"] . "/registration_user.tpl");
        exit;
    }

    $rs = $dbconn->Execute("SELECT value FROM " . SETTINGS_TABLE . " WHERE name='default_lang'");
    $def_lang = $rs->fields[0] ? $rs->fields[0] : "1";

    $strSQL = "INSERT INTO " . USERS_TABLE . " (fname, sname, status, login, password, phone, email, website, date_registration, lang)
					VALUES ('{$fname}','{$sname}','0', '{$login}', '" . md5($password) . "','{$phone}','{$email}','{$wsite}', NOW(), " . $def_lang . ")";
    $rs = $dbconn->Execute($strSQL);
    $uid = $dbconn->Insert_ID();

    CopyTemplateToNewUser($uid);
    sess_write(session_id(), $uid);
    $auth = auth_user();

    $admin_data = GetUserSettings(array('from_email', 'from_name', 'birthday_id'), 1);

    $strSQL = "SELECT * FROM " . SECTION_ATTRS_TABLE . " WHERE id={$admin_data["birthday_id"]}";
    $rs = $dbconn->Execute($strSQL);
    $row = $rs->GetRowAssoc(false);
    $strSQL = "INSERT INTO " . SECTION_ATTRS_TABLE . " (name,id_section,mandatory,control_type,control_setup,is_const,id_user)
					VALUES ('{$row["name"]}',{$row["id_section"]},'{$row["mandatory"]}','{$row["control_type"]}','{$row["control_setup"]}','{$row["is_const"]}',{$uid})";
    $dbconn->Execute($strSQL);
    $birthday_id = $dbconn->Insert_ID();

    $strSQL = "INSERT INTO " . USER_SETTINGS_TABLE . " (value, name, id_user) VALUES
						('{$fname} {$sname}','from_name',{$uid}),('0','timeout',{$uid}),
						('0','smtp_quota',{$uid}),('0','send_period',{$uid}),
						('{$email}','from_email',{$uid}),('1','is_tips',{$uid}),
						('0','auto_delete',{$uid}),('smtp','type_dispatch',{$uid}),
						('1','action_with_subscr',{$uid}),('0','change_link',{$uid}),
						('0','bounce',{$uid}),('test@test.com','test_email',{$uid}),('{$birthday_id}','birthday_id',{$uid})";
    $dbconn->Execute($strSQL);

    if (GetAlertStatus("mail_newuser_by_user")) {
        // Alert polzovatelu o registracii
        $data_ = array();
        $data_["site_name"] = $config["server"];
        $data_["name"] = GetUserName($uid);
        $data_["login_info"] = "{$lang["common"]["login"]}: {$login}\n{$lang["common"]["pwd"]}: {$password}";
        $data_["link"] = $config["server"];
        SendAlert("mail_newuser_by_user", $data_, $email, $data_["name"], 1);
    }

    $dbconn->Execute("INSERT INTO " . USER_GROUP_TABLE . " (id_user, id_group) VALUES ({$uid}, {$group_id})");
    $dbconn->Execute("UPDATE " . USERS_TABLE . " SET status='1' WHERE id={$uid}");

    $strSQL = "SELECT type FROM " . GROUPS_TABLE . "  WHERE id='{$group_id}'";
    $rs = $dbconn->Execute($strSQL);
    $group_type = $rs->fields[0];
    $amount = 0;
    if ($group_type == 'd') {
        $strSQL = "SELECT id, amount, period FROM " . GROUP_PERIOD_TABLE . " WHERE id_group='" . floor($group_id) . "' LIMIT 1";
        $rs = $dbconn->Execute($strSQL);		
        $id_period = $rs->fields[0];
        $amount = explode('|', $rs->fields[1]);
        $period = explode('|', $rs->fields[2]);
        if (count($amount) == 2 && count($period) == 2){
        $period_day = $amount[0] * $config_admin["pay_period"][$period[0]];
        $period_day = $period_day > 0 ? $period_day : 36500;
        $amount = $amount[1];
        $amount = $amount > 0 ? $amount : 0;		
        $strSQL = "SELECT id, date_begin, date_end FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$uid}";
                $rs = $dbconn->Execute($strSQL);
                if ($rs->fields[0] > 0) {
                    $strSQL = "UPDATE " . BILLING_USER_PERIOD_TABLE . " SET date_end=date_end + INTERVAL " . $period_day . " DAY AND email={$amount} WHERE id='" . $rs->fields[0] . "'";
                } else {
                    $strSQL = "INSERT INTO " . BILLING_USER_PERIOD_TABLE . " (id_group_period, date_begin, date_end, id_user, email)
                            VALUES ({$id_period}, NOW(), NOW()+INTERVAL " . $period_day . " DAY, {$uid}, {$amount})";
                }
                $dbconn->Execute($strSQL); 
        }
    } else {
    
    if (isset($group_arr[$group_id]) && isset($group_arr[$group_id]['trial_period']) && isset($group_arr[$group_id]['trial_value'])) {
        $period = $group_arr[$group_id]['trial_period'] ? $group_arr[$group_id]['trial_period'] : 'day';
        $amount = $group_arr[$group_id]['trial_value'] ? $group_arr[$group_id]['trial_value'] : 0;
        if ($amount > 0) {
            $id_user = $uid;
            $id_group = $group_id;
            $id_product = 0;
            if (in_array($period, array('day', 'week', 'month', 'year'))) {
                $period_day = $amount * $config_admin["pay_period"][$period];

                $strSQL = "SELECT id, date_begin, date_end FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$id_user}";
                $rs = $dbconn->Execute($strSQL);
                if ($rs->fields[0] > 0) {
                    $strSQL = "UPDATE " . BILLING_USER_PERIOD_TABLE . " SET date_end=date_end + INTERVAL " . $period_day . " DAY WHERE id='" . $rs->fields[0] . "'";
                } else {
                    $strSQL = "INSERT INTO " . BILLING_USER_PERIOD_TABLE . " (id_group_period, date_begin, date_end, id_user)
                            VALUES ({$id_product}, NOW(), NOW()+INTERVAL " . $period_day . " DAY, {$id_user})";
                }
                $dbconn->Execute($strSQL);
            }
        }
    }
    }
    /*
      if (isset($row["cost"]) && intval($row["cost"]) == 0) {
      $period = $row['period'];
      $amount = $row['amount'];
      $id_user = $uid;
      $id_group = $group_id;
      $id_product = $row['id'];
      if (in_array($period, array('day', 'week', 'month', 'year'))) {
      $period_day = $amount * $config_admin["pay_period"][$period];

      $strSQL = "SELECT id, date_begin, date_end FROM " . BILLING_USER_PERIOD_TABLE . " WHERE id_user={$id_user}";
      $rs = $dbconn->Execute($strSQL);
      if ($rs->fields[0] > 0) {
      $strSQL = "UPDATE " . BILLING_USER_PERIOD_TABLE . " SET date_end=date_end + INTERVAL " . $period_day . " DAY WHERE id='" . $rs->fields[0] . "'";
      } else {
      $strSQL = "INSERT INTO " . BILLING_USER_PERIOD_TABLE . " (id_group_period, date_begin, date_end, id_user)
      VALUES ({$id_product}, NOW(), NOW()+INTERVAL " . $period_day . " DAY, {$id_user})";
      }
      $dbconn->Execute($strSQL);
      }
      }
     */

    if ($period_id) {
        echo "<script>location.href='{$config["server"]}/payment.php?sel=save_1&period_id={$period_id}'</script>";
    } else {
        echo "<script>location.href='{$config["server"]}/payment.php'</script>";
    }

    //echo "<script>location.href='{$config["server"]}/payment.php?sel=save_1&period_id={$id_period}'</script>";
    exit;
}

function GroupPeriods() {
    global $smarty, $dbconn, $config, $lang, $config_admin;

    $group_id = isset($_GET['group_id']) ? $_GET['group_id'] : 0;

    $settings_manager = new SettingsManager();
    $form["currency"] = $settings_manager->GetSiteSettings("site_unit_costunit");

    $strSQL = "SELECT a.*, b.name AS group_name FROM " . GROUP_PERIOD_TABLE . " AS a, " . GROUPS_TABLE . " AS b WHERE a.status=1 AND b.id=a.id_group AND b.type='f' AND b.id = {$group_id} ORDER BY a.date";
    $rs = $dbconn->Execute($strSQL);
    $i = 0;
    while (!$rs->EOF) {
        $row = $rs->GetRowAssoc(false);
        $data[$i]["id"] = $row["id"];
        $data[$i]["type"] = $row["type"];
        if ($data[$i]["type"] == "3") {
            $tmp_amount = explode("|", $row["amount"]);
            $tmp_period = explode("|", $row["period"]);
            $data[$i]["period"] = $tmp_amount[0] . " " . $lang["pays"]["periods"][$tmp_period[0]] . ", ";
            $data[$i]["period"] .= $tmp_amount[1] . " " . $lang["pays"]["periods"][$tmp_period[1]];
        } else {
            $data[$i]["period"] = $row["amount"] . " " . $lang["pays"]["periods"][$row["period"]];
        }
        $data[$i]["cost"] = $row["cost"] . " " . $form["currency"];
        $data[$i]["group_name"] = $row["group_name"];
        $data[$i]["pay_link"] = $file_name . "?sel=save_1&period_id=" . $data[$i]["id"];

        $rs->MoveNext();
        $i++;
    }
    if ($par)
        $smarty->assign("view", 1);
    $smarty->assign("data", $data);
    $smarty->assign("get_data_url", $config["server"] . '/registration.php?');

    if ($config["phpversion"] == 4) {
        include_once "include/class.json.php";
        $json = new Services_JSON();
        echo $json->encode($data);
    } else {
        echo json_encode($data);
    }
}
