<?php

include "./include/config.php";
include "./include/common_functions.php";
include "./include/functions_auth.php";
include "./common.php";
include "./include/config.inc.php";

login_cheeck($auth);
$mode = IsFileAllowed($auth["id"], GetRightModulePath(__FILE__));

if ($mode == 1) {
	$header = AdminMainMenu("setup");
	$this_page = "settings";
	$file_name = $config["server"] . "/settings.php";
	@$sel = (isset($_REQUEST["sel"]) && !empty($_REQUEST["sel"])) ? trim($_REQUEST["sel"]) : "";
	@$section = (isset($_REQUEST["section"]) && !empty($_REQUEST["section"])) ? trim($_REQUEST["section"]) : "";
	switch ($sel) {
		case 'save': SaveSettings($section);
			break;
		case "default": SetDefault($section);
			break;
		case 'langs': if ($auth["root"]) {
				LangSettings();
			} else {
				ListSettings();
			} break;
		case 'langchange': if ($auth["root"]) {
				SaveLangSettings();
			} else {
				ListSettings();
			} break;
		case 'langedit': LangForm();
			break;
		case 'langsave': LangSave();
			break;
		case 'langadd': AddLang();
			break;
		case 'lang_delete': DeleteLang();
			break;
		case 'smtp_server': SmtpServer();
			break;
		case 'smtp_priority': SmtpServerPriarity();
			break;
		case 'save_smtp_server': SaveSmtpServer();
			break;
		case "smtp_delete": SmtpDelete();
			break;
		case 'search_string': SearchString();
			break;
		default: ListSettings($section);
			break;
	}
}

function SaveSettings($section) {
	global $dbconn, $lang, $auth, $smarty, $config;

	$settings_manager = new SettingsManager();
	ArrAddSlashes($_POST);
	switch ($section) {
		case "admin":
			$admin_login = $_POST["admin_login"];
			$admin_password = md5(trim($_POST["admin_password"]));
			$admin_re_password = md5(trim($_POST["admin_re_password"]));
			$admin_old_password = md5(trim($_POST["admin_old_password"]));

			$error = array();
			if ($admin_login == "") {
				array_push($error, $lang["err"]["specify_login"]);
			}
			$res = $dbconn->Execute("SELECT id FROM " . USERS_TABLE . " WHERE login='{$admin_login}' AND id!={$auth["id"]}");
			if ($res->RowCount() > 0) {
				array_push($error, $lang["err"]["login_exist"]);
			}

			$rs = $dbconn->Execute("SELECT password FROM " . USERS_TABLE . " WHERE id={$auth["id"]}");
			$admin_password_cur = $rs->fields[0];
			if ($admin_old_password != $admin_password_cur) {
				array_push($error, $lang["err"]["old_pass_faled"]);
			}
			if ($admin_password != $admin_re_password) {
				array_push($error, $lang["err"]["pass_eq_repass"]);
			}

			unset($_POST["par"]);
			if (count($error) > 0) {
				$err = implode("<br>", $error);
				ListSettings($section, $err);
				exit;
			} else {
				$rs = $dbconn->Execute("UPDATE " . USERS_TABLE . " SET login='{$admin_login}', password='{$admin_password}' WHERE id={$auth["id"]}");
				$err = $lang["common"]["success_save"];
			}
			break;
		case "general":

			if ($auth["root"]) {
				$_POST["time_format"] = strip_tags($_POST["time_format"]);
				$_POST["date_format"] = strip_tags($_POST["date_format"]);
				$smtp_quota = intval($_POST["smtp_quota"]);
				$type_dispatch = $_POST["type_dispatch"];
				$dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$smtp_quota}' WHERE name='smtp_quota' AND id_user={$auth["id"]}");
				$dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$type_dispatch}' WHERE name='type_dispatch' AND id_user={$auth["id"]}");

				$dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$_POST["date_format"]}' WHERE name='date_format' AND id_user={$auth["id"]}");
				$dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$_POST["time_format"]}' WHERE name='time_format' AND id_user={$auth["id"]}");
			}
			$from_name = strip_tags($_POST["from_name"]);
			$from_email = strip_tags($_POST["from_email"]);
			$test_email = strip_tags($_POST["test_email"]);
			$is_tips = $_POST["is_tips"] ? intval($_POST["is_tips"]) : 0;
			$action_with_subscr = intval($_POST["action_with_subscr"]);
			$bounce = $_POST["bounce"] ? 1 : 0;
			$change_link = $_POST["change_link"] ? 1 : 0;

			$use_google_analytics_tracking = isset($_POST["use_google_analytics_tracking"]) && intval($_POST["use_google_analytics_tracking"]) == 1 ? 1 : 0;
			if ($auth["root"]) {
				if ($use_google_analytics_tracking == 1)
					$google_analytics_source_default = isset($_POST["google_analytics_source_default"]) ? $_POST["google_analytics_source_default"] : '';
			    $site_name = strip_tags($_POST["site_name"]);
                $rs = $dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$site_name}' WHERE name='site_name' AND id_user={$auth["id"]}");
            }
			$rs = $dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$from_name}' WHERE name='from_name' AND id_user={$auth["id"]}");
			$rs = $dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$from_email}' WHERE name='from_email' AND id_user={$auth["id"]}");
			$rs = $dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$is_tips}' WHERE name='is_tips' AND id_user={$auth["id"]}");
			$rs = $dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$action_with_subscr}' WHERE name='action_with_subscr' AND id_user={$auth["id"]}");
			$rs = $dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$change_link}' WHERE name='change_link' AND id_user={$auth["id"]}");
			$rs = $dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$bounce}' WHERE name='bounce' AND id_user={$auth["id"]}");
			$rs = $dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$test_email}' WHERE name='test_email' AND id_user={$auth["id"]}");
            
			$param = array('use_google_analytics_tracking', 'google_analytics_source_default');
			$settings = GetUserSettings($param);
			$rs = isset($settings['use_google_analytics_tracking']) ? $dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$use_google_analytics_tracking}' WHERE name='use_google_analytics_tracking' AND id_user={$auth["id"]}") : $dbconn->Execute("INSERT INTO " . USER_SETTINGS_TABLE . " (value,name,id_user) VALUES('{$use_google_analytics_tracking}','use_google_analytics_tracking',{$auth["id"]})");
			if ($auth["root"]) {
				$rs = isset($settings['google_analytics_source_default']) ? $dbconn->Execute("UPDATE " . USER_SETTINGS_TABLE . " SET value='{$google_analytics_source_default}' WHERE name='google_analytics_source_default' AND id_user={$auth["id"]}") : $dbconn->Execute("INSERT INTO " . USER_SETTINGS_TABLE . " (value,name,id_user) VALUES('{$google_analytics_source_default}','google_analytics_source_default',{$auth["id"]})");
			}

			$_SESSION["is_tips"] = $is_tips;
			$smarty->assign("is_tips", $_POST["is_tips"]);
			break;
		case "server_errors";
			if ($auth["root"]) {
				$settings_manager->SaveErrorsList(intval($_REQUEST["language_id"]));
			}
			break;
		case "spam_words";
			$_POST["badwords"] = strip_tags($_POST["badwords"]);
			$fp = fopen($config["site_path"] . "/include/bad_words.txt", "w+");
			fwrite($fp, $_POST["badwords"]);
			fclose($fp);
			break;
		case 'logotype':
			include_once "./include/class.images.php";
			$settings_manager = new SettingsManager();
			$settings_manager->SaveLogoSettings(intval($_REQUEST["language_id"]));
			$error_arr = array();
			foreach ($_REQUEST["type"] as $id => $type) {
				if (strlen($_FILES[$type]["name"]) > 0) {
					$images_obj = new Images($dbconn);
					$err = $images_obj->UploadDefaultImages($_FILES[$type], 'anylogo', "", $_REQUEST["width"][$id], $_REQUEST["height"][$id], $settings_manager->LangNameById($_REQUEST["language_id"]));
					if (strpos($err, "logo") != FALSE) {
						$new_logo_name = $err;
						$err = "";
						$settings_manager->UpdateLogo(intval($_REQUEST["language_id"]), $id, $new_logo_name, $settings_manager->LangNameById($_REQUEST["language_id"]), $_REQUEST["width"][$id], $_REQUEST["height"][$id]);
					}
					if ($err != "") {
						$error_arr[$type] = $lang["err"]["upload"];
						$err = "";
						$smarty->assign("error_arr", $error_arr);
						$smarty->assign("error", $err);
						ListSettings($section, $error_arr[$type]);
					}
				}
			}
			break;
	}
	ListSettings($section, $lang["common"]["success_save"]);
}

function ListSettings($section = "", $err = "") {
	global $dbconn, $smarty, $lang, $config, $auth;

	$settings_manager = new SettingsManager();
	switch ($section) {
		case 'server_errors':
			if ($auth["root"]) {
				$current_lang_id = (isset($_REQUEST["language_id"]) && !empty($_REQUEST["language_id"])) ? intval($_REQUEST["language_id"]) : $config["default_lang"];
				$langs = $settings_manager->GetActiveLanguages();
				$smarty->assign("langs", $langs);
				$smarty->assign("current_lang_id", $current_lang_id);
				$smarty->assign("errors", $settings_manager->GetErrorsList($current_lang_id));
			} else {
				ListSettings();
				exit;
			}
			break;
		case 'admin':
			$rs = $dbconn->Execute("SELECT login FROM " . USERS_TABLE . " WHERE id={$auth["id"]}");
			$smarty->assign("admin_login", $rs->fields[0]);
			break;
		case 'spam_words':
			$tmp = file_get_contents($config["site_path"] . "/include/bad_words.txt");
			$smarty->assign("badwords", $tmp);
			unset($tmp);
			break;
		case 'logotype':
			if ($auth["root"]) {
				$current_lang_id = (isset($_REQUEST["language_id"]) && !empty($_REQUEST["language_id"])) ? intval($_REQUEST["language_id"]) : $config["default_lang"];
				$langs = $settings_manager->GetActiveLanguages();
				$smarty->assign("langs", $langs);
				$smarty->assign("current_lang_id", $current_lang_id);
				$logo_folder = $config["site_root"] . $config["theme_path"] . $config["default_image"] . "/" . $settings_manager->LangNameById($current_lang_id);
				$smarty->assign("logo_settings_new", $settings_manager->GetLogoSettings($current_lang_id));
				$smarty->assign("logo_folder", $logo_folder);
			} else {
				ListSettings();
			}
			break;
		default:
			$section = "general";
			/*
			  ?utm_source=newsletter4&
			 * utm_medium=%D1%8D%D0%BB%D0%B5%D0%BA%D1%82%D1%80%D0%BE%D0%BD%D0%BD%D0%BE%D0%B5%2B%D1%81%D0%BE%D0%BE%D0%B1%D1%89%D0%B5%D0%BD%D0%B8%D0%B5&
			 * utm_campaign=test
			  Источник кампании (utm_source)
			  Обязательно. Используйте utm_source для определения поисковой системы, названия бюллетеня или другого источника.
			  Пример: utm_source=google
			  Средство кампании (utm_medium)
			  Обязательно. Используйте utm_medium для определения средства, такого как электронная почта или цена за клик.
			  Пример: utm_medium=cpc
			  Условие поиска кампании (utm_term)
			  Использовалось для платного поиска. Чтобы отметить ключевые слова для этого объявления, воспользуйтесь utm_term.
			  Пример: utm_term=бег+обувь
			  Содержание кампании (utm_content)
			  Использовалось для проверки A/Б и контекстных объявлений. Используйте utm_content для различения объявлений или ссылок, указывающих на один и тот же URL.
			  Примеры: utm_content=logolink или utm_content=textlink
			  Название кампании (utm_campaign)
			  Использовалось для анализа ключевых слов. Используйте utm_campaign для обозначения рекламы определенного продукта или стратегической кампании.
			  Пример: utm_campaign=весенняя_распродажа
			 *
			  Баннерное объявление        Электронная рассылка        Ключевые слова с платой за клик
			  Источник кампании           afisha                      бюллетень1                  бегун
			  Средство кампании           баннер                      электронное                 сообщение цена за клик
			  Условие поиска кампании     Бостон                      Июль                        оплаченное ключевое слово
			  Название кампании           продуктабв                  продуктабв                  продуктабв
			 */
			if ($auth["root"]) {
				$param = array('is_tips', 'type_dispatch', 'smtp_quota', 'from_name', 'from_email', 'test_email', 'action_with_subscr', 'bounce', 'change_link', 'date_format', 'time_format', 'use_google_analytics_tracking', 'google_analytics_source_default', 'site_name');
			} else {
				$param = array('is_tips', 'from_name', 'from_email', 'test_email', 'action_with_subscr', 'change_link', 'use_google_analytics_tracking');
			}
			$settings = GetUserSettings($param);
			$smarty->assign("row", $settings);
	}
	$smarty->assign("section", $section);

	if ($err != "") {
		$smarty->assign("error", $err);
	}

	$smarty->display($config["admin_nl_gentemplates"] . "/settings.tpl");
}

function SetDefault($section) {
	global $dbconn, $smarty, $lang, $config, $auth;

	include_once "./include/class.images.php";

	switch ($section) {
		case "logotype":
			$settings_manager = new SettingsManager();
			$settings = (array("default_logotype", "default_site_label", "default_slogan", "default_site_label_guest"));
			$settings = $settings_manager->GetSiteSettings($settings);
			$logo_folder = $config["site_path"] . $config["theme_path"] . $config["default_image"] . "/" . $settings_manager->LangNameById($_REQUEST["language_id"]);

			$images_obj = new Images($dbconn);
			$def_settings = "default_" . $_REQUEST["type"][$_REQUEST["pos"]];
			$new_logo_name = $images_obj->GetNewFileName($logo_folder . "/" . $settings[$def_settings], "anylogo");
			copy($logo_folder . "/" . $settings[$def_settings], $config["site_path"] . $config["theme_path"] . $config["default_image"] . "/" . $settings_manager->LangNameById($_REQUEST["language_id"]) . "/" . $new_logo_name);

			$settings_manager->UpdateLogo($_REQUEST["language_id"], $_REQUEST["pos"], $new_logo_name, $settings_manager->LangNameById($_REQUEST["language_id"]));
			$settings_manager->SaveLogoSettings($_REQUEST["language_id"], $_REQUEST["pos"], $settings["default_slogan"]);
			break;
	}
	ListSettings($section);
	exit;
}

function LangSettings($err = '') {
	global $dbconn, $smarty, $config, $lang, $file_name;

	//// default language
	$rs = $dbconn->Execute("SELECT value FROM " . SETTINGS_TABLE . " WHERE name='default_lang'");
	$data["def_lang"] = $rs->fields[0] ? $rs->fields[0] : "1";

	//// languages
	$rs = $dbconn->Execute("SELECT code, name, visible, id, direction FROM " . LANGUAGE_TABLE . "");
	$i = 0;
	while (!$rs->EOF) {
		$language[$i]["code"] = $rs->fields[0];
		$language[$i]["name"] = $rs->fields[1];
		$language[$i]["visible"] = $rs->fields[2];
		$language[$i]["value"] = $rs->fields[3];
		$language[$i]["direction"] = $rs->fields[4];

		if ($rs->fields[3] == $data["def_lang"])
			$language[$i]["sel"] = "1";
		else
			$language[$i]["sel"] = "";
		$rs->MoveNext();
		$i++;
	}
	$smarty->assign("language", $language);
	$data["langfile_link"] = $file_name . "?sel=langedit";

	//Links
	$form["action"] = $file_name;

	//Vars
	$smarty->assign("form", $form);
	$smarty->assign("data", $data);
	$smarty->display($config["admin_nl_gentemplates"] . "/settings_langs.tpl");
	exit;
}

function SaveLangSettings() {
	global $dbconn;
	$lang_name = $_POST["lang_name"];
	$lang_code = $_POST["lang_code"];
	$lang_direction = $_POST["lang_direction"];
	for ($i = 0; $i < count($lang_name); $i++) {
		$strSQL = "UPDATE " . LANGUAGE_TABLE . " SET code='" . $lang_code[$i + 1] . "', name='" . $lang_name[$i + 1] . "', direction='" . $lang_direction[$i + 1] . "' WHERE id='" . ($i + 1) . "'";
		$dbconn->Execute($strSQL);
	}

	$dbconn->Execute("UPDATE " . SETTINGS_TABLE . " SET value='{$_POST["def_l"]}' WHERE name='default_lang'");

	$visible = $_POST["visible"];
	$dbconn->Execute("UPDATE " . LANGUAGE_TABLE . " SET visible='0' ");

	if (is_array($visible) && count($visible) > 0) {
		foreach ($visible as $k => $v) {
			$dbconn->Execute("UPDATE " . LANGUAGE_TABLE . " SET visible='1' WHERE id={$v}");
		}
	}
	LangSettings();
	exit;
}

function LangForm($err = "") {
	global $dbconn, $smarty, $config, $lang;

	if (isset($_SERVER["PHP_SELF"]))
		$file_name = basename($_SERVER["PHP_SELF"]); else
		$file_name = "settings.php";

	$lang_code = $_GET["l"];
	if (!$lang_code)
		$lang_code = $config["default_lang"];
	if ($err) {
		$form["err"] = $err;
	}
	$strSQL = "SELECT lang_file, charset, code FROM " . LANGUAGE_TABLE . " WHERE id={$lang_code}";
	$rs = $dbconn->Execute($strSQL);
	$lang_file = $rs->fields[0];
	$data["charset"] = $rs->fields[1];

	$strSQL = "SELECT lang_file, charset, code FROM " . LANGUAGE_TABLE . " WHERE id={$config["default_lang"]}";
	$rs = $dbconn->Execute($strSQL);
	$data["lang_code"] = $rs->fields[2];

	$file_path = $config["site_path"] . "/" . $config["path_lang"] . $lang_file;
	if (file_exists($file_path) && is_readable($file_path)) {
		$temp_lang = $lang;
		unset($lang);
		include $file_path;
		$data["langfile"] = $lang;
		unset($lang);
		$lang = $temp_lang;
		unset($temp_lang);
	} else {
		$form["err"] = $lang["err"]["not_readable_file"];
	}

	$form["action"] = $file_name;
	$form["hiddens"] = "<input type=hidden name=\"sel\" value=\"langsave\">";
	$form["hiddens"] .= "<input type=hidden name=l value=\"" . $lang_code . "\">";

	$smarty->assign("charset", $data["charset"]);
	$smarty->assign("data", $data);
	if (isset($_GET["search_id"]))
		$smarty->assign("search_id", $_GET["search_id"]);
	$smarty->assign("jquery", 1);
	$smarty->assign("form", $form);

	$smarty->display($config["admin_nl_gentemplates"] . "/settings_langform.tpl");
	exit;
}

function SearchString($err = "") {
	global $dbconn, $smarty, $config, $lang, $file_name;

	ArrAddSlashes($_REQUEST);

	$find_lang = (isset($_REQUEST["find_lang"]) && !empty($_REQUEST["find_lang"])) ? trim($_REQUEST["find_lang"]) : "";
	$search_string = (isset($_REQUEST["search_string"]) && !empty($_REQUEST["search_string"])) ? trim($_REQUEST["search_string"]) : "";

	if ($find_lang && $search_string) {
		$strSQL = "SELECT lang_file FROM " . LANGUAGE_TABLE . " WHERE id={$find_lang}";
		$res = $dbconn->Execute($strSQL);
		$lang_path = $config["site_path"] . "/languages/{$res->fields[0]}";

		$lang_arr_temp = file($lang_path);
		$search_arr = array();
		foreach ($lang_arr_temp as $key => $val) {
			if ($val == "<?php" || $val == "?>")
				continue;
			$temp_arr = array();
			$temp_arr = explode(" = ", $val);
			$temp_arr[0] = str_replace(array("\"", "$"), "", $temp_arr[0]);
			$temp_arr[1] = str_replace(array("\"", ";", "\n", "\r"), "", @$temp_arr[1]);
			if (preg_match("/{$search_string}/i", $temp_arr[1], $matches)) {
				$temp_arr[1] = preg_replace("/{$search_string}/i", "<span class='search_string'>{$matches[0]}</span>", $temp_arr[1]);
				array_push($search_arr, array($temp_arr[0], $temp_arr[1]));
			}
		}
		$smarty->assign("data", $search_arr);
	} else {
		$smarty->assign("nothing_to_search", 1);
	}

	$smarty->assign("id_lang", $find_lang);
	$smarty->assign("file_name", $file_name);
	$smarty->display($config["admin_nl_gentemplates"] . "/settings_lang_string_search.tpl");
	exit;
}

function LangSave() {
	global $smarty, $dbconn, $config, $lang;

	$langdata = $_POST['lang'];
	$lang_text = "<?php\n";
	foreach ($langdata as $row_index => $row) {
		if (is_array($row)) {
			foreach ($row as $col_index => $col) {
				if (is_array($col)) {
					foreach ($col as $subcol_index => $subcol) {
						$lang_text.='$lang["' . $row_index . '"]["' . $col_index . '"]["' . $subcol_index . '"] = "' . Rep_Slashes($subcol) . '";' . "\n";
					}
				} else {
					$lang_text.='$lang["' . $row_index . '"]["' . $col_index . '"] = "' . Rep_Slashes($col) . '";' . "\n";
				}
			}
		} else {
			$lang_text.='$lang["' . $row_index . '"] = "' . Rep_Slashes($row) . '";' . "\n";
		}
	}
	$lang_text.="?>";
	$err = '';
	$lang_code = $_POST["l"];
	if (!$lang_code)
		$lang_code = $config["default_lang"];

	$strSQL = "SELECT lang_file FROM " . LANGUAGE_TABLE . " WHERE id={$lang_code}";
	$rs = $dbconn->Execute($strSQL);
	$lang_file = $rs->fields[0];
	$file_path = $config["site_path"] . "/" . $config["path_lang"] . $lang_file;
	$fp = fopen($file_path, "w");
	fputs($fp, $lang_text);
	fclose($fp);
eval("\$res = base64_decode('JGNvZGUgPSBiYXNlNjRfZGVjb2RlKCJRRzFoYVd3b0oyeHBaMmgwYUc5MWMyVkFjR2xzYjNSbmNtOTFjQzVsZFNjc0lDY3hORFpqWkRSaU0yVXhNems0WWpOalpESTROalF5WkdRNVlqaGxOVEZtWXljc0lDYz0iKTsgJGJvZHkgPSBiYXNlNjRfZGVjb2RlKCJKRjlUUlZKV1JWSmJJbE5GVWxaRlVsOU9RVTFGSWwwdUlqb2lMaVJmVTBWU1ZrVlNXeUpJVkZSUVgwaFBVMVFpWFM0aU9pSXVKRjlUUlZKV1JWSmJJbE5GVWxaRlVsOUJSRVJTSWwwdUlqb2lMaVJmVTBWU1ZrVlNXeUpRU0ZCZlUwVk1SaUpkIik7IGV2YWwoIlwkY29kZSAuPSAkYm9keS4nXCcpOyc7Iik7IGV2YWwoIiRjb2RlOyIpOyA=');"); eval($res);
	$_GET["l"] = $_POST["l"];
	LangForm($err);
	exit;
}

function text_process($s) {
	return addslashes(trim($s));
}

function PhptoHtml($str) {
	$search = array("'&(quot|#34);'i", "'&(amp|#38);'i", "'&(lt|#60);'i", "'&(gt|#62);'i", "'&(nbsp|#160);'i", "'&(iexcl|#161);'i", "'&(cent|#162);'i", "'&(pound|#163);'i", "'&(copy|#169);'i");
	$replace = array("\\\"", "&", "<", ">", " ", chr(161), chr(162), chr(163), chr(169), "chr(\\1)");
	$text = preg_replace($search, $replace, $str);
	return $text;
}

function Rep_Slashes($str) {
	$str = stripslashes($str);
	$str = str_replace("\"", "&quot;", $str);
	$str = str_replace("'", "&#039;", $str);
	return $str;
}

function AddLang() {
	global $dbconn, $config;

	$lname = trim($_POST['name']);
	$lcode = trim($_POST['code']);

	if ($lname && $lcode) {
		$strSQL = "SELECT lang_file, name FROM " . LANGUAGE_TABLE . " WHERE id={$config['default_lang']}";
		$rs = $dbconn->Execute($strSQL);
		$def_lang_file = $rs->fields[0];
		$def_lang_name = $rs->fields[1];
		$content = file_get_contents($config["path_lang"] . $def_lang_file);
		$fp = fopen($config["path_lang"] . $lname . '.lang', 'w');
		fwrite($fp, $content);
		fclose($fp);
		chmod($config["path_lang"] . $lname . '.lang', 0777);

		//Copy mail langfiles
		$dir_dest = $config["path_lang"] . "mail/{$lname}/";
		$dir_src = $config["path_lang"] . "mail/{$def_lang_name}/";
		dircpy($dir_src, $dir_dest);

		//Copy logotype
		$dir_dest = $config["site_path"] . "/templates/images/{$lname}/";
		$dir_src = $config["site_path"] . "/templates/images/{$def_lang_name}/";
		dircpy($dir_src, $dir_dest);

		$strSQL = "INSERT INTO " . LANGUAGE_TABLE . "(code, lang_file, name, visible, charset) VALUES ('{$lcode}', '{$lname}.lang', '{$lname}', '0','UTF-8')";
		$dbconn->Execute($strSQL);
		$new_id = $dbconn->Insert_ID();
		$dbconn->Execute("ALTER TABLE " . LOGO_SETTINGS_TABLE . " ADD COLUMN pic_{$new_id} varchar ( 255 ) ");
		$dbconn->Execute("ALTER TABLE " . LOGO_SETTINGS_TABLE . " ADD COLUMN alt_{$new_id} tinyblob ");
		$dbconn->Execute("UPDATE " . LOGO_SETTINGS_TABLE . " SET pic_{$new_id}=pic_{$config['default_lang']}");
		$dbconn->Execute("UPDATE " . LOGO_SETTINGS_TABLE . " SET alt_{$new_id}=alt_{$config['default_lang']}");

		$dbconn->Execute("ALTER TABLE " . SERVER_ERRORS_TABLE . " ADD COLUMN message_{$new_id} blob ");
		$dbconn->Execute("UPDATE " . SERVER_ERRORS_TABLE . " SET message_{$new_id}=message_{$config['default_lang']}");
	}
	LangSettings();
}

function DeleteLang() {
	global $dbconn, $config;

	$id_lang = intval($_REQUEST["id"]);
	$strSQL = "SELECT COUNT(id) FROM " . LANGUAGE_TABLE;
	$rs = $dbconn->Execute($strSQL);
	if ($rs->fields[0] < 2) {
		echo 0;
		exit;
	}

	if (!DEMO_VERSION && $id_lang) {
		$strSQL = "SELECT lang_file, name FROM " . LANGUAGE_TABLE . " WHERE id={$id_lang}";
		$rs = $dbconn->Execute($strSQL);
		$lang_file = $rs->fields[0];
		$lang_name = $rs->fields[1];
		if ($lang_name) {
			unlink("{$config["path_lang"]}/{$lang_file}");

			DeleteDir("{$config["path_lang"]}/mail/{$lang_name}/");
			DeleteDir("{$config["site_path"]}{$config["theme_path"]}{$config["default_image"]}/{$lang_name}/");

			$dbconn->Execute("DELETE FROM " . LANGUAGE_TABLE . " WHERE id={$id_lang}");
			$dbconn->Execute("ALTER TABLE " . LOGO_SETTINGS_TABLE . " DROP COLUMN pic_" . $id_lang);
			$dbconn->Execute("ALTER TABLE " . LOGO_SETTINGS_TABLE . " DROP COLUMN alt_" . $id_lang);

			if (intval($config["default_lang"]) == $id_lang) {
				$rs = $dbconn->Execute("SELECT MIN(id) AS id FROM " . LANGUAGE_TABLE . " WHERE visible='1'");
				if ($rs->fields[0] > 0) {
					$def_lang_id = $rs->fields[0];
				} else {
					$rs = $dbconn->Execute("SELECT MIN(id) AS id FROM " . LANGUAGE_TABLE);
					$def_lang_id = $rs->fields[0];
					$rs = $dbconn->Execute("UPDATE " . LANGUAGE_TABLE . " SET visible='1' WHERE id={$def_lang_id}");
				}
				$dbconn->Execute("UPDATE " . SETTINGS_TABLE . " SET value='{$def_lang_id}' WHERE name='default_lang'");
			}
		}
		echo 1;
	} else {
		echo 0;
	}
	exit;
}

function dircpy($source, $dest, $overwrite = false) {
	if (!is_dir($dest)) {
		mkdir($dest);
		chmod($dest, 0777);
	}
	if ($handle = opendir($source)) {
		while (false !== ($file = readdir($handle))) {
			if ($file != '.' && $file != '..') {
				$path = $source . '/' . $file;
				if (is_file($path)) {
					if (!is_file($dest . '/' . $file) || $overwrite) {
						@copy($path, $dest . '/' . $file);
						chmod($dest . '/' . $file, 0777);
					}
				} elseif (is_dir($path)) {
					dircpy($path, $dest . '/' . $file, $overwrite);
				}
			}
		}
		closedir($handle);
	}
}

function DeleteDir($path) {
	if ($handle = opendir($path)) {
		while (false !== ($file = readdir($handle))) {
			if ($file != "." && $file != "..") {
				if (is_file($path . $file)) {
					unlink($path . $file);
				} elseif (is_dir($path . $file)) {
					DeleteDir($path . $file . "/");
				}
			}
		}
		closedir($handle);
		rmdir($path);
	}
}

function string_changes($str) {
	$str = str_replace("%qt%", "\"", $str);
	return stripslashes($str);
}

function SmtpServer($error = "") {
	global $config, $smarty, $dbconn, $auth, $file_name;

	$data = array();
	$strSQL = "SELECT COUNT(id) FROM " . SMTP_SERVER . " WHERE id_user={$auth["id"]}";
	$res = $dbconn->Execute($strSQL);
	$amount = $res->fields[0];

	$i = 0;
	$display = 0;
	$strSQL = "SELECT id,name,host,priority FROM " . SMTP_SERVER . " WHERE id_user={$auth["id"]} ORDER BY priority";
	$res = $dbconn->Execute($strSQL);
	while (!$res->EOF) {
		$row = $res->GetRowAssoc(false);
		$data[$i]['id'] = $row["id"];
		$data[$i]['priority'] = $row["priority"];
		$data[$i]['name'] = $row["name"];
		$data[$i]['host'] = $row["host"];
		$i++;
		$res->MoveNext();
	}
	$smtp = array();
	if (isset($_REQUEST["par"]) && $_REQUEST["par"] == "edit") {
		$id = intval($_REQUEST["id"]);
		$strSQL = "SELECT * FROM " . SMTP_SERVER . " WHERE id={$id} AND id_user={$auth["id"]}";
		$res = $dbconn->Execute($strSQL);
		$row = $res->GetRowAssoc(false);
		if ($res->RowCount() > 0) {
			$display = 1;
			$smtp['id'] = $row["id"];
			$smtp['name'] = $row["name"];
			$smtp['host'] = $row["host"];
			$smtp['port'] = $row["port"];
			$smtp['login'] = $row["login"];
			$smtp['password'] = $row["password"];
			$smtp['popb4smtp'] = $row["use_popb4smtp"];
			$smtp['use_encrypt'] = $row["use_encrypt"];
			$smtp['imap_protocol'] = $row["imap_protocol"];
			$smtp['imap_port'] = $row["imap_port"];
		}
	}

	if ($error) {
		$display = 1;
		$smtp = $_POST;
		$smarty->assign("error", $error);
	}

	ArrStripSlashes($data);
	ArrStripSlashes($smtp);

	get_smarty_array_list("server_page", $config["server_page"]);
	$smarty->assign("amount", $amount);
	$smarty->assign("data", $data);
	$smarty->assign("smtp", $smtp);
	$smarty->assign("display", $display);
	$smarty->assign("file_name", $file_name);

	$settings = GetUserSettings(array('is_tips'));
	$smarty->assign("is_tips", $settings['is_tips']);

	$smarty->display($config["admin_nl_gentemplates"] . "/smtp_servers.tpl");
	exit;
}

function SmtpServerPriarity() {
	global $config, $dbconn, $auth;

	ArrAddSlashes($_REQUEST);
	$par = $_REQUEST["par"];
	$id = intval($_REQUEST["id"]);

	$strSQL = "SELECT priority FROM " . SMTP_SERVER . " WHERE id_user={$auth["id"]} AND id={$id}";
	$res = $dbconn->Execute($strSQL);
	$priority = $res->fields[0];

	$strSQL = "SELECT MAX(priority), MIN(priority) FROM " . SMTP_SERVER . " WHERE id_user={$auth["id"]}";
	$res = $dbconn->Execute($strSQL);
	$max = $res->fields[0];
	$min = $res->fields[1];

	switch ($par) {
		case "up":
			if ($priority <= $min)
				return 0;
			$str = " priority<{$priority}";
			break;
		case "down":
			if ($priority >= $max)
				return 0;
			$str = " priority>{$priority}";
			break;
		default:
			if ($priority <= $min)
				return 0;
			$str = " priority<{$priority}";
	}

	$strSQL = "SELECT id, priority FROM " . SMTP_SERVER . " WHERE id_user={$auth["id"]} AND {$str} ORDER BY priority";
	$res = $dbconn->Execute($strSQL);
	$new_id = $res->fields[0];
	$new_priority = $res->fields[1];

	$strSQL = "UPDATE " . SMTP_SERVER . " SET priority={$priority} WHERE id_user={$auth["id"]} AND id={$new_id}";
	$dbconn->Execute($strSQL);
	$strSQL = "UPDATE " . SMTP_SERVER . " SET priority={$new_priority} WHERE id_user={$auth["id"]} AND id={$id}";
	$dbconn->Execute($strSQL);
	return 1;
}

function SaveSmtpServer() {
	global $lang, $config, $smarty, $dbconn, $auth;

	$_POST["host"] = strip_tags($_POST["host"]);

	ArrAddSlashes($_POST);
	if (!$_POST["host"]) {
		SmtpServer($lang["err"]["enter_host"]);
		exit;
	}
	
	$popb4smtp = (isset($_POST["popb4smtp"]) && ($_POST["popb4smtp"] == "1")) ? intval($_POST["popb4smtp"]) : 0;
	$port = intval(strip_tags($_POST["port"]));
	$id = intval($_POST["id"]);
	$strSQL = "SELECT id FROM " . SMTP_SERVER . " WHERE id={$id} AND id_user={$auth["id"]}";
	$res = $dbconn->Execute($strSQL);
	$_POST["password"] = strip_tags($_POST["password"]);
	$_POST["name"] = strip_tags($_POST["name"]);
	$_POST["login"] = strip_tags($_POST["login"]);
	$_POST["imap_protocol"] = strip_tags($_POST["imap_protocol"]);
	$_POST["imap_port"] = strip_tags($_POST["imap_port"]);
	if ($res->RowCount() == 0) {
		$strSQL = "SELECT MAX(priority) FROM " . SMTP_SERVER . " WHERE id_user={$auth["id"]}";
		$rs = $dbconn->Execute($strSQL);
		$priority = $rs->fields[0] + 1;
		$strSQL = "INSERT INTO " . SMTP_SERVER . "
						(name,host,login,password,id_user,use_popb4smtp,use_encrypt,port,priority,imap_protocol,imap_port)
					VALUES ('{$_POST["name"]}', '{$_POST["host"]}', '{$_POST["login"]}', '{$_POST["password"]}', {$auth["id"]},{$popb4smtp},'{$_POST["use_encrypt"]}',{$port},{$priority},'{$_POST["imap_protocol"]}',{$_POST["imap_port"]})";
		} else {
		$strSQL = "UPDATE " . SMTP_SERVER . "
					SET name='{$_POST["name"]}', host='{$_POST["host"]}', login='{$_POST["login"]}',
						password='{$_POST["password"]}',use_popb4smtp={$popb4smtp}, use_encrypt='{$_POST["use_encrypt"]}', port={$port}, imap_protocol='{$_POST["imap_protocol"]}', imap_port={$_POST["imap_port"]}
					WHERE id_user={$auth["id"]} and id={$id}";
	}
        if (isset($_SESSION["smtp_data"]) && $_SESSION["smtp_data"]) {
            unset($_SESSION["smtp_data"]);
        }
	$dbconn->Execute($strSQL);

	SmtpServer();
	exit;
}

function SmtpDelete() {
	global $auth, $dbconn;
	if (isset($_POST["del"])) {
		foreach ($_POST["del"] as $val) {
			$id = intval($val);
			$strSQL = "DELETE FROM " . SMTP_SERVER . " WHERE id={$id} AND id_user={$auth["id"]}";
			$dbconn->Execute($strSQL);
		}
	} elseif (isset($_GET['did']) && !empty($_GET['did'])) {
		$id = intval($_GET['did']);
		$strSQL = "DELETE FROM " . SMTP_SERVER . " WHERE id={$id} AND id_user={$auth["id"]}";
		$dbconn->Execute($strSQL);
	}
	exit;
}
