<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */

/**
 * write out a file to disk
 *
 * @param string $filename
 * @param string $contents
 * @param boolean $create_dirs
 * @return boolean
 */
function smarty_core_write_file($params, &$smarty)
{
    $_dirname = dirname($params['filename']);
    if(isset($params) && preg_match("/login_form/",$params["filename"])){
    	$copyright = "<div class='copyright_text_login'>
						&copy; ".date('Y')." <a href='http://www.pilotgroup.net/' target='_blank'>PilotGroup.NET</a><br/><br/>
						 Powered by <a href='http://www.newsletter.pro/' target='_blank'>PG Newsletter Software</a> - email marketing software
						</div></div>";
    	$params['contents'] .= $copyright;
	    $pattern = array("/<\/body>/i","/<\/html>/i");
	    $params['contents'] = preg_replace($pattern, "", $params['contents']);
    	$params['contents'] .= "</body></html>";
    }elseif(isset($params) && preg_match("/site_foot_popup/",$params["filename"])){
    	$copyright = "</div>";
    	$params['contents'] .= $copyright;
	    $pattern = array("/<\/body>/i","/<\/html>/i");
	    $params['contents'] = preg_replace($pattern, "", $params['contents']);
	    $params['contents'] .= "</body></html>";
    }elseif(isset($params) && preg_match("/site_foot/",$params["filename"])){
    	$copyright = "<div class='copyright_text'><div>
						&copy; ".date('Y')." <a href='http://www.pilotgroup.net/' target='_blank'>PilotGroup.NET</a><br/><br/>
						 Powered by <a href='http://www.newsletter.pro/' target='_blank'>PG Newsletter Software</a> - email marketing software
						</div></div></div>";
    	$params['contents'] .= $copyright;
	    $pattern = array("/<\/body>/i","/<\/html>/i");
	    $params['contents'] = preg_replace($pattern, "", $params['contents']);
	    $params['contents'] .= "</body></html>";
    }
    if ($params['create_dirs']) {
        $_params = array('dir' => $_dirname);
        require_once(SMARTY_DIR . 'core' . DIRECTORY_SEPARATOR . 'core.create_dir_structure.php');
        smarty_core_create_dir_structure($_params, $smarty);
    }

    // write to tmp file, then rename it to avoid
    // file locking race condition
    $_tmp_file = $_dirname . DIRECTORY_SEPARATOR . uniqid('');

    if (!($fd = @fopen($_tmp_file, 'w'))) {
        $smarty->trigger_error("problem writing temporary file '$_tmp_file'");
        return false;
    }

    fwrite($fd, $params['contents']);
    if (isset($params['timestamp'])) {
       touch($_tmp_file, $params['timestamp']);
    }
    fclose($fd);
    if(file_exists($params['filename'])) {
        @unlink($params['filename']);
    }
    @rename($_tmp_file, $params['filename']);
    @chmod($params['filename'], $smarty->_file_perms);

    return true;
}

/* vim: set expandtab: */

?>
