<?php
include "include/config.php";
include "include/common_functions.php";
include "include/functions_auth.php";
include "common.php";
include "include/config.inc.php";
include "include/newsletters_function.php";

login_cheeck($auth);
$mode = IsFileAllowed($auth["id"], GetRightModulePath(__FILE__));
$file_name = $config["server"]."/autoresponders.php";
$smarty->assign("form_action",$file_name);
$this_page="autoresponders";
$smarty->assign("this_page",$this_page);

if($mode == 1){
	@$sel =$_POST["sel"]?$_POST["sel"]:$_GET["sel"];
	@$param =$_REQUEST["param"]?$_REQUEST["param"]:"general";
	switch($sel){
		case "delete": if(IsFunctionAllowed($auth["id"],50)){DeleteNewsletter();}else{ListNewsletter();} break;
		case "view_step_1": ListAutoresponder($param); break;
		case "create_step1": if(IsFunctionAllowed($auth["id"],49)){Create_Step1();}else{ListNewsletter();} break;
		case "save_step1": Save_Step1(); break;
		case "save_step2": Save_Step2(); break;
		case "change_status": ChangeStatusR(); break;
		case "view": ViewNewsletter(); break;
		case "location": Location(); break;
		case "trigger": ListTrigger(); break;
		case "create_trigger": CreateTrigger(); break;
		case "save_trigger": SaveTrigger(); break;
		case "delete_trigger": DeleteTrigger(); break;
		case "change_status_trigger": ChangeStatus(); break;
		default: ListAutoresponder();
	}
}

function ListAutoresponder($param="general"){
	global $lang, $config, $smarty, $dbconn, $auth;

	AdminMainMenu("autoresponders");
	if(IsFunctionAllowed($auth["id"],49)){$smarty->assign("create_responder",1);}
	if(IsFunctionAllowed($auth["id"],50)){$smarty->assign("delete_responder",1);}

	$data=array();
	if($param=="general"){
		$data = getLists();
		ArrStripSlashes($data);
		foreach ($data as $key =>$val){
			$strSQL = "SELECT COUNT(id)
							FROM ".AUTORESPONDER_TABLE."
							WHERE id_user={$auth["id"]} AND id IN (
								SELECT id_autoresponder FROM ".AUTORESPONDER_LIST_TABLE." WHERE id_user={$auth["id"]} AND id_list={$val["id"]}
							)";
			$res=$dbconn->Execute($strSQL);
			$data[$key]["count_responder"] = $res->fields[0];
		}
	}elseif ($param=="view_list"){
		$id_list = intval($_REQUEST["id_list"]);
		$strSQL = "SELECT COUNT(id) FROM ".AUTORESPONDER_TABLE."
						WHERE id_user={$auth["id"]} AND id IN (
							SELECT id_autoresponder FROM ".AUTORESPONDER_LIST_TABLE." WHERE id_user={$auth["id"]} AND id_list={$id_list}
						)";
		$res=$dbconn->Execute($strSQL);
		$amount = $res->fields[0];

		$i=0;
		$strSQL = "SELECT id,name, DATE_FORMAT(date,'{$config["date_format"]}') as date,format, status,period
							FROM ".AUTORESPONDER_TABLE."
							WHERE id_user={$auth["id"]} AND id IN (
								SELECT id_autoresponder FROM ".AUTORESPONDER_LIST_TABLE." WHERE id_user={$auth["id"]} AND id_list={$id_list}
							)";
		$res=$dbconn->Execute($strSQL);
		while(!$res->EOF){
			$data[$i]['id'] = $res->fields[0];
			$data[$i]['name'] = $res->fields[1];
			$data[$i]['date'] = $res->fields[2];
			$data[$i]['format'] = $res->fields[3];
			$data[$i]['id_list'] = $id_list;
			$data[$i]['format_str'] = $lang["newsletters"][$res->fields[3]];
			$data[$i]['status'] = ($res->fields[4]=="1")?"global":"";
			if($res->fields[5]=="0"){
				$data[$i]['send_rule'] = $lang["autoresponders"]["send_1"];
			}else{
				$arr = explode("|",$res->fields[5]);
				$qwe = $arr[0]." ".$lang["pays"]["periods"][$arr[1]];
				$data[$i]['send_rule'] = str_replace("[period]",$qwe,$lang["autoresponders"]["status_send"]);
			}
			$i++;
			$res->MoveNext();
		}
		ArrStripSlashes($data);

		$smarty->assign("amount",$amount);
		$smarty->assign("id_list",$id_list);
	}
	get_smarty_array_list("newsletter_page", $config["newsletter_page"]);
	$smarty->assign("data",$data);
	$smarty->assign("param",$param);
	$smarty->display($config["admin_nl_gentemplates"]."/autoresponders.tpl");
}

function Create_Step1($error=0){
	global $smarty, $config, $auth, $dbconn, $lang;

	AdminMainMenu("autoresponders");
	$param = $_REQUEST['param']?$_REQUEST['param']:"";

	if ($param==""){
		$data = getLists();
		ArrStripSlashes($data);

		foreach ($data as $key =>$val){
			$strSQL = "SELECT COUNT(id)
							FROM ".AUTORESPONDER_TABLE."
							WHERE id_user={$auth["id"]} AND id IN (
								SELECT id_autoresponder FROM ".AUTORESPONDER_LIST_TABLE." WHERE id_user={$auth["id"]} AND id_list={$val["id"]}
							)";
			$res=$dbconn->Execute($strSQL);
			$data[$key]["count_responder"] = $res->fields[0];
		}

		$smarty->assign("data",$data);
	}elseif($param=="create_list"){
		$id = intval($_GET["id"]);
		$id_list = intval($_GET["id_list"]);
		$data = array();
		$data["send_1"] = 1;
		if($id){
			$strSQL = "SELECT id,name,subject, format,period
							FROM ".AUTORESPONDER_TABLE."
							WHERE id_user={$auth["id"]} AND id={$id}";
			$res=$dbconn->Execute($strSQL);
			$data["id"] = $res->fields[0];
			$data["name"] = $res->fields[1];
			$data["subject"] = $res->fields[1];
			$data["format"] = $res->fields[3];
			if($res->fields[4]=="0"){
				$data["send_1"] = 1;
			}else{
				$data["send_1"] = 2;
				$arr = explode("|",$res->fields[4]);
				$data["period"] = $arr[0];
				$data["period_time"] = $arr[1];
			}
		}
		ArrStripSlashes($data);
		if($error){
			$smarty->assign("error",$lang["err"]["empty_newsl_subject"]);
			$smarty->assign("data",$_POST);
		}else{
			$smarty->assign("data",$data);
		}
		$smarty->assign("id_list",$id_list);
		$smarty->assign("temp",getTemplates());
	}else{
		$id = intval($_GET["id"]);
		$id_list = intval($_GET["id_list"]);
		$data = array();
		$data["send_1"] = 1;
		if($id){
			$strSQL = "SELECT id,name,subject, format,period
							FROM ".AUTORESPONDER_TABLE."
							WHERE id_user={$auth["id"]} AND id IN (
								SELECT id_autoresponder FROM ".AUTORESPONDER_LIST_TABLE." WHERE id_user={$auth["id"]} AND id_list={$id_list}
							)";
			$res=$dbconn->Execute($strSQL);
			$data["id"] = $res->fields[0];
			$data["name"] = $res->fields[1];
			$data["subject"] = $res->fields[1];
			$data["format"] = $res->fields[3];
			if($res->fields[4]=="0"){
				$data["send_1"] = 1;
			}else{
				$data["send_1"] = 2;
				$arr = explode("|",$res->fields[4]);
				$data["period"] = $arr[0];
				$data["period_time"] = $arr[1];
			}
		}
		ArrStripSlashes($data);
		if($error){
			$smarty->assign("error",$lang["err"]["empty_newsl_subject"]);
			$smarty->assign("data",$_POST);
		}else{
			$smarty->assign("data",$data);
		}
		$smarty->assign("id_list",$id_list);
		$smarty->assign("temp",getTemplates());
	}
	$smarty->assign("param",$param);
	$smarty->display($config["admin_nl_gentemplates"]."/autoresponders_create_step1.tpl");
}

function Save_Step1(){
	global $smarty, $config, $auth, $dbconn;

	if($_POST["subject"] == "" || $_POST["name"] == ""){
		Create_Step1(1);
		exit;
	}
	if($_POST["send_1"]=="1"){
		$period = 0;
	}else{
		$period = "{$_POST["period"]}|{$_POST["period_time"]}";
	}
	ArrAddSlashes($_POST);
	$id = intval($_POST["id"]);
	$id_list = intval($_POST["id_list"]);
	if(!$id){
		$strSQL = "INSERT INTO ".AUTORESPONDER_TABLE." (name,subject,match_confirm,format,period,date,id_user,status)
						VALUES('{$_POST["name"]}','{$_POST["subject"]}','{$_POST["match_confirm"]}','{$_POST["format"]}','{$period}', NOW(),{$auth["id"]},1)";
		$dbconn->Execute($strSQL);
		$id = $dbconn->_insertid();
		$strSQL = "INSERT INTO ".AUTORESPONDER_LIST_TABLE." (id_autoresponder,id_list,date_status,id_user) VALUES({$id},{$id_list},NOW(),{$auth["id"]})";
		$dbconn->Execute($strSQL);
	}else{
		$strSQL = "UPDATE ".AUTORESPONDER_TABLE." SET name='{$_POST["name"]}', subject='{$_POST["subject"]}',match_confirm='{$_POST["match_confirm"]}',format='{$_POST["format"]}',period='{$period}' WHERE id={$id} AND id_user={$auth["id"]}";
		$dbconn->Execute($strSQL);
	}
	Create_Step2($id);
	exit;
}

function Create_Step2($id, $error=0){
	global $smarty, $config, $auth, $dbconn, $lang;

	AdminMainMenu("autoresponders");
	$data = array();
	$strSQL = "SELECT id,body,body_text,format FROM ".AUTORESPONDER_TABLE." WHERE id={$id} AND id_user={$auth["id"]}";
	$res=$dbconn->Execute($strSQL);
	$row = $res->GetRowAssoc(false);
	$data["id"] = $row["id"];
	$data["body"] = $row["body"];
	$data["body_text"] = $row["body_text"];
	$data["format"] = $row["format"];

	if(isset($_POST["temp_id"])){
		$content = getTemplates(intval($_POST["temp_id"]));
		if ($data["format"] == "text") {
			$data["body_text"] = token2br($content["body_text"]);
		}else{
			$data["body"] = token2br($content["body_html"]);
		}
	}
	ArrStripSlashes($data);

	if($error){
		$smarty->assign("error",$lang["err"]["empty_newsl_content"]);
		$data = $_POST;
	}

	//Initialize FCKEditor
	include_once "fckeditor/fckeditor.php";

	$editor=new FCKeditor('body_html');
	$editor->Value=$data["body"];
	$editor->Width='100%';
	$editor->Height='500';
	$editor->BasePath=$config["server"].'/fckeditor/';
	$editor->Config['AutoDetectLanguage']	= false ;
	$fck_lang = file_exists($config["site_path"].'/fckeditor/editor/lang/'.$config["lang_code"].".js")?$config["lang_code"]:"en";
	$editor->Config['DefaultLanguage']		= $fck_lang;
	$smarty->assign("editor",$editor->CreateHtml());
	//Initialize FCKEditor

	$smarty->assign("data",$data);
	$smarty->assign("id_list",intval($_POST["id_list"]));
	$smarty->display($config["admin_nl_gentemplates"]."/autoresponders_create_step2.tpl");
	exit;
}

function Save_Step2(){
	global $smarty, $config, $auth, $dbconn, $file_name;

	$error = 0;
	if($_POST["format"] == "html"){
		if($_POST["body_html"] == ""){
			$error = 1;
		}
	}elseif($_POST["format"] == "text"){
		if($_POST["body_text"] == ""){
			$error = 1;
		}
	}elseif($_POST["format"] == "htmltext"){
		if($_POST["body_html"] == "" || $_POST["body_text"] == ""){
			$error = 1;
		}
	}
	if($error){
		Create_Step2(intval($_POST["id"]),1);
		exit;
	}

	ArrAddSlashes($_POST);

	$id = intval($_POST["id"]);
	$strSQL = "UPDATE ".AUTORESPONDER_TABLE."
					SET body='{$_POST["body_html"]}',body_text='{$_POST["body_text"]}'
					WHERE id={$id} AND id_user={$auth["id"]}";
	$dbconn->Execute($strSQL);

	$id_list = intval($_POST["id_list"]);
	header("Location: {$file_name}?sel=view_step_1&param=view_list&id_list={$id_list}");
	exit;
}

function ChangeStatusR(){
	global $lang, $config, $dbconn, $auth;

	if($config["phpversion"]==4 && strpos($sel,"ajax")!==false){
		include "./include/class.json.php";
    	$json = new Services_JSON();
	}
	$status = "1";
	$data = array();

	if($_GET["par"]=="cros"){
		$status = "1";
		$data["class"] = "global";
	}else{
		$status = "0";
		$data["class"] = "";
	}
	$id = intval($_GET["id"]);
	$data["id"] = $id;
	$strSQL = "UPDATE ".AUTORESPONDER_TABLE." SET status='{$status}' WHERE id={$id} AND id_user={$auth["id"]}";
	$dbconn->Execute($strSQL);
	//header("Content-type:  charset=utf-8");
	if($config["phpversion"]==4){
		echo $json->encode($data);
	}else{
		echo json_encode($data);
	}
	exit;
}

function ViewNewsletter(){
	global $config, $smarty, $lang,$file_name;
	AdminMainMenu("newsletters");

	$format = ($_GET["format"]=="html" || $_GET["format"]=="")?"body":"body_text";
	$format = ($_GET["format"]=="htmltext")?"body":$format;
	$data = getContent(intval($_GET['id']),$format);

	$data["content"] = preg_replace("'href\s*=\s*[\"\']([^#\"\'>]+://|)?((?!mailto)[^#\"\'>]+)[\"\'>]'ixe",
								 "'href=\"{$config["server"]}/click.php?cl='.urlencode('\\2').'\"'",
								 $data["content"]);

	$smarty->assign("data",$data);
	$smarty->assign("selected",$_GET["format"]);
	$smarty->assign("form_action",$file_name."?sel=view&id={$_GET['id']}");
	$smarty->assign("html",$lang["common"]["html"]);
	$smarty->assign("text",$lang["common"]["text"]);
	$smarty->display($config["admin_nl_gentemplates"]."/templates_view.tpl");
	exit;
}

function getContent($id,$format="body"){
	global $dbconn,$auth;

	if($_GET["format"]==""){
		$strSQL = "SELECT format,body,body_text FROM ".AUTORESPONDER_TABLE." WHERE id={$id} AND id_user={$auth["id"]}";
		$res=$dbconn->Execute($strSQL);
		$data = array();
		$data["format"] = $res->fields[0];
		if($res->fields[0]=="text"){
			$data["content"] = nl2br($res->fields[2]);
		}else{
			$data["content"] = $res->fields[1];
		}
	}else{
		$strSQL = "SELECT {$format}, format FROM ".AUTORESPONDER_TABLE." WHERE id={$id} AND id_user={$auth["id"]}";
		$res=$dbconn->Execute($strSQL);
		if($_GET["format"]=="text"){
			$data["content"] = nl2br($res->fields[0]);
		}else{
			$data["content"] = $res->fields[0];
		}
		$data["format"] = $res->fields[1];
	}
	ArrStripSlashes($data);
	return $data;
}

function DeleteNewsletter(){
	global $file_name;
	if (isset($_POST["del"])) {
		foreach ($_POST["del"] as $val) {
			delResponder(intval($val));
		}
	}elseif ( isset($_GET['did']) && !empty($_GET['did'])){
		delResponder(intval($_GET['did']));
	}
	header("Location: {$file_name}");
	exit;
}

function delResponder($id){
	global $dbconn,$config,$auth;
	$strSQL = "DELETE FROM ".AUTORESPONDER_TABLE." WHERE id={$id} AND id_user={$auth["id"]}";
	$dbconn->Execute($strSQL);
	$strSQL = "DELETE FROM ".AUTORESPONDER_LIST_TABLE." WHERE id_autoresponder={$id} AND id_user={$auth["id"]}";
	$dbconn->Execute($strSQL);
}

function Location(){
	global $config, $dbconn, $auth,$lang;

	if ( (!isset($_GET["sel"])) || (!isset($_GET["id"])) ) exit;

	$id = intval($_GET["id"]);
	$action = $_GET["action"];

	header('Content-type: text/html; charset=utf-8');
	switch($action){
		case "template":
			$strSQL = "SELECT name FROM ".TEMPLATES_TABLE." WHERE id={$id}";
			$res=$dbconn->Execute($strSQL);
			if(file_exists($config["site_path"]."/pictures/{$res->fields[0]}.gif")){
				echo "<img src=\"{$config["server"]}/pictures/{$res->fields[0]}.gif\" border=\"1\" title=\"{$res->fields[0]}\" width=\"300\">";
			}else{
				echo "<img src=\"{$config["server"]}/pictures/nopreview.gif\" border=\"1\" title=\"no preview available\" width=\"250\">";
			}
			break;
		case "view_large":
			$strSQL = "SELECT body, body_text FROM ".TEMPLATES_TABLE." WHERE id={$id}";
			$res=$dbconn->Execute($strSQL);
			$body = $res->fields[0] ? $res->fields[0] : $res->fields[1];
			$body = stripslashes($body);
			echo $body;
			break;
		case "get_link":
			$strSQL = "SELECT body FROM ".CRELEASES_TABLE." WHERE id={$id}";
			$res=$dbconn->Execute($strSQL);
			$body = stripslashes($res->fields[0]);
			$default = $_GET["def"];
			preg_match_all("'href\s*=\s*[\"\'](([^#\"\'>]+://|)?([^#:\"\'>]+))[\"\'>]'ixe",$body,$matches);
			if(count($matches[1])>0){
				$str="<select name='link' style='width:220px;'>\n";
				foreach ($matches[1] as $key=>$val){
					$default_str = ($default==$val)?"selected":"";
					$str.="<option {$default_str} value=\"{$val}\">{$val}\n";
				}
				$str.="</select>";
			}else{
				$str="<select name='link' style='width:220px;'>\n";
				$str.="<option value=\"0\">{$lang["autoresponders"]["trigger_condition_link_empty"]}\n";
				$str.="</select>";
			}
			echo $str;
			break;
		default: exit;
	}
}

function ListTrigger(){
	global $lang, $config, $smarty, $dbconn, $auth;

	AdminMainMenu("autoresponders");
	if(IsFunctionAllowed($auth["id"],52)){$smarty->assign("create_trigger",1);}
	if(IsFunctionAllowed($auth["id"],53)){$smarty->assign("delete_trigger",1);}

	$data=array();

	$strSQL = "SELECT COUNT(id) FROM ".TRIGGERS_TABLE." WHERE id_user={$auth["id"]}";
	$res=$dbconn->Execute($strSQL);
	$amount = $res->fields[0];

	$i=0;
	$strSQL = "SELECT id,name, DATE_FORMAT(date,'{$config["date_format"]}') as date,condition_use,status
							FROM ".TRIGGERS_TABLE."
							WHERE id_user={$auth["id"]}";
	$res=$dbconn->Execute($strSQL);
	while(!$res->EOF){
		$data[$i]['id'] = $res->fields[0];
		$data[$i]['name'] = $res->fields[1];
		$data[$i]['date'] = $res->fields[2];
		$data[$i]['condition_use'] = $lang["autoresponders"]["condition_{$res->fields[3]}"];
		$data[$i]['status'] = ($res->fields[4]==1)?"global":"";
		$i++;
		$res->MoveNext();
	}
	ArrStripSlashes($data);

	get_smarty_array_list("newsletter_page", $config["newsletter_page"]);
	$smarty->assign("amount",$amount);
	$smarty->assign("data",$data);
	$smarty->display($config["admin_nl_gentemplates"]."/triggers.tpl");
}

function CreateTrigger($error=0){
	global $smarty, $config, $auth, $dbconn, $lang;

	AdminMainMenu("autoresponders");

	$id = intval($_GET["id"]);
	$data = array();
	$data["send_1"] = 1;
	$smarty->assign("lists",getLists());
	if($id){
		$strSQL = "SELECT * FROM ".TRIGGERS_TABLE." WHERE id_user={$auth["id"]} AND id={$id}";
		$res=$dbconn->Execute($strSQL);
		$row = $res->GetRowAssoc(false);
		$data["id"] = $row["id"];
		$data["name"] = $row["name"];
		$data["condition"] = $row["condition_use"];
		$data["action"] = unserialize($row["action"]);
		$data["link"] = $row["link"];
		if($data["condition"]=="link"){
			$data["id_newsletter_link"] = $row["id_newsletter"];
		}else{
			$data["id_newsletter_view"] = $row["id_newsletter"];
		}
		$data["id_send_newsletter"] = $row["id_send_newsletter"];
		$list = array();
		$list = explode("|",$row["id_list"]);
		$all_list = getLists();
		foreach ($all_list as $key=>$val){
			if(in_array($val["id"],$list)){
				$all_list[$key]["sel"] = 1;
			}else{
				$all_list[$key]["sel"] = 0;
			}
		}
		$smarty->assign("lists",$all_list);
		ArrStripSlashes($data);
	}
	if($error){
		$smarty->assign("error",$lang["err"]["obligatory_fields_empty"]);
		$smarty->assign("data",$_POST);
	}else{
		$smarty->assign("data",$data);
	}
	$smarty->assign("newsletters",getNewsletters());
	$smarty->display($config["admin_nl_gentemplates"]."/trigger_create.tpl");
}

function SaveTrigger(){
	global $smarty, $config, $auth, $dbconn;

	if(trim($_POST["name"]) == ""){
		CreateTrigger(1);
		exit;
	}

	if($_POST["condition"]=="link" && $_POST["id_newsletter_link"]=="0"){
		CreateTrigger(1);
		exit;
	}
	if($_POST["condition"]=="view" && $_POST["id_newsletter_view"]=="0"){
		CreateTrigger(1);
		exit;
	}
	if($_POST["action_send"]=="send" && $_POST["id_newsletter_send"]=="0"){
		CreateTrigger(1);
		exit;
	}
	if(!$_POST["action_send"] && !$_POST["action_add"]/* && !$_POST["action_remove"]*/){
		CreateTrigger(1);
		exit;
	}
	if($_POST["action_add"]=="add" && count($_POST["list"])==0){
		CreateTrigger(1);
		exit;
	}

	ArrAddSlashes($_POST);
	$id = intval($_POST["id"]);
	if(!$id){
		$strSQL = "INSERT INTO ".TRIGGERS_TABLE." (name,date,status,id_user) VALUES('{$_POST["name"]}',NOW(),1,{$auth["id"]})";
		$dbconn->Execute($strSQL);
		$id = $dbconn->_insertid();
	}

	$condition = ($_POST["condition"]=="link") ? "link" : "view";
	if($condition=="link"){
		$id_newsletter = intval($_POST["id_newsletter_link"]);
	}else{
		$id_newsletter = intval($_POST["id_newsletter_view"]);
	}
	$strUpdate = ", condition_use='{$condition}', id_newsletter={$id_newsletter}";
	if($condition=="link"){
		$link = $_POST["link"];
		$strUpdate .= ", link='{$link}'";
	}
	$action = array();
	if($_POST["action_send"]=="send"){
		$action["action_send"]="send";
		$id_newsletter_send = intval($_POST["id_newsletter_send"]);
		$strUpdate .= ", id_send_newsletter={$id_newsletter_send}";
	}else{
		$action["action_send"]="";
	}
	if($_POST["action_add"]=="add"){
		$action["action_add"]="add";
		$list = array();
		$list = $_POST["list"];
		$strUpdate .= ", id_list='".implode("|",$list)."'";
	}else{
		$action["action_add"]="";
	}
	/*if($_POST["action_remove"]=="remove"){
		$action["action_remove"]="remove";
	}else{
		$action["action_remove"]="";
	}*/
	$action_str = serialize($action);
	$strUpdate .= ", action='{$action_str}'";
	$strSQL = "UPDATE ".TRIGGERS_TABLE." SET name='{$_POST["name"]}' {$strUpdate} WHERE id={$id} AND id_user={$auth["id"]}";
	$dbconn->Execute($strSQL);

	ListTrigger();
	exit;
}

function DeleteTrigger(){
	global $file_name,$auth,$dbconn;
	if (isset($_POST["del"])) {
		foreach ($_POST["del"] as $val) {
			$id = intval($val);
			$strSQL = "DELETE FROM ".TRIGGERS_TABLE." WHERE id={$id} AND id_user={$auth["id"]}";
			$dbconn->Execute($strSQL);
		}
	}elseif ( isset($_GET['did']) && !empty($_GET['did'])){
		$id = intval($_GET['did']);
		$strSQL = "DELETE FROM ".TRIGGERS_TABLE." WHERE id={$id} AND id_user={$auth["id"]}";
		$dbconn->Execute($strSQL);
		header("Location: {$file_name}?sel=trigger");
	}
	exit;
}

function ChangeStatus(){
	global $lang, $config, $dbconn, $auth;

	if($config["phpversion"]==4 && strpos($sel,"ajax")!==false){
		include "./include/class.json.php";
    	$json = new Services_JSON();
	}
	$status = "d";
	$data = array();

	if($_GET["par"]=="cros"){
		$status = "1";
		$data["class"] = "global";
	}else{
		$status = "0";
		$data["class"] = "";
	}
	$id = intval($_GET["id"]);
	$data["id"] = $id;
	$strSQL = "UPDATE ".TRIGGERS_TABLE." SET status='{$status}' WHERE id={$id} AND id_user={$auth["id"]}";
	$dbconn->Execute($strSQL);
	//header("Content-type:  charset=utf-8");
	if($config["phpversion"]==4){
		echo $json->encode($data);
	}else{
		echo json_encode($data);
	}
	exit;
}
?>