<?php

/**
*	Class used for data exchange with the payment system. It contains
*		an enterprise of classes. The principles of class functioning depend on the chosen mode of operation.
*
*	Every class created by means of Engine can be easily broaden. Only constructor of the class and class
*		$_arrayField requires modification. It is desirable to make the names of the keys in the array
*		$_arrayField identical, but this is not obligatory.
*
*	The places in the body of the class used for class modification are underlined
*		by the following comment: \*** MODIFIED CODE ***\. Also the folder 'systems' contains
*		file tmpl_system.php which stands for the template for the class of the payment system.
*
* @package DatingPro
* @subpackage Include files
**/


if (!defined('PAYMENT_CONFIG')) {
	die("Чтобы использовать файл " . __FILE__ . " необходимо подключить конфиг!");
}

include_once PAYMENT_DIR."Error_Handler.php";


class Payment_Engine extends Error_Handler {

	/**
	*	Standard cosntructor
	*
	*	@param int $method Method of class operation
	*	@param bool $debug Enabling of debug mode
	*	@param bool $log Enabling logging of the debug system
	*/
	function Payment_Engine($method = PAYMENT_ENGINE_SEND, $debug = false, $log = false) {

		if ($log) {
			$this->Error_Handler(ERROR_HANDLER_MODE_LOG);
		} else {
			$this->Error_Handler();
		}
		$this->debug = $debug;
		$this->switchEngine($method);
	}

	/**
	*	Enterprise of classes. Returns the class identical for a definite payment system
	*
	*	@access public
	*	@param string $type name of the class of the payment system
	*	@return class
	*/
	function &factory($type) {
		$class = "Payment_".$type;
		$file = SYSTEMS_DIR."classes/{$type}.php";
		if (include_once($file)) {
			if ($this->debug) trigger_error("Файл $type.php присутствует.", E_USER_NOTICE);
			if (class_exists($class)) {
				if ($this->debug) trigger_error("Класс $class существует.", E_USER_NOTICE);
				$object = & new $class($this->_method, $this->debug);
				return $object;
			} else {
				trigger_error("Класса  $class не существует.", E_USER_ERROR);
			}
		} else {
			trigger_error("Файла $file нет.", E_USER_ERROR);
		}
	}

	/**
	*	Switch of the mode of the sites
	*
	*	@access public
	*	@type const int
	*/
	function switchEngine($method) {
		switch ($method) {
			case PAYMENT_ENGINE_SEND:
				$this->_method = $method;
				if ($this->debug) trigger_error("Установлен режим PAYMENT_ENGINE_SEND.", E_USER_NOTICE);
				break;

			case PAYMENT_ENGINE_RECEIVE:
				$this->_method = $method;
				$this->SetLog();
				if ($this->debug) trigger_error("Установлен режим PAYMENT_ENGINE_RECEIVE.", E_USER_NOTICE);
				break;

			default:
				trigger_error("Выбранный режим не определён.", E_USER_ERROR);
				break;
		}
	}

	function setLog() {
		global $dbconn, $config;
		$strSQL = "CREATE TABLE IF NOT EXISTS ".$config['table_prefix']."p_data
                (
                  id       int(11)  NOT NULL auto_increment,
                  data text,
                  date_add timestamp(14),
                  PRIMARY KEY (id)
                ) CHARSET=utf8";
		$dbconn->Execute($strSQL);

		$str_to_db = "\nGet data : \n";

		foreach ($_GET as $key=>$value) {
			$str_to_db .= "Key: ".$key." ; Value: ".$value."\n";
		}

		$str_to_db .= "\n============= Get finished =============\n";
		$str_to_db .= "\nPost : \n";

		foreach ($_POST as $key=>$value) {
			$str_to_db .= "Key: ".$key." ; Value: ".$value."\n";
		}
		$str_to_db .= "\n============= Post finished =============\n";

		$strSQL = "INSERT INTO ".$config['table_prefix']."p_data (data, date_add) VALUES ('".mysql_escape_string($str_to_db)."', NOW())";
		$dbconn->Execute($strSQL);
	}
}

?>