<?php

/**
* Functions for users authorization
*
* @package Newsletter
* @subpackage Include files
**/

global $functions_auth_php_included;
if (!isset($functions_auth_php_included)){
$functions_auth_php_included="included";

/// authentication admin and moderators
function sess_read($sess_id){
	global $dbconn;
	$ip_address = $_SERVER["REMOTE_ADDR"];
 	$strSQL = "SELECT id_user FROM ".ACTIVE_SESSIONS_TABLE." WHERE session = '{$sess_id}'";
	$rs = $dbconn->Execute($strSQL);
	if($rs->RowCount()){
		return $rs->fields[0];
	}else{
		return "";
	}
}

function sess_write($sess_id, $id_user){
	global $dbconn;
	$ip_address = $_SERVER["REMOTE_ADDR"];
	$file = $_SERVER["REQUEST_URI"];
	if(!$file) $file= $_SERVER["SCRIPT_NAME"];

	$strSQL = "DELETE FROM ".ACTIVE_SESSIONS_TABLE." WHERE session = '{$sess_id}' ";
	$rs = $dbconn->Execute($strSQL);

	$strSQL = "SELECT guest_user FROM ".USERS_TABLE." WHERE id={$id_user}";
	$rs = $dbconn->Execute($strSQL);
	$guest_user = intval($rs->fields[0]);
	if($guest_user == 1){
		$dbconn->Execute("DELETE FROM ".ACTIVE_SESSIONS_TABLE." WHERE id_user = {$id_user}");
	}

	$strSQL = "INSERT INTO ".ACTIVE_SESSIONS_TABLE." (id_user, session, ip_address, file, update_date) VALUES ( {$id_user}, '{$sess_id}', '{$ip_address}', '{$file}', NOW())";
	$rs = $dbconn->Execute($strSQL);
    return true;
}

function sess_delete($sess_id){
	global $dbconn;
	$strSQL = "DELETE FROM ".ACTIVE_SESSIONS_TABLE." WHERE session='{$sess_id}'";
	$rs = $dbconn->Execute($strSQL);
    return true;
}

function sess_clear($lifetime){
	global $dbconn;
    $strSQL = "DELETE FROM ".ACTIVE_SESSIONS_TABLE." WHERE UNIX_TIMESTAMP(update_date) < UNIX_TIMESTAMP(NOW())-{$lifetime}";
	$rs = $dbconn->Execute($strSQL);
    return true;
}

function auth_user_read($auth_user, $auth_pass, $type){
	global $dbconn;

	$auth_user = addslashes($auth_user);
	switch($type){
		case "0":
			$strSQL = "SELECT a.id, a.fname, a.sname, a.email, a.guest_user, a.root_user, a.login, a.status, (SELECT id_group FROM ".USER_GROUP_TABLE." WHERE id_user=a.id) as id_group, lang FROM ".USERS_TABLE." a WHERE a.login = '{$auth_user}' AND a.password = '".md5($auth_pass)."' AND a.status='1' "; break;
		case "1":
			$strSQL = "SELECT a.id, a.fname, a.sname, a.email, a.guest_user, a.root_user, a.login, a.status, (SELECT id_group FROM ".USER_GROUP_TABLE." WHERE id_user=a.id) as id_group, lang FROM ".USERS_TABLE." a WHERE a.id = {$auth_user}"; break;
	}
	$rs = $dbconn->Execute($strSQL);
	if($rs->RowCount() == 0) return "";
	$row = $rs->GetRowAssoc(false);
	$ret['id']=intval($row['id']);
	$ret['login']=$row['login'];
	$ret['name']=$row["fname"]." ".$row["sname"];
	$ret['email']=$row['email'];
	$ret['status']=$row['status'];
	$ret['root']=intval($row['root_user']);
	$ret['guest']=intval($row['guest_user']);
	$ret['type']=$type;
	$ret['id_group']=$row['id_group'];
	$ret['lang']=$row['lang'];
	return $ret;
}

function auth_guest_read(){
	global $dbconn;
	$strSQL = "SELECT id, fname, sname, login FROM ".USERS_TABLE." WHERE guest_user ='1' ";
	$rs = $dbconn->Execute($strSQL);
	if($rs->RowCount() == 0) return "";
	$row = $rs->GetRowAssoc(false);
	$ret['id']=intval($row['id']);
	$ret['login']=$row['login'];
	$ret['name']=$row["fname"]." ".$row["sname"];
	$ret['email']= "";
	$ret['status']= "1";
	$ret['root']= 0;
	$ret['guest']= 1;
	$ret['type']= "1";
	$ret['lang']= 1;
	return $ret;
}

function auth_user_update_date($sess_id,$id_user){
	global $dbconn;
    $date = date("YmdHis");

	$file = $_SERVER["REQUEST_URI"];
	if(!$file) $file= $_SERVER["SCRIPT_NAME"];

	$strSQL = "SELECT guest_user FROM ".USERS_TABLE." WHERE id={$id_user}";
	$rs = $dbconn->Execute($strSQL);
	$guest_user = intval($rs->fields[0]);
	if($guest_user == 1){
		$ip_address = $_SERVER["REMOTE_ADDR"];
		$dbconn->Execute("DELETE FROM ".ACTIVE_SESSIONS_TABLE." WHERE id_user = {$id_user}");
		$dbconn->Execute("INSERT INTO ".ACTIVE_SESSIONS_TABLE." (id_user, session, ip_address, file, update_date) VALUES ( {$id_user}, '{$sess_id}', '{$ip_address}', '{$file}', NOW())");
	}else{
		$strSQL = "UPDATE ".ACTIVE_SESSIONS_TABLE." SET update_date = NOW(), file='{$file}'  WHERE session='{$sess_id}' AND id_user = {$id_user}";
		$rs = $dbconn->Execute($strSQL);
	}
/*	/////// update
	$strSQL = "Update ".USERS_TABLE."  set date_last_seen='".$date."' where id = '".$id_user."'";
	$rs = $dbconn->Execute($strSQL);*/
    return true;
}

function auth_user(){
	global $dbconn,$smarty,$lang;

	$sess_id = session_id();
	if(!$sess_id) $sess_id = $PHPSESSID;

	@$login = $_POST["login_lg"];
	@$pass = $_POST["pass_lg"];

	$login =  htmlspecialchars(trim($login));
	$pass =  htmlspecialchars(trim($pass));

	sess_clear(3600);

	$check_id = sess_read($sess_id);
	if(empty($check_id)){
		if( ($login !="") && ($pass != "") ){
			$auth = auth_user_read($login, $pass, "0");
			if(empty($auth["id"]) || $auth==""){
				$smarty->assign("login_error",1);
				return "";
			}else{
				sess_write($sess_id, $auth["id"]);
				SetLoginStatistic($auth["id"]);
				if($auth['guest']) $smarty->assign("login_error",1);
				return $auth;
			}
		}else{
			$auth = auth_guest_read();
			if($auth['guest'] && $_POST) $smarty->assign("login_error",1);
			if(empty($auth["id"])){
				return "";
			}else{
				sess_write($sess_id, $auth["id"]);
				return $auth;
			}
		}
	}else{
		$auth = auth_user_read($check_id, "", "1");

		if(empty($auth["id"])) return "";

		if( ($login !="") && ($pass != "") && ($auth['guest']=='1') ){
			$auth = auth_user_read($login, $pass, "0");
			if(empty($auth["id"]) || $auth==""){
				return "";
			}else{
				sess_write($sess_id, $auth["id"]);
				return $auth;
			}
		}
		if($auth['guest']=='1')
		return $auth;
		auth_user_update_date($sess_id,$auth["id"]);
		return $auth;
	}
}

function login_cheeck($auth){
	global $config, $lang;
	if(!intval($auth["id"]) || intval($auth["id"])==2 || $auth['status'] == '0')
		PermissionError();
	return;
}

function SetLoginStatistic($id){
	global $dbconn;
	$str_sql = "SELECT value, name FROM ".USER_SETTINGS_TABLE." WHERE id_user={$id} AND name IN ('type_dispatch', 'is_tips')";
	$rs = $dbconn->Execute($str_sql);
	while(!$rs->EOF){
		$row = $rs->GetRowAssoc(false);
		$settings[$row["name"]] = $row["value"];
		$rs->MoveNext();
	}
	$config["type_dispatch"] = $settings["type_dispatch"] ? $settings["type_dispatch"] : "smtp";
	$_SESSION["is_tips"] = $settings["is_tips"] ? $settings["is_tips"] : "1";
	$dbconn->Execute("UPDATE ".USERS_TABLE." SET login_count=login_count+1 WHERE id={$id}");
	return;
}

/// authentication subscribers
function sess_read_subscr($sess_id){
	global $dbconn;
	$ip_address = $_SERVER["REMOTE_ADDR"];
 	$strSQL = "SELECT id_user FROM ".ACTIVE_SESSIONS_SUBSCRIBERS_TABLE." WHERE session = '{$sess_id}'";
	$rs = $dbconn->Execute($strSQL);
	if($rs->RowCount()){
		return $rs->fields[0];
	}else{
		return "";
	}
}

function sess_write_subscr($sess_id, $id_user){
	global $dbconn;
	$ip_address = $_SERVER["REMOTE_ADDR"];
	$file = $_SERVER["REQUEST_URI"];
	if(!$file) $file= $_SERVER["SCRIPT_NAME"];

	$strSQL = "DELETE FROM ".ACTIVE_SESSIONS_SUBSCRIBERS_TABLE." WHERE session = '{$sess_id}' ";
	$rs = $dbconn->Execute($strSQL);

	$strSQL = "INSERT INTO ".ACTIVE_SESSIONS_SUBSCRIBERS_TABLE." (id_user, session, ip_address, file, update_date) VALUES ( {$id_user}, '{$sess_id}', '{$ip_address}', '{$file}', NOW()) ";
	$rs = $dbconn->Execute($strSQL);
    return true;
}

function sess_delete_subscr($sess_id){
	global $dbconn;
	$strSQL = "DELETE FROM ".ACTIVE_SESSIONS_SUBSCRIBERS_TABLE." WHERE session='{$sess_id}'";
	$rs = $dbconn->Execute($strSQL);
    return true;
}

function sess_clear_subscr($lifetime){
	global $dbconn;
    $strSQL = "DELETE FROM ".ACTIVE_SESSIONS_SUBSCRIBERS_TABLE." WHERE UNIX_TIMESTAMP(update_date) < UNIX_TIMESTAMP(NOW())-{$lifetime}";
	$rs = $dbconn->Execute($strSQL);
    return true;
}

function auth_user_read_subscr($auth_user, $auth_pass, $type){
	global $dbconn;

	$auth_user = addslashes($auth_user);
	switch($type){
		case "0":
			$strSQL = "SELECT id, firstname, secondname, email1, company, status FROM ".SEND_USERS_TABLE." WHERE email1 = '{$auth_user}' AND password = '".md5($auth_pass)."' AND status='1' "; break;
		case "1":
			$strSQL = "SELECT id, firstname, secondname, email1, company, status FROM ".SEND_USERS_TABLE." WHERE id = {$auth_user}"; break;
	}
	$rs = $dbconn->Execute($strSQL);
	if($rs->RowCount() == 0) return "";
	$row = $rs->GetRowAssoc(false);
	$ret['id']=intval($row['id']);
	$ret['login']=$row['email1'];
	$ret['name']=$row["firstname"]." ".$row["secondname"];
	$ret['email']=$row['email1'];
	$ret['status']=$row['status'];
	$ret['company']=$row['company'];
	$ret['type']=$type;
	return $ret;
}

function auth_user_update_date_subscr($sess_id,$id_user){
	global $dbconn;
    $date = date("YmdHis");

	$file = $_SERVER["REQUEST_URI"];
	if(!$file) $file= $_SERVER["SCRIPT_NAME"];

	$strSQL = "UPDATE ".ACTIVE_SESSIONS_SUBSCRIBERS_TABLE." SET update_date = NOW(), file='{$file}'  WHERE session='{$sess_id}' AND id_user = {$id_user}";
	$rs = $dbconn->Execute($strSQL);
    return true;
}

function auth_subscriber(){
	global $dbconn;

	$sess_id = session_id();
	if(!$sess_id) $sess_id = $PHPSESSID;

	@$login = $_POST["login_subscr"];
	@$pass = $_POST["pass_subscr"];

	$login =  htmlspecialchars(trim($login));
    $pass =  htmlspecialchars(trim($pass));

	sess_clear(3600);

    $check_id = sess_read_subscr($sess_id);
	if(empty($check_id)){
		if( ($login !="") && ($pass != "") ){
			$auth = auth_user_read_subscr($login, $pass, "0");
             if(empty($auth)){
					return "";
			 }else{
					sess_write_subscr($sess_id, $auth["id"]);
					return $auth;
			 }
		}else{
			return "";
		}
	}else{
		$auth = auth_user_read_subscr($check_id, "", "1");

		if(empty($auth["id"])) return "";
		auth_user_update_date_subscr($sess_id,$auth["id"]);
		return $auth;
	}
}

}
?>