<?php

include_once PAYMENT_DIR."Payment_Data_Kipper.php";

/**
* paypal payment system class
*
* @package DatingPro
* @subpackage Payment systems files
**/

class Payment_paypal extends Payment_Data_Kipper {

        /**
        *	Array for setting Payment System parameters.
        *
        *       @access private
        *       @type array
        */
        var $_arrayField = array(

        /*** MODIFIED CODE BEGIN ***/

        /* General Parameters: */

        "seller_id"             => "business",

        "amount"                => "amount",

        "currency"              => "currency_code",

        "order_id"              => "custom",

        "test_mode"             => "test_ipn",

        "return_method" => "rm",

        "return_url"    => "return",

        "notify_url"    => "notify_url",

        "cancel_return"    => "cancel_return",

        "type"                  => "cmd",

        "product_name"  => "item_name",

        "product_id"    => "item_number",

        "amount_response"        => "mc_gross",

        "currency_response"      => "mc_currency",

        "payment_date"			=> "payment_date",

        "quantity"			=> "quantity",

        "amount_recurring"		=> "a3",

        "period_recurring"		=> "p3",

        "period_type_recurring"		=> "t3",

        "use_recurring"			=> "src",

        "use_note"			=> "no_note"

        /*** MODIFIED CODE END ***/

        );


		/**
		*	Standard constructor. Nothing should be changed here.
		*
		*	@param int $mode Mode of class funtioning
		*	@param bool $debug Debug mode
		*/
        function Payment_paypal($mode, $debug) {
                $this->_debug = $debug;
                if ($this->_debug) trigger_error(" -> " . get_class($this). " ! ()." , E_USER_NOTICE);

                if ( ($mode == PAYMENT_ENGINE_SEND) || ($mode == PAYMENT_ENGINE_RECEIVE) ) {
                        $this->_mode = $mode;
                        if ($this->_debug) trigger_error("-   " . $this->_mode . " ." , E_USER_NOTICE);
                } else {
                        if ($this->_debug) trigger_error("-    " . $this->_mode . " !!" , E_USER_ERROR);
                        exit();
                }
                $this->_initialization();
                $this->makeFields();
                if ($this->_debug) trigger_error(" <- " . get_class($this). " ! ()." , E_USER_NOTICE);
        }

	    /**
		*	Method of class parameters initialization. It is set while being created.
		*		It is divided into 3 parts: general, receive and send.
		*
		*	@access private
		*/
        function _initialization() {
                if ($this->_debug) trigger_error(" -> " . get_class($this). " ! _initialization()" , E_USER_NOTICE);

                /*** MODIFIED CODE BEGIN ***/

                $this->_url = "https://www.paypal.com/cgi-bin/webscr";
                //$this->_url = "https://www.sandbox.paypal.com/cgi-bin/webscr";
                $this->_method = "POST";
                if ($this->_mode == PAYMENT_ENGINE_SEND) {
                        $this->makeRequiredField('return_method', '2');
                        $this->makeRequired('type', 'seller_id', 'order_id', 'return_url', 'cancel_return');
                        $this->makeOptional('product_name');
                        $this->makeOptional('amount', 'currency', 'notify_url');
                        $this->makeOptional('amount_recurring', 'period_recurring', 'period_type_recurring', 'use_recurring', 'use_note');
                }
                if ($this->_mode == PAYMENT_ENGINE_RECEIVE) {

                }

                /*** MODIFIED CODE END ***/

                if ($this->_debug) trigger_error(" <- " . get_class($this). " ! _initialization()." , E_USER_NOTICE);
        }

		/**
		*	Method used for sending data to the server of Payment System.
		*		According to the type of Payment System there is either redirect to the site of Payment System(POST),
		*		or the URL is put in the heading.
		*
		*	@access public
		*	@return mixed In case when all the parameters were ser correctly, nothing will be returned,
		*		there will be redirect, otherwise notification will be generated and false will be returned
		*/
        function doPayment() {
                if ($this->_debug) trigger_error(" -> " . get_class($this). " ! doPayment()" , E_USER_NOTICE);
                if ($this->_mode == PAYMENT_ENGINE_SEND) {
                        if ($this->_verifyData()) {
                                $this->formMessage();
                                if ($this->_debug) trigger_error(" <- " . get_class($this). " ! doPayment()." , E_USER_NOTICE);
                                exit();
                        } else {
                                if ($this->_debug) trigger_error("-   .", E_USER_WARNING);
                                if ($this->_debug) trigger_error(" <- " . get_class($this). " ! doPayment()." , E_USER_NOTICE);
                                return false;
                        }
                } else {
                        trigger_error("-   PAYMENT_ENGINE_RECEIVE  doPayment()  .", E_USER_ERROR);
                }
                if ($this->_debug) trigger_error(" <- " . get_class($this). " ! doPayment()." , E_USER_NOTICE);
                return false;
        }

   		/**
		*	Checks the incoming data to be set correctly in accord with
		*		the parameters set.
		*
		*	@access public
		*	@param ... Parameters enumeration. Transfer by link.
		*	@return bool true- in case all the parameters are set correctly and the payment
		*		was successfully processed, false - in case parameters are set incorrectly or payment failed.
		*/
        function checkPayment() {
                if ($this->_debug) trigger_error(" -> " . get_class($this). " ! checkPayment()" , E_USER_NOTICE);
                $retVal = true;
                $arg_list = func_get_args();
                if ($this->_mode == PAYMENT_ENGINE_RECEIVE) {
                        if (PAYMENT_IGNORE_TEST_PAYMENT) {

                                /*** MODIFIED CODE BEGIN ***/

                                if (isset($_REQUEST[$this->_arrayField['test_mode']]) &&
                                $_REQUEST[$this->_arrayField['test_mode']] == "1") {
                                        if ($this->_debug) trigger_error("-     .", E_USER_NOTICE);
                                        $retVal = false;
                                }

                                /*** MODIFIED CODE END ***/

                        }
                        if (PAYMENT_LOG_PAYER_INFO) {

                                /*** MODIFIED CODE BEGIN ***/

                                $arg_list[0] = "payer_id: " . $_REQUEST['payer_id'] . ";\n";
                                $arg_list[0] .= "address_street: " . $_REQUEST['address_street'] . ";\n";
                                $arg_list[0] .= "address_zip: " . $_REQUEST['address_zip'] . ";\n";
                                $arg_list[0] .= "first_name: " . $_REQUEST['first_name'] . ";\n";
                                $arg_list[0] .= "address_name: " . $_REQUEST['address_name'] . ";\n";
                                $arg_list[0] .= "address_country: " . $_REQUEST['address_country'] . ";\n";
                                $arg_list[0] .= "address_city: " . $_REQUEST['address_city'] . ";\n";
                                $arg_list[0] .= "payer_email: " . $_REQUEST['payer_email'] . ";\n";
                                $arg_list[0] .= "address_state: " . $_REQUEST['address_state'] . ";\n";
                                $arg_list[0] .= "payer_business_name: " . $_REQUEST['payer_business_name'] . ";\n";
                                $arg_list[0] .= "last_name: " . $_REQUEST['last_name'] . ";";

                                /*** MODIFIED CODE END ***/

                        }
                        if ($this->_verifyData()) {
                                /*** MODIFIED CODE BEGIN ***/

                                $arg_list[1] = $_REQUEST[$this->_arrayField['order_id']];
/*
                                if ($_REQUEST['payer_status'] != "verified") {
                                        if ($this->_debug) trigger_error("-      PayPal'.", E_USER_NOTICE);
                                        $retVal = false;
                                }
                                if ($_REQUEST['address_status'] != "confirmed") {
                                        if ($this->_debug) trigger_error("-       PayPal'.", E_USER_NOTICE);
                                        $retVal = false;
                                }
*/
                                if ( ($_REQUEST['payment_status'] != "Completed") && ($_REQUEST['payment_status'] != "Pending") ) {
                                        if ($this->_debug) trigger_error("-    .", E_USER_NOTICE);
                                        $retVal = false;
                                }

                                /*** MODIFIED CODE END ***/

                        } else {
                                if ($this->_debug) trigger_error("-      .", E_USER_ERROR);
                                $retVal = false;
                        }
                } else {
                        trigger_error("-   PAYMENT_ENGINE_SEND  verifyIncoming()  .", E_USER_ERROR);
                        $retVal = false;
                }
                if ($this->_debug) trigger_error(" <- " . get_class($this). " ! doPayment()." , E_USER_NOTICE);
                return $retVal;
        }

}       // end class Payment_template
?>