<?php
include "include/config.php";
include "include/common_functions.php";
include "include/functions_auth.php";
include "common.php";
include "include/config.inc.php";
include "include/users_function.php";
include "include/class.form.php";
include "include/class.email_validator.php";

@$sel =$_POST["sel"]?$_POST["sel"]:$_GET["sel"];
if($config["phpversion"]==4 && strpos($sel,"ajax")!==false){
	include "include/class.json.php";
    $json = new Services_JSON();
}

login_cheeck($auth);

$this_page="subscribers";
$smarty->assign("this_page",$this_page);

$mode = IsFileAllowed($auth["id"], GetRightModulePath(__FILE__));

$file_name = $config["server"]."/subscribers.php";
$smarty->assign("form_action",$file_name);

if($mode == 1){
	switch($sel){
		case "create": if(IsFunctionAllowed($auth["id"],14)){CreateSubscribers();}else{ListSubscribers();} break;
		case "save": SaveSubscribers(); break;
		case "delete": if(IsFunctionAllowed($auth["id"],15)){DeleteSubscribers();}else{ListSubscribers();} break;
		case "import": if(IsFunctionAllowed($auth["id"],17)){ImportSubscribers();}else{ListSubscribers();} break;
		case "export": if(IsFunctionAllowed($auth["id"],18)){ExportSubscribers();}else{ListSubscribers();} break;
		case "profile": ProfileSubscribers(); break;
		case "view_user_detail": ViewDetailsSubscribers(); break;
		case "export_ajax": ExportAjax(); break;
		case "import_ajax": ImportAjax(); break;
		case "upload_file_ajax": UploadFile(); break;
		case "bounce": Bounce(); break;
		case "bounce_delete": BounceDelete(); break;
		case "delete_from_file": BounceDeleteFromFile(); break;
		case "download": Download(); break;
		default: if(IsFunctionAllowed($auth["id"],37)){ListSubscribers();}else{header("{$file_name}?sel=err");exit;}
	}
}

function ListSubscribers(){
	global $lang, $config, $config_index, $smarty, $dbconn, $auth, $file_name;

	AdminMainMenu("users");

	if(IsFunctionAllowed($auth["id"],14)){$smarty->assign("create_subscriber",1);}
	if(IsFunctionAllowed($auth["id"],15)){$smarty->assign("delete_subscriber",1);}
	if(IsFunctionAllowed($auth["id"],17)){$smarty->assign("import_subscriber",1);}
	if(IsFunctionAllowed($auth["id"],18)){$smarty->assign("export_subscriber",1);}

	ArrAddSlashes($_POST);
	ArrAddSlashes($_REQUEST);

	$filter_url="&1";
	$status = (isset($_REQUEST["status"])) ? intval($_REQUEST["status"]) : 1;
	$status_search = " AND status_subscribe={$status}";
	$filter_url .= ($status==1) ? "&status=1" : "&status={$status}";

	$id_list = isset($_REQUEST["id_list"]) ? intval($_REQUEST["id_list"]) : 0;
	$list_search = ($id_list) ? " AND list_id={$id_list}" : "";
	$filter_url .= ($list_search!="") ? "&id_list={$id_list}" : "";

	$user_page = isset($_REQUEST["user_page"]) ? intval($_REQUEST["user_page"]) : 0;
	$filter_url .= $user_page ? "&user_page={$user_page}" : "";
	$filter = $filter_url;

	$page = isset($_REQUEST["p"]) ? intval($_REQUEST["p"]) : 0;
	$filter_url .= $page ? "&p={$page}" : "";

	$search = "";
	$search_text = isset($_REQUEST["search_text"]) ? $_REQUEST["search_text"] : "";
	if ($search_text){
		$type = $_REQUEST["type"];
		$search_text_out = stripslashes($search_text);
		$filter_url .= "&search_text={$search_text_out}&type={$type}";
		$smarty->assign("search_text",$search_text_out);
		$smarty->assign("type",$type);

		if ($search_text != "") $search = " AND {$type} LIKE '{$search_text}%' ";
		else $search = "";
	}

	if($status==4){
		$strSQL = "SELECT COUNT(su.id)
					FROM ".SEND_USERS_TABLE." su
					WHERE su.id_user={$auth["id"]} AND su.status=1
						AND IF((SELECT COUNT(client_id)
										FROM ".CLIENTS_LISTS_TABLE."
										WHERE su.id = client_id),1,0)=0";
	}else{
		$strSQL = "SELECT COUNT(su.id)
					FROM ".SEND_USERS_TABLE." su
					WHERE su.id_user={$auth["id"]} AND su.status=1 {$search}
						AND su.id IN (SELECT client_id
										FROM ".CLIENTS_LISTS_TABLE."
										WHERE su.id = client_id {$status_search} {$list_search})";
	}

	$res=$dbconn->Execute($strSQL);
	$total = $res->fields[0];

	if (isset($_SESSION["message"]) && $_SESSION["message"] != "") {
		$msg = $_SESSION["message"];
		$_SESSION["message"] = "";
	}else{
		$msg = "";
	}

	$smarty->assign("navigation", create_navigation($total, $user_page, $filter, $file_name, $page));
	get_smarty_array_list("user_page", $config["user_page"]);
	$per_page = $config["user_page"][$user_page];

	if($status==4){
		$strSQL = "SELECT DISTINCT(su.id),su.firstname,su.secondname,su.email1,su.status
						FROM ".SEND_USERS_TABLE." su
						WHERE su.id_user={$auth["id"]} AND su.status=1
							AND IF((SELECT COUNT(client_id)
											FROM ".CLIENTS_LISTS_TABLE."
											WHERE su.id = client_id),1,0)=0
						ORDER BY su.id";
	}else{
		$strSQL = "SELECT DISTINCT(su.id),su.firstname,su.secondname,su.email1,su.status
						FROM ".SEND_USERS_TABLE." su
						WHERE su.id_user={$auth["id"]} AND su.status=1 {$search}
							AND su.id IN (SELECT client_id
											FROM ".CLIENTS_LISTS_TABLE."
											WHERE su.id = client_id  {$status_search} {$list_search})
						ORDER BY su.id";
	}
	$res=$dbconn->PageExecute($strSQL, $per_page, $page+1);
	$users=array();
	$c=0;
	while (!$res->EOF){
		$users[$c]["id"] = $res->fields[0];
		$users[$c]["firstname"] = $res->fields[1];
		$users[$c]["secondname"] = $res->fields[2];
		$users[$c]["email1"] = $res->fields[3];
		$users[$c]["status"] = $res->fields[4];

		///// count additional paramenters
		$form_class=new Form($dbconn, $config);
		$user_attrs=array();
		$count=0;
		$attrs=$form_class->getAllAttributes($count);
		foreach ($attrs as $index=>$attr){
			$temp=$form_class->getUserAttribute($users[$c]["id"], $attr['id'], true);
			if ($temp===false) continue;
			$user_attrs[$attr['id']]=$temp;
		}
		$users[$c]["deiteils"] = count($user_attrs);

		$strSQL = "SELECT a.name
						FROM ".LISTS_TABLE." a
						WHERE a.id_user={$auth["id"]}
							AND a.id IN (SELECT list_id FROM ".CLIENTS_LISTS_TABLE." WHERE client_id={$users[$c]["id"]})";
		$res2 = $dbconn->Execute($strSQL);
		$j=0;
		while (!$res2->EOF){
			$users[$c]["list"][$j] = $res2->fields[0];
			$j++;
			$res2->MoveNext();
		}
		$c++;
		$res->MoveNext();
	}
	ArrStripSlashes($users);

	$smarty->assign("total",$total);
	$smarty->assign("user_page",$user_page);
	$smarty->assign("id_list",$id_list);
	$smarty->assign("filter_url",$filter_url);

	$smarty->assign("msg",$msg);
	$smarty->assign("users",$users);
	$smarty->assign("list",get_values_list());
	$smarty->assign("status",get_status_list());
	$smarty->assign("status_sel",$status);

	$smarty->display($config["admin_nl_gentemplates"]."/users.tpl");
	exit;
}

function CreateSubscribers($data=array(),$error=""){
	global $lang, $config, $config_index, $smarty, $dbconn, $auth, $file_name;

	AdminMainMenu("users");

	$id = isset($_GET['id'])? intval($_GET['id']):0;
	//$data = array();
	$data["status"] = 1;
	if($id){
		$data=getUser($id);
	}
	if($error){
		$smarty->assign("error",$error);
	}

	get_smarty_array_list("status_subscribe", $config["status_subscribe_val"]);
	$smarty->assign("status_subscribe",$config["status_subscribe_val"]["subscribe"]);
	$smarty->assign("data",$data);
	$smarty->assign("lists",getListsSub());
	$smarty->assign("subscriber_id",$id);

	$smarty->display($config["admin_nl_gentemplates"]."/users_change.tpl");
}

function SaveSubscribers(){
	global $lang, $config, $config_index, $smarty, $dbconn, $auth, $file_name;

	AdminMainMenu("users");

	$form_class=new Form($dbconn, $config);
	$attrs=array();
	$data=$_POST;

	foreach ($data as $key=>$value){
		$arr=array();
		if (preg_match('/^attr_(\d*)/', $key, $arr)==0) continue;
		$id_attr=$arr[1];
		$sec_attrs[$id_attr]=$form_class->getSectionAttribute($id_attr);
		unset($data[$key]);
		if (is_array($value) && $sec_attrs[$id_attr]['control_type']=='select'){
			$temp=array();
			foreach ($value as $i=>$v) {
				$temp[$v]=$v;
			}
			$data[$id_attr]=$temp;
		}else $data[$id_attr]=$value;
		$attrs[$id_attr]=$value;
	}

	//Checkbox control, if attribute not exist in _POST data, but exist in Form attributes it sets to 0
	$total_count = 0;
	$form_fields=$form_class->getAllAttributes($total_count);
	foreach ($form_fields as $form_field){
		if ($form_field['control_type']=='checkbox'){
			//check if this field presence in filled attributes
			$keys=array_keys($attrs);
			if (!in_array($form_field['id'], $keys)) $attrs[$form_field['id']]=0;
			$sec_attrs[$form_field['id']]=$form_class->getSectionAttribute($form_field['id']);
		}
	}

	//Get attibutes patterns
	$regs=$form_class->getRegExps();
	if(isset($sec_attrs) && is_array($sec_attrs))
	foreach ($sec_attrs as $index=>$field){
		if (isset($field['setup']['reg_exp'])) {
			$id_reg=$sec_attrs[$index]['setup']['reg_exp'];
			$sec_attrs[$index]['setup']['reg_exp']=$regs[$id_reg]['reg_exp'];
		}
	}

	//Check user data
	$err='';
	$valid=true;
	foreach ($attrs as $id_attr=>$value){
		if ($sec_attrs[$id_attr]['mandatory']=='Y'){
			if ($value=='' || !isset($value)){
				$valid=false;
				$err .= "<br>".$sec_attrs[$id_attr]['field_name'];
			}
		}
		if (isset($sec_attrs[$id_attr]['setup']['reg_exp'])){
			$pattern=$sec_attrs[$id_attr]['setup']['reg_exp'];
			if (preg_match($pattern, $value)==0){
				$valid=false;
				$err .= "<br>".$sec_attrs[$id_attr]['field_name'];
			}
		}
	}
	$email_validator = New EmailValidator($_POST["email1"]);
	if ($email_validator->returnValidatedEmailStatus()==2) {
		if (!$_POST['id']){
			$id_user=0;
			$msg = addUser($_POST, $id_user, $form_class);
		}else{
			$id_user=intval($_POST['id']);
			updUser($id_user,$_POST);
		}
	}else{
		$msg = $lang["err"]["invalid_email"];
	}
	if($msg){
		CreateSubscribers($_POST,$msg);
		exit;
	}
	$form_class->saveUserAttributes($id_user, $attrs);
	$_SESSION["message"] = $msg;
	ListSubscribers();
	exit;
}

function DeleteSubscribers(){
	if (isset($_POST["del"])) {
		foreach ($_POST["del"] as $key => $val) {
			delUser(intval($val));
		}
	}elseif ( isset($_GET['did']) && !empty($_GET['did'])){
		delUser(intval($_GET['did']));
	}
	ListSubscribers();
	exit;
}

function ImportSubscribers(){
	global $lang, $config, $config_index, $smarty, $dbconn, $auth;

	AdminMainMenu("users");

	$form_class=new Form($dbconn, $config);
	$user_attrs=array();
	$count=0;
	$attrs=$form_class->getAllAttributes($count);
	array_push($attrs,$attrs[0]);
	unset($attrs[0]);
	$smarty->assign('fields', $attrs);

	$smarty->assign("lists",getListsSub());
	$smarty->display($config["admin_nl_gentemplates"]."/users_import_csv.tpl");
	exit;
}

function UploadFile(){
	global $lang, $config, $config_index, $smarty, $dbconn, $auth, $json;

	$uploaddir = $config["site_path"]."/files/";
	$file_name = basename($_FILES['file']['name']);
	$uploadfile = $uploaddir.$file_name;
	$data = array();


	$img_ext_array = array("csv");
	$ex_arr = explode(".",$_FILES["file"]["name"]);
	$extension = strtolower($ex_arr[count($ex_arr)-1]);

	if (in_array($extension,$img_ext_array) && move_uploaded_file($_FILES['file']['tmp_name'], $uploadfile)) {
		$delimiter = (trim($_REQUEST["delimiter"]) != "") ? trim($_REQUEST["delimiter"]) : ";";
		$file = file($uploadfile);
		$str_1 = $file[0];
		if(isset($_REQUEST["use_header"]) && $_REQUEST["use_header"]=="1"){
			$str_1 = $file[1];
			unset($file[0]);
			$fp = fopen($uploadfile,"w+");
			fwrite($fp,implode("",$file));
			fclose($fp);
		}
		unset($file);
		$header = explode("{$delimiter}",trim($str_1));

		foreach ($header as $key=>$val){
			if($val=="") unset($header[$key]);
		}
		$data["status"]=1;
		$data["file_name"]=$file_name;
		foreach ($header as $key=>$val){
			$data["field"][$key] = $val;
		}
	} else {
		unlink($_FILES['file']['tmp_name']);
		$data["status"]=0;
		$data["file_name"]=$file_name;
	}
	//header("Content-type:  charset=utf-8");
	if($config["phpversion"]==4){
		echo $json->encode($data);
	}else{
		echo json_encode($data);
	}
	exit;
}

function ImportAjax(){
	global $lang, $config, $config_index, $smarty, $dbconn, $auth, $json;

	AdminMainMenu("users");

	$form_class=new Form($dbconn, $config);
	$data = array();
	$list = array();
	$data['error'] = '';
	$total_all = intval($_POST['total']);
	$curent = intval($_POST['curent']);
	$delimiter = (trim($_POST["delimiter"]) != "") ? trim($_POST["delimiter"]) : ";";

	$uploaddir = $config["site_path"]."/files/";
	$fp=fopen($uploaddir.$_POST["filename"], "r");
	if (!$fp){
		$data['error'] .= $lang["err"]["no_file"]." ".$_POST["filename"]."<br>";
	}
	fclose($fp);

	if (count($_POST["list"]) < 1) {
		$data['error'] .= $lang["err"]["specify_subscrs_list"]."<br>";
	}
	$list = $_POST["list"];

	if (count($_POST["fields"]) < 1) {
		$data['error'] .= $lang["err"]["invalid_feilds"]."<br>";
	}
	if ($data['error'] != ''){
		//header("Content-type:  charset=utf-8");
		if($config["phpversion"]==4){
			echo $json->encode($data);
		}else{
			echo json_encode($data);
		}
		exit;
	}
	$file = file($uploaddir.$_POST["filename"]);

	if($total_all==0){
		$total_all = count($file);
	}

	$oblig_arr = array('date','firstname','secondname','email1');
	$fields = array();
	$fields = $_POST["fields"];

	$it=0;
	$total = count($file);

	$total_it = ($total<=1000) ? $total : 1000;
	$subscriber = array();
	$count_import = intval($_POST['count_import']);
	$count_exist = intval($_POST['count_exist']);
	$count_error = intval($_POST['count_error']);

	for($i=$it;$i<$total_it;$i++){
		$subscriber = array();
		$add_fields = array();
		$zap_arr = explode($delimiter,$file[$i]);
		foreach ($fields as $key => $val) {
			if(in_array($val,$oblig_arr)){
				$subscriber[$val] = trim($zap_arr[$key]);
			}else{
				$add_fields[$val] = trim($zap_arr[$key]);
			}
		}
		$email_validator = New EmailValidator($subscriber["email1"]);
		if(!$subscriber["email1"] || $email_validator->returnValidatedEmailStatus()!=2){
			$count_error++;
		}else{
			if(!ImportUser($subscriber,$add_fields,$list,$form_class)){
				$count_exist++;
			}
			$count_import++;
		}
		unset($file[$i]);
	}
	$curent = $curent + $total_it;

	$fp=fopen($uploaddir.$_POST["filename"], "w+");
	fwrite($fp,implode("",$file));
	fclose($fp);

	$data["total"] = $total_all;
	$data["curent"] = $curent;
	$data["count_import"] = $count_import;
	$data["count_exist"] = $count_exist;
	$data["count_error"] = $count_error;
	if($total_all==$curent) {
		unlink($uploaddir.$_POST["filename"]);
		$data["mess_end"] = $lang["users"]["import_final"];
		$data["mess_end"] = str_replace("[imp]",$count_import,$data["mess_end"]);
		$data["mess_end"] = str_replace("[imp_all]",$total_all,$data["mess_end"]);
		if($count_exist){
			$data["mess_end"] .= str_replace("[imp_ext]",$count_exist,$lang["users"]["import_final_db_exist"]);
		}
		if($count_error){
			$data["mess_end"] .= str_replace("[imp_err]",$count_error,$lang["users"]["import_final_error"]);
		}
	}
	//header("Content-type:  charset=utf-8");
	if($config["phpversion"]==4){
		echo $json->encode($data);
	}else{
		echo json_encode($data);
	}
	exit;
}

function ExportSubscribers(){
	global $lang, $config, $smarty, $dbconn, $auth, $file_name;

	AdminMainMenu("users");
	$form_class=new Form($dbconn, $config);

	$user_attrs=array();
	$count=0;
	$attrs=$form_class->getAllAttributes($count);
	array_push($attrs,$attrs[0]);
	unset($attrs[0]);
	$smarty->assign('fields', $attrs);

	//$smarty->assign("path_send",$config["server"]."/files/");
	$smarty->assign("path_send",$file_name."?sel=download&file=");
	$smarty->assign("lists",getListsSub());
	$smarty->display($config["admin_nl_gentemplates"]."/users_export_csv.tpl");
}

function Download(){
	global $config;
	header('Content-Type: application/octet-stream; charset=utf-8');
	header('Content-Disposition: attachment; filename='.$_GET["file"].'.csv');
	$file = $config["site_path"]."/files/".$_GET["file"].".csv";
	echo file_get_contents($file);
	exit;
}

function ExportAjax(){
	global $lang, $config, $config_index, $smarty, $dbconn, $auth, $json;

	AdminMainMenu("users");
	$form_class=new Form($dbconn, $config);
	$data = array();
	$data['error'] = '';
	$end = strstr($_POST['FileName'], ".");
	$total = intval($_POST['total']);
	$file_name = str_replace($end,"",$_POST['FileName']).".csv";
	if($total==0){
		$fp = fopen ($config["site_path"]."/files/".$file_name,"w+");
	}else{
		$fp = fopen ($config["site_path"]."/files/".$file_name,"a");
	}

	if (!$fp) {
		$data['error'] .= $lang["err"]["no_file"]." ".$_POST["FileName"]."<br>";
	}

	if (count($_POST["list"]) < 1) {
		$data['error'] .= $lang["err"]["specify_subscrs_list"]."<br>";
	}

	if (count($_POST["oblig_filds"]) < 1) {
		$data['error'] .= $lang["err"]["invalid_feilds"]."<br>";
	}

	if ($data['error'] != ''){
		//header("Content-type:  charset=utf-8");
		if($config["phpversion"]==4){
			echo $json->encode($data);
		}else{
			echo json_encode($data);
		}
		exit;
	}
	$c = 0;

	$delimiter = (trim($_POST["Delimiter"]) != "") ? trim($_POST["Delimiter"]) : ";";
	$oblig_str="";
	$temp = array();
	$change_fields = array();
	$oblig_arr = array(	"date" => $lang["users"]["date"],
		"firstname" => $lang["common"]["firstname"],
		"secondname" => $lang["common"]["secondname"],
		"email1" => $lang["common"]["email"]);
	foreach ($_POST["oblig_filds"] as $key=>$val){
		$temp[$key] = $oblig_arr[$val];
		$change_fields[$key] = $val;
	}
	$oblig_str = implode($delimiter,$temp);

	$oblig_str .= $delimiter;

	if(is_array($_POST["add_filds"]) && count($_POST["add_filds"])>0){
		//$oblig_str .= $delimiter;
		$attr = array();
		foreach ($_POST["add_filds"] as $key=>$val){
			$temp=$form_class->getSectionAttribute($val);
			$attr[$val]=$temp["field_name"];
		}
		$oblig_str .= implode($delimiter,$attr).$delimiter;
	}
	if($total==0){
		fwrite($fp,$oblig_str."\n");
	}
	$lists = array();
	$l = 0;
	foreach ($_POST["list"] as $list_id){
		$lists[] = "cl.list_id='".$list_id."'";
		$strSQL = "SELECT name FROM ".LISTS_TABLE." WHERE id_user={$auth["id"]} AND id={$list_id}";
		$res = $dbconn->Execute($strSQL);
		$list_array[$l] = stripslashes($res->fields[0]);
		$l++;
	}
	unset($l);
	if($total==0){
		$strSQL = "SELECT COUNT(distinct cl.client_id)
						FROM ".CLIENTS_LISTS_TABLE." cl, ".SEND_USERS_TABLE." s
						WHERE cl.client_id=s.id AND (".implode(' OR ',$lists).")";
		$res=$dbconn->Execute($strSQL);
		$total = $res->fields[0];
	}else{
		$total = $total;
	}

	$count = intval($_POST['curent']);

	$limit_str= " LIMIT {$count},1000";
	$strSQL = "SELECT distinct cl.client_id, s.".implode(", s.",$change_fields)."
						FROM ".CLIENTS_LISTS_TABLE." cl, ".SEND_USERS_TABLE." s
						WHERE cl.client_id=s.id AND (".implode(' OR ',$lists).") {$limit_str}";
	$res=$dbconn->Execute($strSQL);
	$count = $res->RowCount()+$count;
	while (!$res->EOF){
		$user_str="";
		$row = $res->GetRowAssoc(false);
		foreach ($change_fields as $key=>$val){
			if($val=="comment") $row["comment"] = str_replace($delimiter," ",$row["comment"]);
			$row[$val]=$row[$val];
		}
		$user_attr=array();
		if(isset($attr) && is_array($attr))
		foreach ($attr as  $key=>$val){
			$temp1=$form_class->getUserAttribute($row['client_id'], $key, true);
			if ($temp1===false) $temp1="";
			$user_attr[$key]=$temp1;
		}
		unset($row["client_id"]);
		$user_str = implode($delimiter,$row);
		if(count($user_attr)>0){
			$user_str .= $delimiter;
			$user_str .= implode($delimiter,$user_attr).$delimiter;
		}
		fwrite($fp, $user_str.$delimiter."\n");
		$res->MoveNext();
	}
	fclose ($fp);

	$data = array();
	$data["total"] = $total;
	$data["curent"] = $count;
	$data['error'] = '';
	if($total==$count) $data["filename"] = str_replace(".csv","",$file_name);
	//header("Content-type:  charset=utf-8");
	if($config["phpversion"]==4){
		echo $json->encode($data);
	}else{
		echo json_encode($data);
	}
	exit;
}

function ProfileSubscribers(){
	global $lang, $config, $config_index, $smarty, $dbconn, $auth;

	AdminMainMenu("users");
	$smarty->assign("users",getUser(intval($_GET['id'])));
	$smarty->display($config["admin_nl_gentemplates"]."/users_profile.tpl");
	exit;
}

function ViewDetailsSubscribers(){
	global $config, $smarty, $dbconn, $auth;

	AdminMainMenu("users");

	if ( isset($_GET['id'])){
		$form_class=new Form($dbconn, $config);
		$user_attrs=array();
		$count=0;
		$attrs=$form_class->getAllAttributes($count);

		foreach ($attrs as $index=>$attr){
			$temp=$form_class->getUserAttribute(intval($_GET['id']), $attr['id'], true);
			if ($temp===false) continue;
			$user_attrs[$attr['id']]=$temp;
		}
		$smarty->assign('attrs', $attrs);
		$smarty->assign('user_attrs', $user_attrs);
		$smarty->display($config["admin_nl_gentemplates"]."/users_view_details.tpl");
		exit;
	}else{
		ListSubscribers();
		exit;
	}
}

function get_values_list(){
	global $dbconn, $auth;

	$values = array();
	$i = 0;
	$strSQL = "SELECT id, name FROM ".LISTS_TABLE." WHERE id_user={$auth["id"]} ORDER BY name";
	$rs = $dbconn->Execute($strSQL);
	while (!$rs->EOF){
		$values['id'][$i] = $rs->fields[0];
		$values['name'][$i] = $rs->fields[1];
		$i++;
		$rs->MoveNext();
	}
	ArrStripSlashes($values);
	return $values;
}

function get_status_list(){
	global $lang;
	$values = array();
	$values['id'][0] = SUBSCRIBE;
	$values['name'][0] = $lang["users"]["st_subscribe"];
	$values['id'][1] = UNSUBSCRIBE;
	$values['name'][1] = $lang["users"]["st_unsubscribe"];
	$values['id'][2] = UNCONF_SUB;
	$values['name'][2] = $lang["users"]["st_unconf_sub"];
	$values['id'][3] = UNCONF_UNSUB;
	$values['name'][3] = $lang["users"]["st_unconf_unsub"];
	$values['id'][4] = NOT_ASSIGNET;
	$values['name'][4] = $lang["users"]["st_not_assignet"];
	return $values;
}

function Bounce($error=""){
	global $lang, $config, $smarty, $dbconn, $auth, $file_name;

	AdminMainMenu("users");

	$status = isset($_REQUEST["status"]) ? intval($_REQUEST["status"]) : 0;
	if($status){
		$status = ($status==1)?"soft":"hard";
		$status_search = " AND b.status='{$status}'";
		$add_param = "&status=".$_REQUEST["status"];
	}else{
		$status_search = "";
		$add_param = "&status=0";
	}
	@$page = $_REQUEST["p"] ? intval($_REQUEST["p"]) : 0;
	@$user_page = $_REQUEST["user_page"] ? intval($_REQUEST["user_page"]) : 0;
	$per_page = $config["user_page"][$user_page];

	$strSQL = "SELECT COUNT(id)
					FROM ".BOUNCE_EMAIL_TABLE." b
					WHERE b.id_user={$auth["id"]} AND b.view=1 {$status_search}";
	$rs = $dbconn->Execute($strSQL);
	$total = $rs->fields[0];

	$strSQL = "SELECT b.*,
						(SELECT CONCAT(firstname,' ', secondname)
							FROM ".SEND_USERS_TABLE."
							WHERE id=b.id_subscriber AND id_user={$auth["id"]}) as name
					FROM ".BOUNCE_EMAIL_TABLE." b
					WHERE b.id_user={$auth["id"]} AND b.view=1 {$status_search}";
	$rs = $dbconn->PageExecute($strSQL, $per_page, $page+1);
	$i=0;$data= array();
	while (!$rs->EOF){
		$row = $rs->GetRowAssoc(false);
		$data[$i]["id"] = $row["id"];
		$data[$i]["id_subscriber"] = $row["id_subscriber"];
		$data[$i]["name"] = $row["name"];
		$data[$i]["email"] = $row["email"];
		$data[$i]["status"] = $row["status"];
		$data[$i]["date"] = $row["date"];
		$data[$i]["status_str"] = (!$lang["users"][$row["status"]][$row["substatus"]])?$lang["users"]["hard"]["emaildoesntexist"]:$lang["users"][$row["status"]][$row["substatus"]];
		$data[$i]["count"] = $row["count"];
		$i++;
		$rs->MoveNext();
	}
	ArrStripSlashes($data);
	$smarty->assign("navigation", create_navigation($total, $user_page, "&sel=bounce".$add_param, $file_name, $page));
	get_smarty_array_list("user_page", $config["user_page"]);

	if($error!="") $smarty->assign("msg",$error);
	$smarty->assign("status",$status);
	$smarty->assign("status_int",$_REQUEST["status"]);
	$smarty->assign("total",$total);
	$smarty->assign("user_page",$user_page);
	$smarty->assign("data",$data);
	$smarty->display($config["admin_nl_gentemplates"]."/bounce.tpl");
}

function BounceDelete(){
	global $auth, $dbconn;
	if (is_array($_REQUEST["id"])) {
		foreach ($_REQUEST["id"] as $key => $val) {
			$strSQL = "";
			$id = intval($val);
			$id_sub = intval($_REQUEST["id_sub"][$key]);
			$strSQL =  "UPDATE ".SEND_USERS_TABLE." SET status=0 WHERE id={$id_sub} AND id_user={$auth["id"]}";
			$dbconn->Execute($strSQL);
			$strSQL =  "UPDATE ".BOUNCE_EMAIL_TABLE." SET view=0 WHERE id={$id} AND id_user={$auth["id"]}";
			$dbconn->Execute($strSQL);
			$strSQL =  "DELETE FROM ".CLIENTS_LISTS_TABLE." WHERE client_id={$id_sub} AND id_user={$auth["id"]}";
			$dbconn->Execute($strSQL);
			$strSQL =  "DELETE FROM ".SENT_USERS_TABLE." WHERE id_subscriber={$id_sub} AND id_user={$auth["id"]}";
			$dbconn->Execute($strSQL);
			$strSQL =  "DELETE FROM ".CLICK_COUNTER_TABLE." WHERE client_id={$id_sub} AND id_user={$auth["id"]};";
			$dbconn->Execute($strSQL);
		}
	}elseif($_REQUEST["id"]){
		$id = intval($_REQUEST["id"]);
		$id_sub = intval($_REQUEST["id_sub"]);
		$strSQL =  "UPDATE ".SEND_USERS_TABLE." SET status=0 WHERE id={$id_sub} AND id_user={$auth["id"]}";
		$dbconn->Execute($strSQL);
		$strSQL =  "UPDATE ".BOUNCE_EMAIL_TABLE." SET view=0 WHERE id={$id} AND id_user={$auth["id"]}";
		$dbconn->Execute($strSQL);
		$strSQL =  "DELETE FROM ".CLIENTS_LISTS_TABLE." WHERE client_id={$id_sub} AND id_user={$auth["id"]}";
		$dbconn->Execute($strSQL);
		$strSQL =  "DELETE FROM ".SENT_USERS_TABLE." WHERE id_subscriber={$id_sub} AND id_user={$auth["id"]}";
		$dbconn->Execute($strSQL);
		$strSQL =  "DELETE FROM ".CLICK_COUNTER_TABLE." WHERE client_id={$id_sub} AND id_user={$auth["id"]};";
		$dbconn->Execute($strSQL);
	}
	Bounce();
	exit;
}

function BounceDeleteFromFile(){
	global $auth, $dbconn, $lang;

	$config["count_email"] = 500;
	$all = 0;
	$lines = file($_FILES["file"]["tmp_name"]);
	unlink($_FILES["file"]["tmp_name"]);
	foreach ($lines as $key=>$value){
		$lines[$key] = trim($value);
	}
	/*$email_validator = New EmailValidator($lines[0]);*/
	if(is_array($lines) && @$lines[0]!=""/* && $email_validator->returnValidatedEmailStatus()==1*/){
		$r = ceil(count($lines) / $config["count_email"]);
		for ($i=0;$i<$r;$i++){
			$output = array_slice($lines, 0, $config["count_email"]);
			array_splice($lines, 0, $config["count_email"]);
			$strSQL = "SELECT id FROM ".SEND_USERS_TABLE." WHERE email1 IN ('".implode("','",$output)."')";
			$rs = $dbconn->Execute($strSQL);
			$arr_id = array();
			while(!$rs->EOF){
				$arr_id[] = $rs->fields[0];
				$rs->MoveNext();
			}
			$all = $all + count($arr_id);
			$str_id = implode(",",$arr_id);
			if($str_id!=""){
				$dbconn->Execute("DELETE FROM ".SEND_USERS_TABLE." WHERE id IN (".$str_id.")");
				$dbconn->Execute("DELETE FROM ".CLIENTS_LISTS_TABLE." WHERE client_id IN (".$str_id.")");
				$dbconn->Execute("DELETE FROM ".CLICK_COUNTER_TABLE." WHERE client_id IN (".$str_id.")");
				$dbconn->Execute("DELETE FROM ".USER_ATTR_TABLE." WHERE id_user IN (".$str_id.")");
			}
		}
		Bounce(str_replace("[count]",$all,$lang["err"]["success_delete"]));
		exit;
	}
	Bounce($lang["err"]["invalid_file_format"]);
	exit;
}


?>