// View tags personalization block
(function($) {
	$.fn.dropDownBlock = function(block, options) {
		var defaults = { 
			speed: 'fast',
			top: $(this).height(),
			left: 0
		}, 
		opts 	= $.extend(defaults, options),
  		toggler = $(this),
  		block 	= $(block);
  		toggler.css({'outline': 'none'})
  		height = $(block).height();

  		toggler.click(function(e) {
  			e.preventDefault();
  			$(block).css({
        		'position' 	: 'absolute',
        		'top' 		: (- opts['top'] - height +6 ) + 'px',
        		'left' 		: (opts['left']) + 'px'
      		});

      		if($(block).is(':visible')) $(block).fadeOut(opts['speed']);
      		else $(block).fadeIn(opts['speed']);   
      		this.focus();
  		});
  		toggler.blur(function() {
  			$(block).fadeOut(opts['speed']);
  		});
	};
})(jQuery);
$('#tags_html').dropDownBlock($('#tags_div_html'));
$('#tags_text').dropDownBlock($('#tags_div_text'));

// Insert tags personalization in to editor and textarea
$("#tags_div_html > div[id^='tag_']").click(function(){
	var id = $(this).attr('id');
	if(id=="tag_custom"){
		return GB_show('', 'templates.php?sel=get_custom_fields&type=html', 500, 500);
	}else{
		var oEditor = FCKeditorAPI.GetInstance('body_html');
		oEditor.InsertHtml($('#'+id+'_ins').html());
	}
});
$("input[id^='unsublink_btn_']").click(function(){
	var id = $(this).attr('id').substring(14);
	if(id == "html"){
		var oEditor = FCKeditorAPI.GetInstance('body_html'); 
		oEditor.InsertHtml($('#tag_unsublink_ins').html());
	}else{
		insertAtCursor(document.getElementById('body_text'), $('#tag_unsublink_instext').html())
	}
});
$("input[id^='tellfrend_btn_']").click(function(){
	var id = $(this).attr('id').substring(14);
	if(id == "html"){
		var oEditor = FCKeditorAPI.GetInstance('body_html'); 
		oEditor.InsertHtml($('#tag_tellfrend_ins').html());
	}else{
		insertAtCursor(document.getElementById('body_text'), $('#tag_tellfrend_instext').html())
	}
});

$("#tags_div_text > div[id^='tag_']").click(function(){
	var id = $(this).attr('id');
	if(id=="tag_custom"){
		return GB_show('', 'templates.php?sel=get_custom_fields&type=text', 500, 500);
	}else{
		insertAtCursor(document.getElementById('body_text'), $('#'+id+'_instext').html())
	}
	
});

// Insert text in to textarea
function insertAtCursor(myField, myValue) {
	if (document.selection) {
		myField.focus();
		sel = document.selection.createRange();
		sel.text = myValue;
	} else {
		if (myField.selectionStart || myField.selectionStart == '0') {
			var startPos = myField.selectionStart;
			var endPos = myField.selectionEnd;
			myField.value = myField.value.substring(0, startPos)
				+ myValue
				+ myField.value.substring(endPos, myField.value.length);
		} else {
			myField.value += myValue;
		}
	}
}
function DoImport(importtype, TextOrHTML){
	if(ajaxData.length == 0) {
		alert(errorMsg);
	} else {
		if (TextOrHTML.toLowerCase() == 'text') {
			insertAtCursor(document.getElementById('body_text'), ajaxData);
		} else {
			var oEditor = FCKeditorAPI.GetInstance('body_html'); 
			oEditor.SetHTML(ajaxData);
		}
	}
}
function DoInsert(TextOrHTML){
	if(ajaxData.length == 0) {
		alert(errorMsg);
	} else {
		if (TextOrHTML.toLowerCase() == 'text') {
			insertAtCursor(document.getElementById('body_text'), ajaxData);
		} else {
			var oEditor = FCKeditorAPI.GetInstance('body_html'); 
			oEditor.InsertHtml(ajaxData);
		}
	}
}

// Check submit form
function CheckForm(){
	var subject = document.getElementById('subject');
	if(subject.value == ""){
		alert(GetError('specify_temp_content'));
		return false;
	}
	return true;
}
// Changing the type of create a template
$("#create_from_html > div > input[type='radio']").click(function(){
	var id = $(this).attr('id').substring(10);
	$("#create_from_html > div > input[type='radio']").each(function(){
		var ids = $(this).attr('id').substring(10);
		if(id != ids) $("#create_from_html > #"+ids).addClass('no-display');
	});
	$("#create_from_html > #"+id).removeClass('no-display');
});
$("#create_from_text > div > input[type='radio']").click(function(){
	var id = $(this).attr('id').substring(10);
	$("#create_from_text > div > input[type='radio']").each(function(){
		var ids = $(this).attr('id').substring(10);
		if(id != ids) $("#create_from_text > #"+ids).addClass('no-display');
	});
	$("#create_from_text > #"+id).removeClass('no-display');
});

// Change format of content
$("#format").change(function(){
	var val = $(this).val();
	if(val=="html"){
		$("#"+val+"_content").show();
		$("#text_content").hide();
	}else if(val=="text"){
		$("#"+val+"_content").show();
		$("#html_content").hide();
	}else{
		$("#text_content").show();
		$("#html_content").show();
	}
});